/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.options.codetemplates.CodeTemplatesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CodeTemplatesPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JComboBox cbLanguage = new JComboBox();
    private JTable tTemplates = new JTable();
    private JScrollPane spTable = new JScrollPane(this.tTemplates);
    private JEditorPane epTemplates = new JEditorPane();
    private JButton bNew = new JButton();
    private JButton bRemove = new JButton();
    private JComboBox cbExpander = new JComboBox();
    private CodeTemplatesModel model;
    private Lookup lookup;
    private int lastIndex = -1;

    public CodeTemplatesPanel() {
        this.bRemove.setEnabled(false);
        CodeTemplatesPanel.loc(this.bNew, "New");
        CodeTemplatesPanel.loc(this.bRemove, "Remove");
        JLabel lExpander = new JLabel();
        CodeTemplatesPanel.loc(lExpander, "Expander_Key");
        JPanel pExpander = new JPanel(new FlowLayout());
        pExpander.add(lExpander);
        pExpander.add(this.cbExpander);
        this.cbExpander.addItem(CodeTemplatesPanel.loc("SPACE"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("S-SPACE"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("TAB"));
        this.cbExpander.addItem(CodeTemplatesPanel.loc("ENTER"));
        this.tTemplates.getTableHeader().setReorderingAllowed(false);
        this.tTemplates.getSelectionModel().setSelectionMode(0);
        Font f = this.tTemplates.getFont();
        this.spTable.setPreferredSize(new Dimension(10, 10));
        JLabel lbTemplates = new JLabel();
        CodeTemplatesPanel.loc(lbTemplates, "Template_List");
        lbTemplates.setLabelFor(this.tTemplates);
        JLabel lbExpandedText = new JLabel();
        CodeTemplatesPanel.loc(lbExpandedText, "Expanded_Text");
        lbExpandedText.setLabelFor(this.epTemplates);
        this.epTemplates.setPreferredSize(new Dimension(10, 10));
        FormLayout layout = new FormLayout("p, 5dlu, 100dlu, 100dlu:g, 5dlu, p", "p, 5dlu, p, 1dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g, 5dlu, p");
        layout.setRowGroups((int[][])new int[][]{{3, 7}});
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.addLabel(CodeTemplatesPanel.loc("CTL_Language"), lc.xy(1, 1), (Component)this.cbLanguage, cc.xy(3, 1));
        builder.add((Component)lbTemplates, lc.xy(1, 3));
        builder.add((Component)this.spTable, cc.xywh(1, 5, 4, 4));
        builder.add((Component)this.bNew, cc.xy(6, 5));
        builder.add((Component)this.bRemove, cc.xy(6, 7));
        builder.add((Component)lbExpandedText, lc.xyw(1, 10, 4));
        builder.add((Component)new JScrollPane(this.epTemplates), cc.xyw(1, 12, 4));
        builder.add((Component)pExpander, cc.xyw(1, 14, 4, "l, c"));
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)CodeTemplatesPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(CodeTemplatesPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(CodeTemplatesPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)CodeTemplatesPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)CodeTemplatesPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.model = new CodeTemplatesModel();
        this.cbLanguage.removeActionListener(this);
        this.bNew.removeActionListener(this);
        this.bRemove.removeActionListener(this);
        this.cbExpander.removeActionListener(this);
        this.tTemplates.getSelectionModel().removeListSelectionListener(this);
        this.cbLanguage.removeAllItems();
        ArrayList languages = new ArrayList(this.model.getLanguages());
        Collections.sort(languages);
        Iterator it = languages.iterator();
        while (it.hasNext()) {
            this.cbLanguage.addItem(it.next());
        }
        KeyStroke expander = this.model.getExpander();
        if (KeyStroke.getKeyStroke(32, 1).equals(expander)) {
            this.cbExpander.setSelectedIndex(1);
        } else if (KeyStroke.getKeyStroke(9, 0).equals(expander)) {
            this.cbExpander.setSelectedIndex(2);
        } else if (KeyStroke.getKeyStroke(10, 0).equals(expander)) {
            this.cbExpander.setSelectedIndex(3);
        } else {
            this.cbExpander.setSelectedIndex(0);
        }
        this.cbLanguage.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.cbExpander.addActionListener(this);
        this.tTemplates.getSelectionModel().addListSelectionListener(this);
        this.cbLanguage.setSelectedItem("Java");
    }

    void applyChanges() {
        if (this.model != null) {
            this.saveCurrentTemplate();
            this.model.saveChanges();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbLanguage) {
            this.saveCurrentTemplate();
            final String language = (String)this.cbLanguage.getSelectedItem();
            final DefaultTableModel tableModel = this.model.getTableModel(language);
            this.tTemplates.setModel(tableModel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epTemplates.setContentType(CodeTemplatesPanel.this.model.getMimeType(language));
                    if (tableModel.getRowCount() > 0) {
                        CodeTemplatesPanel.this.lastIndex = -1;
                        CodeTemplatesPanel.this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        CodeTemplatesPanel.this.lastIndex = 0;
                    } else {
                        CodeTemplatesPanel.this.lastIndex = -1;
                    }
                }
            });
        } else if (e.getSource() == this.bNew) {
            this.saveCurrentTemplate();
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(CodeTemplatesPanel.loc("CTL_Enter_template_name"), CodeTemplatesPanel.loc("CTL_New_template_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.InputLine.OK_OPTION) {
                String templateName = descriptor.getInputText().trim();
                if (templateName.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Empty_template_name"), 0));
                } else {
                    int i;
                    TableModel tableModel = this.tTemplates.getModel();
                    int k = tableModel.getRowCount();
                    for (i = 0; i < k; ++i) {
                        String name = (String)tableModel.getValueAt(i, 0);
                        if (!templateName.equals(name)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CodeTemplatesPanel.loc("CTL_Duplicate_template_name"), 0));
                        break;
                    }
                    if (i == k) {
                        String language = (String)this.cbLanguage.getSelectedItem();
                        this.lastIndex = -1;
                        this.model.addRow(language, templateName, "");
                        this.tTemplates.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTable.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeTemplatesPanel.this.epTemplates.requestFocus();
                }
            });
        } else if (e.getSource() == this.bRemove) {
            String language = (String)this.cbLanguage.getSelectedItem();
            int index = this.tTemplates.getSelectedRow();
            this.model.removeRow(language, index);
            this.lastIndex = -1;
            if (index < this.tTemplates.getModel().getRowCount()) {
                this.tTemplates.getSelectionModel().setSelectionInterval(index, index);
            } else if (this.tTemplates.getModel().getRowCount() > 0) {
                this.tTemplates.getSelectionModel().setSelectionInterval(this.tTemplates.getModel().getRowCount() - 1, this.tTemplates.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
            }
        } else if (e.getSource() == this.cbExpander) {
            switch (this.cbExpander.getSelectedIndex()) {
                case 0: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 0));
                    break;
                }
                case 1: {
                    this.model.setExpander(KeyStroke.getKeyStroke(32, 1));
                    break;
                }
                case 2: {
                    this.model.setExpander(KeyStroke.getKeyStroke(9, 0));
                    break;
                }
                case 3: {
                    this.model.setExpander(KeyStroke.getKeyStroke(10, 0));
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.tTemplates.getSelectedRow();
        if (index < 0) {
            this.epTemplates.setText("");
            this.bRemove.setEnabled(false);
            this.lastIndex = -1;
            return;
        }
        this.saveCurrentTemplate();
        TableModel tableModel = this.tTemplates.getModel();
        this.bRemove.setEnabled(true);
        String text = (String)tableModel.getValueAt(index, 1);
        this.epTemplates.setText(text);
        this.lastIndex = index;
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    void saveCurrentTemplate() {
        TableModel tableModel = this.tTemplates.getModel();
        if (this.lastIndex < 0) {
            return;
        }
        if (this.epTemplates.getText().equals(tableModel.getValueAt(this.lastIndex, 1))) {
            return;
        }
        tableModel.setValueAt(this.epTemplates.getText(), this.lastIndex, 1);
        this.firePropertyChange("changed", null, null);
    }
}

