/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class KeymapViewModel
implements TreeModel,
ShortcutsDialog.ShortcutsFinder {
    private Vector listeners = new Vector();
    private String currentProfile;
    private KeymapModel model = new KeymapModel();
    private Map categoryToActionsCache = new HashMap();
    private Map modifiedProfiles = new HashMap();
    private Set deletedProfiles = new HashSet();
    private Map shortcutsCache = new HashMap();
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private Map categories;

    public KeymapViewModel() {
        this.currentProfile = this.model.getCurrentProfile();
    }

    public Object getRoot() {
        return "";
    }

    public Object getChild(Object parent, int index) {
        return this.getItems((String)parent).get(index);
    }

    public int getChildCount(Object parent) {
        if (parent instanceof String) {
            return this.getItems((String)parent).size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return !(node instanceof String);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.getItems((String)parent).indexOf(child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private void treeChanged() {
        final Vector v = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent tme = new TreeModelEvent((Object)this, new Object[]{""});
                int k = v.size();
                for (int i = 0; i < k; ++i) {
                    ((TreeModelListener)v.get(i)).treeNodesChanged(tme);
                }
            }
        });
    }

    private void nodeChanged(final TreePath path) {
        final Vector v = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent tme = new TreeModelEvent((Object)this, path);
                int k = v.size();
                for (int i = 0; i < k; ++i) {
                    ((TreeModelListener)v.get(i)).treeNodesChanged(tme);
                }
            }
        });
    }

    public Map getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap();
            ArrayList c = new ArrayList(this.model.getActionCategories());
            Collections.sort(c);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                String cn = (String)it.next();
                String folderName = "";
                StringTokenizer st = new StringTokenizer(cn, "/");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    ArrayList<String> asd = (ArrayList<String>)this.categories.get(folderName);
                    if (asd == null) {
                        asd = new ArrayList<String>();
                        this.categories.put(folderName, asd);
                    }
                    String string = folderName = folderName.length() == 0 ? name : folderName + '/' + name;
                    if (!asd.isEmpty() && asd.get(asd.size() - 1).equals(folderName)) continue;
                    asd.add(folderName);
                }
            }
        }
        return this.categories;
    }

    public List getItems(String category) {
        ArrayList result = (ArrayList)this.categoryToActionsCache.get(category);
        if (result == null) {
            result = new ArrayList();
            List ll = (List)this.getCategories().get(category);
            if (ll != null) {
                result.addAll(ll);
            }
            ArrayList l = new ArrayList(this.model.getActions(category));
            Collections.sort(l, new ActionsComparator());
            result.addAll(l);
            this.categoryToActionsCache.put(category, result);
        }
        return result;
    }

    List getProfiles() {
        HashSet result = new HashSet(this.model.getProfiles());
        result.addAll(this.modifiedProfiles.keySet());
        ArrayList r = new ArrayList(result);
        Collections.sort(r);
        return r;
    }

    boolean isCustomProfile(String profile) {
        return this.model.isCustomProfile(profile);
    }

    void deleteProfile(String profile) {
        if (this.model.isCustomProfile(profile)) {
            this.deletedProfiles.add(profile);
            this.modifiedProfiles.remove(profile);
        } else {
            Map m = this.model.getKeymapDefaults(profile);
            m = KeymapViewModel.convertFromEmacs(m);
            this.modifiedProfiles.put(profile, m);
            this.treeChanged();
        }
    }

    String getCurrentProfile() {
        return this.currentProfile;
    }

    void setCurrentProfile(String currentKeymap) {
        this.currentProfile = currentKeymap;
        this.treeChanged();
    }

    void cloneProfile(String newProfileName) {
        HashMap result = new HashMap();
        this.cloneProfile("", result);
        this.modifiedProfiles.put(newProfileName, result);
    }

    private void cloneProfile(String category, Map result) {
        Iterator it = this.getItems(category).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                this.cloneProfile((String)o, result);
                continue;
            }
            String[] shortcuts = this.getShortcuts((ActionImpl)o);
            result.put(o, new HashSet<String>(Arrays.asList(shortcuts)));
        }
    }

    public ActionImpl findActionForShortcut(String shortcut) {
        return this.findActionForShortcut(shortcut, "");
    }

    private ActionImpl findActionForShortcut(String shortcut, String category) {
        Iterator it = this.getItems(category).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                ActionImpl result = this.findActionForShortcut(shortcut, (String)o);
                if (result == null) continue;
                return result;
            }
            ActionImpl action = (ActionImpl)o;
            String[] shortcuts = this.getShortcuts(action);
            int k = shortcuts.length;
            for (int i = 0; i < k; ++i) {
                if (shortcuts[i].equals(shortcut)) {
                    return action;
                }
                if (!shortcuts[i].equals(shortcut + " ")) continue;
                return action;
            }
        }
        return null;
    }

    public ActionImpl findActionForId(final String actionId) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.findActionForId(actionId, "");
        }
        final ActionImpl[] result = new ActionImpl[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    result[0] = KeymapViewModel.this.findActionForId(actionId, "");
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return result[0];
    }

    private ActionImpl findActionForId(String actionId, String category) {
        Iterator it = this.getItems(category).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                ActionImpl result = this.findActionForId(actionId, (String)o);
                if (result == null) continue;
                return result;
            }
            String id = ((ActionImpl)o).getId();
            if (!actionId.equals(id)) continue;
            return (ActionImpl)o;
        }
        return null;
    }

    public String[] getShortcuts(ActionImpl action) {
        Set shortcuts;
        Map profileMap;
        Map actionToShortcuts;
        if (this.modifiedProfiles.containsKey(this.currentProfile) && (actionToShortcuts = (Map)this.modifiedProfiles.get(this.currentProfile)).containsKey(action)) {
            Set s = (Set)actionToShortcuts.get(action);
            return s.toArray(new String[s.size()]);
        }
        if (!this.shortcutsCache.containsKey(this.currentProfile)) {
            profileMap = KeymapViewModel.convertFromEmacs(this.model.getKeymap(this.currentProfile));
            this.shortcutsCache.put(this.currentProfile, profileMap);
        }
        if ((shortcuts = (Set)(profileMap = (Map)this.shortcutsCache.get(this.currentProfile)).get(action)) == null) {
            return new String[0];
        }
        return shortcuts.toArray(new String[shortcuts.size()]);
    }

    void addShortcut(TreePath path, String shortcut) {
        ActionImpl action = this.findActionForShortcut(shortcut);
        if (action != null) {
            this.removeShortcut(action, shortcut);
        }
        action = (ActionImpl)path.getLastPathComponent();
        HashSet<String> s = new HashSet<String>();
        s.add(shortcut);
        s.addAll(Arrays.asList(this.getShortcuts(action)));
        this.setShortcuts(action, s);
        this.nodeChanged(path);
    }

    public void setShortcuts(ActionImpl action, Set shortcuts) {
        HashMap<ActionImpl, Set> actionToShortcuts = (HashMap<ActionImpl, Set>)this.modifiedProfiles.get(this.currentProfile);
        if (actionToShortcuts == null) {
            actionToShortcuts = new HashMap<ActionImpl, Set>();
            this.modifiedProfiles.put(this.currentProfile, actionToShortcuts);
        }
        actionToShortcuts.put(action, shortcuts);
    }

    void removeShortcut(TreePath path, String shortcut) {
        ActionImpl action = (ActionImpl)path.getLastPathComponent();
        this.removeShortcut(action, shortcut);
        this.nodeChanged(path);
    }

    private void removeShortcut(ActionImpl action, String shortcut) {
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.getShortcuts(action)));
        s.remove(shortcut);
        HashMap<ActionImpl, HashSet<String>> actionToShortcuts = (HashMap<ActionImpl, HashSet<String>>)this.modifiedProfiles.get(this.currentProfile);
        if (actionToShortcuts == null) {
            actionToShortcuts = new HashMap<ActionImpl, HashSet<String>>();
            this.modifiedProfiles.put(this.currentProfile, actionToShortcuts);
        }
        actionToShortcuts.put(action, s);
    }

    public void refreshActions() {
        this.categoryToActionsCache = new HashMap();
        this.model.refreshActions();
    }

    public void apply() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String profile;
                Iterator<Object> it = KeymapViewModel.this.modifiedProfiles.keySet().iterator();
                while (it.hasNext()) {
                    profile = (String)it.next();
                    Map actionToShortcuts = (Map)KeymapViewModel.this.modifiedProfiles.get(profile);
                    actionToShortcuts = KeymapViewModel.convertToEmacs(actionToShortcuts);
                    KeymapViewModel.this.model.changeKeymap(profile, actionToShortcuts);
                }
                it = KeymapViewModel.this.deletedProfiles.iterator();
                while (it.hasNext()) {
                    profile = (String)it.next();
                    KeymapViewModel.this.model.deleteProfile(profile);
                }
                KeymapViewModel.this.model.setCurrentProfile(KeymapViewModel.this.currentProfile);
                KeymapViewModel.this.modifiedProfiles = new HashMap();
                KeymapViewModel.this.deletedProfiles = new HashSet();
                KeymapViewModel.this.shortcutsCache = new HashMap();
                KeymapViewModel.this.model = new KeymapModel();
            }
        });
    }

    public boolean isChanged() {
        return !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty();
    }

    public void cancel() {
        this.modifiedProfiles = new HashMap();
        this.deletedProfiles = new HashSet();
        this.shortcutsCache = new HashMap();
        this.setCurrentProfile(this.model.getCurrentProfile());
        this.model = new KeymapModel();
    }

    private static Map convertToEmacs(Map shortcuts) {
        HashMap result = new HashMap();
        Iterator it = shortcuts.keySet().iterator();
        while (it.hasNext()) {
            Object action = it.next();
            Set sh = (Set)shortcuts.get(action);
            HashSet<String> newSet = new HashSet<String>();
            Iterator it2 = sh.iterator();
            while (it2.hasNext()) {
                KeyStroke[] ks;
                String s = (String)it2.next();
                if (s.length() == 0 || (ks = KeymapViewModel.getKeyStrokes(s, " ")) == null) continue;
                StringBuffer sb = new StringBuffer(Utilities.keyToString((KeyStroke)ks[0]));
                int k = ks.length;
                for (int i = 1; i < k; ++i) {
                    sb.append(' ').append(Utilities.keyToString((KeyStroke)ks[i]));
                }
                newSet.add(sb.toString());
            }
            result.put(action, newSet);
        }
        return result;
    }

    private static Map convertFromEmacs(Map emacs) {
        HashMap result = new HashMap();
        Iterator it = emacs.keySet().iterator();
        while (it.hasNext()) {
            ActionImpl action = (ActionImpl)it.next();
            Set emacsShortcuts = (Set)emacs.get(action);
            Iterator it2 = emacsShortcuts.iterator();
            HashSet<String> shortcuts = new HashSet<String>();
            while (it2.hasNext()) {
                String emacsShortcut = (String)it2.next();
                KeyStroke[] keyStroke = Utilities.stringToKeys((String)emacsShortcut);
                shortcuts.add(Utils.getKeyStrokesAsText(keyStroke, " "));
            }
            result.put(action, shortcuts);
        }
        return result;
    }

    private static KeyStroke[] getKeyStrokes(String keyStrokes, String delim) {
        if (keyStrokes.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer st = new StringTokenizer(keyStrokes, delim);
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = Utils.getKeyStroke(ks);
            if (keyStroke == null) {
                return null;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)KeymapPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)KeymapViewModel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)KeymapViewModel.loc(key));
        }
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                return 1;
            }
            if (o2 instanceof String) {
                return -1;
            }
            return ((ActionImpl)o1).getDisplayName().compareTo(((ActionImpl)o2).getDisplayName());
        }
    }
}

