/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class NbMoveRefactoringPlugin
implements RefactoringPlugin {
    protected static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.refactoring");
    private static ThreadLocal semafor = new ThreadLocal();
    private MoveClassRefactoring refactoring;
    private Collection manifestRefactorings;
    private boolean firstManifestRefactoring = true;
    private HashMap oldManifests;
    private EditableManifest targetManifest;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin;

    public NbMoveRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = (MoveClassRefactoring)refactoring;
        this.manifestRefactorings = new ArrayList();
        this.oldManifests = new HashMap();
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            Project project;
            Problem problem = null;
            Collection col = this.refactoring.getResources();
            Project targetProject = FileOwnerQuery.getOwner((FileObject)this.refactoring.getTargetClassPathRoot());
            if (targetProject == null || !(targetProject instanceof NbModuleProject)) {
                Problem problem2 = problem;
                return problem2;
            }
            NbModuleProject cachedProject = null;
            String[] cachedServices = null;
            FileObject[] cachedServicesFiles = null;
            Manifest cachedManifest = null;
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                FileObject fo = JavaModel.getFileObject((Resource)res);
                project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project == null || !(project instanceof NbModuleProject)) continue;
                if (cachedProject == null || cachedProject != project) {
                    cachedProject = (NbModuleProject)project;
                    cachedServices = this.loadMetaInfServices((Project)cachedProject);
                    cachedManifest = cachedProject.getManifest();
                    FileObject services = Utility.findMetaInfServices((Project)cachedProject);
                    cachedServicesFiles = services == null ? new FileObject[]{} : services.getChildren();
                }
                String name = res.getName();
                String clazzName = name.replaceAll("\\.java$", ".class");
                String serviceName = name.replaceAll("\\.java$", "").replace('/', '.');
                JavaClass clazz = this.findClazz(res, serviceName);
                for (int i = 0; i < cachedServices.length; ++i) {
                    serviceName = serviceName.replaceAll("[.]", "\\.");
                    if (cachedServices[i] != null) {
                        if (!cachedServices[i].matches("^" + serviceName + "[ \\\n]?")) continue;
                        ServicesMoveRefactoringElement elem = new ServicesMoveRefactoringElement(clazz, cachedServicesFiles[i], cachedProject);
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                        continue;
                    }
                    ErrorManager.getDefault().log(16, "Error loading one of the files in folder " + cachedServices);
                }
                Attributes attrs = cachedManifest.getMainAttributes();
                Iterator<Map.Entry<Object, Object>> itx = attrs.entrySet().iterator();
                while (itx.hasNext()) {
                    Map.Entry<Object, Object> entry = itx.next();
                    String val = (String)entry.getValue();
                    if (val.indexOf(clazzName) == -1 && val.indexOf(clazzName) == -1) continue;
                    RefactoringElementImplementation elem = this.createManifestRefactoring(clazz, cachedProject.getManifestFile(), ((Attributes.Name)entry.getKey()).toString(), val, null, cachedProject);
                    refactoringElements.add((AbstractRefactoring)this.refactoring, elem);
                    this.manifestRefactorings.add(elem);
                }
                Map<String, Attributes> entries = cachedManifest.getEntries();
                if (entries == null) continue;
                Iterator<Map.Entry<String, Attributes>> itf = entries.entrySet().iterator();
                while (itf.hasNext()) {
                    Map.Entry<String, Attributes> secEnt = itf.next();
                    attrs = secEnt.getValue();
                    String val = secEnt.getKey();
                    if (val.indexOf(clazzName) == -1) continue;
                    String section = attrs.getValue("OpenIDE-Module-Class");
                    RefactoringElementImplementation elem = this.createManifestRefactoring(clazz, cachedProject.getManifestFile(), null, val, section, cachedProject);
                    refactoringElements.add((AbstractRefactoring)this.refactoring, elem);
                    this.manifestRefactorings.add(elem);
                }
            }
            Iterator itd = this.refactoring.getOtherDataObjects().iterator();
            while (itd.hasNext()) {
                String packageName;
                DataObject dobj = (DataObject)itd.next();
                project = FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
                if (project != null && project instanceof NbModuleProject && (cachedProject == null || cachedProject != project)) {
                    cachedProject = (NbModuleProject)project;
                    cachedServices = this.loadMetaInfServices((Project)cachedProject);
                    cachedManifest = cachedProject.getManifest();
                }
                if ((packageName = NbMoveRefactoringPlugin.findPackageName(cachedProject, dobj.getPrimaryFile())) == null) continue;
                Iterator<Map.Entry<Object, Object>> itf = cachedManifest.getMainAttributes().entrySet().iterator();
                while (itf.hasNext()) {
                    Map.Entry<Object, Object> ent = itf.next();
                    String val = (String)ent.getValue();
                    if (!packageName.equals(val)) continue;
                    ManifestMoveRefactoringElement elem = new ManifestMoveRefactoringElement(packageName, cachedProject.getManifestFile(), val, ((Attributes.Name)ent.getKey()).toString(), cachedProject, dobj.getPrimaryFile());
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                    this.manifestRefactorings.add(elem);
                }
            }
            Problem problem3 = problem;
            return problem3;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(JavaClass clazz, FileObject manifestFile, String attributeKey, String attributeValue, String section, NbModuleProject proj) {
        return new ManifestMoveRefactoringElement(clazz, manifestFile, attributeValue, attributeKey, section, proj);
    }

    private JavaClass findClazz(Resource res, String name) {
        Iterator itx = res.getClassifiers().iterator();
        while (itx.hasNext()) {
            JavaClass clzz = (JavaClass)itx.next();
            if (!clzz.getName().equals(name)) continue;
            return clzz;
        }
        return (JavaClass)res.getClassifiers().iterator().next();
    }

    protected final String[] loadMetaInfServices(Project project) {
        FileObject services = Utility.findMetaInfServices(project);
        if (services == null) {
            return new String[0];
        }
        FileObject[] files = services.getChildren();
        String[] ret = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            ret[i] = Utility.readFileIntoString(files[i]);
        }
        return ret;
    }

    private static String findPackageName(NbModuleProject project, FileObject fo) {
        Sources srcs = ProjectUtils.getSources((Project)project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (int i = 0; i < grps.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)grps[i].getRootFolder(), (FileObject)fo) || !grps[i].contains(fo)) continue;
            return FileUtil.getRelativePath((FileObject)grps[i].getRootFolder(), (FileObject)fo);
        }
        return null;
    }

    private static FileObject createMetaInf(NbModuleProject project) throws IOException {
        Sources srcs = ProjectUtils.getSources((Project)project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (int i = 0; i < grps.length; ++i) {
            FileObject fo = grps[i].getRootFolder().getFileObject("META-INF");
            if (fo == null) continue;
            return fo.createFolder("services");
        }
        return grps[0].getRootFolder().createFolder("META-INF").createFolder("services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableManifest readManifest(FileObject fo) {
        InputStream str = null;
        try {
            str = fo.getInputStream();
            EditableManifest editableManifest = new EditableManifest(str);
            return editableManifest;
        }
        catch (IOException exc) {
            err.notify((Throwable)exc);
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException exc) {
                    err.notify((Throwable)exc);
                }
            }
        }
        return new EditableManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeManifest(FileObject fo, EditableManifest manifest) {
        OutputStream str = null;
        FileLock lock = null;
        try {
            lock = fo.lock();
            str = fo.getOutputStream(lock);
            manifest.write(str);
        }
        catch (IOException exc) {
            err.notify((Throwable)exc);
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException exc) {
                    err.notify((Throwable)exc);
                }
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public final class ServicesMoveRefactoringElement
    extends AbstractRefactoringElement {
        private JavaClass clazz;
        private String oldName;
        private NbModuleProject project;

        public ServicesMoveRefactoringElement(JavaClass clazz, FileObject file, NbModuleProject proj) {
            this.name = clazz.getSimpleName();
            this.parentFile = file;
            this.clazz = clazz;
            this.oldName = clazz.getName();
            this.project = proj;
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin = NbMoveRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbMoveRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin), (String)"TXT_ServicesRename", (Object)this.name);
        }

        public void performChange() {
            MoveClassRefactoring move = NbMoveRefactoringPlugin.this.refactoring;
            NbModuleProject newproject = (NbModuleProject)FileOwnerQuery.getOwner((FileObject)move.getTargetClassPathRoot());
            FileObject newFile = this.parentFile;
            if (newproject != this.project) {
                FileObject services = Utility.findMetaInfServices((Project)newproject);
                try {
                    if (services == null) {
                        services = NbMoveRefactoringPlugin.createMetaInf(newproject);
                    }
                    if ((newFile = services.getFileObject(this.parentFile.getNameExt())) == null) {
                        newFile = services.createData(this.parentFile.getNameExt());
                    }
                }
                catch (IOException ex) {
                    err.notify((Throwable)ex);
                }
            }
            String oldcontent = Utility.readFileIntoString(this.parentFile);
            String longName = this.oldName;
            String newName = this.clazz.getName();
            if (oldcontent != null) {
                longName = longName.replaceAll("[.]", "\\.");
                if (newFile == this.parentFile) {
                    oldcontent = oldcontent.replaceAll("^" + longName, newName);
                    Utility.writeFileFromString(this.parentFile, oldcontent);
                } else {
                    oldcontent = oldcontent.replaceAll("^" + longName + "[ \\\n]?", "");
                    String newcontent = Utility.readFileIntoString(newFile);
                    newcontent = newName + "\n" + newcontent;
                    Utility.writeFileFromString(newFile, newcontent);
                    StringTokenizer tok = new StringTokenizer(oldcontent, "\n");
                    boolean hasMoreThanComments = false;
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken().trim();
                        if (token.length() <= 0 || Pattern.matches("^[#].*", token)) continue;
                        hasMoreThanComments = true;
                        break;
                    }
                    if (hasMoreThanComments) {
                        Utility.writeFileFromString(this.parentFile, oldcontent);
                    } else {
                        try {
                            this.parentFile.delete();
                        }
                        catch (IOException exc) {
                            err.notify((Throwable)exc);
                        }
                    }
                }
            }
        }
    }

    public final class ManifestMoveRefactoringElement
    extends AbstractRefactoringElement {
        private JavaClass clazz;
        private String attrName;
        private String sectionName = null;
        private String oldName;
        private NbModuleProject project;
        private FileObject movedFile = null;

        public ManifestMoveRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName, NbModuleProject project) {
            this.name = attributeValue;
            this.clazz = clazz;
            this.parentFile = parentFile;
            this.project = project;
            this.attrName = attributeName;
            this.oldName = clazz.getName();
        }

        public ManifestMoveRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName, String secName, NbModuleProject project) {
            this(clazz, parentFile, attributeValue, attributeName, project);
            this.sectionName = secName;
        }

        public ManifestMoveRefactoringElement(String pathName, FileObject parentFile, String attributeValue, String attributeName, NbModuleProject project, FileObject movedFile) {
            this.name = attributeValue;
            this.parentFile = parentFile;
            this.attrName = attributeName;
            this.oldName = pathName;
            this.project = project;
            this.movedFile = movedFile;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin = NbMoveRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbMoveRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin), (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin = NbMoveRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbMoveRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbMoveRefactoringPlugin), (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
            NbModuleProject targetProject = (NbModuleProject)FileOwnerQuery.getOwner((FileObject)NbMoveRefactoringPlugin.this.refactoring.getTargetClassPathRoot());
            if (NbMoveRefactoringPlugin.this.firstManifestRefactoring) {
                Iterator it = NbMoveRefactoringPlugin.this.manifestRefactorings.iterator();
                while (it.hasNext()) {
                    ManifestMoveRefactoringElement el = (ManifestMoveRefactoringElement)((Object)it.next());
                    if (el.isEnabled()) continue;
                    it.remove();
                }
                FileObject fo = targetProject.getManifestFile();
                NbMoveRefactoringPlugin.this.targetManifest = NbMoveRefactoringPlugin.readManifest(fo);
                NbMoveRefactoringPlugin.this.firstManifestRefactoring = false;
            }
            NbModuleProject sourceProject = this.project;
            EditableManifest sourceManifest = null;
            if (sourceProject == targetProject) {
                sourceManifest = NbMoveRefactoringPlugin.this.targetManifest;
            } else {
                sourceManifest = (EditableManifest)NbMoveRefactoringPlugin.this.oldManifests.get(sourceProject);
                if (sourceManifest == null) {
                    sourceManifest = NbMoveRefactoringPlugin.readManifest(sourceProject.getManifestFile());
                    NbMoveRefactoringPlugin.this.oldManifests.put(sourceProject, sourceManifest);
                }
            }
            if (this.sectionName != null) {
                String newSectionName = this.clazz.getName().replace('.', '/') + ".class";
                NbMoveRefactoringPlugin.this.targetManifest.addSection(newSectionName);
                Iterator it = sourceManifest.getAttributeNames(this.name).iterator();
                while (it.hasNext()) {
                    String secattrname = (String)it.next();
                    NbMoveRefactoringPlugin.this.targetManifest.setAttribute(secattrname, sourceManifest.getAttribute(secattrname, this.name), newSectionName);
                }
                sourceManifest.removeSection(this.name);
            } else {
                if (sourceManifest != NbMoveRefactoringPlugin.this.targetManifest) {
                    sourceManifest.removeAttribute(this.attrName, null);
                }
                if (this.clazz != null) {
                    String newClassname = this.clazz.getName().replace('.', '/') + ".class";
                    NbMoveRefactoringPlugin.this.targetManifest.setAttribute(this.attrName, newClassname, null);
                } else {
                    String newPath = NbMoveRefactoringPlugin.this.refactoring.getTargetPackageName(this.movedFile).replace('.', '/') + "/" + this.movedFile.getNameExt();
                    NbMoveRefactoringPlugin.this.targetManifest.setAttribute(this.attrName, newPath, null);
                }
            }
            NbMoveRefactoringPlugin.this.manifestRefactorings.remove((Object)this);
            if (NbMoveRefactoringPlugin.this.manifestRefactorings.isEmpty()) {
                NbMoveRefactoringPlugin.writeManifest(targetProject.getManifestFile(), NbMoveRefactoringPlugin.this.targetManifest);
                Iterator it = NbMoveRefactoringPlugin.this.oldManifests.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    EditableManifest man = (EditableManifest)entry.getValue();
                    NbModuleProject proj = (NbModuleProject)entry.getKey();
                    if (man == NbMoveRefactoringPlugin.this.targetManifest) continue;
                    NbMoveRefactoringPlugin.writeManifest(proj.getManifestFile(), man);
                }
            }
        }
    }
}

