/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.realm.JDBCRealmForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class SaveJDBCRealmAction
extends Action {
    private String[] createStandardRealmTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        JDBCRealmForm rform = (JDBCRealmForm)form;
        String adminAction = rform.getAdminAction();
        String rObjectName = rform.getObjectName();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parent = rform.getParentObjectName();
                String objectName = ValveUtil.getObjectName(parent, ":type=Realm");
                ObjectName pname = new ObjectName(parent);
                StringBuffer sb = new StringBuffer(pname.getDomain());
                try {
                    if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                        sb.append(":type=Engine");
                        parent = sb.toString();
                    }
                }
                catch (Exception e) {
                    String message = resources.getMessage(locale, "error.engineName.bad", (Object)sb.toString());
                    this.getServlet().log(message);
                    response.sendError(400, message);
                    return null;
                }
                ObjectName oname = new ObjectName(objectName);
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("realmName", new ActionError("error.realmName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                String domain = oname.getDomain();
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new String[]{parent, rform.getDriver(), rform.getConnectionName(), rform.getConnectionPassword(), rform.getConnectionURL()};
                operation = "createJDBCRealm";
                rObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardRealmTypes);
                if (rObjectName == null) {
                    request.setAttribute("warning", (Object)"error.jdbcrealm");
                    return mapping.findForward("Save Unsuccessful");
                }
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    TreeControlNode parentNode = control.findNode(rform.getParentObjectName());
                    if (parentNode != null) {
                        String nodeLabel = rform.getNodeLabel();
                        String encodedName = URLEncoder.encode(rObjectName, "UTF-8");
                        TreeControlNode childNode = new TreeControlNode(rObjectName, "Realm.gif", nodeLabel, "EditRealm.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parent + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        String value = null;
        try {
            ObjectName roname = new ObjectName(rObjectName);
            attribute = "digest";
            value = rform.getDigest();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "driverName";
            value = rform.getDriver();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "roleNameCol";
            value = rform.getRoleNameCol();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "userNameCol";
            value = rform.getUserNameCol();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "userCredCol";
            value = rform.getPasswordCol();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "userTable";
            value = rform.getUserTable();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "userRoleTable";
            value = rform.getRoleTable();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "connectionName";
            value = rform.getConnectionName();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "connectionURL";
            value = rform.getConnectionURL();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
            attribute = "connectionPassword";
            value = rform.getConnectionPassword();
            this.setAttributeIfPresent(this.mBServer, roname, attribute, value);
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }

    protected void setAttributeIfPresent(MBeanServer mBServer, ObjectName roname, String attribute, String value) throws JMException {
        if (mBServer == null || roname == null || attribute == null) {
            throw new IllegalArgumentException("MBeanServer, ObjectName, attribute required.");
        }
        if (value != null && value.trim().length() > 0) {
            mBServer.setAttribute(roname, new Attribute(attribute, value));
        }
    }
}

