/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.server;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.server.ServerForm;

public class EditServerAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        String nodeLabel = request.getParameter("nodeLabel");
        String select = request.getParameter("select");
        ServerForm serverFm = new ServerForm();
        session.setAttribute("serverForm", (Object)serverFm);
        serverFm.setNodeLabel(nodeLabel);
        serverFm.setObjectName(select);
        ObjectName sname = null;
        try {
            sname = new ObjectName(select);
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.serviceName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        String attribute = null;
        try {
            attribute = "port";
            serverFm.setPortNumberText(((Integer)this.mBServer.getAttribute(sname, attribute)).toString());
            attribute = "shutdown";
            serverFm.setShutdownText((String)this.mBServer.getAttribute(sname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        return mapping.findForward("Server");
    }
}

