/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.net.URLDecoder;
import javax.management.MBeanServer;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.BaseForm;
import org.apache.webapp.admin.users.UserUtils;

public final class UserForm
extends BaseForm {
    private MBeanServer mserver = null;
    private String fullName = null;
    private String[] groups = new String[0];
    private String password = null;
    private String[] roles = new String[0];
    private String username = null;

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        if (groups == null) {
            groups = new String[]{};
        }
        this.groups = groups;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        if (roles == null) {
            roles = new String[]{};
        }
        this.roles = roles;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.fullName = null;
        this.groups = new String[0];
        this.password = null;
        this.roles = new String[0];
        this.username = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        try {
            if (this.mserver == null) {
                this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
            }
            String databaseName = URLDecoder.decode(request.getParameter("databaseName"), "UTF-8");
            request.setAttribute("groupsForm", (Object)UserUtils.getGroupsForm(this.mserver, databaseName));
            request.setAttribute("rolesForm", (Object)UserUtils.getRolesForm(this.mserver, databaseName));
        }
        catch (Exception e) {
            // empty catch block
        }
        ActionErrors errors = new ActionErrors();
        String submit = request.getParameter("submit");
        if (this.username == null || this.username.length() < 1) {
            errors.add("username", new ActionError("users.error.username.required"));
        }
        if (this.password == null || this.username.length() < 1) {
            errors.add("password", new ActionError("users.error.password.required"));
        }
        if (this.username != null && this.username.indexOf(34) >= 0) {
            errors.add("username", new ActionError("users.error.quotes"));
        }
        if (this.password != null && this.password.indexOf(34) > 0) {
            errors.add("description", new ActionError("users.error.quotes"));
        }
        if (this.fullName != null && this.fullName.indexOf(34) > 0) {
            errors.add("fullName", new ActionError("users.error.quotes"));
        }
        return errors;
    }
}

