/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.folding;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.modules.html.editor.folding.HTMLFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public class HTMLFoldManager
implements FoldManager,
SettingsChangeListener {
    private static final boolean SHOW_TIMES;
    private FoldOperation operation;
    private HTMLSyntaxSupport sup;
    private Timer timer;
    private TimerTask timerTask;
    private int foldsUpdateInterval = -1;
    boolean documentDirty = true;
    private static final String FOLD_MANAGER_CREATED = "FOLD_MANAGER_CREATED";
    private BaseDocument doc = null;
    private static final boolean debug = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation operation) {
        this.operation = operation;
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.getOperation().getHierarchy().getComponent().getDocument();
        if (doc instanceof BaseDocument && doc.getLength() > 0 && doc.getProperty(FOLD_MANAGER_CREATED) == null) {
            this.doc = (BaseDocument)doc;
            doc.putProperty(FOLD_MANAGER_CREATED, new Object());
            this.sup = new HTMLSyntaxSupport(this.getDocument());
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    private void restartTimer() {
        this.documentDirty = true;
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, this.foldsUpdateInterval);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                Thread thr = new Thread(new Runnable(){

                    public void run() {
                        try {
                            (this).HTMLFoldManager.this.documentDirty = false;
                            HTMLFoldManager.this.updateFolds();
                        }
                        catch (ParsingCancelledException parsingCancelledException) {
                            // empty catch block
                        }
                    }
                });
                thr.setPriority(2);
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public void release() {
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt.getSettingName() == "code-folding-update-interval") {
            this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
            this.restartTimer();
        }
    }

    private List generateFolds() throws BadLocationException, ParsingCancelledException {
        return this.generateFolds((HTMLSyntaxSupport)this.getDocument().getSyntaxSupport());
    }

    List generateFolds(HTMLSyntaxSupport sup) throws BadLocationException, ParsingCancelledException {
        Stack<Object> stack = new Stack<Object>();
        ArrayList<FoldInfo> generated = new ArrayList<FoldInfo>(100);
        SyntaxElement sel = sup.getElementChain(0);
        while (sel != null) {
            if (this.documentDirty) {
                throw new ParsingCancelledException();
            }
            if (sel.getType() == 4) {
                SyntaxElement.Tag tag = (SyntaxElement.Tag)sel;
                if (tag.isEmpty()) {
                    generated.add(new FoldInfo(sel.getElementOffset() - 1, sel.getElementOffset() + sel.getElementLength(), HTMLFoldTypes.TAG, this.getSingletonTagFoldName(tag.getName())));
                } else {
                    stack.push(sel);
                }
            } else if (sel.getType() == 5) {
                SyntaxElement.Named endtag = (SyntaxElement.Named)sel;
                if (!stack.isEmpty()) {
                    SyntaxElement top = (SyntaxElement)stack.peek();
                    if (top.getType() == 4 && ((SyntaxElement.Tag)top).getName().equalsIgnoreCase(endtag.getName())) {
                        generated.add(new FoldInfo(top.getElementOffset() - 1, endtag.getElementOffset() + endtag.getElementLength(), HTMLFoldTypes.TAG, this.getTagFoldName(((SyntaxElement.Tag)top).getName())));
                        stack.pop();
                    } else {
                        ArrayList<SyntaxElement.Tag> savedElements = new ArrayList<SyntaxElement.Tag>();
                        boolean foundStartTag = false;
                        while (!stack.isEmpty()) {
                            SyntaxElement.Tag start = (SyntaxElement.Tag)stack.pop();
                            savedElements.add(start);
                            if (!start.getName().equalsIgnoreCase(endtag.getName())) continue;
                            generated.add(new FoldInfo(start.getElementOffset() - 1, endtag.getElementOffset() + endtag.getElementLength(), HTMLFoldTypes.TAG, this.getTagFoldName(start.getName())));
                            foundStartTag = true;
                            break;
                        }
                        if (!foundStartTag) {
                            for (int i = savedElements.size() - 1; i >= 0; --i) {
                                stack.push(savedElements.get(i));
                            }
                        }
                    }
                }
            } else if (sel.getType() == 0) {
                generated.add(new FoldInfo(sel.getElementOffset(), sel.getElementOffset() + sel.getElementLength(), HTMLFoldTypes.COMMENT, "<!--...-->"));
            }
            sel = this.getNextSyntaxElement(sel);
        }
        return generated;
    }

    private String getSingletonTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append("/>");
        return sb.toString();
    }

    private String getTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append(">...</");
        sb.append(tagName);
        sb.append(">");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFolds() throws ParsingCancelledException {
        FoldHierarchy fh = this.getOperation().getHierarchy();
        long startTime = System.currentTimeMillis();
        try {
            List generated = this.generateFolds();
            if (SHOW_TIMES) {
                System.out.println("[html folding] parsing of text of " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - startTime) + " millis.");
            }
            Iterator itr = generated.iterator();
            HashSet<FoldInfo> olfs = new HashSet<FoldInfo>();
            while (itr.hasNext()) {
                FoldInfo elem = (FoldInfo)itr.next();
                if (!this.isOneLineElement(elem)) continue;
                olfs.add(elem);
            }
            generated.removeAll(olfs);
            List existingFolds = FoldUtilities.findRecursive((Fold)fh.getRootFold());
            if (!$assertionsDisabled && existingFolds == null) {
                throw new AssertionError((Object)"Existing folds is null!");
            }
            final ArrayList<FoldInfo> newborns = new ArrayList<FoldInfo>(generated.size() / 2);
            final ArrayList<Fold> zombies = new ArrayList<Fold>(generated.size() / 2);
            Iterator genItr = generated.iterator();
            Hashtable<Integer, FoldInfo> newbornsLinesCache = new Hashtable<Integer, FoldInfo>();
            ArrayList<FoldInfo> duplicateNewborns = new ArrayList<FoldInfo>();
            while (genItr.hasNext()) {
                FoldInfo fi = (FoldInfo)genItr.next();
                int fiLineOffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset);
                FoldInfo found = (FoldInfo)newbornsLinesCache.get(new Integer(fiLineOffset));
                if (found != null && found.endOffset < fi.endOffset) {
                    duplicateNewborns.add(found);
                }
                newbornsLinesCache.put(new Integer(fiLineOffset), fi);
                Fold fs = FoldUtilities.findNearestFold((FoldHierarchy)fh, (int)fi.startOffset);
                if (fs != null && fs.getStartOffset() == fi.startOffset && fs.getEndOffset() == fi.endOffset) {
                    if (fi.foldType == fs.getType() && fi.description.equals(fs.getDescription())) continue;
                    zombies.add(fs);
                    newborns.add(fi);
                    continue;
                }
                newborns.add(fi);
            }
            newborns.removeAll(duplicateNewborns);
            existingFolds.removeAll(zombies);
            Hashtable<Integer, Fold> linesToFoldsCache = new Hashtable<Integer, Fold>();
            Iterator extItr = existingFolds.iterator();
            while (extItr.hasNext()) {
                Fold f = (Fold)extItr.next();
                Iterator genItr2 = generated.iterator();
                boolean found = false;
                while (genItr2.hasNext()) {
                    FoldInfo fi = (FoldInfo)genItr2.next();
                    if (f.getStartOffset() != fi.startOffset || f.getEndOffset() != fi.endOffset) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    zombies.add(f);
                    continue;
                }
                int lineoffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)f.getStartOffset());
                linesToFoldsCache.put(new Integer(lineoffset), f);
            }
            Iterator newbornsItr = newborns.iterator();
            ArrayList<FoldInfo> newbornsToRemove = new ArrayList<FoldInfo>();
            while (newbornsItr.hasNext()) {
                FoldInfo fi = (FoldInfo)newbornsItr.next();
                Fold existing = (Fold)linesToFoldsCache.get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset)));
                if (existing == null) continue;
                if (existing.getEndOffset() < fi.endOffset) {
                    zombies.add(existing);
                    continue;
                }
                newbornsToRemove.add(fi);
            }
            newborns.removeAll(newbornsToRemove);
            if (SHOW_TIMES) {
                System.out.println("[html folding] parsing and mangles with elements for " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - startTime) + " millis.");
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HTMLFoldManager.this.getDocument().readLock();
                    try {
                        FoldHierarchy fh = HTMLFoldManager.this.getOperation().getHierarchy();
                        fh.lock();
                        try {
                            FoldHierarchyTransaction fhTran = HTMLFoldManager.this.getOperation().openTransaction();
                            try {
                                Iterator i = zombies.iterator();
                                while (i.hasNext()) {
                                    Fold f = (Fold)i.next();
                                    if (HTMLFoldManager.this.getDocument().getLength() == 0) break;
                                    HTMLFoldManager.this.getOperation().removeFromHierarchy(f, fhTran);
                                }
                                Iterator newFolds = newborns.iterator();
                                while (newFolds.hasNext()) {
                                    FoldInfo f = (FoldInfo)newFolds.next();
                                    if (HTMLFoldManager.this.getDocument().getLength() == 0) {
                                        break;
                                    }
                                    if (f.startOffset < 0 || f.endOffset < 0 || f.startOffset >= f.endOffset || f.endOffset > HTMLFoldManager.this.getDocument().getLength()) continue;
                                    HTMLFoldManager.this.getOperation().addToHierarchy(f.foldType, f.description, false, f.startOffset, f.endOffset, 0, 0, null, fhTran);
                                }
                            }
                            catch (BadLocationException ble) {
                                Document fhDoc = HTMLFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
                                if (fhDoc.getLength() > 0) {
                                    ErrorManager.getDefault().notify((Throwable)ble);
                                }
                            }
                            finally {
                                fhTran.commit();
                            }
                        }
                        finally {
                            fh.unlock();
                        }
                    }
                    finally {
                        HTMLFoldManager.this.getDocument().readUnlock();
                    }
                }
            });
        }
        catch (BadLocationException e) {
            Document fhDoc = this.getOperation().getHierarchy().getComponent().getDocument();
            if (fhDoc.getLength() > 0) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException ite) {
            ErrorManager.getDefault().notify((Throwable)ite);
        }
        catch (ParsingCancelledException pce) {
            throw new ParsingCancelledException();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        long foldsGenerationTime = System.currentTimeMillis() - startTime;
        if (SHOW_TIMES) {
            System.out.println("[html folding] folds for " + this.getDocument().getProperty((Object)"title") + " generated in " + foldsGenerationTime + " millis.");
        }
    }

    private boolean isOneLineElement(FoldInfo fi) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.endOffset);
    }

    private boolean foldsBoundariesEquals(Fold f1, Fold f2) {
        return f1.getStartOffset() == f2.getStartOffset() && f1.getEndOffset() == f2.getEndOffset();
    }

    private SyntaxElement getNextSyntaxElement(SyntaxElement se) throws BadLocationException {
        SyntaxElement next = se.getNext();
        if (next != null && next.getType() == 4 && ((SyntaxElement.Named)next).getName().startsWith("<") && (next = next.getNext()) == null) {
            return null;
        }
        return next;
    }

    private int getSetting(String settingName) {
        JTextComponent tc = this.getOperation().getHierarchy().getComponent();
        return SettingsUtil.getInteger((Class)Utilities.getKitClass((JTextComponent)tc), (String)settingName, (Integer)HTMLSettingsDefaults.defaultCodeFoldingUpdateInterval);
    }

    static {
        $assertionsDisabled = !HTMLFoldManager.class.desiredAssertionStatus();
        SHOW_TIMES = Boolean.getBoolean("org.netbeans.modules.html.editor.folding.measure");
    }

    static class ParsingCancelledException
    extends Exception {
    }

    static class FoldInfo {
        public int startOffset;
        public int endOffset;
        public FoldType foldType = null;
        public String description = null;

        public FoldInfo(int startOffset, int endOffset, FoldType foldType, String description) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.foldType = foldType;
            this.description = description;
        }

        public String toString() {
            return "FI(" + this.description + ", " + this.foldType + ", <" + this.startOffset + "-" + this.endOffset + ">)";
        }
    }
}

