/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.Color;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.CodeTemplateParameterImpl;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;

final class CodeTemplateDrawLayer
extends DrawLayer.AbstractLayer {
    public static final String NAME = "code-template-draw-layer";
    public static final int VISIBILITY = 5000;
    private static final Coloring COLORING = new Coloring(null, null, new Color(138, 191, 236));
    private static int instanceCounter;
    private CodeTemplateParameterImpl paramImpl;
    private CodeTemplateInsertHandler handler;
    private int regionIndex;
    private Position regionStartPosition;
    private Position regionEndPosition;
    private boolean colorBackground;
    private Coloring coloring;
    private boolean textFramePropertyAssigned;

    CodeTemplateDrawLayer(CodeTemplateParameterImpl paramImpl) {
        super(NAME + instanceCounter++);
        this.paramImpl = paramImpl;
        this.handler = paramImpl.getHandler();
    }

    public void init(DrawContext ctx) {
        this.coloring = null;
        JTextComponent c = ctx.getEditorUI().getComponent();
        this.regionStartPosition = null;
        if (c != null) {
            if (this.handler.getActiveMasterImpl() == this.paramImpl) {
                this.colorBackground = true;
                int startOffset = ctx.getStartOffset();
                this.regionIndex = 0;
                SyncDocumentRegion syncRegion = this.paramImpl.getRegion();
                int regionCount = syncRegion.getRegionCount();
                while (this.regionIndex < regionCount) {
                    MutablePositionRegion region = syncRegion.getSortedRegion(this.regionIndex);
                    Position startPos = region.getStartPosition();
                    if (startOffset <= startPos.getOffset()) {
                        this.regionStartPosition = startPos;
                        this.regionEndPosition = region.getEndPosition();
                        this.setNextActivityChangeOffset(this.regionStartPosition.getOffset());
                        break;
                    }
                    ++this.regionIndex;
                }
            } else {
                this.colorBackground = false;
            }
        }
    }

    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        if (this.regionStartPosition != null) {
            int regionStartOffset = this.regionStartPosition.getOffset();
            int regionEndOffset = this.regionEndPosition.getOffset();
            int fragmentOffset = ctx.getFragmentOffset();
            SyncDocumentRegion syncRegion = this.paramImpl.getRegion();
            if (fragmentOffset == regionStartOffset && regionStartOffset != regionEndOffset) {
                if (regionStartOffset == syncRegion.getFirstRegionStartOffset()) {
                    JTextComponent c = ctx.getEditorUI().getComponent();
                    c.putClientProperty("text-frame-start-position", this.regionStartPosition);
                    c.putClientProperty("text-frame-end-position", this.regionEndPosition);
                    this.textFramePropertyAssigned = true;
                }
                this.coloring = this.colorBackground ? COLORING : null;
                this.setNextActivityChangeOffset(regionEndOffset);
            } else if (fragmentOffset == regionEndOffset) {
                this.coloring = null;
                ++this.regionIndex;
                if (this.regionIndex < syncRegion.getRegionCount()) {
                    MutablePositionRegion region = syncRegion.getSortedRegion(this.regionIndex);
                    this.regionStartPosition = region.getStartPosition();
                    this.regionEndPosition = region.getEndPosition();
                    this.setNextActivityChangeOffset(this.regionStartPosition.getOffset());
                } else {
                    this.regionStartPosition = null;
                    this.regionEndPosition = null;
                }
                JTextComponent c = ctx.getEditorUI().getComponent();
                this.resetTextFrameProperties(c);
            }
            return true;
        }
        return false;
    }

    void resetTextFrameProperties(JTextComponent c) {
        if (this.textFramePropertyAssigned) {
            c.putClientProperty("text-frame-start-position", null);
            c.putClientProperty("text-frame-end-position", null);
            this.textFramePropertyAssigned = false;
        }
    }

    public void updateContext(DrawContext ctx) {
        if (this.coloring != null) {
            this.coloring.apply(ctx);
        }
    }
}

