/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.IOException;
import org.netbeans.modules.pdf.PDFDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class PDFDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = -4354042385752587850L;
    private static final String PDF_MIME_TYPE = "application/pdf";

    public PDFDataLoader() {
        super("org.netbeans.modules.pdf.PDFDataObject");
    }

    public PDFDataLoader(Class recognizedObject) {
        super(recognizedObject);
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensions = new ExtensionList();
        extensions.addMimeType(PDF_MIME_TYPE);
        extensions.addMimeType("application/x-pdf");
        extensions.addMimeType("application/vnd.pdf");
        extensions.addMimeType("application/acrobat");
        extensions.addMimeType("text/pdf");
        extensions.addMimeType("text/x-pdf");
        this.setExtensions(extensions);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)PDFDataLoader.class, (String)"LBL_loaderName");
    }

    protected String actionsContext() {
        return "Loaders/application/pdf/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new PDFDataObject(primaryFile, (MultiFileLoader)this);
    }
}

