/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.text.MessageFormat;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;

final class FSException
extends IOException {
    private Object[] args;

    private FSException(String resource, Object[] args) {
        super(resource);
        this.args = args;
    }

    public String getMessage() {
        return " " + this.getLocalizedMessage();
    }

    public String getLocalizedMessage() {
        String res = super.getMessage();
        String format = FileSystem.getString(res);
        if (this.args != null) {
            return MessageFormat.format(format, this.args);
        }
        return format;
    }

    public static void io(String resource) throws IOException {
        FSException fsExc = new FSException(resource, null);
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }

    public static void io(String resource, Object[] args) throws IOException {
        FSException fsExc = new FSException(resource, args);
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }

    public static void io(String resource, Object arg1) throws IOException {
        FSException fsExc = new FSException(resource, new Object[]{arg1});
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }

    public static void io(String resource, Object arg1, Object arg2) throws IOException {
        FSException fsExc = new FSException(resource, new Object[]{arg1, arg2});
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }

    public static void io(String resource, Object arg1, Object arg2, Object arg3) throws IOException {
        FSException fsExc = new FSException(resource, new Object[]{arg1, arg2, arg3});
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }

    public static void io(String resource, Object arg1, Object arg2, Object arg3, Object arg4) throws IOException {
        FSException fsExc = new FSException(resource, new Object[]{arg1, arg2, arg3, arg4});
        ErrorManager.getDefault().annotate((Throwable)fsExc, 16, null, fsExc.getLocalizedMessage(), null, null);
        throw fsExc;
    }
}

