/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class LongEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 8;
    }

    public int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 8 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfLong", new Object[]{new Integer(8)}));
        }
        return octetLength / 8;
    }

    public final void encodeToBytesFromLongArray(long[] ldata, int lstart, int llength, byte[] b, int start) {
        int lend = lstart + llength;
        int i = lstart;
        while (i < lend) {
            long bits = ldata[i];
            b[start++] = (byte)(bits >>> 56 & 0xFFL);
            b[start++] = (byte)(bits >>> 48 & 0xFFL);
            b[start++] = (byte)(bits >>> 40 & 0xFFL);
            b[start++] = (byte)(bits >>> 32 & 0xFFL);
            b[start++] = (byte)(bits >>> 24 & 0xFFL);
            b[start++] = (byte)(bits >>> 16 & 0xFFL);
            b[start++] = (byte)(bits >>> 8 & 0xFFL);
            b[start++] = (byte)(bits & 0xFFL);
            ++i;
        }
    }

    public final void decodeFromBytesToLongArray(long[] ldata, int istart, byte[] b, int start, int length) {
        int size = length / 8;
        int i = 0;
        while (i < size) {
            ldata[istart++] = (long)(b[start++] & 0xFF) << 56 | (long)(b[start++] & 0xFF) << 48 | (long)(b[start++] & 0xFF) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final long[] decodeFromInputStreamToIntArray(InputStream s) throws IOException {
        longList = new ArrayList<Long>();
        b = new byte[8];
        while (true) {
            block3: {
                if ((n = s.read(b)) == 8) break block3;
                if (n != -1) ** GOTO lbl11
                break;
lbl-1000:
                // 1 sources

                {
                    m = s.read(b, n, 8 - n);
                    if (m == -1) {
                        throw new EOFException();
                    }
                    n += m;
lbl11:
                    // 2 sources

                    ** while (n != 8)
                }
            }
            l = (b[0] & 255) << 56 | (b[1] & 255) << 48 | (b[2] & 255) << 40 | (b[3] & 255) << 32 | (b[4] & 255) << 24 | (b[5] & 255) << 16 | (b[6] & 255) << 8 | b[7] & 255;
            longList.add(new Long(l));
        }
        return this.generateArrayFromList(longList);
    }

    public final void encodeToOutputStreamFromLongArray(long[] ldata, OutputStream s) throws IOException {
        int i = 0;
        while (i < ldata.length) {
            long bits = ldata[i];
            s.write((int)(bits >>> 56 & 0xFFL));
            s.write((int)(bits >>> 48 & 0xFFL));
            s.write((int)(bits >>> 40 & 0xFFL));
            s.write((int)(bits >>> 32 & 0xFFL));
            s.write((int)(bits >>> 24 & 0xFFL));
            s.write((int)(bits >>> 16 & 0xFFL));
            s.write((int)(bits >>> 8 & 0xFFL));
            s.write((int)(bits & 0xFFL));
            ++i;
        }
    }

    public final void encodeToBytes(Object array, int astart, int alength, byte[] b, int start) {
        this.encodeToBytesFromLongArray((long[])array, astart, alength, b, start);
    }

    public final Object decodeFromBytes(byte[] b, int start, int length) throws EncodingAlgorithmException {
        long[] data = new long[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToLongArray(data, 0, b, start, length);
        return data;
    }

    public Object convertFromCharacters(char[] ch, int start, int length) {
        final CharBuffer cb = CharBuffer.wrap(ch, start, length);
        final ArrayList longList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb, new BuiltInEncodingAlgorithm.WordListener(){

            public void word(int start, int end) {
                String lStringValue = cb.subSequence(start, end).toString();
                longList.add(Long.valueOf(lStringValue));
            }
        });
        return this.generateArrayFromList(longList);
    }

    public final void convertToCharactersFromLongArray(long[] ldata, StringBuffer s) {
        int end = ldata.length - 1;
        int i = 0;
        while (i <= end) {
            s.append(Long.toString(ldata[i]));
            if (i != end) {
                s.append(' ');
            }
            ++i;
        }
    }

    public final long[] generateArrayFromList(List array) {
        long[] ldata = new long[array.size()];
        int i = 0;
        while (i < ldata.length) {
            ldata[i] = (Long)array.get(i);
            ++i;
        }
        return ldata;
    }

    public void encodeToOutputStream(Object data, OutputStream s) throws IOException {
        if (!(data instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data;
        this.encodeToOutputStreamFromLongArray(ldata, s);
    }

    public final Object decodeFromInputStream(InputStream s) throws IOException {
        return this.decodeFromInputStreamToIntArray(s);
    }

    public void convertToCharacters(Object data, StringBuffer s) {
        if (!(data instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data;
        this.convertToCharactersFromLongArray(ldata, s);
    }
}

