/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentChooserEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor {
    public static final int ALL_COMPONENTS = 0;
    public static final int VISUAL_COMPONENTS = 1;
    public static final int OTHER_COMPONENTS = 2;
    private static final String NULL_REF = "null";
    private static final String INVALID_REF = "default";
    private static String noneText = null;
    private static String invalidText = null;
    private FormModel formModel;
    private List components;
    private Class[] beanTypes = null;
    private int componentCategory = 0;
    private ComponentRef value;
    private PropertyChangeSupport changeSupport;
    private static final String XML_COMPONENT = "ComponentRef";
    private static final String ATTR_NAME = "name";

    public ComponentChooserEditor() {
    }

    public ComponentChooserEditor(Class[] componentTypes) {
        this.beanTypes = componentTypes;
    }

    public void setValue(Object value) {
        if (value == null || value instanceof ComponentRef) {
            this.value = (ComponentRef)value;
        } else if (value instanceof RADComponent) {
            this.value = new ComponentRef((RADComponent)value);
        } else if (value instanceof String) {
            this.value = new ComponentRef((String)value);
        } else {
            return;
        }
        this.firePropertyChange();
    }

    public Object getValue() {
        if (this.value != null && INVALID_REF.equals(this.value.getDescription())) {
            return BeanSupport.NO_VALUE;
        }
        return this.value;
    }

    public String[] getTags() {
        List compList = this.getComponents();
        int count = compList.size() + 1;
        Object[] names = new String[count];
        names[0] = this.noneString();
        if (count > 1) {
            for (int i = 1; i < count; ++i) {
                names[i] = ((RADComponent)compList.get(i - 1)).getName();
            }
            Arrays.sort(names, 1, count);
        }
        return names;
    }

    public String getAsText() {
        if (this.value == null) {
            return this.noneString();
        }
        if (this.value.getComponent() == null) {
            return this.invalidString();
        }
        String str = this.value.getDescription();
        return NULL_REF.equals(str) ? this.noneString() : str;
    }

    public void setAsText(String str) {
        if (str == null || str.equals("") || str.equals(this.noneString())) {
            this.setValue(null);
        } else {
            this.setValue(str);
        }
    }

    public String getJavaInitializationString() {
        return this.value != null ? this.value.getJavaInitString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        ComponentChooserEditor componentChooserEditor = this;
        synchronized (componentChooserEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void setFormModel(FormModel model) {
        this.formModel = model;
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public void setBeanTypes(Class[] types) {
        this.beanTypes = types;
    }

    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setComponentCategory(int cat) {
        this.componentCategory = cat;
    }

    public int getComponentCategory() {
        return this.componentCategory;
    }

    public Node storeToXML(Document doc) {
        String nameStr = this.value != null ? (this.value.getComponent() != null ? this.value.getDescription() : INVALID_REF) : NULL_REF;
        Element el = doc.createElement(XML_COMPONENT);
        el.setAttribute(ATTR_NAME, nameStr);
        return el;
    }

    public void readFromXML(Node element) throws IOException {
        String name;
        Node nameAttr;
        if (!XML_COMPONENT.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null && (nameAttr = attributes.getNamedItem(ATTR_NAME)) != null && (name = nameAttr.getNodeValue()) != null) {
            this.value = new ComponentRef(name);
        }
    }

    protected List getComponents() {
        if (this.components == null) {
            this.components = new ArrayList();
        } else {
            this.components.clear();
        }
        if (this.formModel != null) {
            RADComponent[] comps;
            if (this.componentCategory == 1) {
                comps = this.formModel.getVisualComponents();
            } else if (this.componentCategory == 2) {
                comps = this.formModel.getOtherComponents(true);
            } else {
                List allComps = this.formModel.getMetaComponents();
                comps = allComps.toArray(new RADComponent[allComps.size()]);
            }
            for (int i = 0; i < comps.length; ++i) {
                if (!this.acceptBean(comps[i])) continue;
                this.components.add(comps[i]);
            }
        }
        return this.components;
    }

    protected boolean acceptBean(RADComponent comp) {
        if (this.beanTypes == null) {
            return true;
        }
        boolean match = false;
        for (int i = 0; i < this.beanTypes.length && !match; ++i) {
            match = this.beanTypes[i].isAssignableFrom(comp.getBeanClass());
        }
        return match;
    }

    protected String noneString() {
        if (noneText == null) {
            noneText = FormUtils.getBundleString("CTL_NoComponent");
        }
        return noneText;
    }

    protected String invalidString() {
        if (invalidText == null) {
            invalidText = FormUtils.getBundleString("CTL_InvalidReference");
        }
        return invalidText;
    }

    protected final void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    private class ComponentRef
    implements RADComponent.ComponentReference,
    FormDesignValue {
        private String componentName;
        private RADComponent component;

        ComponentRef(String name) {
            this.componentName = name;
        }

        ComponentRef(RADComponent metacomp) {
            this.componentName = metacomp.getName();
            this.component = metacomp;
        }

        public FormDesignValue copy(FormModel formModel) {
            return null;
        }

        public boolean equals(Object obj) {
            boolean equal;
            if (obj instanceof ComponentRef) {
                ComponentRef ref = (ComponentRef)obj;
                boolean bl = equal = ref.component == this.component;
                equal = this.componentName == null ? equal && ref.componentName == null : equal && this.componentName.equals(ref.componentName);
            } else {
                equal = obj instanceof RADComponent && obj == this.component;
            }
            return equal;
        }

        String getJavaInitString() {
            this.checkComponent();
            if (this.component != null) {
                if (this.component == this.component.getFormModel().getTopRADComponent()) {
                    return "this";
                }
            } else if (!ComponentChooserEditor.NULL_REF.equals(this.componentName)) {
                return null;
            }
            return this.componentName;
        }

        public RADComponent getComponent() {
            this.checkComponent();
            return this.component;
        }

        public String getDescription() {
            this.checkComponent();
            return this.componentName;
        }

        public Object getDesignValue() {
            this.checkComponent();
            return this.component != null ? this.component.getBeanInstance() : IGNORED_VALUE;
        }

        private void checkComponent() {
            if (this.component == null && !ComponentChooserEditor.NULL_REF.equals(this.componentName) && !ComponentChooserEditor.INVALID_REF.equals(this.componentName)) {
                List compList = ComponentChooserEditor.this.getComponents();
                for (RADComponent comp : compList) {
                    if (!comp.getName().equals(this.componentName)) continue;
                    if (comp.isInModel()) {
                        this.component = comp;
                    }
                    break;
                }
            } else if (this.component != null) {
                if (!this.component.isInModel()) {
                    this.component = null;
                } else {
                    this.componentName = this.component.getName();
                }
            }
        }
    }
}

