/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public final class PaletteItem
implements Node.Cookie {
    private PaletteItemDataObject itemDataObject;
    ClassSource componentClassSource;
    String componentType_explicit;
    private Class componentClass;
    private Throwable lastError;
    private int componentType = -1;
    private static final int LAYOUT = 1;
    private static final int BORDER = 2;
    private static final int VISUAL = 4;
    private static final int MENU = 8;
    private static final int TYPE_MASK = 15;

    PaletteItem(PaletteItemDataObject dobj) {
        this.itemDataObject = dobj;
    }

    void setComponentClassSource(String className, String[] cpTypes, String[] cpNames) {
        this.componentClassSource = new ClassSource(className, cpTypes, cpNames);
    }

    void setComponentExplicitType(String type) {
        this.componentType_explicit = type;
    }

    public Node getNode() {
        return this.itemDataObject.getNodeDelegate();
    }

    public String getId() {
        return this.getComponentClassName();
    }

    public String getComponentClassName() {
        return this.componentClassSource.getClassName();
    }

    public ClassSource getComponentClassSource() {
        return this.componentClassSource;
    }

    public Class getComponentClass() {
        if (this.componentClass == null && this.lastError == null) {
            this.componentClass = this.loadComponentClass();
        }
        return this.componentClass;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public String getExplicitComponentType() {
        return this.componentType_explicit;
    }

    public boolean isVisual() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 4) != 0;
    }

    public boolean isMenu() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 8) != 0;
    }

    public boolean isLayout() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 1;
    }

    public boolean isBorder() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 2;
    }

    public String toString() {
        return PaletteUtils.getItemComponentDescription(this);
    }

    String getDisplayName() {
        BeanDescriptor bd = this.getBeanDescriptor();
        return bd != null ? bd.getDisplayName() : null;
    }

    String getTooltip() {
        BeanDescriptor bd = this.getBeanDescriptor();
        return bd != null ? bd.getShortDescription() : null;
    }

    Image getIcon(int type) {
        BeanInfo bi = this.getBeanInfo();
        return bi != null ? bi.getIcon(type) : null;
    }

    void reset() {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.itemDataObject.displayName = null;
        this.itemDataObject.tooltip = null;
        this.itemDataObject.icon16 = null;
        this.itemDataObject.icon32 = null;
    }

    private Class loadComponentClass() {
        try {
            return FormUtils.loadSystemClass(this.getComponentClassName());
        }
        catch (ClassNotFoundException cnfex) {
            try {
                return ClassPathUtils.loadClass(this.getComponentClassSource());
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                this.lastError = ex;
            }
            catch (LinkageError ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                this.lastError = ex;
            }
            return null;
        }
    }

    private BeanInfo getBeanInfo() {
        Class compClass = this.getComponentClass();
        if (compClass != null) {
            try {
                return Introspector.getBeanInfo(compClass);
            }
            catch (Exception ex) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanDescriptor getBeanDescriptor() {
        Class compClass = this.getComponentClass();
        if (compClass != null) {
            try {
                return Introspector.getBeanInfo(compClass).getBeanDescriptor();
            }
            catch (Exception ex) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    private void resolveComponentType() {
        if (this.componentType_explicit == null) {
            this.componentType = 0;
            Class compClass = this.getComponentClass();
            if (compClass == null) {
                return;
            }
            if (LayoutManager.class.isAssignableFrom(compClass)) {
                this.componentType = 1;
                return;
            }
            if (Border.class.isAssignableFrom(compClass)) {
                this.componentType = 2;
                return;
            }
            if (Component.class.isAssignableFrom(compClass)) {
                this.componentType |= 4;
            }
            if (MenuComponent.class.isAssignableFrom(compClass) || JMenuItem.class.isAssignableFrom(compClass) || JMenuBar.class.isAssignableFrom(compClass) || JPopupMenu.class.isAssignableFrom(compClass)) {
                this.componentType |= 8;
            }
        } else {
            this.componentType = "visual".equalsIgnoreCase(this.componentType_explicit) ? 4 : ("layout".equalsIgnoreCase(this.componentType_explicit) ? 1 : ("border".equalsIgnoreCase(this.componentType_explicit) ? 2 : ("menu".equalsIgnoreCase(this.componentType_explicit) ? 12 : 0)));
        }
    }
}

