/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.DebuggerOutput;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
JPDABreakpointListener,
PropertyChangeListener {
    private static final Pattern dollarEscapePattern = Pattern.compile("\\$");
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final Pattern threadNamePattern = Pattern.compile("\\{threadName\\}");
    private static final Pattern classNamePattern = Pattern.compile("\\{className\\}");
    private static final Pattern methodNamePattern = Pattern.compile("\\{methodName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private IOManager ioManager;
    private JPDADebugger debugger;
    private ContextProvider contextProvider;
    private Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getDebugger() != this.debugger) {
                return;
            }
        }
        if (event.getConditionResult() == 2) {
            return;
        }
        JPDABreakpoint breakpoint = (JPDABreakpoint)event.getSource();
        this.getBreakpointsNodeModel().setCurrentBreakpoint(breakpoint);
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        String printText = breakpoint.getPrintText();
        if (printText == null || printText.length() == 0) {
            return;
        }
        printText = this.substitute(printText, event);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println(printText, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            Object object = this.lock;
            synchronized (object) {
                block5: {
                    if (this.debugger == null) break block5;
                    if (evt.getPropertyName() != "state") break block5;
                    if (this.debugger.getState() == 2) break block6;
                }
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substitute(String printText, JPDABreakpointEvent event) {
        Matcher m;
        String name;
        JPDAThread t = event.getThread();
        if (t != null) {
            name = backslashEscapePattern.matcher(t.getName()).replaceAll("\\\\\\\\");
            name = dollarEscapePattern.matcher(name).replaceAll("\\\\\\$");
            printText = threadNamePattern.matcher(printText).replaceAll(name);
        } else {
            printText = threadNamePattern.matcher(printText).replaceAll("?");
        }
        if (event.getReferenceType() != null) {
            name = dollarEscapePattern.matcher(event.getReferenceType().name()).replaceAll("\\\\\\$");
            printText = classNamePattern.matcher(printText).replaceAll(name);
        } else {
            printText = classNamePattern.matcher(printText).replaceAll("?");
        }
        String language = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
        String methodName = t.getMethodName();
        if (methodName.equals("")) {
            methodName = "?";
        }
        methodName = dollarEscapePattern.matcher(methodName).replaceAll("\\\\\\$");
        printText = methodNamePattern.matcher(printText).replaceAll(methodName);
        int lineNumber = t.getLineNumber(language);
        printText = lineNumber < 0 ? lineNumberPattern.matcher(printText).replaceAll("?") : lineNumberPattern.matcher(printText).replaceAll(String.valueOf(lineNumber));
        while ((m = expressionPattern.matcher(printText)).find()) {
            String expression = m.group(1);
            String value = "";
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.debugger == null) {
                        return value;
                    }
                    value = this.debugger.evaluate(expression).getValue();
                }
                value = backslashEscapePattern.matcher(value).replaceAll("\\\\\\\\");
                value = dollarEscapePattern.matcher(value).replaceAll("\\\\\\$");
            }
            catch (InvalidExpressionException e) {
                String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager != null) {
                        this.ioManager.println("Cannot evaluate expression '" + expression + "' : " + msg, null);
                    }
                }
            }
            printText = m.replaceFirst(value);
        }
        Throwable thr = event.getConditionException();
        if (thr != null) {
            printText = printText + "\n***\n" + thr.getLocalizedMessage() + "\n***\n";
        }
        return printText;
    }

    private void lookupIOManager() {
        List lamls = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        Iterator i = lamls.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)o).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.hookBreakpoint(bpt);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.unhookBreakpoint(bpt);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.removeJPDABreakpointListener((JPDABreakpointListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List l = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                NodeModel nm = (NodeModel)it.next();
                if (!(nm instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nm;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

