/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.TldAttributeType;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TagHandlerGenerator;
import org.netbeans.modules.web.wizards.TagHandlerSelection;
import org.netbeans.modules.web.wizards.TagInfoPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.src.ClassElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class TagHandlerIterator
implements TemplateWizard.Iterator {
    private transient FileType fileType;
    private WizardDescriptor.Panel packageChooserPanel;
    private WizardDescriptor.Panel tagHandlerSelectionPanel;
    private WizardDescriptor.Panel tagInfoPanel;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = -7586964579556513549L;

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wiz) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(project);
        this.tagHandlerSelectionPanel = new TagHandlerSelection(wiz);
        this.packageChooserPanel = sourceGroups.length == 0 ? Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.tagHandlerSelectionPanel) : JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.tagHandlerSelectionPanel);
        sourceGroups = sources.getSourceGroups("doc_root");
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = Util.getJavaSourceGroups(project);
        }
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        this.tagInfoPanel = new TagInfoPanel(wiz, project, sourceGroups);
        return new WizardDescriptor.Panel[]{this.packageChooserPanel, this.tagInfoPanel};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        FileObject tldFo;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        if (((TagHandlerSelection)this.tagHandlerSelectionPanel).isBodyTagSupport()) {
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("BodyTagHandler", "java");
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wiz));
        TagInfoPanel tldPanel = (TagInfoPanel)this.tagInfoPanel;
        Object[][] attrs = tldPanel.getAttributes();
        boolean isBodyTag = ((TagHandlerSelection)this.tagHandlerSelectionPanel).isBodyTagSupport();
        if (attrs.length > 0 || isBodyTag) {
            ClassElement clazz = ClassElement.forName((String)tldPanel.getClassName(), (FileObject)dobj.getPrimaryFile());
            boolean evaluateBody = !((TagInfoPanel)this.tagInfoPanel).isEmpty();
            TagHandlerGenerator generator = new TagHandlerGenerator(clazz, attrs, isBodyTag, evaluateBody);
            try {
                generator.generate();
            }
            catch (SourceException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            SaveCookie save = (SaveCookie)dobj.getCookie(SaveCookie.class);
            if (save != null) {
                save.save();
            }
        }
        if (tldPanel.writeToTLD() && (tldFo = tldPanel.getTLDFile()) != null) {
            if (!tldFo.canWrite()) {
                String mes = MessageFormat.format(NbBundle.getMessage(TagHandlerIterator.class, (String)"MSG_tldRO"), tldFo.getNameExt());
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            } else {
                TLDDataObject tldDO = (TLDDataObject)DataObject.find((FileObject)tldFo);
                Taglib taglib = null;
                try {
                    taglib = tldDO.getTaglib();
                }
                catch (IOException ex) {
                    String mes = MessageFormat.format(NbBundle.getMessage(TagHandlerIterator.class, (String)"MSG_tldCorrupted"), tldFo.getNameExt());
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                if (taglib != null) {
                    TagType tag = new TagType();
                    tag.setName(tldPanel.getTagName());
                    tag.setTagClass(tldPanel.getClassName());
                    if (tldPanel.isEmpty()) {
                        tag.setBodyContent("empty");
                    } else if (tldPanel.isScriptless()) {
                        tag.setBodyContent(isBodyTag ? "JSP" : "scriptless");
                    } else if (tldPanel.isTegdependent()) {
                        tag.setBodyContent("tagdependent");
                    }
                    for (int i = 0; i < attrs.length; ++i) {
                        boolean rtexpr;
                        TldAttributeType attr = new TldAttributeType();
                        attr.setName((String)attrs[i][0]);
                        attr.setType((String)attrs[i][1]);
                        boolean required = (Boolean)attrs[i][2];
                        if (required) {
                            attr.setRequired("true");
                        }
                        if (rtexpr = ((Boolean)attrs[i][3]).booleanValue()) {
                            attr.setRtexprvalue("true");
                        }
                        tag.addAttribute(attr);
                    }
                    taglib.addTag(tag);
                    SaveCookie save = (SaveCookie)tldDO.getCookie(SaveCookie.class);
                    if (save != null) {
                        save.save();
                    }
                    try {
                        tldDO.write(taglib);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    }
                }
            }
        }
        return Collections.singleton(dobj);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(TagHandlerIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

