/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.AppClientProjectUtil;
import org.netbeans.modules.j2ee.clientproject.SourceRoots;
import org.netbeans.modules.j2ee.clientproject.UpdateHelper;
import org.netbeans.modules.j2ee.clientproject.ui.LibrariesNode;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class AppClientLogicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("AppClientLogicalViewProvider.BROKEN_LINKS_RP");
    private final AppClientProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    private static final Object KEY_SERVICE_REFS = "serviceRefs";
    private static final String KEY_SETUP_DIR = "setupDir";
    private static final String KEY_CONF_DIR = "confDir";
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath"};
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/j2ee/clientproject/ui/resources/brokenProjectBadge.gif", (boolean)true);

    public AppClientLogicalViewProvider(AppClientProject project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
    }

    public Node createLogicalView() {
        return new AppClientLogicalViewRootNode();
    }

    public Node findPath(Node root, Object target) {
        Project project = (Project)root.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!project.equals(owner)) {
                return null;
            }
            Node[] nodes = root.getChildren().getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                Node result = PackageView.findPath((Node)nodes[i], (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] _listeners;
        AppClientLogicalViewProvider appClientLogicalViewProvider = this;
        synchronized (appClientLogicalViewProvider) {
            if (this.changeListeners == null) {
                return;
            }
            _listeners = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < _listeners.length; ++i) {
            _listeners[i].stateChanged(event);
        }
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    public boolean hasInvalidJdkVersion() {
        String javaSource = this.evaluator.getProperty("javac.source");
        String javaTarget = this.evaluator.getProperty("javac.target");
        if (javaSource == null && javaTarget == null) {
            return false;
        }
        String platformId = this.evaluator.getProperty("platform.active");
        JavaPlatform activePlatform = AppClientProjectUtil.getActivePlatform(platformId);
        if (activePlatform == null) {
            return true;
        }
        SpecificationVersion platformVersion = activePlatform.getSpecification().getVersion();
        try {
            return javaSource != null && new SpecificationVersion(javaSource).compareTo((Object)platformVersion) > 0 || javaTarget != null && new SpecificationVersion(javaTarget).compareTo((Object)platformVersion) > 0;
        }
        catch (NumberFormatException nfe) {
            ErrorManager.getDefault().log("Invalid javac.source: " + javaSource + " or javac.target: " + javaTarget + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private String[] getBreakableProperties() {
        SourceRoots roots = this.project.getSourceRoots();
        String[] srcRootProps = roots.getRootProperties();
        roots = this.project.getTestSourceRoots();
        String[] testRootProps = roots.getRootProperties();
        String[] result = new String[BREAKABLE_PROPERTIES.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, result, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(srcRootProps, 0, result, BREAKABLE_PROPERTIES.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, BREAKABLE_PROPERTIES.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String nodeName) {
            this(project, nodeName, null);
        }

        public PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (cp != null) {
                cp.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private final String nodeName;
        private final Project project;
        Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    this.actions = new Action[superActions.length + 2];
                    System.arraycopy(superActions, 0, this.actions, 0, superActions.length);
                    this.actions[superActions.length] = null;
                    this.actions[superActions.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(context);
        }
    }

    private static final class LogicalViewChildren
    extends Children.Keys
    implements ChangeListener {
        private static final Object LIBRARIES = "Libs";
        private static final Object TEST_LIBRARIES = "TestLibs";
        private static final String WSDL_FOLDER = "wsdl";
        private final Project project;
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private final ReferenceHelper resolver;
        private final SourceRoots testSources;
        private final WsdlCreationListener wsdlListener;
        private final MetaInfListener metaInfListener;
        private FileObject wsdlFolder;
        private Car jp;

        public LogicalViewChildren(AppClientProject project, PropertyEvaluator evaluator, UpdateHelper helper, ReferenceHelper resolver) {
            this.project = project;
            this.evaluator = evaluator;
            this.helper = helper;
            this.resolver = resolver;
            this.testSources = project.getTestSourceRoots();
            this.metaInfListener = new MetaInfListener();
            this.wsdlListener = new WsdlCreationListener();
            Car[] jps = Car.getCars((Project)project);
            assert (jps.length > 0);
            this.jp = jps[0];
        }

        protected void addNotify() {
            FileObject srcDir;
            FileObject metaInf;
            super.addNotify();
            this.getSources().addChangeListener((ChangeListener)this);
            AntProjectHelper projectHelper = this.helper.getAntProjectHelper();
            String prop = this.evaluator.getProperty("meta.inf");
            if (prop != null && (metaInf = projectHelper.resolveFileObject(prop)) != null) {
                metaInf.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if ((prop = this.evaluator.getProperty("src.dir")) != null && (srcDir = projectHelper.resolveFileObject(prop)) != null) {
                srcDir.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            WebServicesClientSupport wsClientSupportImpl = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
            try {
                if (wsClientSupportImpl != null) {
                    this.wsdlFolder = wsClientSupportImpl.getWsdlFolder(false);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.addFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            FileObject srcDir;
            FileObject metaInf;
            this.setKeys(Collections.EMPTY_SET);
            this.getSources().removeChangeListener((ChangeListener)this);
            AntProjectHelper projectHelper = this.helper.getAntProjectHelper();
            String prop = this.evaluator.getProperty("meta.inf");
            if (prop != null && (metaInf = projectHelper.resolveFileObject(prop)) != null) {
                metaInf.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if ((prop = this.evaluator.getProperty("src.dir")) != null && (srcDir = projectHelper.resolveFileObject(prop)) != null) {
                srcDir.removeFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.removeFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Node[] result;
            if (key == LIBRARIES) {
                result = new Node[]{new LibrariesNode(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"CTL_LibrariesNode"), this.project, this.evaluator, this.helper, this.resolver, "run.classpath", new String[]{"build.classes.dir"}, "platform.active", "j2ee.server.instance", new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.classpath", "included-library"), LibrariesNode.createAddLibraryAction(this.project, this.helper.getAntProjectHelper(), "javac.classpath", "included-library"), LibrariesNode.createAddFolderAction(this.project, "javac.classpath", "included-library"), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE")}, "included-library")};
            } else if (key == TEST_LIBRARIES) {
                result = new Node[]{new LibrariesNode(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"CTL_TestLibrariesNode"), this.project, this.evaluator, this.helper, this.resolver, "run.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, null, new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.test.classpath", null), LibrariesNode.createAddLibraryAction(this.project, this.helper.getAntProjectHelper(), "javac.test.classpath", null), LibrariesNode.createAddFolderAction(this.project, "javac.test.classpath", null), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE_TESTS")}, null)};
            } else if (key instanceof SourceGroupKey) {
                result = new Node[]{PackageView.createPackageView((SourceGroup)((SourceGroupKey)key).group)};
            } else if (key == AppClientLogicalViewProvider.KEY_SETUP_DIR) {
                result = new Node[]{J2eeProjectView.createServerResourcesNode((Project)this.project)};
            } else if (key == AppClientLogicalViewProvider.KEY_CONF_DIR) {
                result = new Node[]{J2eeProjectView.createConfigFilesView((FileObject)this.jp.getMetaInf())};
            } else if (key == KEY_SERVICE_REFS) {
                Map properties = ((AppClientProject)this.project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String serverInstance = (String)properties.get("j2ee.server.instance");
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                boolean wsitSupported = j2eePlatform != null && j2eePlatform.isToolSupported("wsit");
                Car wm = Car.getCar((FileObject)this.project.getProjectDirectory());
                result = null;
                if (wm != null && ("1.5".equals(wm.getJ2eePlatformVersion()) || wsitSupported)) {
                    JAXWSClientView view = JAXWSClientView.getJAXWSClientView();
                    result = new Node[]{view.createJAXWSClientView(this.project)};
                } else {
                    FileObject wsdlFolder;
                    WebServicesClientSupport wss;
                    FileObject clientRoot = this.project.getProjectDirectory();
                    WebServicesClientView clientView = WebServicesClientView.getWebServicesClientView((FileObject)clientRoot);
                    if (clientView != null && (wss = WebServicesClientSupport.getWebServicesClientSupport((FileObject)clientRoot)) != null && (wsdlFolder = wss.getWsdlFolder()) != null) {
                        FileObject[] children = wsdlFolder.getChildren();
                        boolean foundWsdl = false;
                        for (int i = 0; i < children.length; ++i) {
                            if (!children[i].getExt().equalsIgnoreCase(WSDL_FOLDER)) continue;
                            foundWsdl = true;
                            break;
                        }
                        if (foundWsdl) {
                            result = new Node[]{clientView.createWebServiceClientView(wsdlFolder)};
                        }
                    }
                }
            } else {
                assert (false) : "Unknown key type";
                result = new Node[]{};
            }
            return result;
        }

        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogicalViewChildren.this.setKeys(LogicalViewChildren.this.getKeys());
                }
            });
        }

        private Collection getKeys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }
            Sources sources = this.getSources();
            SourceGroup[] groups = sources.getSourceGroups("java");
            ArrayList<Object> result = new ArrayList<Object>(groups.length);
            result.add(AppClientLogicalViewProvider.KEY_CONF_DIR);
            result.add(AppClientLogicalViewProvider.KEY_SETUP_DIR);
            for (int i = 0; i < groups.length; ++i) {
                result.add(new SourceGroupKey(groups[i]));
            }
            result.add(LIBRARIES);
            URL[] testRoots = this.testSources.getRootURLs();
            boolean addTestSources = false;
            for (int i = 0; i < testRoots.length; ++i) {
                File f = new File(URI.create(testRoots[i].toExternalForm()));
                if (!f.exists()) continue;
                addTestSources = true;
                break;
            }
            if (addTestSources) {
                result.add(TEST_LIBRARIES);
            }
            result.add(KEY_SERVICE_REFS);
            return result;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        private final class MetaInfListener
        extends FileChangeAdapter {
            private MetaInfListener() {
            }

            public void fileFolderCreated(FileEvent fe) {
                if (fe.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fe.getFile().getName())) {
                    fe.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                } else if (fe.getFile().isFolder() && "META-INF".equals(fe.getFile().getName())) {
                    fe.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.metaInfListener);
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (fe.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fe.getFile().getName())) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                } else if (fe.getFile().isFolder() && "META-INF".equals(fe.getFile().getName())) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.metaInfListener);
                }
            }
        }

        private final class WsdlCreationListener
        extends FileChangeAdapter {
            private WsdlCreationListener() {
            }

            public void fileDataCreated(FileEvent fe) {
                if (LogicalViewChildren.WSDL_FOLDER.equalsIgnoreCase(fe.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (LogicalViewChildren.WSDL_FOLDER.equalsIgnoreCase(fe.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                } else if (fe.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fe.getFile().getName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }

        private static class SourceGroupKey {
            public final SourceGroup group;
            public final FileObject fileObject;

            SourceGroupKey(SourceGroup group) {
                this.group = group;
                this.fileObject = group.getRootFolder();
            }

            public int hashCode() {
                return this.fileObject.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SourceGroupKey)) {
                    return false;
                }
                SourceGroupKey otherKey = (SourceGroupKey)obj;
                String thisDisplayName = this.group.getDisplayName();
                String otherDisplayName = otherKey.group.getDisplayName();
                return this.fileObject.equals(otherKey.fileObject) && thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
            }
        }
    }

    private final class AppClientLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Action brokenLinksAction;
        private BrokenServerAction brokenServerAction;
        private boolean broken;
        private boolean illegalState;
        private Set files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;

        public AppClientLogicalViewRootNode() {
            super((Children)new LogicalViewChildren(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.evaluator, AppClientLogicalViewProvider.this.helper, AppClientLogicalViewProvider.this.resolver), Lookups.singleton((Object)AppClientLogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/clientproject/ui/resources/appclient.gif");
            super.setName(ProjectUtils.getInformation((Project)AppClientLogicalViewProvider.this.project).getDisplayName());
            if (AppClientLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (AppClientLogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider moduleProvider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)moduleProvider));
            this.setProjectFiles(AppClientLogicalViewProvider.this.project);
        }

        protected void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private void setGroups(Collection groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        protected void setFiles(Set files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            if (files == null) {
                return;
            }
            Iterator it = files.iterator();
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, 0, "Cannot get " + fo + " filesystem, ignoring...", null, null, null);
                    err.notify(1, (Throwable)e);
                }
            }
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + dispName + "</font>" : null;
        }

        public Image getIcon(int type) {
            Image img = this.getMyIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = (FileObject)this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        private Image getMyIcon(int type) {
            Image original = super.getIcon(type);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0) : original;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = (FileObject)this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        private Image getMyOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0) : original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public void stateChanged(ChangeEvent e) {
            this.setProjectFiles(AppClientLogicalViewProvider.this.project);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setProjectFiles(AppClientLogicalViewProvider.this.project);
        }

        public Action[] getActions(boolean context) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)AppClientLogicalViewProvider.this.project, (String)s);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle bundle = NbBundle.getBundle(AppClientLogicalViewProvider.class);
            ArrayList<Action> actions = new ArrayList<Action>(30);
            J2eeModuleProvider provider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null));
            if (provider != null && provider.hasVerifierSupport()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)bundle.getString("LBL_VerifyAction_Name"), null));
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)bundle.getString("LBL_JavadocAction_Name"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)bundle.getString("LBL_RedeployAction_Name"), null));
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.openSubprojectsAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            try {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Projects/Actions");
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                    Lookup.Template query = new Lookup.Template(Object.class);
                    Lookup lookup = actionRegistry.getLookup();
                    Iterator it = lookup.lookup(query).allInstances().iterator();
                    if (it.hasNext()) {
                        actions.add(null);
                    }
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof Action) {
                            actions.add((Action)next);
                            continue;
                        }
                        if (!(next instanceof JSeparator)) continue;
                        actions.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                actions.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                actions.add(this.brokenServerAction);
            }
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        private boolean isBroken() {
            return this.broken;
        }

        private void setBroken(boolean broken) {
            this.broken = broken;
            this.brokenLinksAction.setEnabled(broken);
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private void setIllegalState(boolean illegalState) {
            this.illegalState = illegalState;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private RequestProcessor.Task task = null;
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent e) {
                String j2eeSpec = AppClientProjectProperties.getProperty("j2ee.platform", AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), "nbproject/project.properties");
                String instance = BrokenServerSupport.selectServer((String)j2eeSpec, (Object)J2eeModule.CLIENT);
                if (instance != null) {
                    AppClientProjectProperties.setServerInstance(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), instance);
                }
                this.checkMissingServer();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("j2ee.server.instance".equals(evt.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
            }

            public void instanceAdded(String serverInstanceID) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String serverInstanceID) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean old = this.brokenServer;
                String servInstID = AppClientProjectProperties.getProperty("j2ee.server.instance", AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), "nbproject/private/private.properties");
                this.brokenServer = BrokenServerSupport.isBroken((String)servInstID);
                if (old != this.brokenServer) {
                    AppClientLogicalViewRootNode.this.fireIconChange();
                    AppClientLogicalViewRootNode.this.fireOpenedIconChange();
                    AppClientLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(AppClientLogicalViewRootNode.this.broken);
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                AppClientLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)AppClientLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    AppClientLogicalViewProvider.this.helper.requestSave();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)AppClientLogicalViewProvider.this.resolver, (String[])AppClientLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent evt) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean broken;
                boolean old = AppClientLogicalViewRootNode.this.broken;
                if (old != (broken = AppClientLogicalViewProvider.this.hasBrokenLinks())) {
                    AppClientLogicalViewRootNode.this.setBroken(broken);
                }
                if ((old = AppClientLogicalViewRootNode.this.illegalState) != (broken = AppClientLogicalViewProvider.this.hasInvalidJdkVersion())) {
                    AppClientLogicalViewRootNode.this.setIllegalState(broken);
                }
            }

            private void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

