/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.clientproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.FileSearchUtility;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.ImportBuildfile;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.ImportLocation;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.J2eeVersionWarningPanel;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ImportLocationVisual
extends JPanel {
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private static final String J2EE_SPEC_15_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"J2EESpecLevel_15");
    private static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"J2EESpecLevel_14");
    private static final String J2EE_SPEC_13_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"J2EESpecLevel_13");
    private final ImportLocation panel;
    private final DocumentListener documentListener;
    private boolean projectFolderTouched;
    private boolean projectNameTouched;
    private List<Project> earProjects;
    private WizardDescriptor wizardDescriptor;
    private J2eeVersionWarningPanel warningPanel;
    private JComboBox addToAppComboBox;
    private JLabel addToAppLabel;
    private JButton browseProjectFolder;
    private JButton browseProjectLocation;
    private JComboBox j2eeSpecComboBox;
    private JCheckBox jCheckBox1;
    private JLabel jLabel7;
    private JLabel jLabelPrjLocation;
    private JLabel jLabelPrjLocationDesc;
    private JLabel jLabelPrjName;
    private JLabel jLabelSrcLocation;
    private JLabel jLabelSrcLocationDesc;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton manageServersButton;
    public JTextField projectFolder;
    public JTextField projectLocation;
    public JTextField projectName;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JPanel warningPlaceHolderPanel;
    private boolean ignoreEvent;
    private Dialog dialog;

    public ImportLocationVisual(ImportLocation panel) {
        this.panel = panel;
        this.initComponents();
        this.setJ2eeVersionWarningPanel();
        this.initServers(FoldersListSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.initEnterpriseApplications();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_NWP1_NamePanel_A11YDesc"));
        this.setName(NbBundle.getBundle((String)"org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("LBL_IW_ImportTitle"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_ImportEJBModule"));
        this.projectName.setText("");
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ImportLocationVisual.this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                ImportLocationVisual.this.update(e);
            }

            public void changedUpdate(DocumentEvent e) {
                ImportLocationVisual.this.update(e);
            }
        };
        this.projectName.getDocument().addDocumentListener(this.documentListener);
        this.projectFolder.getDocument().addDocumentListener(this.documentListener);
    }

    private void initComponents() {
        this.jLabelSrcLocationDesc = new JLabel();
        this.jLabelSrcLocation = new JLabel();
        this.projectLocation = new JTextField();
        this.browseProjectLocation = new JButton();
        this.jLabelPrjLocationDesc = new JLabel();
        this.jLabelPrjName = new JLabel();
        this.projectName = new JTextField();
        this.jLabelPrjLocation = new JLabel();
        this.projectFolder = new JTextField();
        this.browseProjectFolder = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.addToAppLabel = new JLabel();
        this.addToAppComboBox = new JComboBox();
        this.warningPlaceHolderPanel = new JPanel();
        this.manageServersButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setNextFocusableComponent(this.projectLocation);
        this.getAccessibleContext().setAccessibleName(null);
        this.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((JLabel)this.jLabelSrcLocationDesc, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationSrcDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabelSrcLocationDesc, gridBagConstraints);
        this.jLabelSrcLocation.setHorizontalAlignment(2);
        this.jLabelSrcLocation.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabelSrcLocation, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationSrc_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelSrcLocation, gridBagConstraints);
        this.jLabelSrcLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_IW_Location_A11Desc"));
        this.projectLocation.setNextFocusableComponent(this.browseProjectLocation);
        this.projectLocation.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ImportLocationVisual.this.projectLocationFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.projectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_IW_ImportLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectLocation, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button_w"));
        this.browseProjectLocation.setNextFocusableComponent(this.projectName);
        this.browseProjectLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.browseProjectLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.browseProjectLocation, gridBagConstraints);
        this.browseProjectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_IW_ImportLocationBrowse_A11YDesc"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjLocationDesc, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationPrjDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabelPrjLocationDesc, gridBagConstraints);
        this.jLabelPrjName.setHorizontalAlignment(2);
        this.jLabelPrjName.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjName, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelPrjName, gridBagConstraints);
        this.jLabelPrjName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("ACS_LBL_IW_ProjectName_A11Desc"));
        this.projectName.setNextFocusableComponent(this.projectFolder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.jLabelPrjLocation.setHorizontalAlignment(2);
        this.jLabelPrjLocation.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjLocation, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelPrjLocation, gridBagConstraints);
        this.jLabelPrjLocation.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("ACS_LBL_IW_ProjectFolder_A11Desc"));
        this.projectFolder.setNextFocusableComponent(this.browseProjectFolder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.projectFolder, gridBagConstraints);
        this.projectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectFolder, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseProjectFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.browseProjectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.browseProjectFolder, gridBagConstraints);
        this.browseProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jCheckBox1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("LBL_IW_SetAsMainProject_CheckBox"));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("ACS_LBL_IW_SetAsMainProject_A11YDesc"));
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverInstanceLabel, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Server"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.jPanel1.add((Component)this.serverInstanceLabel, gridBagConstraints);
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.setNextFocusableComponent(this.j2eeSpecComboBox);
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.serverInstanceComboBox, gridBagConstraints);
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("ACS_LBL_IW_SelectServerInstance_A11YDesc"));
        this.jLabel7.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_SelectJ2EEVersion_LabelMnemonic").charAt(0));
        this.jLabel7.setLabelFor(this.j2eeSpecComboBox);
        this.jLabel7.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.j2eeSpecComboBox.setNextFocusableComponent(this.jCheckBox1);
        this.j2eeSpecComboBox.setPrototypeDisplayValue("MMMMMMMMM");
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPanel1.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("ACS_LBL_IW_SelectJ2EEVersion_A11YDesc"));
        this.addToAppLabel.setLabelFor(this.addToAppComboBox);
        Mnemonics.setLocalizedText((JLabel)this.addToAppLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle").getString("LBL_NWP1_AddToEApp_CheckBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPanel1.add((Component)this.addToAppLabel, gridBagConstraints);
        this.addToAppComboBox.setNextFocusableComponent(this.serverInstanceComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.addToAppComboBox, gridBagConstraints);
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.warningPlaceHolderPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.jPanel1.add((Component)this.manageServersButton, gridBagConstraints);
        this.manageServersButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportLocationVisual.class, (String)"ASCN_ManageServers"));
        this.manageServersButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ASCD_ManageServers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        String lastSelectedJ2eeSpecLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        this.initServers(lastSelectedServerInstanceID);
        if (lastSelectedJ2eeSpecLevel != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeSpecLevel);
        }
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    private void projectLocationFocusLost(FocusEvent evt) {
        if (this.projectLocation.getText().trim().length() > 0) {
            this.updateProjectName();
            this.updateProjectFolder();
            this.updateJ2EEVersion();
            this.panel.stateChanged(null);
        }
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            Set supportedVersions = j2eePlatform.getSupportedSpecVersions(J2eeModule.CLIENT);
            this.j2eeSpecComboBox.removeAllItems();
            if (supportedVersions.contains("1.5")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_15_LABEL);
            }
            if (supportedVersions.contains("1.4")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_14_LABEL);
            }
            if (prevSelectedItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
            }
        } else {
            this.j2eeSpecComboBox.removeAllItems();
        }
        this.panel.fireChangeEvent();
    }

    private void browseProjectFolderActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectFolder.getText().length() > 0 && this.getProjectFolder().exists()) {
            chooser.setSelectedFile(this.getProjectFolder());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_SelectNewLocation"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.projectFolder.setText(projectDir.getAbsolutePath());
        }
    }

    private void browseProjectLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            File existingSourcesFile;
            File currentDirectory = null;
            FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
            if (existingSourcesFO != null && (existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO)) != null && existingSourcesFile.isDirectory()) {
                currentDirectory = existingSourcesFile;
            }
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            } else {
                chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_SelectExistingLocation"));
        if (0 == chooser.showOpenDialog(this)) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)chooser.getSelectedFile()).getAbsolutePath());
            this.updateJ2EEVersion();
            this.updateProjectName();
            this.updateProjectFolder();
            this.panel.stateChanged(null);
        }
    }

    private void update(DocumentEvent e) {
        if (this.ignoreEvent) {
            return;
        }
        this.ignoreEvent = true;
        if (this.projectLocation.getDocument() == e.getDocument()) {
            this.updateProjectName();
            this.updateProjectFolder();
        }
        this.ignoreEvent = false;
        if (this.projectFolder.getDocument() == e.getDocument()) {
            boolean bl = this.projectFolderTouched = !"".equals(this.projectFolder.getText());
        }
        if (this.projectName.getDocument() == e.getDocument()) {
            this.projectNameTouched = !"".equals(this.projectName.getText());
        }
        this.panel.stateChanged(null);
    }

    private void updateProjectName() {
        if (this.projectNameTouched) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)this.getProjectLocation());
        if (fo != null) {
            this.projectName.setText(fo.getName());
        }
    }

    private void updateJ2EEVersion() {
        File f = new File(this.projectLocation.getText().trim());
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        if (fo != null) {
            FileObject configFilesPath = FileSearchUtility.guessConfigFilesPath(fo);
            if (configFilesPath != null) {
                FileObject appClientXML = configFilesPath.getFileObject("application-client.xml");
                this.checkACXmlJ2eeVersion(appClientXML);
            } else {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_15_LABEL);
            }
        }
    }

    private void updateProjectFolder() {
        if (this.projectFolderTouched) {
            return;
        }
        if (this.isValidProjectLocation()) {
            this.projectFolder.setText(this.getProjectLocation().getAbsolutePath());
        } else {
            this.projectFolder.setText("");
        }
    }

    private boolean isValidProjectLocation() {
        return this.getProjectLocation().exists() && this.getProjectLocation().isDirectory() && this.projectLocation.getText().length() > 0 && !this.projectLocation.getText().endsWith(":");
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        File prjDir = new File(this.projectLocation.getText().trim());
        String prjName = this.projectName.getText().trim();
        if (this.getSelectedServerInstanceID() == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_NoServer"));
            return false;
        }
        if (!prjDir.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProvideExistingSourcesLocation"));
            return false;
        }
        if (FileSearchUtility.guessJavaRoots(FileUtil.toFileObject((File)prjDir)) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_NoEjbJarModule"));
            return false;
        }
        if (prjName == null || prjName.length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProvideProjectName"));
            return false;
        }
        String result = ImportLocationVisual.checkValidity(this.projectName.getText(), this.projectFolder.getText());
        if (result != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    static String checkValidity(String projectName, String projectLocation) {
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_BuildFolder");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_DistFolder");
                } else if ("build.xml".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_BuildXML");
                } else if ("manifest.mf".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_Manifest");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            assert (destFO != null) : "No FileObject for " + destFolder;
            boolean clear = false;
            try {
                clear = ProjectManager.getDefault().findProject(destFO) == null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!clear) {
                return NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProjectFolderHasDeletedProject");
            }
        }
        return null;
    }

    void read(WizardDescriptor d) {
        this.wizardDescriptor = d;
    }

    void store(WizardDescriptor d) {
        String name = this.projectName.getText().trim();
        String moduleLoc = this.projectLocation.getText().trim();
        if (name.equals("") || moduleLoc.equals("")) {
            return;
        }
        d.putProperty("projdir", (Object)new File(this.projectFolder.getText().trim()));
        File moduleLocFile = new File(moduleLoc);
        d.putProperty("sourceRoot", (Object)moduleLocFile);
        d.putProperty("name", (Object)name);
        d.putProperty("javaRoot", (Object)FileSearchUtility.guessJavaRootsAsFiles(FileUtil.toFileObject((File)moduleLocFile)));
        d.putProperty("serverInstanceID", (Object)this.getSelectedServerInstanceID());
        d.putProperty("j2eeLevel", (Object)this.getSelectedJ2eeSpec());
        d.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        if (this.warningPanel != null && this.warningPanel.getDowngradeAllowed()) {
            d.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            FoldersListSettings fls = FoldersListSettings.getDefault();
            d.putProperty("setSourceLevel", (Object)(fls.isAgreedSetSourceLevel14() ? "1.4" : (fls.isAgreedSetSourceLevel15() ? "1.5" : "1.6")));
        }
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        File dirF = new File(this.projectFolder.getText());
        JButton ok = new JButton(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Buildfile_OK"));
        ok.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_IW_BuildFileDialog_OKButton_LabelMnemonic"));
        ok.setMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_BuildFileDialog_OK_LabelMnemonic").charAt(0));
        JButton cancel = new JButton(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Buildfile_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_IW_BuildFileDialog_CancelButton_LabelMnemonic"));
        cancel.setMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_BuildFileDialog_Cancel_LabelMnemonic").charAt(0));
        ImportBuildfile ibf = new ImportBuildfile(dirF.getAbsolutePath(), ok);
        if (!new File(dirF, "build.xml").exists()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object src = event.getSource();
                if (src instanceof JButton) {
                    String name = ((JButton)src).getText();
                    if (name.equals(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Buildfile_OK"))) {
                        ImportLocationVisual.this.closeDialog();
                    } else if (name.equals(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Buildfile_Cancel"))) {
                        NotifyDescriptor.Confirmation ndesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_Buildfile_CancelConfirmation"), 0);
                        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
                        if (ret == NotifyDescriptor.YES_OPTION) {
                            ImportLocationVisual.this.closeDialog();
                        }
                    }
                }
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)ibf, NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_BuildfileTitle"), true, new Object[]{ok, cancel}, DialogDescriptor.OK_OPTION, 0, null, actionListener);
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        this.dialog.setVisible(true);
    }

    private void closeDialog() {
        this.dialog.dispose();
    }

    public boolean isSuitableProjectRoot(FileObject dir) {
        FileObject configFilesRoot = FileSearchUtility.guessConfigFilesPath(dir);
        if (configFilesRoot != null && !FileUtil.isParentOf((FileObject)dir, (FileObject)configFilesRoot)) {
            return false;
        }
        FileObject[] srcRoots = FileSearchUtility.guessJavaRoots(dir);
        return srcRoots == null || this.isParentOf(dir, srcRoots);
    }

    private boolean isParentOf(FileObject dir, FileObject[] fos) {
        boolean result = true;
        if (fos != null) {
            for (int i = 0; i < fos.length; ++i) {
                result = FileUtil.isParentOf((FileObject)dir, (FileObject)fos[i]);
                if (result) continue;
                return result;
            }
        }
        return result;
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.CLIENT)) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = Deployment.getDefault().getServerID(serverInstanceID);
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    public String getSelectedServerInstanceID() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    public String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        return item == null ? null : (item.equals(J2EE_SPEC_14_LABEL) ? "1.4" : (item.equals(J2EE_SPEC_15_LABEL) ? "1.5" : "1.3"));
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    public File getProjectLocation() {
        return this.getAsFile(this.projectLocation.getText());
    }

    public File getProjectFolder() {
        return this.getAsFile(this.projectFolder.getText());
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    private Project getSelectedEarApplication() {
        int idx = this.addToAppComboBox.getSelectedIndex();
        return idx <= 0 ? null : this.earProjects.get(idx - 1);
    }

    private void initEnterpriseApplications() {
        this.addToAppComboBox.addItem(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_AddToEApp_None"));
        this.addToAppComboBox.setSelectedIndex(0);
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList<Project>();
        for (int i = 0; i < allProjects.length; ++i) {
            J2eeModuleContainer container = (J2eeModuleContainer)allProjects[i].getLookup().lookup(J2eeModuleContainer.class);
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)allProjects[i]);
            if (container == null) continue;
            this.earProjects.add(projectInfo.getProject());
            this.addToAppComboBox.addItem(projectInfo.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.addToAppComboBox.setEnabled(false);
        }
    }

    private BigDecimal getACXmlVersion(FileObject appClientXML) throws IOException {
        if (appClientXML != null) {
            return DDProvider.getDefault().getDDRoot(appClientXML).getVersion();
        }
        return null;
    }

    private void checkACXmlJ2eeVersion(FileObject appClientXML) {
        try {
            BigDecimal version = this.getACXmlVersion(appClientXML);
            if (version == null) {
                return;
            }
            if (new BigDecimal("1.3").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_13_LABEL);
            } else if (new BigDecimal("1.4").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_14_LABEL);
            } else if (new BigDecimal("5").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_15_LABEL);
            }
        }
        catch (IOException e) {
            ErrorManager errorManager = ErrorManager.getDefault();
            String message = NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_EjbJarXmlCorrupted");
            errorManager.notify(errorManager.annotate((Throwable)e, message));
        }
    }

    private void setJ2eeVersionWarningPanel() {
        String j2ee = this.getSelectedJ2eeSpec();
        if (j2ee == null) {
            return;
        }
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
        if (warningType == null && this.warningPanel == null) {
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
            this.warningPanel.setWarningType(warningType);
        } else {
            this.warningPanel.setWarningType(warningType);
        }
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

