/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.nodes;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.websvc.registry.actions.AddWebServiceAction;
import org.netbeans.modules.websvc.registry.actions.DeleteWebServiceGroupAction;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.nodes.WebServiceGroupCookie;
import org.netbeans.modules.websvc.registry.nodes.WebServiceGroupNodeChildren;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class WebServiceGroupNode
extends AbstractNode
implements WebServiceGroupCookie {
    WebServiceGroup websvcGroup;

    public WebServiceGroupNode(WebServiceGroup wsGroup) {
        super((Children)new WebServiceGroupNodeChildren(wsGroup));
        this.websvcGroup = wsGroup;
        this.setIconBaseWithExtension("org/netbeans/modules/websvc/registry/resources/folder.png");
        this.getCookieSet().add((Node.Cookie)this);
    }

    public WebServiceGroup getWebServiceGroup() {
        return this.websvcGroup;
    }

    public boolean canRename() {
        return true;
    }

    public String getName() {
        return this.websvcGroup.getName();
    }

    public void setName(String name) {
        this.websvcGroup.setName(name);
        this.setDisplayName(name);
        this.fireDisplayNameChange(name, null);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(AddWebServiceAction.class), SystemAction.get(DeleteWebServiceGroupAction.class), SystemAction.get(RenameAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        wsListModel.removeWebServiceGroup(this.websvcGroup.getId());
        super.destroy();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("websvcGroupNode");
    }
}

