/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.nodes.WebServiceGroupCookie;
import org.netbeans.modules.websvc.registry.ui.ProxySelectionDialog;
import org.netbeans.modules.websvc.registry.ui.TestWebServiceMethodDlg;
import org.netbeans.modules.websvc.registry.ui.WSDLFileFilter;
import org.netbeans.modules.websvc.registry.ui.WSListCellRenderer;
import org.netbeans.modules.websvc.registry.util.Util;
import org.netbeans.modules.websvc.registry.wsdl.WSDLInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddWebServiceDlg
extends JPanel
implements ActionListener,
HyperlinkListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private DialogDescriptor dlg = null;
    private String addString = "ADD";
    private String cancelString = "CANCEL";
    private String copyString = "COPY";
    private String clearString = "CLEAR";
    private String currentMessages = "";
    private String currentWSDL = "";
    private String previousWSDL = "";
    static final String WS_URL_PROPS = "ws_urls.xml";
    private static BufferedWriter outFile;
    private WSDLInfo currentWSDLInfo = null;
    private Dialog dialog;
    private Node invokingNode;
    Set webServicesToProcess = null;
    private static JFileChooser wsdlFileChooser;
    private String URL_WSDL_MSG = NbBundle.getMessage(AddWebServiceDlg.class, (String)"URL_WSDL_MSG");
    private String LOCAL_WSDL_MSG = NbBundle.getMessage(AddWebServiceDlg.class, (String)"LOCAL_WSDL_MSG");
    MRUPersistenceManager persistenceManager = new MRUPersistenceManager();
    HashMap jarCache = new HashMap();
    private JPanel emptyPanel = new JPanel();
    private JPanel infoTextPanel = new JPanel();
    private JPanel selectionContainer = new JPanel();
    private JPanel selectionPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel buttonPanelContainer = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel messagePanel = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton localFileButton = new JButton();
    private JButton addButton = new JButton();
    private JButton uddiRegistryButton = new JButton();
    private JButton getInfoButton = new JButton();
    private JButton httpProxyButton = new JButton();
    private JComboBox localFileComboBox = new JComboBox();
    private JComboBox uddiRegistryComboBox = new JComboBox();
    private JComboBox urlComboBox = new JComboBox();
    private JEditorPane infoTextArea = new JEditorPane();
    private JScrollPane infoTextScrollPane = new JScrollPane();
    private JEditorPane messageTextArea = new JEditorPane();
    private JScrollPane messageTextScrollPane = new JScrollPane();
    private JLabel infoTextlabel = new JLabel();
    private JLabel messageTextlabel = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private JRadioButton localFileRadioButton = new JRadioButton();
    private JRadioButton uddiRegistryRadioButton = new JRadioButton();
    private JRadioButton urlRadioButton = new JRadioButton();
    private JPopupMenu resultsPopup = new JPopupMenu();
    private JMenuItem copyMenuItem = new JMenuItem();
    private JMenuItem clearMenuItem = new JMenuItem();
    private ButtonGroup selectionGroup = new ButtonGroup();
    private int returnStatus = 0;
    private WebServiceGroup websvcGroup;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private HTMLDocument document = new HTMLDocument();

    private void initAccessibility() {
        this.infoTextlabel.setLabelFor(this.infoTextArea);
        this.messageTextlabel.setLabelFor(this.messageTextArea);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"ADD_WEB_SERVICE"));
        this.localFileButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"BROWSE"));
        this.urlRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"RADIO_URL"));
        this.localFileRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"RADIO_LOCAL_FILE"));
        this.httpProxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"SET_HTTP_PROXY"));
        this.getInfoButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"GET"));
    }

    public AddWebServiceDlg() {
        this(true, null);
    }

    public AddWebServiceDlg(boolean modal, Node node) {
        this.invokingNode = node;
        this.initComponents();
        this.initAccessibility();
        this.uddiRegistryComboBox.setRenderer(new WSListCellRenderer());
        wsdlFileChooser = new JFileChooser();
        WSDLFileFilter myFilter = new WSDLFileFilter();
        wsdlFileChooser.setFileFilter(myFilter);
        this.enableControls();
        this.persistenceManager.loadMRU();
        this.setDefaults();
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(AddWebServiceDlg.class, (String)"ADD_WEB_SERVICE"), false, 2, DialogDescriptor.CANCEL_OPTION, 0, this.getHelpCtx(), (ActionListener)this);
        this.addButton.setEnabled(false);
        this.dlg.setOptions(new Object[]{this.addButton, this.cancelButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        final AddWebServiceDlg thisPanel = this;
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AddWebServiceDlg.this.getInfoButton.requestFocus();
                        thisPanel.getRootPane().setDefaultButton(AddWebServiceDlg.this.getInfoButton);
                    }
                });
            }
        });
        this.dialog.show();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void cancelButtonAction(ActionEvent evt) {
        this.returnStatus = 0;
        this.closeDialog();
    }

    private void closeDialog() {
        this.persistenceManager.saveMRU();
        this.dialog.dispose();
    }

    private void copyMenuItemAction(ActionEvent evt) {
        this.messageTextArea.copy();
    }

    private void clearMenuItemAction(ActionEvent evt) {
        this.currentMessages = "";
        this.messageTextArea.setText("");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddWebServiceDlg.class);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 1));
        this.selectionContainer.setLayout(new BorderLayout());
        this.selectionContainer.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jLabel1.setText(NbBundle.getMessage(this.getClass(), (String)"SELECT_SOURCE"));
        this.selectionContainer.add((Component)this.jLabel1, "North");
        this.selectionPanel.setLayout(new GridBagLayout());
        this.selectionPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Mnemonics.setLocalizedText((AbstractButton)this.urlRadioButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"RADIO_URL"));
        this.urlRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.enableControls();
            }
        });
        this.urlRadioButton.setSelected(true);
        this.selectionGroup.add(this.urlRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.selectionPanel.add((Component)this.urlRadioButton, gridBagConstraints);
        this.urlComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.selectionPanel.add((Component)this.urlComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.localFileRadioButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"RADIO_LOCAL_FILE"));
        this.localFileRadioButton.setSelected(false);
        this.localFileRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.enableControls();
            }
        });
        this.selectionGroup.add(this.localFileRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.selectionPanel.add((Component)this.localFileRadioButton, gridBagConstraints);
        this.localFileComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.selectionPanel.add((Component)this.localFileComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.localFileButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"BROWSE"));
        this.localFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.localFileButtonAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.selectionPanel.add((Component)this.localFileButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.getInfoButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"GET"));
        this.getInfoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.getInfoButtonAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.selectionPanel.add((Component)this.getInfoButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.httpProxyButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"SET_HTTP_PROXY"));
        this.httpProxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new ProxySelectionDialog().show();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.selectionPanel.add((Component)this.httpProxyButton, gridBagConstraints);
        this.selectionContainer.add((Component)this.selectionPanel, "Center");
        this.add((Component)this.selectionContainer, "North");
        this.infoTextPanel.setLayout(new BorderLayout(5, 5));
        this.infoTextPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFocusable(false);
        this.infoTextArea.setFocusCycleRoot(false);
        this.infoTextArea.setEditorKit(new HTMLEditorKit());
        this.infoTextArea.setContentType("text/html");
        this.infoTextArea.addHyperlinkListener(this);
        this.infoTextScrollPane.setViewportView(this.infoTextArea);
        this.infoTextPanel.add((Component)this.infoTextScrollPane, "Center");
        Mnemonics.setLocalizedText((JLabel)this.infoTextlabel, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"WEBSERVICE_INFORMATION"));
        this.infoTextPanel.add((Component)this.infoTextlabel, "North");
        this.messagePanel.setLayout(new BorderLayout(5, 5));
        this.messagePanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setEditorKit(new HTMLEditorKit());
        this.messageTextArea.setContentType("text/html");
        this.messageTextArea.setToolTipText(NbBundle.getMessage(AddWebServiceDlg.class, (String)"TOOLTIP_MESSAGEAREA"));
        this.messageTextScrollPane.setViewportView(this.messageTextArea);
        this.messagePanel.add((Component)this.messageTextScrollPane, "Center");
        Mnemonics.setLocalizedText((JLabel)this.messageTextlabel, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"RESULTS"));
        this.messagePanel.add((Component)this.messageTextlabel, "North");
        this.centerPanel.setLayout(new BorderLayout(5, 5));
        this.centerPanel.add((Component)this.infoTextPanel, "Center");
        this.centerPanel.add((Component)this.messagePanel, "South");
        this.add((Component)this.centerPanel, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"Add"));
        this.addButton.setActionCommand(this.addString);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"CANCEL"));
        this.cancelButton.setActionCommand(this.cancelString);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.cancelButton);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 400) / 2, 400, 400);
        this.copyMenuItem.setText(NbBundle.getMessage(AddWebServiceDlg.class, (String)"CONTEXTMENU_COPY"));
        this.copyMenuItem.setActionCommand(this.copyString);
        this.copyMenuItem.addActionListener(this);
        this.resultsPopup.add(this.copyMenuItem);
        this.clearMenuItem.setText(NbBundle.getMessage(AddWebServiceDlg.class, (String)"CONTEXTMENU_CLEAR"));
        this.clearMenuItem.setActionCommand(this.clearString);
        this.clearMenuItem.addActionListener(this);
        this.resultsPopup.add(this.clearMenuItem);
        PopupListener popupListener = new PopupListener();
        this.messageTextArea.addMouseListener(popupListener);
    }

    private void enableControls() {
        boolean enabled = false;
        enabled = this.urlRadioButton.isSelected();
        this.urlComboBox.setEnabled(enabled);
        enabled = this.localFileRadioButton.isSelected();
        this.localFileComboBox.setEnabled(enabled);
        this.localFileButton.setEnabled(enabled);
        enabled = this.uddiRegistryRadioButton.isSelected();
        this.uddiRegistryComboBox.setEnabled(enabled);
        this.uddiRegistryButton.setEnabled(enabled);
    }

    private String fixFileURL(String inFileURL) {
        String returnFileURL = inFileURL;
        returnFileURL = returnFileURL.substring(0, 1).equalsIgnoreCase("/") ? "file://" + returnFileURL : "file:///" + returnFileURL;
        return returnFileURL;
    }

    private String fixWsdlURL(String inURL) {
        String returnWsdlURL = inURL;
        if (!returnWsdlURL.toLowerCase().endsWith("wsdl")) {
            returnWsdlURL = returnWsdlURL + "?WSDL";
        }
        return returnWsdlURL;
    }

    private void localFileButtonAction(ActionEvent evt) {
        File curDir = null;
        File curSelection = null;
        if (this.localFileComboBox.getSelectedIndex() >= 0 && (curSelection = new File((String)this.localFileComboBox.getSelectedItem())).exists()) {
            curDir = curSelection.isDirectory() ? curSelection : curSelection.getParentFile();
        }
        if (curDir == null) {
            curDir = new File(System.getProperty("netbeans.user"), "websvc");
        }
        if (curSelection != null && curSelection.exists()) {
            wsdlFileChooser.setSelectedFile(curSelection);
        }
        wsdlFileChooser.setCurrentDirectory(curDir);
        if (wsdlFileChooser.showOpenDialog(this) == 0) {
            String localFile = wsdlFileChooser.getSelectedFile().getAbsolutePath();
            if (((DefaultComboBoxModel)this.localFileComboBox.getModel()).getIndexOf(localFile) == -1) {
                this.localFileComboBox.addItem(localFile);
            }
            this.localFileComboBox.setSelectedItem(localFile);
            this.processWSDL(this.fixFileURL(localFile));
        }
    }

    private void getInfoButtonAction(ActionEvent evt) {
        Object urlString = null;
        if (this.urlRadioButton.isSelected()) {
            final String urlStr = ((String)this.urlComboBox.getSelectedItem()).trim();
            if (null != urlStr && urlStr.equalsIgnoreCase(this.URL_WSDL_MSG)) {
                this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
                this.displayError(NbBundle.getMessage(this.getClass(), (String)"ERROR_MUST_SPECIFY_URL"));
            } else {
                if (((DefaultComboBoxModel)this.urlComboBox.getModel()).getIndexOf(urlStr) == -1) {
                    this.urlComboBox.addItem(urlStr);
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        AddWebServiceDlg.this.processWSDL(AddWebServiceDlg.this.fixWsdlURL(urlStr));
                    }
                });
            }
        } else if (this.localFileRadioButton.isSelected()) {
            final String chosenFile = (String)this.localFileComboBox.getSelectedItem();
            if (chosenFile != null && chosenFile.equalsIgnoreCase(this.LOCAL_WSDL_MSG)) {
                this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
                this.displayError(NbBundle.getMessage(this.getClass(), (String)"ERROR_MUST_LOCAL_FILE"));
            } else {
                if (((DefaultComboBoxModel)this.localFileComboBox.getModel()).getIndexOf(chosenFile) == -1) {
                    this.localFileComboBox.addItem(chosenFile);
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        AddWebServiceDlg.this.processWSDL(AddWebServiceDlg.this.fixFileURL(chosenFile));
                    }
                });
            }
        }
    }

    private void processWSDL(String inWSDLURL) {
        Cursor normalCursor = this.dialog.getCursor();
        this.dialog.setCursor(new Cursor(3));
        this.setCurrentWSDL(inWSDLURL);
        if (null == inWSDLURL) {
            return;
        }
        URL wsdlUrl = null;
        try {
            wsdlUrl = new URL(inWSDLURL);
        }
        catch (MalformedURLException mue) {
            this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
            this.displayError(NbBundle.getMessage(this.getClass(), (String)"INVALID_URL"));
            this.dialog.setCursor(normalCursor);
            return;
        }
        this.currentWSDLInfo = this.generateWsdlInfo(wsdlUrl);
        if (null != this.currentWSDLInfo) {
            this.setWebServicesToProcess(this.currentWSDLInfo.getWebServices());
            this.displayWSDLInfo(this.currentWSDLInfo.getWebServices());
            this.infoTextArea.setCaretPosition(1);
            if (!this.currentWSDLInfo.hasOperations()) {
                this.displayError("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"WARNING_SOLICIT") + "</FONT>");
            }
        }
        this.dialog.setCursor(normalCursor);
    }

    private String getCurrentWSDL() {
        return this.currentWSDL;
    }

    private void setCurrentWSDL(String inWSDL) {
        this.currentWSDL = inWSDL;
    }

    private void uddiRegistryButtonAction(ActionEvent evt) {
    }

    private WSDLInfo generateWsdlInfo(URL wsdlUrl) {
        Set webServices = null;
        this.addButton.setEnabled(false);
        WSDLInfo returnWSDLInfo = new WSDLInfo();
        if (this.dlg != null) {
            this.dlg.setValid(false);
        }
        this.infoTextlabel.setEnabled(true);
        this.infoTextArea.setEnabled(true);
        StringWriter infoWriter = new StringWriter();
        infoWriter.write(NbBundle.getMessage(AddWebServiceDlg.class, (String)"PARSING_MSG"));
        infoWriter.write("WSDL - " + wsdlUrl.toString());
        this.displayMessage(infoWriter.toString());
        returnWSDLInfo.setWsdlUrl(wsdlUrl);
        Date date = new Date();
        File tmpOutputDir = null;
        try {
            File tempFile = File.createTempFile("wstemp", "ws");
            tmpOutputDir = new File(tempFile.getParentFile(), "wstemp" + date.getTime());
            if (tmpOutputDir.exists()) {
                tmpOutputDir.mkdirs();
            }
        }
        catch (IOException exc) {
            this.displayError(exc.getLocalizedMessage());
            return null;
        }
        returnWSDLInfo.setOutputDirectory(tmpOutputDir.getAbsolutePath());
        returnWSDLInfo.setPackageName("webservice");
        returnWSDLInfo.setRemoveGeneratedFiles(false);
        if (!returnWSDLInfo.create()) {
            this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
            this.displayError(returnWSDLInfo.getErrorMessage());
            return null;
        }
        webServices = returnWSDLInfo.getWebServices();
        if (webServices == null) {
            this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
            this.displayError(NbBundle.getMessage(AddWebServiceDlg.class, (String)"WSDL_PARSE_ERROR"));
            return null;
        }
        this.addButton.setEnabled(true);
        this.getInfoButton.requestFocus();
        this.getRootPane().setDefaultButton(this.getInfoButton);
        infoWriter = new StringWriter();
        infoWriter.write(NbBundle.getMessage(AddWebServiceDlg.class, (String)"FINISHED_PARSING_MSG"));
        this.displayMessage(infoWriter.toString());
        return returnWSDLInfo;
    }

    private void displayWSDLInfo(Set inWebServices) {
        Iterator serviceIterator = inWebServices.iterator();
        WebServiceData webServiceData = null;
        String displayInfo = "";
        while (serviceIterator.hasNext()) {
            Object wsObj = serviceIterator.next();
            if (null == wsObj || !(wsObj instanceof WebServiceData) || null == this.currentWSDLInfo) continue;
            webServiceData = (WebServiceData)wsObj;
            String serviceInfo = this.currentWSDLInfo.getServiceInfo(webServiceData.getName());
            String changedServiceInfo = this.setDisplayName(webServiceData, serviceInfo);
            displayInfo = displayInfo + changedServiceInfo;
        }
        if (!displayInfo.equals("")) {
            this.displayInfo(displayInfo);
        }
    }

    private String setDisplayName(WebServiceData inWSData, String inHTMLString) {
        String currentDisplayName;
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        String newDisplayName = currentDisplayName = inWSData.getName();
        int ii = 1;
        while (wsListModel.webServiceExists(inWSData)) {
            newDisplayName = currentDisplayName + Integer.toString(ii);
            inWSData.setDisplayName(newDisplayName);
            ++ii;
        }
        int tokenLocation = inHTMLString.indexOf("%%DISPLAY_NAME%%");
        String firstPart = "";
        String lastPart = "";
        if (-1 != tokenLocation) {
            firstPart = inHTMLString.substring(0, tokenLocation);
            lastPart = inHTMLString.substring(tokenLocation + "%%DISPLAY_NAME%%".length());
        }
        return firstPart + newDisplayName + lastPart;
    }

    public void deleteDirectory(File dir) {
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isDirectory()) {
                this.deleteDirectory(children[i]);
                continue;
            }
            children[i].delete();
        }
        dir.delete();
    }

    private void displayInfo(String info) {
        String htmlStart = "<HTML><HEAD><style type=\"text/css\">body { font-family: Verdana, sans-serif; font-size: 11; }</style></HEAD><BODY>";
        String htmlEnd = "</BODY></HTML>";
        this.infoTextArea.setText(htmlStart + info + htmlEnd);
    }

    private void displayError(String inError) {
        this.displayMessage("<FONT COLOR=\"RED\">" + inError + "</FONT>");
    }

    private void displayMessage(String message) {
        this.displayMessage(message, true);
    }

    private void displayMessage(String message, boolean useTimeStamp) {
        String dateStamp = this.dateFormat.format(new Date());
        String htmlStart = "<HTML><HEAD><style type=\"text/css\">body { font-family: Verdana, sans-serif; font-size: 12; }</style></HEAD><BODY>";
        String htmlEnd = "</BODY></HTML>";
        if (!this.previousWSDL.equals(this.getCurrentWSDL())) {
            if (!this.previousWSDL.equals("")) {
                this.currentMessages = this.currentMessages + "<BR><FONT COLOR=\"BLUE\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"MESSAGE_END") + " " + this.previousWSDL + "</FONT>";
            }
            this.currentMessages = this.currentMessages + "<BR><FONT COLOR=\"BLUE\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"MESSAGE_START") + " " + this.getCurrentWSDL() + "</FONT>";
            this.previousWSDL = this.getCurrentWSDL();
        }
        this.currentMessages = useTimeStamp ? this.currentMessages + "<BR><B><I>" + dateStamp + ":&nbsp</I></B>" + message : this.currentMessages + "<BR>" + message;
        this.messageTextArea.setText(htmlStart + this.currentMessages + htmlEnd);
    }

    private void setWebServicesToProcess(Set inWebServices) {
        this.webServicesToProcess = inWebServices;
    }

    private Set getWebServicesToProcess() {
        return this.webServicesToProcess;
    }

    private void addButtonAction(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Cursor normalCursor = AddWebServiceDlg.this.dialog.getCursor();
                AddWebServiceDlg.this.dialog.setCursor(new Cursor(3));
                AddWebServiceDlg.this.addWebServices();
                AddWebServiceDlg.this.dialog.setCursor(normalCursor);
            }
        });
    }

    private void addWebServices() {
        Set webServices = this.getWebServicesToProcess();
        if (webServices == null) {
            return;
        }
        Iterator iter = webServices.iterator();
        boolean duplicateFound = false;
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        HashSet addFailedWebServices = new HashSet();
        addFailedWebServices.addAll(webServices);
        while (iter.hasNext()) {
            WebServiceData wsData = (WebServiceData)iter.next();
            this.findValuesInHTML(wsData);
            if (null == wsData.getDisplayName() || wsData.getDisplayName().equals(" ") || wsData.getDisplayName().length() == 0) {
                this.displayError(wsData.getName() + ":" + NbBundle.getMessage(this.getClass(), (String)"ERROR_BLANK_WS_DISPLAYNAME"));
                continue;
            }
            if (!Util.isValidIdentifier(wsData.getDisplayName())) {
                this.displayError(wsData.getDisplayName() + ":" + NbBundle.getMessage(this.getClass(), (String)"ERROR_INVALID_DISPLAYNAME"));
                continue;
            }
            if (null == wsData.getPackageName() || wsData.getPackageName().length() == 0) {
                this.displayError(wsData.getDisplayName() + ":" + NbBundle.getMessage(this.getClass(), (String)"ERROR_BLANK_WS_PACKAGENAME"));
                continue;
            }
            if (!Util.isValidPackageName(wsData.getPackageName())) {
                this.displayError(wsData.getPackageName() + ":" + NbBundle.getMessage(this.getClass(), (String)"ERROR_INVALID_PACKAGENAME"));
                continue;
            }
            if (!wsListModel.webServiceExists(wsData)) {
                String jarFileName = System.getProperty("netbeans.user") + "/websvc/" + "webservice" + new Date().getTime() + ".jar";
                if (!this.compileWebService(wsData, jarFileName)) {
                    this.addButton.setEnabled(false);
                    return;
                }
                wsListModel.addWebService(wsData);
                if (this.invokingNode != null) {
                    WebServiceGroupCookie groupCookie = (WebServiceGroupCookie)this.invokingNode.getCookie(WebServiceGroupCookie.class);
                    if (groupCookie != null) {
                        groupCookie.getWebServiceGroup().add(wsData.getId());
                        wsData.setGroupId(groupCookie.getWebServiceGroup().getId());
                    } else {
                        ErrorManager.getDefault().log(1, "Add Web Service to Registry :: Invoking node w/ no GroupCookie :: class " + this.invokingNode.getClass());
                        WebServiceGroup wsGroup = wsListModel.getWebServiceGroup("default");
                        wsGroup.add(wsData.getId());
                        wsData.setGroupId(wsGroup.getId());
                    }
                } else {
                    WebServiceGroup wsGroup = wsListModel.getWebServiceGroup("default");
                    if (wsGroup == null) {
                        wsGroup = new WebServiceGroup("default");
                    }
                    wsListModel.addWebServiceGroup(wsGroup);
                    wsGroup.add(wsData.getId());
                    wsData.setGroupId(wsGroup.getId());
                }
                this.displayMessage(wsData.getDisplayName() + " " + NbBundle.getMessage(this.getClass(), (String)"WS_SUCCESSFULLY_ADDED"));
                addFailedWebServices.remove(wsData);
                continue;
            }
            String msg = wsData.getDisplayName() + " " + NbBundle.getMessage(AddWebServiceDlg.class, (String)"WS_ALREADY_EXIST_MSG");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
        if (addFailedWebServices.size() > 0) {
            this.displayWSDLInfo(addFailedWebServices);
            this.setWebServicesToProcess(addFailedWebServices);
        } else {
            this.closeDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileWebService(WebServiceData inWSData, String inJarFileName) {
        PipedOutputStream pos = null;
        BufferedInputStream in = null;
        try {
            pos = new PipedOutputStream();
            in = new BufferedInputStream(new PipedInputStream(pos));
            PipedReaderTask readerTask = new PipedReaderTask(in, this.messageTextArea);
            this.displayMessage(NbBundle.getMessage(this.getClass(), (String)"WSCOMPILE_START"));
            Thread pipeThread = new Thread(readerTask);
            pipeThread.start();
            if (!Util.createWSJar(inWSData, pos, inJarFileName)) {
                ErrorManager.getDefault().log(this.getClass().getName() + ": " + NbBundle.getMessage(this.getClass(), (String)"PROXY_GEN_ERROR"));
                this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
                this.displayError(NbBundle.getMessage(this.getClass(), (String)"PROXY_GEN_ERROR"));
                boolean bl = false;
                return bl;
            }
            inWSData.setProxyJarFileName(inJarFileName);
            this.displayMessage(NbBundle.getMessage(this.getClass(), (String)"WSCOMPILE_END"));
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            this.displayInfo("<FONT COLOR=\"RED\">" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"PROCESSING_ERROR") + "</FONT>");
            this.displayError(NbBundle.getMessage(this.getClass(), (String)"PROXY_GEN_ERROR"));
            boolean bl = false;
            return bl;
        }
        finally {
            if (pos != null) {
                try {
                    pos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    private void findValuesInHTML(WebServiceData inWSData) {
        JTextField tf;
        ComponentView cv;
        Component currentComponent;
        View view;
        int offset;
        this.document = (HTMLDocument)this.infoTextArea.getDocument();
        Element rootElement = this.document.getDefaultRootElement();
        Element formElement = null;
        Element inputElement = null;
        formElement = this.document.getElement(rootElement, HTML.Attribute.NAME, "service_form." + inWSData.getName());
        inputElement = this.document.getElement(formElement, HTML.Attribute.NAME, "service_name." + inWSData.getName());
        if (null != inputElement) {
            offset = inputElement.getStartOffset();
            view = this.infoTextArea.getUI().getRootView(this.infoTextArea);
            currentComponent = null;
            while (view.getViewCount() > 0) {
                if (view instanceof ComponentView) {
                    cv = (ComponentView)view;
                    currentComponent = cv.getComponent();
                    break;
                }
                int index = view.getViewIndex(offset, Position.Bias.Forward);
                view = view.getView(index);
            }
            if (view instanceof ComponentView) {
                cv = (ComponentView)view;
                currentComponent = cv.getComponent();
            }
            if (currentComponent instanceof JTextField) {
                tf = (JTextField)currentComponent;
                inWSData.setDisplayName(tf.getText());
            }
        }
        if (null != (inputElement = this.document.getElement(formElement, HTML.Attribute.NAME, "package_name." + inWSData.getName()))) {
            offset = inputElement.getStartOffset();
            view = this.infoTextArea.getUI().getRootView(this.infoTextArea);
            currentComponent = null;
            while (view.getViewCount() > 0) {
                if (view instanceof ComponentView) {
                    cv = (ComponentView)view;
                    currentComponent = cv.getComponent();
                    break;
                }
                int index = view.getViewIndex(offset, Position.Bias.Forward);
                view = view.getView(index);
            }
            if (view instanceof ComponentView) {
                cv = (ComponentView)view;
                currentComponent = cv.getComponent();
            }
            if (currentComponent instanceof JTextField) {
                tf = (JTextField)currentComponent;
                inWSData.setPackageName(tf.getText());
            }
        }
    }

    private void setDefaults() {
        this.addButton.setEnabled(false);
        this.urlRadioButton.setSelected(true);
        this.localFileRadioButton.setSelected(false);
        this.urlComboBox.setSelectedIndex(0);
        this.localFileComboBox.setSelectedIndex(0);
        this.displayInfo("<BR><BR><BR><BR><B>" + NbBundle.getMessage(AddWebServiceDlg.class, (String)"INSTRUCTIONS") + "</B>");
        this.enableControls();
    }

    public static void main(String[] args) {
        System.setProperty("http.proxyHost", "webcache.sfbay.sun.com");
        System.setProperty("http.proxyPort", "8080");
        System.setProperty("netbeans.home", "D:\\rave-slim\\nbbuild\rave");
        System.setProperty("netbeans.user", "D:\\rave-slim\\userdir");
        AddWebServiceDlg myWSPanel = new AddWebServiceDlg();
        JDialog dialog = new JDialog();
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Saving ...");
            }
        });
        dialog.getContentPane().add(myWSPanel);
        dialog.pack();
        dialog.show();
    }

    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if (actionCommand.equalsIgnoreCase(this.addString)) {
            this.addButtonAction(evt);
        } else if (actionCommand.equalsIgnoreCase(this.cancelString)) {
            this.cancelButtonAction(evt);
        } else if (actionCommand.equalsIgnoreCase(this.copyString)) {
            this.copyMenuItemAction(evt);
        } else if (actionCommand.equalsIgnoreCase(this.clearString)) {
            this.clearMenuItemAction(evt);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            String link = e.getDescription();
            String[] parts = link.split("@");
            if (null == parts) {
                return;
            }
            String actionName = parts[0];
            if (actionName.equalsIgnoreCase("test")) {
                this.testMethod(link);
            }
        }
    }

    private void testMethod(String inHyperLink) {
        String[] parts = inHyperLink.split("@");
        if (null == parts) {
            return;
        }
        String actionName = parts[0];
        String serviceName = parts[1];
        String portName = parts[2];
        String methodName = parts[3];
        String[] patternParts = inHyperLink.split("\\|");
        if (null == patternParts) {
            return;
        }
        String signaturePattern = patternParts[1];
        Set services = this.currentWSDLInfo.getWebServices();
        Iterator serviceIterator = services.iterator();
        JavaMethod method = null;
        WebServiceData wsData = null;
        while (serviceIterator.hasNext()) {
            WebServiceData currentWSData = (WebServiceData)serviceIterator.next();
            if (currentWSData.getName().equals(serviceName)) {
                Port[] ports = currentWSData.getPorts();
                for (int ii = 0; null != ports && ii < ports.length; ++ii) {
                    if (!ports[ii].getName().getLocalPart().equals(portName)) continue;
                    Iterator operatorIterator = ports[ii].getOperations();
                    while (operatorIterator.hasNext()) {
                        Operation currentOperation = (Operation)operatorIterator.next();
                        JavaMethod currentMethod = currentOperation.getJavaMethod();
                        if (!currentMethod.getName().equals(methodName) || !this.signatureEqual(currentMethod, signaturePattern)) continue;
                        method = currentMethod;
                        wsData = currentWSData;
                        break;
                    }
                    if (null != method) break;
                }
            }
            if (null == method) continue;
            break;
        }
        if (null != wsData) {
            if (null == wsData.getProxyJarFileName() || wsData.getProxyJarFileName().length() == 0) {
                String searchWSDL = wsData.getURL();
                String jarFileName = null;
                Object jarFileNameObject = this.jarCache.get(searchWSDL);
                if (null == jarFileNameObject) {
                    File tempFile = null;
                    try {
                        tempFile = File.createTempFile("wstemp", ".jar");
                        tempFile.deleteOnExit();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                        return;
                    }
                    jarFileName = tempFile.getAbsolutePath();
                    Cursor normalCursor = this.dialog.getCursor();
                    this.dialog.setCursor(new Cursor(3));
                    boolean compiledOK = this.compileWebService(wsData, jarFileName);
                    this.dialog.setCursor(normalCursor);
                    if (!compiledOK) {
                        return;
                    }
                    this.jarCache.put(searchWSDL, jarFileName);
                } else {
                    jarFileName = (String)jarFileNameObject;
                }
                wsData.setProxyJarFileName(jarFileName);
            }
            TestWebServiceMethodDlg dlg = new TestWebServiceMethodDlg(wsData, method, portName);
            dlg.displayDialog();
        }
    }

    private boolean signatureEqual(JavaMethod inMethod, String inPattern) {
        if (null == inMethod || null == inPattern) {
            return false;
        }
        String[] parts = inPattern.split("!");
        if (null == parts) {
            return false;
        }
        String returnType = parts[0];
        if (parts.length == 1) {
            return inMethod.getParameterCount() <= 0;
        }
        if (!returnType.equals(inMethod.getReturnType().getRealName())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(parts[1], ":");
        LinkedList<String> compareList = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            compareList.add(tokenizer.nextToken());
        }
        Iterator paramIterator = inMethod.getParameters();
        LinkedList<String> inList = new LinkedList<String>();
        while (paramIterator.hasNext()) {
            inList.add(((JavaParameter)paramIterator.next()).getType().getRealName());
        }
        return inList.equals(compareList);
    }

    public class PipedReaderTask
    implements Runnable {
        private BufferedInputStream inputStream;
        private String pipedOutput = "";
        private JEditorPane messagePane;

        public PipedReaderTask(BufferedInputStream inBufferedInput, JEditorPane inMessagePane) {
            this.inputStream = inBufferedInput;
            this.messagePane = inMessagePane;
        }

        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            try {
                String currentLine = null;
                while ((currentLine = reader.readLine()) != null) {
                    this.pipedOutput = this.pipedOutput + currentLine;
                    this.messagePane.setText(this.pipedOutput);
                }
                reader.close();
            }
            catch (IOException ioe) {
                this.pipedOutput = this.pipedOutput + "IOException=" + ioe;
            }
        }

        public String getPipedOutput() {
            return this.pipedOutput;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AddWebServiceDlg.this.resultsPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MRUPersistenceManager {
        File mruFile = new File(System.getProperty("netbeans.user"), "ws_urls.xml");

        private MRUPersistenceManager() {
        }

        public void loadMRU() {
            block5: {
                XMLDecoder decoder = null;
                AddWebServiceDlg.this.urlComboBox.addItem(AddWebServiceDlg.this.URL_WSDL_MSG);
                AddWebServiceDlg.this.localFileComboBox.addItem(AddWebServiceDlg.this.LOCAL_WSDL_MSG);
                try {
                    decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(this.mruFile)));
                    if (this.mruFile.exists()) {
                        int i;
                        int wsDataNums = (Integer)decoder.readObject();
                        for (i = 0; i < wsDataNums; ++i) {
                            String urlItem = (String)decoder.readObject();
                            if (urlItem.equals(AddWebServiceDlg.this.URL_WSDL_MSG)) continue;
                            AddWebServiceDlg.this.urlComboBox.addItem(urlItem);
                        }
                        wsDataNums = (Integer)decoder.readObject();
                        for (i = 0; i < wsDataNums; ++i) {
                            String lfItem = (String)decoder.readObject();
                            if (lfItem.equals(AddWebServiceDlg.this.LOCAL_WSDL_MSG)) continue;
                            AddWebServiceDlg.this.localFileComboBox.addItem(lfItem);
                        }
                        decoder.close();
                    }
                }
                catch (Exception e) {
                    if (decoder == null) break block5;
                    decoder.close();
                }
            }
        }

        public void saveMRU() {
            block5: {
                if (this.mruFile.exists()) {
                    this.mruFile.delete();
                }
                XMLEncoder encoder = null;
                try {
                    int i;
                    encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.mruFile)));
                    int itemCount = AddWebServiceDlg.this.urlComboBox.getItemCount();
                    encoder.writeObject(new Integer(itemCount));
                    for (i = 0; i < itemCount; ++i) {
                        String urlItem = ((String)AddWebServiceDlg.this.urlComboBox.getItemAt(i)).trim();
                        encoder.writeObject(urlItem);
                    }
                    itemCount = AddWebServiceDlg.this.localFileComboBox.getItemCount();
                    encoder.writeObject(new Integer(itemCount));
                    for (i = 0; i < itemCount; ++i) {
                        String lfItem = (String)AddWebServiceDlg.this.localFileComboBox.getItemAt(i);
                        encoder.writeObject(lfItem);
                    }
                    encoder.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (encoder == null) break block5;
                    encoder.close();
                }
            }
        }
    }
}

