/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.modules.project.libraries.ui.NewLibraryPanel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class LibrariesCustomizer
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager manager;
    private LibrariesModel model = new LibrariesModel();
    private BeanTreeView libraries;
    private JButton createButton;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField libraryName;
    private JPanel libsPanel;
    private JTabbedPane properties;

    public LibrariesCustomizer() {
        this.initComponents();
        this.postInitComponents();
    }

    public void setSelectedLibrary(LibraryImplementation library) {
        if (library == null) {
            return;
        }
        ExplorerManager manager = this.getExplorerManager();
        Node root = manager.getRootContext();
        String[] path = new String[]{library.getType(), library.getName()};
        try {
            Node node = NodeOp.findPath((Node)root, (String[])path);
            if (node != null) {
                manager.setSelectedNodes(new Node[]{node});
            }
        }
        catch (NodeNotFoundException e) {
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesCustomizer.class);
    }

    public boolean apply() {
        try {
            this.model.apply();
            return true;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return false;
        }
    }

    public void cancel() {
        this.model.cancel();
    }

    public void addNotify() {
        super.addNotify();
        LibrariesCustomizer.expandAllNodes(this.libraries, this.getExplorerManager().getRootContext());
        if (this.getExplorerManager().getSelectedNodes().length == 0) {
            Node root = this.getExplorerManager().getRootContext();
            Node[] nodes = root.getChildren().getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                Node[] lnodes = nodes[i].getChildren().getNodes(true);
                if (lnodes.length <= 0) continue;
                try {
                    this.getExplorerManager().setSelectedNodes(new Node[]{lnodes[0]});
                }
                catch (PropertyVetoException e) {}
                break;
            }
        }
        this.libraries.requestFocus();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("selectedNodes".equals(event.getPropertyName())) {
                        Node[] nodes = (Node[])event.getNewValue();
                        LibrariesCustomizer.this.selectLibrary(nodes);
                        LibrariesCustomizer.this.libraries.requestFocus();
                    }
                }
            });
            this.manager.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                    if ("selectedNodes".equals(event.getPropertyName())) {
                        Node[] nodes = (Node[])event.getNewValue();
                        if (nodes.length <= 1) {
                            return;
                        }
                        throw new PropertyVetoException("Invalid length", event);
                    }
                }
            });
            this.manager.setRootContext(LibrariesCustomizer.buildTree(this.model));
        }
        return this.manager;
    }

    private void postInitComponents() {
        this.libraries = new LibrariesView();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ((GridBagLayout)this.libsPanel.getLayout()).setConstraints((Component)this.libraries, c);
        this.libsPanel.add((Component)this.libraries);
        this.libraries.setPreferredSize(new Dimension(200, 334));
        this.libraryName.setColumns(25);
        this.libraryName.setEnabled(false);
        this.libraryName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibrariesCustomizer.this.nameChanged();
            }
        });
    }

    private void nameChanged() {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length == 1 && nodes[0] instanceof LibraryNode) {
            LibraryNode node = (LibraryNode)nodes[0];
            String newName = this.libraryName.getText();
            if (newName.length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"ERR_InvalidName"), 0));
            } else if (LibrariesCustomizer.isValidName(this.model, newName)) {
                node.getLibrary().setName(newName);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"ERR_ExistingName", (Object)newName), 0));
            }
        }
    }

    private void selectLibrary(Node[] nodes) {
        int tabCount = this.properties.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            this.properties.removeTabAt(0);
        }
        this.libraryName.setEnabled(false);
        this.libraryName.setText("");
        this.jLabel1.setVisible(false);
        this.libraryName.setVisible(false);
        this.properties.setVisible(false);
        this.deleteButton.setEnabled(false);
        if (nodes.length != 1 || !(nodes[0] instanceof LibraryNode)) {
            return;
        }
        this.jLabel1.setVisible(true);
        this.libraryName.setVisible(true);
        this.properties.setVisible(true);
        LibraryNode lnode = (LibraryNode)nodes[0];
        LibraryImplementation impl = lnode.getLibrary();
        boolean editable = this.model.isLibraryEditable(impl);
        this.libraryName.setEnabled(editable);
        this.deleteButton.setEnabled(editable);
        this.libraryName.setText(LibrariesCustomizer.getLocalizedString(impl.getLocalizingBundle(), impl.getName()));
        String libraryType = impl.getType();
        LibraryTypeProvider provider = lnode.getProvider();
        if (provider == null) {
            return;
        }
        String[] volumeTypes = provider.getSupportedVolumeTypes();
        for (int i = 0; i < volumeTypes.length; ++i) {
            Customizer c = provider.getCustomizer(volumeTypes[i]);
            if (!(c instanceof JComponent)) continue;
            c.setObject(impl);
            JComponent component = (JComponent)((Object)c);
            component.setEnabled(editable);
            String tabName = component.getName();
            if (tabName == null) {
                tabName = volumeTypes[i];
            }
            this.properties.addTab(tabName, component);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryName = new JTextField();
        this.jPanel1 = new JPanel();
        this.properties = new JTabbedPane();
        this.createButton = new JButton();
        this.deleteButton = new JButton();
        this.libsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibrariesCustomizer"));
        this.jLabel1.setLabelFor(this.libraryName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_CustomizerLibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.libraryName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.libraryName, gridBagConstraints);
        this.libraryName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibraryName"));
        this.jPanel1.setLayout(new BorderLayout());
        this.properties.setPreferredSize(new Dimension(400, 300));
        this.jPanel1.add((Component)this.properties, "Center");
        this.properties.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AN_LibrariesCustomizerProperties"));
        this.properties.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibrariesCustomizerProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_NewLibrary"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.createLibrary(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.createButton, gridBagConstraints);
        this.createButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_NewLibrary"));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_DeleteLibrary"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.deleteLibrary(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_DeleteLibrary"));
        this.libsPanel.setLayout(new GridBagLayout());
        this.libsPanel.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 6);
        this.add((Component)this.libsPanel, gridBagConstraints);
        this.libsPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_libsPanel"));
        this.jLabel2.setLabelFor(this.libsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("TXT_LibrariesPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void deleteLibrary(ActionEvent evt) {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length == 1 && nodes[0] instanceof LibraryNode) {
            Node[] sib = nodes[0].getParentNode().getChildren().getNodes(true);
            Node selNode = null;
            for (int i = 0; i < sib.length; ++i) {
                if (!nodes[0].equals((Object)sib[i])) continue;
                if (i > 0) {
                    selNode = sib[i - 1];
                    continue;
                }
                if (i >= sib.length - 1) continue;
                selNode = sib[i + 1];
            }
            this.model.removeLibrary(((LibraryNode)nodes[0]).getLibrary());
            try {
                if (selNode != null) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{selNode});
                }
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            this.libraries.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLibrary(ActionEvent evt) {
        block12: {
            Window dlg = null;
            try {
                LibraryCategory lc;
                String preselectedLibraryType = null;
                Node[] preselectedNodes = this.getExplorerManager().getSelectedNodes();
                if (preselectedNodes.length == 1 && (lc = (LibraryCategory)preselectedNodes[0].getLookup().lookup(LibraryCategory.class)) != null) {
                    preselectedLibraryType = lc.getCategoryType();
                }
                NewLibraryPanel p = new NewLibraryPanel(this.model, preselectedLibraryType);
                DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"CTL_CreateLibrary"), true, 2, null, null);
                p.setDialogDescriptor(dd);
                dlg = DialogDisplayer.getDefault().createDialog(dd);
                ((Dialog)dlg).setVisible(true);
                if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                    String libraryType = p.getLibraryType();
                    String libraryName = p.getLibraryName();
                    LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
                    if (provider == null) {
                        return;
                    }
                    LibraryImplementation impl = provider.createLibrary();
                    impl.setName(libraryName);
                    this.model.addLibrary(impl);
                    String[] path = new String[]{impl.getType(), impl.getName()};
                    ExplorerManager mgr = this.getExplorerManager();
                    try {
                        Node node = NodeOp.findPath((Node)mgr.getRootContext(), (String[])path);
                        if (node != null) {
                            mgr.setSelectedNodes(new Node[]{node});
                        }
                    }
                    catch (PropertyVetoException e) {
                    }
                    catch (NodeNotFoundException e) {
                        // empty catch block
                    }
                    this.libraryName.requestFocus();
                    this.libraryName.selectAll();
                    break block12;
                }
                this.libraries.requestFocus();
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    static boolean isValidName(LibrariesModel model, String name) {
        int count = model.getSize();
        for (int i = 0; i < count; ++i) {
            LibraryImplementation lib = (LibraryImplementation)model.getElementAt(i);
            if (lib == null || !lib.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    static String getLocalizedString(String bundleResourceName, String key) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (bundleResourceName == null) {
            return key;
        }
        try {
            bundle = NbBundle.getBundle((String)bundleResourceName);
        }
        catch (MissingResourceException mre) {
            ErrorManager.getDefault().notify(1, (Throwable)mre);
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    private static void expandAllNodes(BeanTreeView btv, Node node) {
        btv.expandNode(node);
        Children ch = node.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            LibrariesCustomizer.expandAllNodes(btv, nodes[i]);
        }
    }

    private static Node buildTree(LibrariesModel model) {
        return new AbstractNode((Children)new RootChildren(model));
    }

    private static class LibraryNode
    extends AbstractNode {
        private static final String ICON = "org/netbeans/modules/project/libraries/resources/libraries";
        private LibraryImplementation lib;
        private LibraryTypeProvider provider;

        public LibraryNode(LibraryImplementation lib, LibraryTypeProvider provider) {
            super(Children.LEAF);
            this.lib = lib;
            this.provider = provider;
            this.setIconBase(ICON);
        }

        public String getName() {
            return this.lib.getName();
        }

        public String getDisplayName() {
            return LibrariesCustomizer.getLocalizedString(this.lib.getLocalizingBundle(), this.lib.getName());
        }

        public LibraryImplementation getLibrary() {
            return this.lib;
        }

        public LibraryTypeProvider getProvider() {
            return this.provider;
        }

        public boolean equals(Object other) {
            if (other instanceof LibraryNode) {
                LibraryNode ol = (LibraryNode)((Object)other);
                return (this.lib == null ? ol.lib == null : this.lib.equals(ol.lib)) && (this.provider == null ? ol.provider == null : this.provider.equals(ol.provider));
            }
            return false;
        }
    }

    private static class CategoryChildren
    extends Children.Keys
    implements ListDataListener {
        private LibraryTypeProvider provider;
        private LibrariesModel model;

        public CategoryChildren(LibraryTypeProvider provider, LibrariesModel model) {
            this.provider = provider;
            this.model = model;
            this.model.addListDataListener(this);
        }

        public void addNotify() {
            ArrayList<LibraryImplementation> keys = new ArrayList<LibraryImplementation>();
            for (int i = 0; i < this.model.getSize(); ++i) {
                LibraryImplementation impl = (LibraryImplementation)this.model.getElementAt(i);
                if (!this.provider.getLibraryType().equals(impl.getType())) continue;
                keys.add(impl);
            }
            this.setKeys(keys);
        }

        public void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof LibraryImplementation) {
                LibraryImplementation impl = (LibraryImplementation)key;
                return new Node[]{new LibraryNode(impl, this.provider)};
            }
            return new Node[0];
        }

        public void contentsChanged(ListDataEvent e) {
            this.addNotify();
        }

        public void intervalAdded(ListDataEvent e) {
            this.addNotify();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.addNotify();
        }
    }

    private static class CategoryNode
    extends AbstractNode {
        private LibraryTypeProvider provider;
        private Node iconDelegate;

        public CategoryNode(LibraryTypeProvider provider, LibrariesModel model) {
            super((Children)new CategoryChildren(provider, model), Lookups.singleton((Object)new LibraryCategory(provider.getLibraryType())));
            this.provider = provider;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.provider.getLibraryType();
        }

        public String getDisplayName() {
            return this.provider.getDisplayName();
        }

        public Image getIcon(int type) {
            return this.iconDelegate.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.iconDelegate.getOpenedIcon(type);
        }
    }

    private static final class LibraryCategory {
        private final String name;

        LibraryCategory(String name) {
            this.name = name;
        }

        public String getCategoryType() {
            return this.name;
        }
    }

    private static class RootChildren
    extends Children.Keys {
        private LibrariesModel model;

        public RootChildren(LibrariesModel model) {
            this.model = model;
        }

        public void addNotify() {
            this.setKeys(LibraryTypeRegistry.getDefault().getLibraryTypeProviders());
        }

        public void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof LibraryTypeProvider) {
                LibraryTypeProvider provider = (LibraryTypeProvider)key;
                return new Node[]{new CategoryNode(provider, this.model)};
            }
            return new Node[0];
        }
    }

    private static class LibrariesView
    extends BeanTreeView {
        public LibrariesView() {
            this.setRootVisible(false);
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
        }
    }
}

