/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class JUnitProgress
extends JPanel
implements ActionListener {
    private DialogDescriptor descriptor = null;
    private Dialog dialog = null;
    private volatile boolean canceled = false;
    private String dialogTitle = "";
    private JLabel lblMessage;

    public JUnitProgress(String dialogTitle) {
        if (dialogTitle != null) {
            this.dialogTitle = dialogTitle;
        }
        this.initComponents();
    }

    public void showMe(boolean displayCancel) {
        if (null == this.descriptor) {
            Object[] options = null;
            Object initOption = null;
            if (displayCancel) {
                options = new Object[]{DialogDescriptor.CANCEL_OPTION};
                initOption = DialogDescriptor.CANCEL_OPTION;
            }
            this.descriptor = new DialogDescriptor((Object)this, this.dialogTitle, false, options, initOption, 0, null, (ActionListener)this);
        }
        if (null != this.dialog) {
            this.dialog.dispose();
        }
        this.canceled = false;
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JUnitProgress.class, (String)"ACS_StatusBar_CreateTests"));
        this.dialog.setSize(400, 150);
        this.dialog.setVisible(true);
    }

    public void hideMe() {
        if (null != this.dialog) {
            this.dialog.dispose();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        this.canceled = true;
    }

    public void setMessage(String msg) {
        this.setMessage(msg, false);
    }

    public void setMessage(final String msg, boolean displayStatus) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.lblMessage.setText(msg);
        } else {
            SwingUtilities.invokeLater(new Thread(){

                public void run() {
                    JUnitProgress.this.lblMessage.setText(msg);
                }
            });
        }
        if (displayStatus) {
            this.displayStatusText(msg);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void displayStatusText(String statusText) {
        StatusDisplayer.getDefault().setStatusText(statusText);
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblMessage.setText(ResourceBundle.getBundle("org/netbeans/modules/junit/Bundle").getString("JUnitProgress.lblMessage.text"));
        this.lblMessage.setAlignmentX(0.5f);
        this.lblMessage.setHorizontalTextPosition(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.lblMessage, gridBagConstraints);
    }
}

