/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelfResizingPanel
extends JPanel {
    private boolean painted = false;

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (!this.painted) {
            this.paintedFirstTime(g);
            this.painted = true;
        }
    }

    protected void paintedFirstTime(Graphics g) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelfResizingPanel.this.adjustWindowSize();
            }
        });
    }

    protected void adjustWindowSize() {
        Dimension currSize = this.getSize();
        int currHeight = currSize.height;
        int prefHeight = this.getPreferredSize().height;
        if (currHeight < prefHeight) {
            int delta = prefHeight - currHeight;
            Window win = SwingUtilities.getWindowAncestor(this);
            Dimension winSize = win.getSize();
            win.setSize(winSize.width, winSize.height + delta);
        }
    }

    protected boolean isPainted() {
        return this.painted;
    }
}

