/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultWindow;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

final class Manager {
    private static Reference instanceRef;
    private final Map junitSessions = new WeakHashMap(5);
    private ComponentListener listener;
    private Map displayHandlers;
    private Map displaysMap;

    Manager() {
    }

    static Manager getInstance() {
        Manager instance;
        Object inst;
        Object v0 = inst = instanceRef != null ? instanceRef.get() : null;
        if (inst != null) {
            instance = inst;
        } else {
            instance = new Manager();
            instanceRef = new WeakReference<Manager>(instance);
        }
        return instance;
    }

    void targetStarted(AntSession session, int sessionType) {
        this.displayMessage(session, sessionType, NbBundle.getMessage(this.getClass(), (String)"LBL_PreparingTests"));
    }

    void testStarted(AntSession session, int sessionType) {
        this.displayMessage(session, sessionType, NbBundle.getMessage(this.getClass(), (String)"LBL_RunningTests"));
    }

    void reportStarted(AntSession session) {
        Object sessType = this.junitSessions.get(session);
        assert (sessType == null || sessType.getClass() == Integer.class);
        if (sessType == null) {
            return;
        }
        if ((Integer)sessType != 2) {
            return;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                class DishonourAvenger
                implements ComponentListener {
                    private boolean activated;
                    final /* synthetic */ Manager this$0;

                    DishonourAvenger(Manager manager) {
                        this.this$0 = manager;
                        this.activated = false;
                    }

                    public void componentMoved(ComponentEvent e) {
                    }

                    public void componentResized(ComponentEvent e) {
                    }

                    public void componentShown(ComponentEvent e) {
                    }

                    public void componentHidden(ComponentEvent e) {
                        if (!this.activated) {
                            this.activated = true;
                            ResultWindow window = ResultWindow.getInstance();
                            window.removeComponentListener(this);
                            window.requestVisible();
                        }
                    }
                }
                ResultWindow.getInstance().addComponentListener(Manager.this.listener = new DishonourAvenger(Manager.this));
            }
        });
    }

    void sessionFinished(AntSession session, int sessionType, boolean initializationFailed) {
        Object o = this.junitSessions.get(session);
        assert (o == null || o instanceof Integer);
        if (o == null) {
            return;
        }
        String message = initializationFailed ? NbBundle.getMessage(this.getClass(), (String)"LBL_TestBuildInitFailed") : null;
        this.displayMessage(session, sessionType, message);
        this.junitSessions.remove(session);
        if (this.listener != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    ResultWindow.getInstance().removeComponentListener(Manager.this.listener);
                }
            });
            this.listener = null;
        }
    }

    void displayOutput(AntSession session, int sessionType, String text, boolean error) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayOutput(text, error);
        this.displayInWindow(session, sessionType, displayHandler);
    }

    void displaySuiteRunning(AntSession session, int sessionType, String suiteName) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displaySuiteRunning(suiteName);
        this.displayInWindow(session, sessionType, displayHandler);
    }

    void displayReport(AntSession session, int sessionType, Report report) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayReport(report);
        this.displayInWindow(session, sessionType, displayHandler);
    }

    private void displayMessage(AntSession session, int sessionType, String message) {
        ResultDisplayHandler displayHandler = this.getDisplayHandler(session);
        displayHandler.displayMessage(message);
        this.displayInWindow(session, sessionType, displayHandler);
    }

    private void displayInWindow(AntSession session, int sessionType, ResultDisplayHandler displayHandler) {
        boolean promote = this.junitSessions.put(session, new Integer(sessionType)) == null && sessionType == 2;
        int displayIndex = this.getDisplayIndex(session);
        if (displayIndex == -1) {
            this.addDisplay(session);
            Mutex.EVENT.writeAccess((Runnable)new Displayer(displayHandler, promote));
        } else if (promote) {
            Mutex.EVENT.writeAccess((Runnable)new Displayer(null, promote));
        }
    }

    private ResultDisplayHandler getDisplayHandler(AntSession session) {
        ResultDisplayHandler displayHandler;
        Object o;
        Object v0 = o = this.displayHandlers != null ? this.displayHandlers.get(session) : null;
        if (o != null) {
            displayHandler = o;
        } else {
            if (this.displayHandlers == null) {
                this.displayHandlers = new WeakHashMap(7);
            }
            displayHandler = new ResultDisplayHandler();
            this.displayHandlers.put(session, displayHandler);
        }
        return displayHandler;
    }

    private int getDisplayIndex(AntSession session) {
        if (this.displaysMap == null) {
            return -1;
        }
        Object o = this.displaysMap.get(session);
        return o != null ? 0 : -1;
    }

    private void addDisplay(AntSession session) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap(4);
        }
        this.displaysMap.put(session, Boolean.TRUE);
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler displayHandler, boolean promote) {
            this.displayHandler = displayHandler;
            this.promote = promote;
        }

        public void run() {
            ResultWindow window = ResultWindow.getInstance();
            if (this.displayHandler != null) {
                window.addDisplayComponent(this.displayHandler.getDisplayComponent());
            }
            if (this.promote) {
                window.promote();
            }
        }
    }
}

