/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KeyMapsStorage {
    public static Object[] loadKeyMaps(String[] mimeTypes, String profile, String fileName) {
        FileObject defaultFo;
        if (profile.equals("NetBeans")) {
            profile = null;
        }
        if ((defaultFo = Utils.getFileObject(mimeTypes, profile, fileName)) == null) {
            return new Object[]{Collections.EMPTY_MAP, Collections.EMPTY_SET};
        }
        return KeyMapsStorage.loadKeyMaps(defaultFo);
    }

    public static Object[] loadKeyMaps(FileObject fo) {
        return (Object[])XMLStorage.load(fo, new KeyMapsReader());
    }

    public static void deleteProfile(String[] mimeTypes, String profile, String fileName) {
        Utils.deleteFileObject(mimeTypes, profile, fileName);
    }

    public static void saveKeyMaps(String[] mimeTypes, String profile, String fileName, Collection keyMap, Collection removed) {
        if (profile.equals("NetBeans")) {
            profile = null;
        }
        FileObject fo = Utils.createFileObject(mimeTypes, profile, fileName);
        KeyMapsStorage.saveKeyMaps(fo, keyMap, removed);
    }

    private static void saveKeyMaps(FileObject fo, Collection keyMap, Collection removed) {
        XMLStorage.Attribs attributes;
        StringBuffer sb = XMLStorage.generateHeader();
        XMLStorage.generateFolderStart(sb, "bindings", null, "");
        Iterator it = keyMap.iterator();
        while (it.hasNext()) {
            MultiKeyBinding mkb = (MultiKeyBinding)it.next();
            attributes = new XMLStorage.Attribs(true);
            attributes.add("actionName", mkb.getActionName());
            attributes.add("key", Utils.keyStrokesToString(mkb.getKeyStrokeList()));
            XMLStorage.generateLeaf(sb, "bind", attributes, "    ");
        }
        it = removed.iterator();
        while (it.hasNext()) {
            String shortcut = Utils.keyStrokesToString((List)it.next());
            attributes = new XMLStorage.Attribs(true);
            attributes.add("key", shortcut);
            attributes.add("remove", "true");
            XMLStorage.generateLeaf(sb, "bind", attributes, "    ");
        }
        XMLStorage.generateFolderEnd(sb, "bindings", "");
        XMLStorage.save(fo, new String(sb));
    }

    private static class KeyMapsReader
    extends XMLStorage.Handler {
        private Map keyMap = new HashMap();
        private Set removedShortcuts = new HashSet();

        private KeyMapsReader() {
        }

        Object getResult() {
            return new Object[]{this.keyMap, this.removedShortcuts};
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (!name.equals("bindings") && name.equals("bind")) {
                    String actionName = attributes.getValue("actionName");
                    String key = attributes.getValue("key");
                    KeyStroke[] shortcut = Utils.stringToKeyStrokes(key);
                    String remove = attributes.getValue("remove");
                    if (remove != null && remove.equals("true")) {
                        this.removedShortcuts.add(Arrays.asList(shortcut));
                        return;
                    }
                    MultiKeyBinding mkb = new MultiKeyBinding(shortcut, actionName);
                    this.keyMap.put(Arrays.asList(shortcut), mkb);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

