/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class SourceGroupSupport {
    private SourceGroupSupport() {
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set testGroups = SourceGroupSupport.getTestSourceGroups(sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    public static boolean isValidPackageName(String packageName) {
        if (packageName.length() > 0 && packageName.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(packageName, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFolderWritable(SourceGroup sourceGroup, String packageName) {
        try {
            FileObject fo = SourceGroupSupport.getFolderForPackage(sourceGroup, packageName, false);
            while (fo == null && packageName.lastIndexOf(46) != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf(46));
                fo = SourceGroupSupport.getFolderForPackage(sourceGroup, packageName, false);
            }
            return fo == null || fo.canWrite();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static SourceGroup getFolderSourceGroup(SourceGroup[] sourceGroups, FileObject folder) {
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroups[i].getRootFolder(), (FileObject)folder)) continue;
            return sourceGroups[i];
        }
        return null;
    }

    public static String getPackageForFolder(SourceGroup sourceGroup, FileObject folder) {
        String relative = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)folder);
        if (relative != null) {
            return relative.replace('/', '.');
        }
        return "";
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String pgkName) throws IOException {
        return SourceGroupSupport.getFolderForPackage(sourceGroup, pgkName, true);
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String pgkName, boolean create) throws IOException {
        String relativePkgName = pgkName.replace('.', '/');
        FileObject folder = sourceGroup.getRootFolder().getFileObject(relativePkgName);
        if (folder != null) {
            return folder;
        }
        if (create) {
            return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)relativePkgName);
        }
        return null;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        HashMap<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static Set getTestSourceGroups(SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = SourceGroupSupport.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet testGroups = new HashSet();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(SourceGroupSupport.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static List getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List sourceRoots = SourceGroupSupport.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = (FileObject)sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static List getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }
}

