/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public abstract class SystemAction
extends SharedClassObject
implements Action,
HelpCtx.Provider {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_ICON = "icon";
    private static final String PROP_ICON_TEXTUAL = "iconTextual";
    private static ImageIcon BLANK_ICON = null;
    private static final Set relativeIconResourceClasses = new HashSet(200);
    private static final long serialVersionUID = -8361232596876856810L;

    private static ImageIcon getBlankIcon() {
        if (BLANK_ICON == null) {
            BLANK_ICON = new ImageIcon(Utilities.loadImage("org/openide/resources/actions/empty.gif", true));
        }
        return BLANK_ICON;
    }

    public static SystemAction get(Class actionClass) {
        return (SystemAction)SystemAction.findObject(actionClass, true);
    }

    public abstract String getName();

    public abstract HelpCtx getHelpCtx();

    public boolean isEnabled() {
        return this.getProperty(PROP_ENABLED).equals(Boolean.TRUE);
    }

    public void setEnabled(boolean value) {
        this.putProperty(PROP_ENABLED, value ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public final void putValue(String name, Object value) {
        this.putProperty(name, value, true);
    }

    public final Object getValue(String name) {
        if ("iconBase".equals(name)) {
            return this.iconResource();
        }
        Object val = this.getProperty(name);
        if (val == null) {
            if ("Name".equals(name)) {
                val = this.getName();
            } else if ("SmallIcon".equals(name)) {
                val = this.getIcon();
            }
        }
        return val;
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected void initialize() {
        this.putProperty(PROP_ENABLED, Boolean.TRUE);
        super.initialize();
    }

    protected boolean clearSharedData() {
        return false;
    }

    public final void setIcon(Icon icon) {
        this.putProperty(PROP_ICON, icon, true);
        this.putProperty(PROP_ICON_TEXTUAL, icon);
    }

    public final Icon getIcon() {
        return this.getIcon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Icon getIcon(boolean createLabel) {
        Object object = this.getLock();
        synchronized (object) {
            Icon img = (Icon)this.getProperty(createLabel ? PROP_ICON_TEXTUAL : PROP_ICON);
            if (img == null) {
                String resName = this.iconResource();
                if (resName != null) {
                    if (resName.indexOf(47) == -1) {
                        String clazz = this.getClass().getName();
                        URL u = this.getClass().getResource(resName);
                        if (u == null) throw new IllegalStateException("No such icon from " + clazz + ": " + resName);
                        img = new ImageIcon(u);
                        if (relativeIconResourceClasses.add(clazz)) {
                            ErrorManager.getDefault().log(16, "Deprecated relative path in " + clazz + ".iconResource (cf. #20072)");
                        }
                    } else {
                        Image i = Utilities.loadImage(resName, true);
                        if (i != null) {
                            img = new ImageIcon(i);
                        } else {
                            URL u = this.getClass().getResource(resName);
                            String clazz = this.getClass().getName();
                            if (u == null) throw new IllegalStateException("No such icon from " + clazz + ": " + resName);
                            img = new ImageIcon(u);
                            if (relativeIconResourceClasses.add(clazz)) {
                                ErrorManager.getDefault().log(16, "Deprecated relative path in " + clazz + ".iconResource (cf. #26887)");
                            }
                        }
                    }
                    this.putProperty(PROP_ICON, img);
                    this.putProperty(PROP_ICON_TEXTUAL, img);
                } else if (createLabel) {
                    int ampr;
                    String text = this.getName();
                    if (text.endsWith("...")) {
                        text = text.substring(0, text.length() - 3);
                    }
                    if ((ampr = (text = text.trim()).indexOf(38)) != -1) {
                        text = new StringBuffer(text).deleteCharAt(ampr).toString();
                    }
                    img = new ComponentIcon(new JLabel(text));
                    this.putProperty(PROP_ICON_TEXTUAL, img);
                } else {
                    img = SystemAction.getBlankIcon();
                    this.putProperty(PROP_ICON, img);
                }
            }
            return img;
        }
    }

    protected String iconResource() {
        return null;
    }

    public static JToolBar createToolbarPresenter(SystemAction[] actions) {
        JToolBar p = new JToolBar();
        int k = actions.length;
        for (int i = 0; i < k; ++i) {
            if (actions[i] == null) {
                p.addSeparator();
                continue;
            }
            if (!(actions[i] instanceof Presenter.Toolbar)) continue;
            p.add(((Presenter.Toolbar)((Object)actions[i])).getToolbarPresenter());
        }
        return p;
    }

    public static SystemAction[] linkActions(SystemAction[] actions1, SystemAction[] actions2) {
        Vector<SystemAction> l = new Vector<SystemAction>(Arrays.asList(actions1));
        l.addAll(Arrays.asList(actions2));
        return l.toArray(actions1);
    }

    public static JPopupMenu createPopupMenu(SystemAction[] actions) {
        return Utilities.actionsToPopup((Action[])actions, Utilities.actionsGlobalContext());
    }

    private static class ComponentIcon
    extends ImageIcon {
        private JComponent comp;
        private BufferedImage image;

        public ComponentIcon(JComponent comp) {
            if (comp.getParent() != null) {
                throw new IllegalArgumentException();
            }
            this.comp = comp;
            Dimension size = comp.getPreferredSize();
            comp.setSize(Math.max(size.width, 16), Math.max(size.height, 16));
        }

        protected void loadImage(Image i) {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.comp.setBackground(c.getBackground());
            this.comp.setForeground(c.getForeground());
            Graphics clip = g.create(x, y, this.getIconWidth(), this.getIconHeight());
            this.comp.paint(clip);
        }

        public int getIconWidth() {
            return this.comp.getWidth();
        }

        public int getIconHeight() {
            return this.comp.getHeight();
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.comp.setForeground(Color.black);
                this.comp.paint(this.image.getGraphics());
            }
            return this.image;
        }
    }
}

