/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public final class PatchedHtmlRenderer {
    private static Stack colorStack = new Stack();
    public static final int STYLE_CLIP = 0;
    public static final int STYLE_TRUNCATE = 1;
    private static final int STYLE_WORDWRAP = 2;
    private static final boolean STRICT_HTML = Boolean.getBoolean("netbeans.lwhtml.strict");
    private static Set badStrings = null;
    private static final Object[] entities = new Object[]{new char[]{'g', 't'}, new char[]{'l', 't'}, new char[]{'q', 'u', 'o', 't'}, new char[]{'a', 'm', 'p'}, new char[]{'l', 's', 'q', 'u', 'o'}, new char[]{'r', 's', 'q', 'u', 'o'}, new char[]{'l', 'd', 'q', 'u', 'o'}, new char[]{'r', 'd', 'q', 'u', 'o'}, new char[]{'n', 'd', 'a', 's', 'h'}, new char[]{'m', 'd', 'a', 's', 'h'}, new char[]{'n', 'e'}, new char[]{'l', 'e'}, new char[]{'g', 'e'}, new char[]{'c', 'o', 'p', 'y'}, new char[]{'r', 'e', 'g'}, new char[]{'t', 'r', 'a', 'd', 'e'}, new char[]{'n', 'b', 's', 'p'}};
    private static final char[] entitySubstitutions = new char[]{'>', '<', '\"', '&', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u2260', '\u2264', '\u2265', '\u00a9', '\u00ae', '\u2122', ' '};
    private static final boolean IS_MAC = (Utilities.getOperatingSystem() & 0x1000) != 0;

    private PatchedHtmlRenderer() {
    }

    public static double renderPlainString(String s, Graphics g, int x, int y, int w, int h, Font f, Color defaultColor, int style, boolean paint) {
        if (style < 0 || style > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + style);
        }
        return PatchedHtmlRenderer._renderPlainString(s, g, x, y, w, h, f, defaultColor, style, paint);
    }

    private static double _renderPlainString(String s, Graphics g, int x, int y, int w, int h, Font f, Color foreground, int style, boolean paint) {
        if (f == null && (f = UIManager.getFont("controlFont")) == null) {
            int fs = 11;
            Object cfs = UIManager.get("customFontSize");
            if (cfs instanceof Integer) {
                fs = (Integer)cfs;
            }
            f = new Font("Dialog", 0, fs);
        }
        FontMetrics fm = g.getFontMetrics(f);
        Rectangle2D r = fm.getStringBounds(s, g);
        if (paint) {
            g.setColor(foreground);
            g.setFont(f);
            if (r.getWidth() <= (double)w || style == 0) {
                g.drawString(s, x, y);
            } else {
                char[] chars = s.toCharArray();
                if (chars.length == 0) {
                    return 0.0;
                }
                double chWidth = r.getWidth() / (double)chars.length;
                int estCharsOver = new Double((r.getWidth() - (double)w) / chWidth).intValue();
                if (style == 1) {
                    int length = chars.length - estCharsOver;
                    if (length <= 0) {
                        return 0.0;
                    }
                    if (paint) {
                        if (length > 3) {
                            Arrays.fill(chars, length - 3, length, '.');
                            g.drawChars(chars, 0, length, x, y);
                        } else {
                            Shape shape = g.getClip();
                            if (s != null) {
                                Area area = new Area(shape);
                                area.intersect(new Area(new Rectangle(x, y, w, h)));
                                g.setClip(area);
                            } else {
                                g.setClip(new Rectangle(x, y, w, h));
                            }
                            g.drawString("...", x, y);
                            g.setClip(shape);
                        }
                    }
                }
            }
        }
        return r.getWidth();
    }

    public static double renderString(String s, Graphics g, int x, int y, int w, int h, Font f, Color defaultColor, int style, boolean paint) {
        switch (style) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rendering mode: " + style);
            }
        }
        if (s.startsWith("<html") || s.startsWith("<HTML")) {
            return PatchedHtmlRenderer._renderHTML(s, 6, g, x, y, w, h, f, defaultColor, style, paint, null, false);
        }
        return PatchedHtmlRenderer.renderPlainString(s, g, x, y, w, h, f, defaultColor, style, paint);
    }

    public static double renderHTML(String s, Graphics g, int x, int y, int w, int h, Font f, Color defaultColor, int style, boolean paint, boolean disableColorChange) {
        if (style < 0 || style > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + style);
        }
        return PatchedHtmlRenderer._renderHTML(s, 0, g, x, y, w, h, f, defaultColor, style, paint, null, disableColorChange);
    }

    static double _renderHTML(String s, int pos, Graphics g, int x, int y, int w, int h, Font f, Color defaultColor, int style, boolean paint, Color background, boolean disableColorChange) {
        if (f == null && (f = UIManager.getFont("controlFont")) == null) {
            int fs = 11;
            Object cfs = UIManager.get("customFontSize");
            if (cfs instanceof Integer) {
                fs = (Integer)cfs;
            }
            f = new Font("Dialog", 0, fs);
        }
        Stack colorStack = SwingUtilities.isEventDispatchThread() ? PatchedHtmlRenderer.colorStack : new Stack();
        g.setColor(defaultColor);
        g.setFont(f);
        char[] chars = s.toCharArray();
        int origX = x;
        boolean done = false;
        boolean inTag = false;
        boolean inClosingTag = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean bold = false;
        boolean italic = false;
        boolean truncated = false;
        double widthPainted = 0.0;
        double heightPainted = 0.0;
        boolean lastWasWhitespace = false;
        double lastHeight = 0.0;
        double dotsWidth = 0.0;
        if (style == 1) {
            dotsWidth = g.getFontMetrics().stringWidth("...");
        }
        colorStack.clear();
        while (!done) {
            block88: {
                int tagEnd;
                block90: {
                    block89: {
                        boolean bl;
                        if (pos == s.length()) {
                            return widthPainted;
                        }
                        try {
                            bl = chars[pos] == '<';
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            ArrayIndexOutOfBoundsException aib = new ArrayIndexOutOfBoundsException("HTML rendering failed at position " + pos + " in String \"" + s + "\".  Please report this at http://www.netbeans.org");
                            if (STRICT_HTML) {
                                throw aib;
                            }
                            ErrorManager.getDefault().notify(16, (Throwable)aib);
                            return PatchedHtmlRenderer.renderPlainString(s, g, x, y, w, h, f, defaultColor, style, paint);
                        }
                        boolean bl2 = inClosingTag = (inTag |= bl) && pos + 1 < chars.length && chars[pos + 1] == '/';
                        if (truncated) {
                            g.setColor(defaultColor);
                            g.setFont(f);
                            if (paint) {
                                g.drawString("...", x, y);
                            }
                            done = true;
                            continue;
                        }
                        if (!inTag) break block88;
                        boolean bl3 = done = (tagEnd = ++pos) >= chars.length - 1;
                        while (!done && chars[tagEnd] != '>') {
                            done = tagEnd == chars.length - 1;
                            ++tagEnd;
                        }
                        if (done) {
                            throw new IllegalArgumentException("HTML rendering failed on string \"" + s + "\"");
                        }
                        if (!inClosingTag) break block89;
                        block1 : switch (chars[++pos]) {
                            case 'H': 
                            case 'P': 
                            case 'h': 
                            case 'p': {
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                if (chars[pos + 1] != 'r') {
                                    if (chars[pos + 1] == 'R') break;
                                    if (!bold) {
                                        PatchedHtmlRenderer.throwBadHTML("Closing bold tag w/o opening bold tag", pos, chars);
                                    }
                                    if (italic) {
                                        g.setFont(PatchedHtmlRenderer.deriveFont(f, 2));
                                    } else {
                                        g.setFont(PatchedHtmlRenderer.deriveFont(f, 0));
                                    }
                                    bold = false;
                                    break;
                                }
                                break block90;
                            }
                            case 'E': 
                            case 'I': 
                            case 'e': 
                            case 'i': {
                                if (bold) {
                                    g.setFont(PatchedHtmlRenderer.deriveFont(f, 1));
                                } else {
                                    g.setFont(PatchedHtmlRenderer.deriveFont(f, 0));
                                }
                                if (!italic) {
                                    PatchedHtmlRenderer.throwBadHTML("Closing italics tag w/oopening italics tag", pos, chars);
                                }
                                italic = false;
                                break;
                            }
                            case 'S': 
                            case 's': {
                                switch (chars[pos + 1]) {
                                    case 'T': 
                                    case 't': {
                                        if (italic) {
                                            g.setFont(PatchedHtmlRenderer.deriveFont(f, 2));
                                        } else {
                                            g.setFont(PatchedHtmlRenderer.deriveFont(f, 0));
                                        }
                                        bold = false;
                                        break block1;
                                    }
                                    case '>': {
                                        strikethrough = false;
                                    }
                                }
                                break;
                            }
                            case 'U': 
                            case 'u': {
                                underline = false;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                if (colorStack.isEmpty()) {
                                    g.setColor(defaultColor);
                                    break;
                                }
                                g.setColor((Color)colorStack.pop());
                                break;
                            }
                            default: {
                                PatchedHtmlRenderer.throwBadHTML("Malformed or unsupported HTML", pos, chars);
                                break;
                            }
                        }
                        break block90;
                    }
                    switch (chars[pos]) {
                        case 'B': 
                        case 'b': {
                            switch (chars[pos + 1]) {
                                case 'R': 
                                case 'r': {
                                    if (style != 2) break;
                                    x = origX;
                                    int lineHeight = g.getFontMetrics().getHeight();
                                    y += lineHeight;
                                    heightPainted += (double)lineHeight;
                                    widthPainted = 0.0;
                                    break;
                                }
                                case '>': {
                                    bold = true;
                                    if (italic) {
                                        g.setFont(PatchedHtmlRenderer.deriveFont(f, 3));
                                        break;
                                    }
                                    g.setFont(PatchedHtmlRenderer.deriveFont(f, 1));
                                }
                            }
                            break;
                        }
                        case 'E': 
                        case 'I': 
                        case 'e': 
                        case 'i': {
                            italic = true;
                            if (bold) {
                                g.setFont(PatchedHtmlRenderer.deriveFont(f, 3));
                                break;
                            }
                            g.setFont(PatchedHtmlRenderer.deriveFont(f, 2));
                            break;
                        }
                        case 'S': 
                        case 's': {
                            switch (chars[pos + 1]) {
                                case '>': {
                                    strikethrough = true;
                                    break;
                                }
                                case 'T': 
                                case 't': {
                                    bold = true;
                                    if (italic) {
                                        g.setFont(PatchedHtmlRenderer.deriveFont(f, 3));
                                        break;
                                    }
                                    g.setFont(PatchedHtmlRenderer.deriveFont(f, 1));
                                }
                            }
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            underline = true;
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            Color c = PatchedHtmlRenderer.findColor(chars, pos, tagEnd);
                            colorStack.push(g.getColor());
                            if (background != null) {
                                // empty if block
                            }
                            if (disableColorChange) break;
                            g.setColor(c);
                            break;
                        }
                        case 'P': 
                        case 'p': {
                            if (style != 2) break;
                            x = origX;
                            int lineHeight = g.getFontMetrics().getHeight();
                            heightPainted = (y += lineHeight + lineHeight / 2) + lineHeight;
                            widthPainted = 0.0;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            if (pos == 1) break;
                        }
                        default: {
                            PatchedHtmlRenderer.throwBadHTML("Malformed or unsupported HTML", pos, chars);
                        }
                    }
                }
                pos = tagEnd + (done ? 0 : 1);
                inTag = false;
                continue;
            }
            if (lastWasWhitespace) {
                while (pos < s.length() - 1 && Character.isWhitespace(chars[pos])) {
                    ++pos;
                }
                if (pos == chars.length - 1) {
                    return style != 2 ? widthPainted : heightPainted;
                }
            }
            boolean isAmp = false;
            boolean nextLtIsEntity = false;
            int nextTag = chars.length - 1;
            if (chars[pos] == '&') {
                boolean inEntity;
                boolean bl = inEntity = pos != chars.length - 1;
                if (inEntity) {
                    int newPos = PatchedHtmlRenderer.substEntity(chars, pos + 1);
                    boolean bl4 = inEntity = newPos != -1;
                    if (inEntity) {
                        pos = newPos;
                        isAmp = chars[pos] == '&';
                        nextLtIsEntity = chars[pos] == '<';
                    } else {
                        nextLtIsEntity = false;
                        isAmp = true;
                    }
                }
            } else {
                nextLtIsEntity = false;
            }
            for (int i = pos; i < chars.length; ++i) {
                if (chars[i] == '<' && !nextLtIsEntity || chars[i] == '&' && !isAmp) {
                    nextTag = i - 1;
                    break;
                }
                isAmp = false;
                nextLtIsEntity = false;
            }
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(chars, pos, nextTag + 1, g);
            lastHeight = r.getHeight();
            int length = nextTag + 1 - pos;
            boolean goToNextRow = false;
            boolean brutalWrap = false;
            double chWidth = r.getWidth() / (double)length;
            if (style == 1) {
                double newWidth = widthPainted + r.getWidth();
                if (newWidth > (double)w - dotsWidth && (newWidth > (double)w || PatchedHtmlRenderer._renderHTML(s, 0, g.create(), x, y, Integer.MAX_VALUE, h, f, defaultColor, 0, false, background, disableColorChange) > (double)w)) {
                    double pixelsOff = widthPainted + r.getWidth() - (double)w - dotsWidth;
                    double estCharsOver = pixelsOff / chWidth;
                    length = new Double(((double)w - dotsWidth - widthPainted) / chWidth).intValue();
                    if (length < 0) {
                        length = 0;
                    }
                    r = fm.getStringBounds(chars, pos, pos + length, g);
                    truncated = true;
                }
            } else if (style == 2 && widthPainted + r.getWidth() > (double)w && chWidth > 3.0) {
                double pixelsOff = widthPainted + (r.getWidth() + 5.0) - (double)w;
                double estCharsOver = pixelsOff / chWidth;
                goToNextRow = true;
                int lastChar = new Double((double)nextTag - estCharsOver).intValue();
                brutalWrap = x == 0;
                for (int i = lastChar; i > pos; --i) {
                    --lastChar;
                    if (!Character.isWhitespace(chars[i])) continue;
                    length = lastChar - pos + 1;
                    brutalWrap = false;
                    break;
                }
                if (lastChar <= pos && (double)length > estCharsOver && !brutalWrap) {
                    x = origX;
                    y = (int)((double)y + r.getHeight());
                    heightPainted += r.getHeight();
                    boolean boundsChanged = false;
                    while (!done && Character.isWhitespace(chars[pos]) && pos < nextTag) {
                        boundsChanged = true;
                        done = ++pos == chars.length - 1;
                    }
                    if (pos == nextTag) {
                        lastWasWhitespace = true;
                    }
                    if (boundsChanged) {
                        r = fm.getStringBounds(chars, pos, nextTag + 1, g);
                    }
                    goToNextRow = false;
                    widthPainted = 0.0;
                    if (chars[pos - 1 + length] == '<') {
                        --length;
                    }
                } else if (brutalWrap) {
                    length = new Double(((double)w - widthPainted) / chWidth).intValue();
                    if (pos + length > nextTag) {
                        length = nextTag - pos;
                    }
                    goToNextRow = true;
                }
            }
            if (done) continue;
            if (paint) {
                g.drawChars(chars, pos, length, x, y);
            }
            if (strikethrough || underline) {
                LineMetrics lm = fm.getLineMetrics(chars, pos, length - 1, g);
                int lineWidth = new Double((double)x + r.getWidth()).intValue();
                if (paint) {
                    if (strikethrough) {
                        int stPos = Math.round(lm.getStrikethroughOffset()) + g.getFont().getBaselineFor(chars[pos]) + 1;
                        g.drawLine(x, y + stPos, lineWidth, y + stPos);
                    }
                    if (underline) {
                        int stPos = Math.round(lm.getUnderlineOffset()) + g.getFont().getBaselineFor(chars[pos]) + 1;
                        g.drawLine(x, y + stPos, lineWidth, y + stPos);
                    }
                }
            }
            if (goToNextRow) {
                x = origX;
                y = (int)((double)y + r.getHeight());
                heightPainted += r.getHeight();
                widthPainted = 0.0;
                pos += length;
                while (pos < chars.length && Character.isWhitespace(chars[pos]) && chars[pos] != '<') {
                    ++pos;
                }
                lastWasWhitespace = true;
                done |= pos >= chars.length;
            } else {
                x = (int)((double)x + r.getWidth());
                widthPainted += r.getWidth();
                lastWasWhitespace = Character.isWhitespace(chars[nextTag]);
                pos = nextTag + 1;
            }
            done |= nextTag == chars.length;
        }
        if (style != 2) {
            return widthPainted;
        }
        return heightPainted + lastHeight;
    }

    private static Color findColor(char[] ch, int pos, int tagEnd) {
        String s;
        int colorPos = pos;
        boolean useUIManager = false;
        for (int i = pos; i < tagEnd; ++i) {
            if (ch[i] != 'c') continue;
            colorPos = i + 6;
            if (ch[colorPos] == '\'' || ch[colorPos] == '\"') {
                ++colorPos;
            }
            if (ch[colorPos] == '#') {
                ++colorPos;
                break;
            }
            if (ch[colorPos] != '!') break;
            useUIManager = true;
            ++colorPos;
            break;
        }
        if (colorPos == pos) {
            String out = "Could not find color identifier in font declaration";
            PatchedHtmlRenderer.throwBadHTML(out, pos, ch);
        }
        if (useUIManager) {
            int end = ch.length - 1;
            for (int i = colorPos; i < ch.length; ++i) {
                if (ch[i] != '\"' && ch[i] != '\'') continue;
                end = i;
                break;
            }
            s = new String(ch, colorPos, end - colorPos);
        } else {
            s = new String(ch, colorPos, 6);
        }
        Color result = null;
        if (useUIManager) {
            result = UIManager.getColor(s);
            if (result == null) {
                PatchedHtmlRenderer.throwBadHTML("Could not resolve logical font declared in HTML: " + s, pos, ch);
                result = UIManager.getColor("textText");
                if (result == null) {
                    result = Color.BLACK;
                }
            }
        } else {
            try {
                int rgb = Integer.parseInt(s, 16);
                result = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                PatchedHtmlRenderer.throwBadHTML("Illegal hexadecimal color text: " + s + " in HTML string", colorPos, ch);
            }
        }
        if (result == null) {
            PatchedHtmlRenderer.throwBadHTML("Unresolvable html color: " + s + " in HTML string \n  ", pos, ch);
        }
        return result;
    }

    private static final Font deriveFont(Font f, int style) {
        Font result = IS_MAC ? new Font(f.getName(), style, f.getSize()) : f.deriveFont(style);
        return result;
    }

    private static final int substEntity(char[] ch, int pos) {
        if (pos >= ch.length - 2) {
            return -1;
        }
        if (ch[pos] == '#') {
            return PatchedHtmlRenderer.substNumericEntity(ch, pos + 1);
        }
        for (int i = 0; i < entities.length; ++i) {
            char[] c = (char[])entities[i];
            boolean match = true;
            if (c.length < ch.length - pos) {
                for (int j = 0; j < c.length; ++j) {
                    match &= c[j] == ch[j + pos];
                }
            } else {
                match = false;
            }
            if (!match || ch[pos + c.length] != ';') continue;
            ch[pos + c.length] = entitySubstitutions[i];
            return pos + c.length;
        }
        return -1;
    }

    private static final int substNumericEntity(char[] ch, int pos) {
        for (int i = pos; i < ch.length; ++i) {
            if (ch[i] != ';') continue;
            try {
                ch[i] = (char)Integer.parseInt(new String(ch, pos, i - pos));
                return i;
            }
            catch (NumberFormatException nfe) {
                PatchedHtmlRenderer.throwBadHTML("Unparsable numeric entity: " + new String(ch, pos, i - pos), pos, ch);
            }
        }
        return -1;
    }

    private static void throwBadHTML(String msg, int pos, char[] chars) {
        char[] chh = new char[pos];
        Arrays.fill(chh, ' ');
        chh[pos - 1] = 94;
        String out = msg + "\n  " + new String(chars) + "\n  " + new String(chh) + "\n Full HTML string:" + new String(chars);
        if (!STRICT_HTML) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                if (badStrings == null) {
                    badStrings = new HashSet();
                }
                if (!badStrings.contains(msg)) {
                    StringTokenizer tk = new StringTokenizer(out, "\n", false);
                    while (tk.hasMoreTokens()) {
                        ErrorManager.getDefault().log(16, tk.nextToken());
                    }
                    badStrings.add(msg.intern());
                }
            }
        } else {
            throw new IllegalArgumentException(out);
        }
    }
}

