/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.XmiContext;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XmiElement {
    protected XmiContext context;
    protected XmiElement parent;

    public XmiElement(XmiElement parent, XmiContext context) {
        this.parent = parent;
        this.context = context;
    }

    public XmiElement(XmiContext context) {
        this.context = context;
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        return this;
    }

    public XmiElement endElement(String qName) {
        return this.parent;
    }

    public void characters(char[] buf, int offset, int len) {
    }

    public void receiveValue(Object value) {
        throw new DebugException("Unexpected call of receiveValue () method.");
    }

    public static class CollectionWrapper {
        private Collection coll;

        public CollectionWrapper(Collection coll) {
            this.coll = coll;
        }

        public Collection getCollection() {
            return this.coll;
        }
    }

    public static class ReferenceHandler
    implements ReferencesCounter {
        private RefObject obj;
        private Reference ref;
        private List values = new LinkedList();
        private int unresolvedRefsCounter = 0;
        private XmiContext context;

        public ReferenceHandler(Reference ref, RefObject obj, List args, XmiContext context) {
            this.obj = obj;
            this.ref = ref;
            this.context = context;
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (value instanceof UnresolvedReference) {
                    Object val = ((UnresolvedReference)value).getValue();
                    if (val != null) {
                        value = val;
                    } else {
                        ((UnresolvedReference)value).setOwner(this);
                    }
                }
                this.values.add(value);
            }
            if (this.unresolvedRefsCounter == 0) {
                this.setReference();
            }
        }

        public void increaseUnresolvedRefs() {
            ++this.unresolvedRefsCounter;
        }

        public void decreaseUnresolvedRefs() {
            --this.unresolvedRefsCounter;
            if (this.unresolvedRefsCounter == 0) {
                this.setReference();
            }
        }

        private void setReference() {
            RefPackage refPackage;
            AssociationEnd end = this.ref.getReferencedEnd();
            boolean isOrdered = end.getMultiplicity().isOrdered();
            Association association = (Association)end.getContainer();
            boolean isFirst = false;
            Iterator iter = association.getContents().iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof AssociationEnd)) continue;
                isFirst = me.equals(end);
                break;
            }
            if ((refPackage = (RefPackage)this.context.findProxy((ModelElement)association)) == null) {
                throw new DebugException("Proxy not found: " + association.getName());
            }
            RefAssociation refAssoc = refPackage.refAssociation((RefObject)association);
            if (refAssoc == null) {
                throw new DebugException("Proxy not found: " + association.getName());
            }
            iter = this.values.iterator();
            while (iter.hasNext()) {
                RefObject secondObj;
                Object value = iter.next();
                RefObject endValue = value instanceof UnresolvedReference ? (RefObject)((UnresolvedReference)value).getValue() : (RefObject)value;
                RefObject firstObj = isFirst ? endValue : this.obj;
                RefObject refObject = secondObj = isFirst ? this.obj : endValue;
                if (firstObj == null || secondObj == null) continue;
                if (!refAssoc.refLinkExists(firstObj, secondObj)) {
                    refAssoc.refAddLink(firstObj, secondObj);
                    continue;
                }
                if (!isOrdered) continue;
                refAssoc.refRemoveLink(firstObj, secondObj);
                refAssoc.refAddLink(firstObj, secondObj);
            }
        }
    }

    public static class UnresolvedReference {
        private Object value = null;
        private ReferencesCounter owner;

        public UnresolvedReference() {
        }

        public UnresolvedReference(ReferencesCounter owner) {
            this.owner = owner;
            owner.increaseUnresolvedRefs();
        }

        public void referenceResolved(Object value) {
            this.value = value;
            if (this.owner != null) {
                this.owner.decreaseUnresolvedRefs();
            }
        }

        public Object getValue() {
            return this.value;
        }

        public void setOwner(ReferencesCounter owner) {
            this.owner = owner;
            owner.increaseUnresolvedRefs();
        }
    }

    public static interface ReferencesCounter {
        public void increaseUnresolvedRefs();

        public void decreaseUnresolvedRefs();
    }

    public static class Dummy
    extends XmiElement {
        private int level = 0;

        public Dummy(XmiElement parent, XmiContext context, String qName) {
            super(parent, null);
            context.unknownElementFound(qName);
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            ++this.level;
            return this;
        }

        public XmiElement endElement(String qName) {
            if (this.level == 0) {
                return this.parent;
            }
            --this.level;
            return this;
        }
    }

    public static class ReferenceValue
    extends XmiElement {
        public ReferenceValue(XmiElement parent, XmiContext context, String xmiId) {
            super(parent, context);
            this.init(parent, xmiId);
        }

        public ReferenceValue(XmiContext context) {
            super(context);
        }

        public void init(XmiElement parent, String xmiId) {
            this.parent = parent;
            Object obj = this.context.getReference(xmiId);
            if (obj == null) {
                obj = new UnresolvedReference();
                this.context.registerUnresolvedRef(xmiId, (UnresolvedReference)obj);
            }
            parent.receiveValue(obj);
        }

        public void initExternal(XmiElement parent, String hRef) {
            String xmiId;
            this.parent = parent;
            XMIReferenceProvider.XMIReference ref = this.context.toXMIReference(hRef);
            String docId = ref.getSystemId();
            Object obj = this.context.getReference(docId, xmiId = ref.getXmiId());
            if (obj == null) {
                obj = new UnresolvedReference();
                this.context.registerUnresolvedExternalRef(docId, xmiId, (UnresolvedReference)obj);
            }
            parent.receiveValue(obj);
        }
    }

    public static class StructureValues
    extends XmiElement {
        private List values = new LinkedList();
        private StructureType type;
        private boolean oldFormat = false;

        public StructureValues(XmiElement parent, XmiContext context, StructureType type) {
            super(parent, context);
            this.type = type;
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (qName.equals("XMI.field")) {
                this.oldFormat = true;
            }
            StructureValue struct = new StructureValue(this, this.context, this.type, attrs, this.oldFormat);
            if (this.oldFormat) {
                return struct.startSubElement(qName, attrs);
            }
            return struct;
        }

        public void receiveValue(Object value) {
            this.values.add(value);
        }

        public XmiElement endElement(String qName) {
            this.parent.receiveValue(this.values);
            return this.parent;
        }
    }

    public static class ObjectValues
    extends XmiElement {
        private List values = new LinkedList();
        private ReferencesCounter target;
        private boolean isNull;

        public ObjectValues(XmiElement parent, XmiContext context, ReferencesCounter target, boolean isNull) {
            super(parent, context);
            this.target = target;
            this.isNull = isNull;
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            return this.context.resolveInstanceOrReference(this, qName, attrs);
        }

        public void receiveValue(Object value) {
            this.values.add(value);
            if (value instanceof UnresolvedReference && this.target != null) {
                ((UnresolvedReference)value).setOwner(this.target);
            }
        }

        public XmiElement endElement(String qName) {
            this.parent.receiveValue(this.isNull ? null : this.values);
            return this.parent;
        }
    }

    public static class CollectionValue
    extends XmiElement
    implements ReferencesCounter {
        private Classifier type;
        private List values = new LinkedList();
        private String collName;
        private int counter = 0;
        private boolean endReached = false;
        private UnresolvedReference unresRef = null;

        public CollectionValue(XmiElement parent, XmiContext context, CollectionType collType) {
            super(parent, context);
            this.type = collType.getType();
            this.collName = collType.getName();
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (this.type instanceof MofClass) {
                return this.context.resolveInstanceOrReference(this, qName, attrs);
            }
            if (this.type instanceof CollectionType) {
                return new CollectionValue(this, this.context, (CollectionType)this.type);
            }
            return this.context.resolveValue(this, this.type, attrs);
        }

        public void receiveValue(Object value) {
            if (value instanceof List) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof UnresolvedReference) {
                        ((UnresolvedReference)obj).setOwner(this);
                    }
                    this.values.add(obj);
                }
            } else {
                if (value instanceof UnresolvedReference) {
                    ((UnresolvedReference)value).setOwner(this);
                }
                this.values.add(value);
            }
        }

        public XmiElement endElement(String qName) {
            this.finishElement();
            return this.parent;
        }

        private void finishElement() {
            this.endReached = true;
            if (this.counter == 0) {
                CollectionWrapper val = this.createValue();
                if (!(this.parent instanceof Content)) {
                    this.parent.receiveValue(val);
                }
            } else if (!(this.parent instanceof Content)) {
                this.unresRef = new UnresolvedReference();
                this.parent.receiveValue(this.unresRef);
            }
        }

        public CollectionWrapper createValue() {
            LinkedList list = new LinkedList();
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof UnresolvedReference) {
                    obj = ((UnresolvedReference)obj).getValue();
                }
                if (obj instanceof CollectionWrapper) {
                    obj = ((CollectionWrapper)obj).getCollection();
                }
                list.add(obj);
            }
            return new CollectionWrapper(list);
        }

        public void increaseUnresolvedRefs() {
            ++this.counter;
        }

        public void decreaseUnresolvedRefs() {
            --this.counter;
            if (this.endReached && this.counter == 0) {
                CollectionWrapper value = this.createValue();
                if (this.unresRef != null) {
                    this.unresRef.referenceResolved(value);
                }
            }
        }
    }

    public static class CollectionValues
    extends XmiElement {
        private List values = new LinkedList();
        private CollectionType type;

        public CollectionValues(XmiElement parent, XmiContext context, CollectionType type) {
            super(parent, context);
            this.type = type;
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            return new CollectionValue(this, this.context, this.type);
        }

        public void receiveValue(Object value) {
            this.values.add(value);
        }

        public XmiElement endElement(String qName) {
            this.parent.receiveValue(this.values);
            return this.parent;
        }
    }

    public static class StructureValue
    extends XmiElement
    implements ReferencesCounter {
        private StructureType type;
        private List fields;
        private Iterator fieldsIterator;
        private StructureField currentField;
        private HashMap fieldsValues = new HashMap();
        private boolean oldFormat;
        private int counter = 0;
        private boolean endReached = false;
        private UnresolvedReference unresRef = null;

        public StructureValue(XmiElement parent, XmiContext context, StructureType type, Attributes attrs, boolean oldFormat) {
            super(parent, context);
            this.type = type;
            this.oldFormat = oldFormat;
            int attrsLength = attrs.getLength();
            this.fields = context.structureFields(type);
            if (oldFormat) {
                this.fieldsIterator = this.fields.iterator();
            } else {
                boolean isMultiplicityType = XmiContext.getQualifiedName((Classifier)type).equals("Model.MultiplicityType");
                for (int index = 0; index < attrsLength; ++index) {
                    String fieldName = attrs.getQName(index);
                    if (isMultiplicityType) {
                        if (fieldName.equals("is_ordered")) {
                            fieldName = "isOrdered";
                        } else if (fieldName.equals("is_unique")) {
                            fieldName = "isUnique";
                        }
                    }
                    String fieldValue = attrs.getValue(index);
                    this.resolveFieldValue(fieldName, fieldValue);
                }
            }
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (this.oldFormat) {
                if (!this.fieldsIterator.hasNext()) {
                    this.finishElement();
                    return this.parent.startSubElement(qName, attrs);
                }
                this.currentField = (StructureField)this.fieldsIterator.next();
            } else {
                this.currentField = (StructureField)this.context.resolveElementName(qName);
            }
            Classifier type = this.currentField.getType();
            return this.context.resolveValue(this, type, attrs);
        }

        public void receiveValue(Object value) {
            if (value instanceof List) {
                if (((List)value).size() != 1) {
                    throw new DebugException("Multi-valued structure field: " + this.currentField.getName());
                }
                value = ((List)value).get(0);
            }
            if (value instanceof UnresolvedReference) {
                ((UnresolvedReference)value).setOwner(this);
            }
            this.setFieldValue((TypedElement)this.currentField, value);
        }

        private void setFieldValue(TypedElement field, Object value) {
            if (this.fieldsValues.get(field) != null) {
                throw new DebugException("Multi-valued structure field: " + field.getName());
            }
            this.fieldsValues.put(field, value);
        }

        private void resolveFieldValue(String fieldName, String fieldValue) {
            StructureField field;
            try {
                field = (StructureField)this.type.lookupElement(fieldName);
            }
            catch (NameNotFoundException e) {
                throw new DebugException("Field name cannot be resolved: " + this.type.getName() + "." + fieldName);
            }
            Classifier type = field.getType();
            while (type instanceof AliasType) {
                type = ((AliasType)type).getType();
            }
            Object value = null;
            if (type instanceof PrimitiveType) {
                value = XmiContext.resolvePrimitiveValue((PrimitiveType)type, fieldValue);
            } else if (type instanceof EnumerationType) {
                value = this.context.resolveEnumerationValue((EnumerationType)type, fieldValue);
            } else if (type instanceof MofClass) {
                String xmiId = fieldValue.trim();
                Object obj = this.context.getReference(xmiId);
                if (obj == null) {
                    obj = new UnresolvedReference(this);
                    this.context.registerUnresolvedRef(xmiId, (UnresolvedReference)obj);
                    value = obj;
                }
            } else {
                throw new DebugException("Field cannot be resolved, invalid type: " + type.getName());
            }
            this.setFieldValue((TypedElement)field, value);
        }

        private RefStruct createInstance() {
            LinkedList args = new LinkedList();
            Iterator iter = this.fields.iterator();
            while (iter.hasNext()) {
                StructureField field = (StructureField)iter.next();
                Object param = this.fieldsValues.get(field);
                if (param instanceof UnresolvedReference) {
                    param = ((UnresolvedReference)param).getValue();
                }
                if (param instanceof CollectionWrapper) {
                    param = ((CollectionWrapper)param).getCollection();
                }
                if (param == null) {
                    param = XmiContext.defaultValue(field.getType());
                }
                args.add(param);
            }
            RefStruct struct = null;
            RefBaseObject proxy = this.context.findProxy((ModelElement)this.type);
            if (proxy == null) {
                throw new DebugException("Proxy not found: " + this.type.getName());
            }
            struct = proxy instanceof RefClass ? ((RefClass)proxy).refCreateStruct((RefObject)this.type, args) : ((RefPackage)proxy).refCreateStruct((RefObject)this.type, args);
            return struct;
        }

        private void finishElement() {
            this.endReached = true;
            if (this.counter == 0) {
                RefStruct instance = this.createInstance();
                if (!(this.parent instanceof Content)) {
                    this.parent.receiveValue(instance);
                }
            } else if (!(this.parent instanceof Content)) {
                this.unresRef = new UnresolvedReference();
                this.parent.receiveValue(this.unresRef);
            }
        }

        public XmiElement endElement(String qName) {
            if (this.oldFormat) {
                if (this.fieldsIterator.hasNext()) {
                    throw new DebugException("Structure value serialization not complete: " + this.type.getName());
                }
                this.finishElement();
                return this.parent.endElement(qName);
            }
            this.finishElement();
            return this.parent;
        }

        public void increaseUnresolvedRefs() {
            ++this.counter;
        }

        public void decreaseUnresolvedRefs() {
            --this.counter;
            if (this.endReached && this.counter == 0) {
                RefStruct instance = this.createInstance();
                if (this.unresRef != null) {
                    this.unresRef.referenceResolved(instance);
                }
            }
        }
    }

    public static class EnumerationValue
    extends XmiElement {
        public EnumerationValue(XmiElement parent, XmiContext context, EnumerationType type, Attributes attributes) {
            super(parent, context);
            this.init(parent, type, attributes);
        }

        public EnumerationValue(XmiContext context) {
            super(context);
        }

        public void init(XmiElement parent, EnumerationType type, Attributes attrs) {
            this.parent = parent;
            String enumValue = attrs.getValue("xmi.value");
            if (enumValue == null) {
                throw new DebugException("xmi.value attribute expected in Enum element");
            }
            parent.receiveValue(this.context.resolveEnumerationValue(type, enumValue));
        }
    }

    public static class PrimitiveValue
    extends XmiElement {
        private String xmiValue;
        private String valueAsText = "";
        private PrimitiveType type;
        private boolean xmiAnyValueEndExpected = false;
        private boolean stopCharsReading = false;

        public PrimitiveValue(XmiElement parent, XmiContext context, PrimitiveType type, Attributes attrs) {
            super(parent, context);
            this.type = type;
            this.xmiValue = attrs.getValue("xmi.value");
        }

        public PrimitiveValue(XmiContext context) {
            super(context);
        }

        public void init(XmiElement parent, PrimitiveType type, Attributes attrs) {
            this.parent = parent;
            this.type = type;
            this.xmiValue = attrs.getValue("xmi.value");
            this.valueAsText = "";
            this.xmiAnyValueEndExpected = false;
            this.stopCharsReading = false;
        }

        public void characters(char[] buf, int offset, int len) {
            if (!this.stopCharsReading) {
                this.valueAsText = this.valueAsText + new String(buf, offset, len);
            }
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (!qName.equals("XMI.any")) {
                throw new DebugException("Unexpected element: " + qName);
            }
            this.xmiAnyValueEndExpected = true;
            this.valueAsText = "";
            return this;
        }

        public XmiElement endElement(String qName) {
            if (this.xmiAnyValueEndExpected) {
                this.stopCharsReading = true;
                this.xmiAnyValueEndExpected = false;
                return this;
            }
            if (this.xmiValue != null) {
                this.valueAsText = this.xmiValue;
            }
            this.parent.receiveValue(XmiContext.resolvePrimitiveValue(this.type, this.valueAsText));
            return this.parent;
        }
    }

    public static class AssociationElement
    extends XmiElement
    implements ReferencesCounter {
        private Association assoc;
        private boolean oddNumberOfElementsRead = false;
        private int counter = 0;
        private boolean endReached = false;
        private List elements = new LinkedList();

        public AssociationElement(XmiElement parent, XmiContext context, Association assoc) {
            super(parent, context);
            this.assoc = assoc;
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            return this.context.resolveInstanceOrReference(this, qName, attrs);
        }

        public void receiveValue(Object obj) {
            if (obj instanceof UnresolvedReference) {
                ((UnresolvedReference)obj).setOwner(this);
            }
            this.elements.add(obj);
            this.oddNumberOfElementsRead = !this.oddNumberOfElementsRead;
        }

        public XmiElement endElement(String qName) {
            if (this.oddNumberOfElementsRead) {
                throw new DebugException("Odd number of association ends serialized: " + this.assoc.getName());
            }
            this.endReached = true;
            if (this.counter == 0) {
                this.createLinks();
            }
            return this.parent;
        }

        private void createLinks() {
            RefAssociation refAssoc = ((RefPackage)this.context.findProxy((ModelElement)this.assoc)).refAssociation((RefObject)this.assoc);
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Object firstObject = iter.next();
                Object secondObject = iter.next();
                if (firstObject instanceof UnresolvedReference) {
                    firstObject = ((UnresolvedReference)firstObject).getValue();
                }
                if (secondObject instanceof UnresolvedReference) {
                    secondObject = ((UnresolvedReference)secondObject).getValue();
                }
                if (refAssoc.refLinkExists((RefObject)firstObject, (RefObject)secondObject)) continue;
                refAssoc.refAddLink((RefObject)firstObject, (RefObject)secondObject);
            }
        }

        public void increaseUnresolvedRefs() {
            ++this.counter;
        }

        public void decreaseUnresolvedRefs() {
            --this.counter;
            if (this.endReached && this.counter == 0) {
                this.createLinks();
            }
        }
    }

    public static class ClassLevelAttribute
    extends XmiElement {
        private Classifier type;

        public ClassLevelAttribute(XmiElement parent, XmiContext context, Attribute attr, Attributes attrs) {
            super(parent, context);
            this.type = attr.getType();
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            return this.context.resolveValue(this, this.type, attrs);
        }

        public void receiveValue(Object value) {
            this.parent.receiveValue(value);
        }
    }

    public static class DataTypeElement
    extends XmiElement {
        private boolean typeCodeReading = false;
        private Node node = null;
        private String xmiId;
        private String docId;

        public DataTypeElement(XmiElement parent, XmiContext context, String name, Attributes attrs) {
            super(parent, context);
            this.xmiId = attrs.getValue(context.XMI_ID);
            this.docId = context.getCurrentDocId();
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (!this.typeCodeReading) {
                if (qName.endsWith("typeCode")) {
                    this.typeCodeReading = true;
                }
                return this;
            }
            if (this.node == null && !qName.equals("XMI.CorbaTypeCode")) {
                throw new DebugException("XMI.CorbaTypeCode element expected");
            }
            this.node = new Node(qName, attrs, this.node);
            return this;
        }

        public XmiElement endElement(String qName) {
            if (this.typeCodeReading) {
                if (this.node.parent != null) {
                    this.node = this.node.parent;
                } else {
                    this.typeCodeReading = false;
                }
                return this;
            }
            if (!qName.endsWith("DataType")) {
                return this;
            }
            Classifier typeEquivalent = this.context.resolveCorbaType(this.node, false);
            if (this.xmiId != null) {
                this.context.putReference(this.docId, this.xmiId, (RefObject)typeEquivalent);
            }
            if (!(this.parent instanceof Content)) {
                this.parent.receiveValue(typeEquivalent);
            }
            return this.parent;
        }

        public static class Node {
            public Node parent;
            public List subnodes = new LinkedList();
            public String name;
            public String tcName;

            public Node(String name, Attributes attrs, Node parent) {
                this.parent = parent;
                this.name = name;
                this.tcName = attrs.getValue("xmi.tcName");
                if (parent != null) {
                    parent.addSubNode(this);
                }
            }

            public void addSubNode(Node subNode) {
                this.subnodes.add(subNode);
            }

            public Node firstSubNode() {
                return (Node)this.subnodes.get(0);
            }
        }
    }

    public static class Instance
    extends XmiElement
    implements ReferencesCounter {
        private String name;
        private String xmiId = null;
        private String docId;
        private int unresolvedRefsCounter = 0;
        private boolean endReached = false;
        private UnresolvedReference unresRef = null;
        private StructuralFeature currentFeature;
        private Classifier currentType;
        private RefClass refClass;
        private MofClass metaClass;
        private HashMap attributesValues = new HashMap();
        private HashMap referencesValues = new HashMap();

        public Instance(XmiElement parent, XmiContext context, String qName, RefClass refClass, Attributes attrs) {
            super(parent, context);
            this.name = qName;
            this.docId = context.getCurrentDocId();
            this.refClass = refClass;
            this.metaClass = (MofClass)refClass.refMetaObject();
            int attrsLength = attrs.getLength();
            for (int index = 0; index < attrsLength; ++index) {
                String attrName = attrs.getQName(index);
                String attrValue = attrs.getValue(index);
                if (attrName.equals(context.XMI_ID)) {
                    this.xmiId = attrValue;
                    continue;
                }
                this.resolveAttributeValue(attrName, attrValue);
            }
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            Object ref = this.context.resolveElementName(qName);
            if (ref == null && this.context.ignoreUnknownElements()) {
                return new Dummy(this, this.context, qName);
            }
            if (!(ref instanceof StructuralFeature)) {
                throw new DebugException("Invalid sub-element: " + qName);
            }
            this.currentFeature = (StructuralFeature)ref;
            if (this.currentFeature.getScope().equals(ScopeKindEnum.CLASSIFIER_LEVEL) && !this.context.isXmi20) {
                throw new DebugException("An instance serialization contains value of static attribute: " + this.currentFeature.getName());
            }
            if (this.currentFeature instanceof Attribute) {
                Classifier type = this.currentFeature.getType();
                return this.context.resolveValue(this, type, attrs);
            }
            if (this.currentFeature instanceof Reference) {
                return new ObjectValues(this, this.context, null, false);
            }
            throw new DebugException("Invalid sub-element: " + qName);
        }

        private RefObject createInstance() {
            RefObject instance;
            List attributes = this.context.instanceAttributes(this.refClass);
            List references = this.context.instanceReferences(this.refClass);
            LinkedList args = new LinkedList();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                Object param = this.attributesValues.get(attr);
                if (param instanceof UnresolvedReference) {
                    param = ((UnresolvedReference)param).getValue();
                } else if (param instanceof List) {
                    Iterator iter2 = ((List)param).iterator();
                    LinkedList temp = new LinkedList();
                    while (iter2.hasNext()) {
                        Object value = iter2.next();
                        if (value instanceof UnresolvedReference && (value = ((UnresolvedReference)value).getValue()) instanceof CollectionWrapper) {
                            value = ((CollectionWrapper)value).getCollection();
                        }
                        temp.add(value);
                    }
                    param = temp;
                }
                if (param instanceof CollectionWrapper) {
                    param = ((CollectionWrapper)param).getCollection();
                }
                if (param == null) {
                    param = XmiContext.defaultValue(attr);
                }
                args.add(param);
            }
            try {
                instance = this.refClass.refCreateInstance(args);
            }
            catch (Exception e) {
                StringBuffer params = new StringBuffer(50);
                Iterator it = args.iterator();
                while (it.hasNext()) {
                    Object arg = it.next();
                    params.append("    ");
                    if (arg == null) {
                        params.append("<null>");
                    } else {
                        params.append("(" + arg.getClass() + ") " + arg.toString());
                    }
                    params.append("\n");
                }
                String msg = "Instance of " + this.name + " cannot be created, parameters:\n" + params.toString() + "\n    reason: " + e.toString();
                Logger.getDefault().log(msg);
                return null;
            }
            if (this.parent instanceof Content) {
                this.context.addOutermostObject(instance);
            }
            if (this.xmiId != null) {
                this.context.putReference(this.docId, this.xmiId, instance);
            }
            iter = references.iterator();
            while (iter.hasNext()) {
                Reference ref = (Reference)iter.next();
                List values = (List)this.referencesValues.get(ref);
                if (values == null) continue;
                new ReferenceHandler(ref, instance, values, this.context);
            }
            this.context.countInstance();
            if (this.context.isXmi20) {
                iter = this.context.staticAttributes(this.refClass).iterator();
                while (iter.hasNext()) {
                    Attribute attr = (Attribute)iter.next();
                    Object value = this.attributesValues.get(attr);
                    if (value == null) continue;
                    this.refClass.refSetValue((RefObject)attr, value);
                }
            }
            return instance;
        }

        public XmiElement endElement(String qName) {
            this.endReached = true;
            if (this.unresolvedRefsCounter == 0) {
                RefObject instance = this.createInstance();
                if (!(this.parent instanceof Content)) {
                    this.parent.receiveValue(instance);
                }
            } else if (!(this.parent instanceof Content)) {
                this.unresRef = new UnresolvedReference();
                this.parent.receiveValue(this.unresRef);
            }
            return this.parent;
        }

        private void setAttributeValue(StructuralFeature attr, Object value) {
            boolean isMultivalued = XmiContext.isMultivalued(attr);
            Object tempValue = this.attributesValues.get(attr);
            if (!isMultivalued) {
                if (tempValue != null) {
                    throw new DebugException("Cannot set a multi-value to a non-multivalued attribute:" + attr.getName());
                }
                this.attributesValues.put(attr, value);
            } else {
                if (tempValue == null) {
                    tempValue = new LinkedList();
                    this.attributesValues.put(attr, tempValue);
                }
                ((List)tempValue).add(value);
            }
        }

        private void setAttributeValues(StructuralFeature attr, List values) {
            boolean isMultivalued = XmiContext.isMultivalued(attr);
            if (!isMultivalued && values.size() == 1) {
                this.setAttributeValue(attr, values.get(0));
                return;
            }
            if (!isMultivalued) {
                throw new DebugException("Cannot set a multi-value to a non-multivalued attribute:" + attr.getName());
            }
            Object tempValue = this.attributesValues.get(attr);
            if (tempValue == null) {
                tempValue = new LinkedList();
                this.attributesValues.put(attr, tempValue);
            }
            ((List)tempValue).addAll(values);
        }

        private void setReferenceValues(Reference ref, List values) {
            boolean isMultivalued = XmiContext.isMultivalued((StructuralFeature)ref);
            Object tempValue = this.referencesValues.get(ref);
            if (!isMultivalued) {
                if (tempValue != null || values.size() > 1) {
                    throw new DebugException("Cannot set a multi-value to a non-multivalued reference:" + ref.getName());
                }
                this.referencesValues.put(ref, values);
                return;
            }
            if (tempValue == null) {
                tempValue = new LinkedList();
                this.referencesValues.put(ref, tempValue);
            }
            ((List)tempValue).addAll(values);
        }

        public void receiveValue(Object value) {
            if (this.currentFeature instanceof Attribute) {
                if (value instanceof List) {
                    this.setAttributeValues(this.currentFeature, value);
                } else {
                    this.setAttributeValue(this.currentFeature, value);
                }
            } else {
                if (!(value instanceof List)) {
                    LinkedList temp = new LinkedList();
                    temp.add(value);
                    value = temp;
                }
                this.setReferenceValues((Reference)this.currentFeature, value);
            }
        }

        private void resolveAttributeValue(String attrName, String attrValue) {
            StructuralFeature attr = this.context.instanceElementByName(this.refClass, attrName);
            if (attr == null && this.context.isXmi20) {
                attr = this.context.staticAttributeByName(this.refClass, attrName);
            }
            if (attr == null) {
                return;
            }
            Classifier type = attr.getType();
            while (type instanceof AliasType) {
                type = ((AliasType)type).getType();
            }
            Object value = null;
            if (type instanceof PrimitiveType) {
                value = XmiContext.resolvePrimitiveValue((PrimitiveType)type, attrValue);
                this.setAttributeValue(attr, value);
            } else if (type instanceof EnumerationType) {
                value = this.context.resolveEnumerationValue((EnumerationType)type, attrValue);
                this.setAttributeValue(attr, value);
            } else if (type instanceof MofClass) {
                boolean isReference = attr instanceof Reference;
                StringTokenizer tokenizer = new StringTokenizer(attrValue, " ");
                LinkedList<RefObject> list = new LinkedList<RefObject>();
                while (tokenizer.hasMoreTokens()) {
                    String xmiId = tokenizer.nextToken();
                    Object obj = this.context.getReference(xmiId);
                    if (obj == null) {
                        obj = isReference ? new UnresolvedReference() : new UnresolvedReference(this);
                        this.context.registerUnresolvedRef(xmiId, (UnresolvedReference)obj);
                    }
                    list.add((RefObject)obj);
                }
                if (isReference) {
                    this.setReferenceValues((Reference)attr, list);
                } else {
                    this.setAttributeValues(attr, list);
                }
            } else {
                throw new DebugException("type cannot be resolved: " + attr.getType().getName());
            }
        }

        public void increaseUnresolvedRefs() {
            ++this.unresolvedRefsCounter;
        }

        public void decreaseUnresolvedRefs() {
            --this.unresolvedRefsCounter;
            if (this.endReached && this.unresolvedRefsCounter == 0) {
                RefObject instance = this.createInstance();
                if (this.unresRef != null) {
                    this.unresRef.referenceResolved(instance);
                }
            }
        }
    }

    public static class Content
    extends XmiElement {
        private Attribute attr = null;
        private RefClass refClass = null;
        private List values;

        public Content(XmiElement parent, XmiContext context) {
            super(parent, context);
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            Object ref = this.context.resolveElementName(qName);
            if (ref == null && this.context.ignoreUnknownElements()) {
                return new Dummy(this, this.context, qName);
            }
            if (ref instanceof RefClass) {
                return this.context.resolveInstanceOrReference(this, qName, attrs);
            }
            if (ref instanceof Attribute) {
                RefClass readRefClass = (RefClass)this.context.resolveElementName(qName.substring(0, qName.lastIndexOf(".")));
                if (ref != this.attr || this.refClass != readRefClass) {
                    if (this.attr != null) {
                        this.setAttributeValue();
                    }
                    this.attr = (Attribute)ref;
                    this.refClass = readRefClass;
                    this.values = new LinkedList();
                }
                return new ClassLevelAttribute(this, this.context, this.attr, attrs);
            }
            if (ref instanceof Association) {
                return new AssociationElement(this, this.context, (Association)ref);
            }
            throw new DebugException("Unexpected element: " + qName);
        }

        public XmiElement endElement(String qName) {
            if (this.attr != null) {
                this.setAttributeValue();
            }
            this.context.resolveExternalReferences();
            if (this.context.isMain && !this.context.allReferencesResolved()) {
                String badRef = this.context.getUnresolvedRefId();
                Logger.getDefault().log("Unknown reference or circularity in instance dependences detected, bad reference: " + badRef);
            }
            return this.parent;
        }

        public void receiveValue(Object value) {
            if (this.attr == null) {
                throw new DebugException("Unexpected call of Content.receiveValue ()");
            }
            if (value instanceof List) {
                this.values.addAll((List)value);
            } else {
                this.values.add(value);
            }
        }

        private void setAttributeValue() {
            Object value;
            LinkedList list = new LinkedList();
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                value = iter.next();
                if (value instanceof UnresolvedReference && (value = ((UnresolvedReference)value).getValue()) == null) {
                    throw new DebugException("Class-scoped attribute value not resolved: " + this.attr.getName());
                }
                list.add(value);
            }
            if (XmiContext.isMultivalued((StructuralFeature)this.attr)) {
                value = list;
            } else {
                if (list.size() != 1) {
                    throw new DebugException("Cannot set a multi-value to a non-multivalued attribute:" + this.attr.getName());
                }
                value = list.get(0);
            }
            this.refClass.refSetValue((RefObject)this.attr, value);
            this.attr = null;
            this.refClass = null;
            this.values = null;
        }
    }

    public static class Difference
    extends XmiElement {
        private String href;
        private boolean diffReading;
        private Diff currentDiff;
        private HashMap diffs = new HashMap();
        private int timeStamp = 1;

        public Difference(XmiElement parent, XmiContext context, Attributes attrs) {
            super(parent, context);
            this.href = attrs.getValue(context.XMI_HREF);
            if (this.href == null) {
                throw new DebugException("Differences referring to the document they are placed in are not supported.");
            }
            this.diffReading = false;
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (!this.diffReading) {
                if (qName.equals("XMI.difference")) {
                    throw new DebugException("Nested differences are not supported.");
                }
                int kind = 0;
                if (qName.equals("XMI.delete")) {
                    kind = 1;
                } else if (qName.equals("XMI.replace")) {
                    kind = 2;
                }
                String localHref = attrs.getValue(this.context.XMI_HREF);
                int index = localHref.lastIndexOf("|");
                if (index == -1) {
                    index = localHref.lastIndexOf("#");
                }
                String id = localHref.substring(index + 1, localHref.length());
                String posString = attrs.getValue("xmi.position");
                int position = 1;
                if (posString != null) {
                    try {
                        position = Integer.parseInt(posString);
                    }
                    catch (NumberFormatException e) {
                        throw new DebugException("Differences - bad number format: " + posString);
                    }
                }
                if (position < 0) {
                    throw new DebugException("Negative values of xmi.position parameters are not supported: " + posString);
                }
                this.currentDiff = new Diff(kind, id, position, this.timeStamp);
                ++this.timeStamp;
                this.diffReading = true;
            } else {
                this.currentDiff.items.add(new Item(qName, attrs));
            }
            return this;
        }

        public void characters(char[] buf, int offset, int len) {
            if (this.diffReading) {
                this.currentDiff.items.add(new String(buf, offset, len));
            }
        }

        public XmiElement endElement(String qName) {
            if (this.diffReading) {
                if (qName.equals("XMI.add") || qName.equals("XMI.delete") || qName.equals("XMI.replace")) {
                    this.diffReading = false;
                    LinkedList<Diff> list = (LinkedList<Diff>)this.diffs.get(this.currentDiff.xmiId);
                    if (list == null) {
                        list = new LinkedList<Diff>();
                        this.diffs.put(this.currentDiff.xmiId, list);
                    }
                    if (this.currentDiff.kind == 1) {
                        list.addFirst(this.currentDiff);
                    } else {
                        list.addLast(this.currentDiff);
                    }
                } else {
                    this.currentDiff.items.add(new Item(qName));
                }
                return this;
            }
            this.context.resolveDifferences(this.href, this.diffs);
            return this.parent;
        }

        public static class Item {
            public boolean isStart;
            public String qName;
            public Attributes attrs;

            public Item(String qName) {
                this.qName = qName;
                this.isStart = false;
            }

            public Item(String qName, Attributes attrs) {
                this.qName = qName;
                this.attrs = new AttributesImpl(attrs);
                this.isStart = true;
            }
        }

        public static class Diff {
            public static final int ADD = 0;
            public static final int DELETE = 1;
            public static final int REPLACE = 2;
            public int kind;
            public int position;
            public String xmiId;
            public LinkedList items = new LinkedList();
            public int timeStamp;

            public Diff(int kind, String xmiId, int position, int timeStamp) {
                this.kind = kind;
                this.xmiId = xmiId;
                this.position = position;
                this.timeStamp = timeStamp;
            }
        }
    }

    public static class Header
    extends XmiElement {
        private int level = 0;
        private StringBuffer buffer = new StringBuffer();

        public Header(XmiElement parent, XmiContext context) {
            super(parent, context);
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            ++this.level;
            this.buffer.append('<' + qName);
            int attrsLength = attrs.getLength();
            for (int index = 0; index < attrsLength; ++index) {
                String attrName = attrs.getQName(index);
                String attrValue = attrs.getValue(index);
                this.buffer.append(" " + attrName + " = '" + attrValue + "'");
            }
            this.buffer.append('>');
            return this;
        }

        public XmiElement endElement(String qName) {
            if (this.level == 0) {
                this.context.receiveHeader(this.buffer.toString());
                return this.parent;
            }
            this.buffer.append("</" + qName + '>');
            --this.level;
            return this;
        }

        public void characters(char[] buf, int offset, int len) {
            this.buffer.append(buf, offset, len);
        }
    }

    public static class Document
    extends XmiElement {
        private String rootElementName;
        private Content content = null;
        private XmiElement xmiElement = null;

        public Document(XmiElement parent, XmiContext context, String rootName, Attributes attrs) {
            super(parent, context);
            this.rootElementName = rootName;
            context.setVersion(attrs);
            if (context.isXmi20) {
                this.content = new Content(this, context);
                if (!this.rootElementName.equals(context.xmiNsPrefix + "XMI")) {
                    AttributesImpl attrs2 = new AttributesImpl();
                    for (int x = 0; x < attrs.getLength(); ++x) {
                        String name = attrs.getQName(x);
                        if (name.equals("xmlns") || name.startsWith("xmlns:") || name.equals(context.xmiNsPrefix + "version")) continue;
                        attrs2.addAttribute(null, null, name, null, attrs.getValue(x));
                    }
                    this.xmiElement = this.content.startSubElement(this.rootElementName, attrs2);
                }
            }
        }

        public XmiElement startSubElement(String qName, Attributes attrs) {
            if (this.context.isXmi20) {
                if (this.xmiElement != null) {
                    return this.xmiElement.startSubElement(qName, attrs);
                }
                return this.content.startSubElement(qName, attrs);
            }
            if (qName.equals("XMI.content")) {
                return new Content(this, this.context);
            }
            if (qName.equals("XMI.difference")) {
                return new Difference(this, this.context, attrs);
            }
            if (qName.equals("XMI.header")) {
                return new Header(this, this.context);
            }
            if (this.context.ignoreUnknownElements()) {
                return new Dummy(this, this.context, qName);
            }
            throw new DebugException("Invalid element name: " + qName);
        }

        public XmiElement endElement(String qName) {
            if (qName.equals(this.rootElementName)) {
                if (this.context.isXmi20) {
                    if (this.xmiElement != null) {
                        this.xmiElement.endElement(qName);
                    }
                    this.content.endElement(qName);
                }
                this.context.finish();
                return this.parent;
            }
            return this;
        }
    }
}

