/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.Debugger;

public class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final Object[] emptyArgs;
    private static final int CONTEXT_CREATED_EVENT = 1;
    private static final int CONTEXT_ENTER_EVENT = 2;
    private static final int CONTEXT_EXIT_EVENT = 3;
    private static final int CONTEXT_RELEASED_EVENT = 4;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    private static Class codegenClass;
    static final boolean check = true;
    private static Hashtable threadContexts;
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    private static Method method_getContextClassLoader;
    private static final Object staticListenersLock;
    private static volatile Object staticListeners;
    private static boolean disabledContextListening;
    private boolean sealed;
    private Object sealKey;
    NativeCall currentActivation;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    private SecurityController securityController;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    int optimizationLevel;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object propertyListeners;
    private Hashtable hashtable;
    private ClassLoader applicationClassLoader;
    private boolean creationEventWasSent;
    Hashtable activationNames;
    int interpreterLineIndex;
    InterpreterData interpreterData;
    int instructionCount;
    int instructionThreshold;

    public Context() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context[] storage = Context.getThreadContextStorage();
        Context old = storage != null ? storage[0] : Context.getCurrentContext_jdk11();
        if (old != null) {
            if (cx != null && cx != old && cx.enterCount != 0) {
                throw new IllegalArgumentException("Cannot enter Context active on another thread");
            }
            if (old.sealed) {
                Context.onSealedMutation();
            }
            cx = old;
        } else {
            if (cx == null) {
                cx = new Context();
            } else if (cx.sealed) {
                Context.onSealedMutation();
            }
            if (cx.enterCount != 0) {
                Kit.codeBug();
            }
            if (!cx.creationEventWasSent) {
                cx.creationEventWasSent = true;
                cx.runListeners(1);
            }
        }
        cx.runListeners(2);
        if (old == null) {
            if (storage != null) {
                storage[0] = cx;
            } else {
                Context.setThreadContext_jdk11(cx);
            }
        }
        ++cx.enterCount;
        return cx;
    }

    public static void exit() {
        Context[] storage = Context.getThreadContextStorage();
        Context cx = storage != null ? storage[0] : Context.getCurrentContext_jdk11();
        if (cx == null) {
            throw new IllegalStateException("Calling Context.exit without previous Context.enter");
        }
        if (cx.enterCount < 1) {
            Kit.codeBug();
        }
        if (cx.sealed) {
            Context.onSealedMutation();
        }
        --cx.enterCount;
        if (cx.enterCount == 0) {
            if (storage != null) {
                storage[0] = null;
            } else {
                Context.setThreadContext_jdk11(null);
            }
        }
        cx.runListeners(3);
        if (cx.enterCount == 0) {
            cx.runListeners(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(Callable callable, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Context[] storage = Context.getThreadContextStorage();
        Context cx = storage != null ? storage[0] : Context.getCurrentContext_jdk11();
        if (cx != null) {
            return callable.call(cx, scope, thisObj, args);
        }
        cx = new Context();
        if (!cx.creationEventWasSent) {
            cx.creationEventWasSent = true;
            cx.runListeners(1);
        }
        cx.runListeners(2);
        if (storage != null) {
            storage[0] = cx;
        } else {
            Context.setThreadContext_jdk11(cx);
        }
        ++cx.enterCount;
        try {
            Object object = callable.call(cx, scope, thisObj, args);
            return object;
        }
        finally {
            --cx.enterCount;
            if (cx.enterCount == 0) {
                if (storage != null) {
                    storage[0] = null;
                } else {
                    Context.setThreadContext_jdk11(null);
                }
            }
            cx.runListeners(3);
            if (cx.enterCount == 0) {
                cx.runListeners(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContextListener(ContextListener listener) {
        boolean disabled;
        Object object = staticListenersLock;
        synchronized (object) {
            disabled = disabledContextListening;
            if (!disabled) {
                staticListeners = Kit.addListener(staticListeners, listener);
            }
        }
        if (disabled) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextListener(ContextListener listener) {
        Object object = staticListenersLock;
        synchronized (object) {
            staticListeners = Kit.removeListener(staticListeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableStaticContextListening() {
        Object object = staticListenersLock;
        synchronized (object) {
            disabledContextListening = true;
            staticListeners = null;
        }
    }

    private void runListeners(int reason) {
        ContextListener l;
        Object listeners = staticListeners;
        int i = 0;
        while ((l = (ContextListener)Kit.getListener(listeners, i)) != null) {
            switch (reason) {
                case 1: {
                    l.contextCreated(this);
                    break;
                }
                case 2: {
                    l.contextEntered(this);
                    break;
                }
                case 3: {
                    l.contextExited(this);
                    break;
                }
                case 4: {
                    l.contextReleased(this);
                    break;
                }
                default: {
                    Kit.codeBug();
                }
            }
            ++i;
        }
    }

    public static Context getCurrentContext() {
        Context[] storage = Context.getThreadContextStorage();
        if (storage != null) {
            return storage[0];
        }
        return Context.getCurrentContext_jdk11();
    }

    private static Context[] getThreadContextStorage() {
        if (threadLocalCx != null) {
            try {
                Context[] storage = (Context[])threadLocalGet.invoke(threadLocalCx, null);
                if (storage == null) {
                    storage = new Context[1];
                    threadLocalSet.invoke(threadLocalCx, new Object[]{storage});
                }
                return storage;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Context getCurrentContext_jdk11() {
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    private static void setThreadContext_jdk11(Context cx) {
        Thread t = Thread.currentThread();
        if (cx != null) {
            threadContexts.put(t, cx);
        } else {
            threadContexts.remove(t);
        }
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal(Object sealKey) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = sealKey;
    }

    public final void unseal(Object sealKey) {
        if (sealKey == null) {
            throw new IllegalArgumentException();
        }
        if (this.sealKey != sealKey) {
            throw new IllegalArgumentException();
        }
        if (!this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = false;
        this.sealKey = null;
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(version);
        Object listeners = this.propertyListeners;
        if (listeners != null && version != this.version) {
            this.firePropertyChangeImpl(listeners, languageVersionProperty, new Integer(this.version), new Integer(version));
        }
        this.version = version;
    }

    static void checkLanguageVersion(int version) {
        switch (version) {
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: {
                return;
            }
        }
        throw new IllegalArgumentException("Bad language version: " + version);
    }

    public final String getImplementationVersion() {
        return "Rhino 1.5 release 5 2004 03 25";
    }

    public final ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            return DefaultErrorReporter.instance;
        }
        return this.errorReporter;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter reporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (reporter == null) {
            throw new IllegalArgumentException();
        }
        ErrorReporter old = this.getErrorReporter();
        if (reporter == old) {
            return old;
        }
        Object listeners = this.propertyListeners;
        if (listeners != null) {
            this.firePropertyChangeImpl(listeners, errorReporterProperty, old, reporter);
        }
        this.errorReporter = reporter;
        return old;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final Locale setLocale(Locale loc) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale result = this.locale;
        this.locale = loc;
        return result;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, l);
    }

    final void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object listeners = this.propertyListeners;
        if (listeners != null) {
            this.firePropertyChangeImpl(listeners, property, oldValue, newValue);
        }
    }

    private void firePropertyChangeImpl(Object listeners, String property, Object oldValue, Object newValue) {
        Object l;
        int i = 0;
        while ((l = Kit.getListener(listeners, i)) != null) {
            if (l instanceof PropertyChangeListener) {
                PropertyChangeListener pcl = (PropertyChangeListener)l;
                pcl.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
            }
            ++i;
        }
    }

    public static void reportWarning(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportWarning(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportWarning(message, filename, linep[0], null, 0);
    }

    public static void reportError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new EvaluatorException(message, sourceName, lineno, lineSource, lineOffset);
        }
        cx.getErrorReporter().error(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        Context.reportError(message, filename, linep[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return cx.getErrorReporter().runtimeError(message, sourceName, lineno, lineSource, lineOffset);
        }
        throw new EvaluatorException(message, sourceName, lineno, lineSource, lineOffset);
    }

    static EvaluatorException reportRuntimeError0(String messageId) {
        String msg = Context.getMessage0(messageId);
        return Context.reportRuntimeError(msg);
    }

    static EvaluatorException reportRuntimeError1(String messageId, Object arg1) {
        String msg = Context.getMessage1(messageId, arg1);
        return Context.reportRuntimeError(msg);
    }

    static EvaluatorException reportRuntimeError2(String messageId, Object arg1, Object arg2) {
        String msg = Context.getMessage2(messageId, arg1, arg2);
        return Context.reportRuntimeError(msg);
    }

    static EvaluatorException reportRuntimeError3(String messageId, Object arg1, Object arg2, Object arg3) {
        String msg = Context.getMessage3(messageId, arg1, arg2, arg3);
        return Context.reportRuntimeError(msg);
    }

    static EvaluatorException reportRuntimeError4(String messageId, Object arg1, Object arg2, Object arg3, Object arg4) {
        String msg = Context.getMessage4(messageId, arg1, arg2, arg3, arg4);
        return Context.reportRuntimeError(msg);
    }

    public static EvaluatorException reportRuntimeError(String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        return Context.reportRuntimeError(message, filename, linep[0], null, 0);
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public final Scriptable initStandardObjects(ScriptableObject scope) {
        return this.initStandardObjects(scope, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scope, boolean sealed) {
        if (scope == null) {
            scope = new NativeObject();
        }
        new ClassCache().associate(scope);
        BaseFunction.init(this, scope, sealed);
        NativeObject.init(this, scope, sealed);
        Scriptable objectProto = ScriptableObject.getObjectPrototype(scope);
        Scriptable functionProto = ScriptableObject.getFunctionPrototype(scope);
        functionProto.setPrototype(objectProto);
        if (scope.getPrototype() == null) {
            scope.setPrototype(objectProto);
        }
        NativeError.init(this, scope, sealed);
        NativeGlobal.init(this, scope, sealed);
        NativeArray.init(this, scope, sealed);
        NativeString.init(this, scope, sealed);
        NativeBoolean.init(this, scope, sealed);
        NativeNumber.init(this, scope, sealed);
        NativeDate.init(this, scope, sealed);
        NativeMath.init(this, scope, sealed);
        NativeWith.init(this, scope, sealed);
        NativeCall.init(this, scope, sealed);
        NativeScript.init(this, scope, sealed);
        new LazilyLoadedCtor(scope, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", sealed);
        new LazilyLoadedCtor(scope, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", sealed);
        new LazilyLoadedCtor(scope, "java", "org.mozilla.javascript.NativeJavaTopPackage", sealed);
        new LazilyLoadedCtor(scope, "getClass", "org.mozilla.javascript.NativeJavaTopPackage", sealed);
        new LazilyLoadedCtor(scope, "JavaAdapter", "org.mozilla.javascript.JavaAdapter", sealed);
        return scope;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public final Object evaluateString(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) throws JavaScriptException {
        Script script = this.compileString(source, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    public final Object evaluateReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException, JavaScriptException {
        Script script = this.compileReader(scope, in, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    public final boolean stringIsCompilableUnit(String source) {
        boolean errorseen = false;
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(this);
        compilerEnv.setErrorReporter(DefaultErrorReporter.instance);
        compilerEnv.setGeneratingSource(false);
        Parser p = new Parser(compilerEnv);
        try {
            p.parse(source, null, 1);
        }
        catch (EvaluatorException ee) {
            errorseen = true;
        }
        return !errorseen || !p.eof();
    }

    public final Script compileReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        return this.compileReader(in, sourceName, lineno, securityDomain);
    }

    public final Script compileReader(Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        if (lineno < 0) {
            throw new IllegalArgumentException("Line number can not be negative:" + lineno);
        }
        return (Script)this.compile(null, in, null, sourceName, lineno, securityDomain, false, false);
    }

    public final Script compileString(String source, String sourceName, int lineno, Object securityDomain) {
        if (lineno < 0) {
            throw new IllegalArgumentException("Line number can not be negative:" + lineno);
        }
        return this.compileString(source, false, sourceName, lineno, securityDomain);
    }

    final Script compileString(String source, boolean fromEval, String sourceName, int lineno, Object securityDomain) {
        try {
            return (Script)this.compile(null, null, source, sourceName, lineno, securityDomain, false, fromEval);
        }
        catch (IOException ex) {
            throw new RuntimeException();
        }
    }

    public final Function compileFunction(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        try {
            return (Function)this.compile(scope, null, source, sourceName, lineno, securityDomain, true, false);
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
    }

    public final String decompileScript(Script script, Scriptable scope, int indent) {
        NativeFunction scriptImpl = (NativeFunction)((Object)script);
        return scriptImpl.decompile(indent, 0);
    }

    public final String decompileFunction(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            return ((BaseFunction)fun).decompile(indent, 0);
        }
        return "function " + fun.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public final String decompileFunctionBody(Function fun, int indent) {
        if (fun instanceof BaseFunction) {
            BaseFunction bf = (BaseFunction)fun;
            return bf.decompile(indent, 1);
        }
        return "[native code]\n";
    }

    public final Scriptable newObject(Scriptable scope) throws EvaluatorException, JavaScriptException {
        return this.newObject(scope, "Object", ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scope, String constructorName) throws EvaluatorException, JavaScriptException {
        return this.newObject(scope, constructorName, ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scope, String constructorName, Object[] args) throws EvaluatorException, JavaScriptException {
        scope = ScriptableObject.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(this, scope, constructorName);
        if (args == null) {
            args = ScriptRuntime.emptyArgs;
        }
        return ctor.construct(this, scope, args);
    }

    public final Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(length);
        this.newArrayHelper(scope, result);
        return result;
    }

    public final Scriptable newArray(Scriptable scope, Object[] elements) {
        if (elements.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray result = new NativeArray(elements);
        this.newArrayHelper(scope, result);
        return result;
    }

    public final Object[] getElements(Scriptable object) {
        long longLen = NativeArray.getLengthProperty(object);
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int len = (int)longLen;
        if (len == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object elem = ScriptableObject.getProperty(object, i);
            result[i] = elem == Scriptable.NOT_FOUND ? Undefined.instance : elem;
        }
        return result;
    }

    public static boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(value);
    }

    public static double toNumber(Object value) {
        return ScriptRuntime.toNumber(value);
    }

    public static String toString(Object value) {
        return ScriptRuntime.toString(value);
    }

    public static Scriptable toObject(Object value, Scriptable scope) {
        return ScriptRuntime.toObject(scope, value);
    }

    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        return ScriptRuntime.toObject(scope, value);
    }

    public static Object javaToJS(Object value, Scriptable scope) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Scriptable) {
            return value;
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        Context cx = Context.getContext();
        return cx.getWrapFactory().wrap(cx, scope, value, null);
    }

    public static Object toType(Object value, Class desiredType) throws IllegalArgumentException {
        return NativeJavaObject.coerceType(desiredType, value, false);
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof EvaluatorException) {
            throw (EvaluatorException)e;
        }
        if (e instanceof EcmaError) {
            throw (EcmaError)e;
        }
        throw new WrappedException(e);
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final void setGeneratingDebug(boolean generatingDebug) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingDebugChanged = true;
        if (generatingDebug && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = generatingDebug;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final void setGeneratingSource(boolean generatingSource) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = generatingSource;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public final void setOptimizationLevel(int optimizationLevel) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkOptimizationLevel(optimizationLevel);
        if (codegenClass == null) {
            optimizationLevel = -1;
        }
        this.optimizationLevel = optimizationLevel;
    }

    static void checkOptimizationLevel(int optimizationLevel) {
        if (-1 > optimizationLevel || optimizationLevel > 9) {
            throw new IllegalArgumentException("Optimization level outside [-1..9]: " + optimizationLevel);
        }
    }

    public final void setSecurityController(SecurityController controller) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Cannot overwrite existing SecurityController object");
        }
        this.securityController = controller;
    }

    public final void setClassShutter(ClassShutter shutter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (shutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = shutter;
    }

    final ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public final Object getThreadLocal(Object key) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    public final void putThreadLocal(Object key, Object value) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public final void removeThreadLocal(Object key) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(key);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public final void setCompileFunctionsWithDynamicScope(boolean flag) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.compileFunctionsWithDynamicScopeFlag = flag;
    }

    public static void setCachingEnabled(boolean cachingEnabled) {
    }

    public final void setWrapHandler(WrapHandler wrapHandler) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapHandler == null) {
            this.setWrapFactory(new WrapFactory());
        } else {
            this.setWrapFactory(new WrapHandlerProxy(wrapHandler));
        }
    }

    public final WrapHandler getWrapHandler() {
        WrapFactory f = this.getWrapFactory();
        if (f instanceof WrapHandlerProxy) {
            return ((WrapHandlerProxy)f)._handler;
        }
        return null;
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public final void setDebugger(Debugger debugger, Object contextData) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.debugger = debugger;
        this.debuggerData = contextData;
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int threshold) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.instructionThreshold = threshold;
    }

    protected void observeInstructionCount(int instructionCount) {
    }

    public GeneratedClassLoader createClassLoader(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            Class<?> cxClass = this.getClass();
            ClassLoader loader = cxClass.getClassLoader();
            if (method_getContextClassLoader != null) {
                Thread thread = Thread.currentThread();
                ClassLoader threadLoader = null;
                try {
                    threadLoader = (ClassLoader)method_getContextClassLoader.invoke((Object)thread, ScriptRuntime.emptyArgs);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (threadLoader != null && threadLoader != loader && Context.testIfCanUseLoader(threadLoader, cxClass)) {
                    return threadLoader;
                }
            }
            this.applicationClassLoader = loader;
        }
        return this.applicationClassLoader;
    }

    public final void setApplicationClassLoader(ClassLoader loader) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (loader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!Context.testIfCanUseLoader(loader, this.getClass())) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = loader;
    }

    private static boolean testIfCanUseLoader(ClassLoader loader, Class cxClass) {
        Class x = Kit.classOrNull(loader, cxClass.getName());
        return x == cxClass;
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return Context.getMessage(messageId, arguments);
    }

    static String getMessage4(String messageId, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] arguments = new Object[]{arg1, arg2, arg3, arg4};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx != null ? cx.getLocale() : Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(defaultResource, locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    private Object compile(Scriptable scope, Reader sourceReader, String sourceString, String sourceName, int lineno, Object securityDomain, boolean returnFunction, boolean fromEval) throws IOException {
        if (securityDomain != null && this.securityController == null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        if (!(sourceReader == null ^ sourceString == null)) {
            Kit.codeBug();
        }
        if (!(scope == null ^ returnFunction)) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(this);
        compilerEnv.setFromEval(fromEval);
        if (this.debugger != null && sourceReader != null) {
            sourceString = Kit.readReader(sourceReader);
            sourceReader = null;
        }
        Parser p = new Parser(compilerEnv);
        ScriptOrFnNode tree = sourceString != null ? p.parse(sourceString, sourceName, lineno) : p.parse(sourceReader, sourceName, lineno);
        int syntaxErrorCount = compilerEnv.getSyntaxErrorCount();
        if (syntaxErrorCount == 0) {
            Interpreter compiler = this.createCompiler();
            String encodedSource = p.getEncodedSource();
            Object result = compiler.compile(scope, compilerEnv, tree, encodedSource, returnFunction, securityDomain);
            syntaxErrorCount = compilerEnv.getSyntaxErrorCount();
            if (syntaxErrorCount == 0) {
                if (this.debugger != null) {
                    if (sourceString == null) {
                        Kit.codeBug();
                    }
                    compiler.notifyDebuggerCompilationDone(this, result, sourceString);
                }
                return result;
            }
        }
        String msg = Context.getMessage1("msg.got.syntax.errors", String.valueOf(syntaxErrorCount));
        throw compilerEnv.getErrorReporter().runtimeError(msg, sourceName, lineno, null, 0);
    }

    private Interpreter createCompiler() {
        Interpreter result = null;
        if (this.optimizationLevel >= 0 && codegenClass != null) {
            result = (Interpreter)Kit.newInstanceOrNull(codegenClass);
        }
        if (result == null) {
            result = new Interpreter();
        }
        return result;
    }

    static String getSourcePositionFromStack(int[] linep) {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            return null;
        }
        if (cx.interpreterData != null) {
            return Interpreter.getSourcePositionFromStack(cx, linep);
        }
        CharArrayWriter writer = new CharArrayWriter();
        RuntimeException re = new RuntimeException();
        re.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        int open = -1;
        int close = -1;
        int colon = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ':') {
                colon = i;
                continue;
            }
            if (c == '(') {
                open = i;
                continue;
            }
            if (c == ')') {
                close = i;
                continue;
            }
            if (c != '\n' || open == -1 || close == -1 || colon == -1 || open >= colon || colon >= close) continue;
            String fileStr = s.substring(open + 1, colon);
            if (!fileStr.endsWith(".java")) {
                String lineStr = s.substring(colon + 1, close);
                try {
                    linep[0] = Integer.parseInt(lineStr);
                    return fileStr;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            colon = -1;
            close = -1;
            open = -1;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        Class cl;
        if (this.regExpProxy == null && (cl = Kit.classOrNull("org.mozilla.javascript.regexp.RegExpImpl")) != null) {
            this.regExpProxy = (RegExpProxy)Kit.newInstanceOrNull(cl);
        }
        return this.regExpProxy;
    }

    private void newArrayHelper(Scriptable scope, Scriptable array) {
        array.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Array");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s = (Scriptable)ctor;
            array.setPrototype((Scriptable)s.get("prototype", s));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        return this.securityController;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String name) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(name, name);
    }

    public final boolean isActivationNeeded(String name) {
        return this.activationNames != null && this.activationNames.containsKey(name);
    }

    public void removeActivationName(String name) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames != null) {
            this.activationNames.remove(name);
        }
    }

    static {
        Class threadClass;
        emptyArgs = ScriptRuntime.emptyArgs;
        codegenClass = Kit.classOrNull("org.mozilla.javascript.optimizer.Codegen");
        threadContexts = new Hashtable(11);
        Class cl = Kit.classOrNull("java.lang.ThreadLocal");
        if (cl != null) {
            try {
                threadLocalGet = cl.getMethod("get", null);
                threadLocalSet = cl.getMethod("set", ScriptRuntime.ObjectClass);
                threadLocalCx = cl.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((threadClass = Kit.classOrNull("java.lang.Thread")) != null) {
            try {
                method_getContextClassLoader = threadClass.getDeclaredMethod("getContextClassLoader", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        staticListenersLock = new Object();
    }

    private static class WrapHandlerProxy
    extends WrapFactory {
        WrapHandler _handler;

        WrapHandlerProxy(WrapHandler handler) {
            this._handler = handler;
        }

        public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
            if (obj == null) {
                return obj;
            }
            Object result = this._handler.wrap(scope, obj, staticType);
            if (result == null) {
                result = super.wrap(cx, scope, obj, staticType);
            }
            return result;
        }

        public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
            Object wrap = this._handler.wrap(scope, obj, obj.getClass());
            if (wrap instanceof Scriptable) {
                return (Scriptable)wrap;
            }
            if (wrap == null) {
                return super.wrapNewObject(cx, scope, obj);
            }
            throw new RuntimeException("Please upgrade from WrapHandler to WrapFactory");
        }
    }
}

