/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Hashtable;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.ListStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ListStyleConverter
extends StyleConverter {
    boolean bNeedSaveEnumCounter = false;
    private Hashtable listStyleLevelNames = new Hashtable();

    public ListStyleConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.config.formatting() >= 3 || !this.styleNames.isEmpty()) {
            laTeXDocumentPortion2.append("% List styles").nl();
            if (this.bNeedSaveEnumCounter) {
                laTeXDocumentPortion2.append("\\newcounter{saveenum}").nl();
            }
            if (this.config.formatting() >= 3) {
                laTeXDocumentPortion2.append("\\newcommand\\writerlistleftskip{}").nl().append("\\newcommand\\writerlistparindent{}").nl().append("\\newcommand\\writerlistlabel{}").nl().append("\\newcommand\\writerlistremovelabel{").append("\\aftergroup\\let\\aftergroup\\writerlistparindent\\aftergroup\\relax").append("\\aftergroup\\let\\aftergroup\\writerlistlabel\\aftergroup\\relax}").nl();
            }
            super.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        }
    }

    public void applyListStyle(String string, int n, boolean bl, boolean bl2, BeforeAfter beforeAfter) {
        if (this.config.getListStyleMap().contains(string)) {
            beforeAfter.add(this.config.getListStyleMap().getBefore(string), this.config.getListStyleMap().getAfter(string));
            return;
        }
        ListStyle listStyle = this.wsc.getListStyle(string);
        if (listStyle != null) {
            bl = listStyle.isNumber(n);
        }
        if (listStyle == null || this.config.formatting() <= 1) {
            if (n <= 4) {
                if (bl) {
                    beforeAfter.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    beforeAfter.add("\\begin{itemize}", "\\end{itemize}");
                }
            }
            return;
        }
        if (this.config.formatting() == 2) {
            if (n == 1) {
                if (!this.styleNames.containsName(string)) {
                    this.createListStyleLabels(string);
                }
                beforeAfter.add("\\liststyle" + this.styleNames.getExportName(string) + "\n", "");
            }
            if (n <= 4) {
                String string2 = ((String[])this.listStyleLevelNames.get(string))[n];
                if (bl2 && listStyle.isNumber(n)) {
                    this.bNeedSaveEnumCounter = true;
                    beforeAfter.add("\\setcounter{saveenum}{\\value{" + string2 + "}}\n", "");
                }
                if (bl) {
                    beforeAfter.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    beforeAfter.add("\\begin{itemize}", "\\end{itemize}");
                }
                if (bl2 && listStyle.isNumber(n)) {
                    beforeAfter.add("\n\\setcounter{" + string2 + "}{\\value{saveenum}}", "");
                }
            }
            return;
        }
        if (n <= 4) {
            if (!this.styleNames.containsName(string)) {
                this.createListStyle(string);
            }
            String string3 = "list" + this.styleNames.getExportName(string) + "level" + Misc.int2roman(n);
            if (!bl2 && listStyle.isNumber(n)) {
                beforeAfter.add("\\setcounter{" + string3 + "}{0}\n", "");
            }
            beforeAfter.add("\\begin{" + string3 + "}", "\\end{" + string3 + "}");
        }
    }

    public void applyListItemStyle(String string, int n, boolean bl, boolean bl2, int n2, BeforeAfter beforeAfter) {
        if (this.config.getListItemStyleMap().contains(string)) {
            beforeAfter.add(this.config.getListItemStyleMap().getBefore(string), this.config.getListItemStyleMap().getAfter(string));
            return;
        }
        ListStyle listStyle = this.wsc.getListStyle(string);
        if (listStyle == null || this.config.formatting() <= 1) {
            if (n <= 4) {
                if (bl) {
                    beforeAfter.add("\\item[] ", "");
                } else {
                    beforeAfter.add("\\item ", "");
                }
            }
            return;
        }
        if (this.config.formatting() == 2) {
            if (n <= 4) {
                if (bl) {
                    beforeAfter.add("\\item[] ", "");
                } else if (bl2 && listStyle.isNumber(n)) {
                    beforeAfter.add("\n\\setcounter{enum" + Misc.int2roman(n) + "}{" + (n2 - 1) + "}\n\\item ", "");
                } else {
                    beforeAfter.add("\\item ", "");
                }
            }
            return;
        }
        if (n <= 4 && !bl) {
            String string2 = "list" + this.styleNames.getExportName(string) + "level" + Misc.int2roman(n);
            if (bl2 && listStyle.isNumber(n)) {
                beforeAfter.add("\\setcounter{" + string2 + "}{" + (n2 - 1) + "}\n", "");
            }
            beforeAfter.add("\\item ", "");
        }
    }

    private void createListStyleLabels(String string) {
        String string2 = this.styleNames.getExportName(string);
        this.declarations.append("\\newcommand\\liststyle").append(string2).append("{%").nl();
        ListStyle listStyle = this.wsc.getListStyle(string);
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[5];
        for (int i = 1; i <= 4; ++i) {
            stringArray[i] = listStyle.isNumber(i) ? "enum" + Misc.int2roman(++n) : "item" + Misc.int2roman(++n2);
        }
        this.listStyleLevelNames.put(string, stringArray);
        this.createLabels(listStyle, stringArray, 4, false, true, false, this.declarations);
        this.declarations.append("}").nl();
    }

    private void createListStyle(String string) {
        int n;
        ListStyle listStyle = this.wsc.getListStyle(string);
        String string2 = this.styleNames.getExportName(string);
        String[] stringArray = new String[5];
        for (n = 1; n <= 4; ++n) {
            stringArray[n] = "list" + string2 + "level" + Misc.int2roman(n);
        }
        this.createLabels(listStyle, stringArray, 4, true, false, true, this.declarations);
        for (n = 1; n <= 4; ++n) {
            String string3 = this.getLength(listStyle, n, "text:space-before");
            String string4 = this.getLength(listStyle, n, "text:min-label-width");
            String string5 = this.getLength(listStyle, n, "text:min-label-distance");
            this.declarations.append("\\newenvironment{").append(stringArray[n]).append("}{").append("\\def\\writerlistleftskip{\\addtolength\\leftskip{").append(Misc.add(string3, string4)).append("}}").append("\\def\\writerlistparindent{}").append("\\def\\writerlistlabel{}");
            this.declarations.append("\\def\\item{").append("\\def\\writerlistparindent{\\setlength\\parindent{").append("-").append(string4).append("}}").append("\\def\\writerlistlabel{");
            if (listStyle.isNumber(n)) {
                this.declarations.append("\\stepcounter{").append(stringArray[n]).append("}");
            }
            this.declarations.append("\\label").append(stringArray[n]).append("\\hspace{").append(string5).append("}").append("\\writerlistremovelabel}}}{}").nl();
        }
    }

    private void createLabels(ListStyle listStyle, String[] stringArray, int n, boolean bl, boolean bl2, boolean bl3, LaTeXDocumentPortion laTeXDocumentPortion) {
        int n2;
        if (bl) {
            int n3 = 0;
            for (n2 = 1; n2 <= n; ++n2) {
                if (!listStyle.isNumber(n2)) continue;
                laTeXDocumentPortion.append("\\newcounter{").append(stringArray[n2]).append("}");
                if (n3 > 0) {
                    laTeXDocumentPortion.append("[").append(stringArray[n3]).append("]");
                }
                laTeXDocumentPortion.nl();
                n3 = n2;
            }
        }
        String[] stringArray2 = new String[n + 1];
        for (n2 = 1; n2 <= n; ++n2) {
            String string = ListStyleConverter.numFormat(listStyle.getLevelProperty(n2, "style:num-format"));
            stringArray2[n2] = string == null ? "" : string + "{" + stringArray[n2] + "}";
        }
        for (n2 = 1; n2 <= n; ++n2) {
            if (!listStyle.isNumber(n2)) continue;
            laTeXDocumentPortion.append("\\renewcommand\\the").append(stringArray[n2]).append("{");
            int n4 = Misc.getPosInteger(listStyle.getLevelProperty(n2, "text:display-levels"), 1);
            for (int i = n2 - n4 + 1; i < n2; ++i) {
                if (!listStyle.isNumber(i)) continue;
                laTeXDocumentPortion.append(stringArray2[i]).append(".");
            }
            laTeXDocumentPortion.append(stringArray2[n2]);
            laTeXDocumentPortion.append("}").nl();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            String string;
            laTeXDocumentPortion.append(bl2 ? "\\renewcommand" : "\\newcommand").append("\\label").append(stringArray[n2]).append("{");
            BeforeAfter beforeAfter = new BeforeAfter();
            if (bl3) {
                string = listStyle.getLevelProperty(n2, "text:style-name");
                this.palette.getCharSc().applyTextStyle(string, beforeAfter, new Context());
            }
            if (listStyle.isNumber(n2)) {
                string = listStyle.getLevelProperty(n2, "style:num-prefix");
                String string2 = listStyle.getLevelProperty(n2, "style:num-suffix");
                laTeXDocumentPortion.append(beforeAfter.getBefore());
                if (string != null) {
                    laTeXDocumentPortion.append(string);
                }
                laTeXDocumentPortion.append("\\the").append(stringArray[n2]);
                if (string2 != null) {
                    laTeXDocumentPortion.append(string2);
                }
                laTeXDocumentPortion.append(beforeAfter.getAfter());
            } else if (listStyle.isBullet(n2)) {
                string = listStyle.getLevelProperty(n2, "text:bullet-char");
                laTeXDocumentPortion.append(beforeAfter.getBefore());
                if (string != null) {
                    laTeXDocumentPortion.append(this.palette.getI18n().convert(string, false, "en"));
                }
                laTeXDocumentPortion.append(beforeAfter.getAfter());
            } else {
                laTeXDocumentPortion.append("\\textbullet");
            }
            laTeXDocumentPortion.append("}").nl();
        }
    }

    private String getLength(ListStyle listStyle, int n, String string) {
        String string2 = listStyle.getLevelStyleProperty(n, string);
        if (string2 == null) {
            return "0cm";
        }
        return string2;
    }

    public static final String numFormat(String string) {
        if ("1".equals(string)) {
            return "\\arabic";
        }
        if ("i".equals(string)) {
            return "\\roman";
        }
        if ("I".equals(string)) {
            return "\\Roman";
        }
        if ("a".equals(string)) {
            return "\\alph";
        }
        if ("A".equals(string)) {
            return "\\Alph";
        }
        return null;
    }
}

