/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.SectionStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;

public class SectionStyleConverter
extends StyleConverter {
    private boolean bNeedMulticol = false;

    public SectionStyleConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bNeedMulticol) {
            laTeXDocumentPortion.append("\\usepackage{multicol}").nl();
        }
    }

    public void applySectionStyle(String string, BeforeAfter beforeAfter, Context context) {
        SectionStyle sectionStyle = this.wsc.getSectionStyle(string);
        if (context.isInMulticols() || sectionStyle == null || sectionStyle.getColCount() < 2) {
            return;
        }
        int n = sectionStyle.getColCount();
        this.bNeedMulticol = true;
        context.setInMulticols(true);
        beforeAfter.add("\\begin{multicols}{" + (n > 10 ? 10 : n) + "}", "\\end{multicols}");
    }
}

