/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.util.CSVList;

public class MetaData {
    private String sTitle = null;
    private String sCreator = null;
    private String sInitialCreator = null;
    private String sDate = null;
    private String sDescription = null;
    private String sLanguage = null;
    private String sSubject = null;
    private String sKeywords = null;

    public MetaData(OfficeDocument officeDocument) {
        NodeList nodeList;
        Document document = officeDocument.getMetaDOM();
        if (document == null) {
            document = officeDocument.getContentDOM();
        }
        if ((nodeList = document.getElementsByTagName("office:meta")).getLength() == 0) {
            return;
        }
        Node node = nodeList.item(0);
        if (!node.hasChildNodes()) {
            return;
        }
        nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if ("dc:title".equals(string)) {
                this.sTitle = this.getContent(node2);
            }
            if ("dc:creator".equals(string)) {
                this.sCreator = this.getContent(node2);
            }
            if ("dc:date".equals(string)) {
                this.sDate = this.getContent(node2);
            }
            if ("dc:description".equals(string)) {
                this.sDescription = this.getContent(node2);
            }
            if ("dc:language".equals(string)) {
                this.sLanguage = this.getContent(node2);
            }
            if ("dc:subject".equals(string)) {
                this.sSubject = this.getContent(node2);
            }
            if ("meta:initial-creator".equals(string)) {
                this.sInitialCreator = this.getContent(node2);
            }
            if (!"meta:keywords".equals(string) || !node2.hasChildNodes()) continue;
            CSVList cSVList = new CSVList(", ");
            NodeList nodeList2 = node2.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node3 = nodeList2.item(j);
                if (!"meta:keyword".equals(node3.getNodeName())) continue;
                cSVList.addValue(this.getContent(node3));
            }
            this.sKeywords = cSVList.toString();
        }
    }

    public String getTitle() {
        return this.sTitle;
    }

    public String getCreator() {
        return this.sCreator == null ? this.sInitialCreator : this.sCreator;
    }

    public String getInitialCreator() {
        return this.sInitialCreator;
    }

    public String getDate() {
        return this.sDate;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public String getLanguage() {
        return this.sLanguage;
    }

    public String getSubject() {
        return this.sSubject;
    }

    public String getKeywords() {
        return this.sKeywords;
    }

    private String getContent(Node node) {
        if (!node.hasChildNodes()) {
            return null;
        }
        String string = "";
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            string = string + nodeList.item(i).getNodeValue();
        }
        return string;
    }
}

