/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    private int mergeThreadPriority = -1;
    private List mergeThreads = new ArrayList();
    private int maxThreadCount = 3;
    private List exceptions = new ArrayList();
    private Directory dir;
    private boolean closed;
    private IndexWriter writer;
    static boolean anyExceptions = false;
    private boolean suppressExceptions;
    private static List allInstances;

    public ConcurrentMergeScheduler() {
        if (allInstances != null) {
            this.addMyself();
        }
    }

    public void setMaxThreadCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        this.maxThreadCount = count;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized int getMergeThreadPriority() {
        this.initMergeThreadPriority();
        return this.mergeThreadPriority;
    }

    public synchronized void setMergeThreadPriority(int pri) {
        if (pri > 10 || pri < 1) {
            throw new IllegalArgumentException("priority must be in range 1 .. 10 inclusive");
        }
        this.mergeThreadPriority = pri;
        int numThreads = this.mergeThreadCount();
        for (int i = 0; i < numThreads; ++i) {
            MergeThread merge = (MergeThread)this.mergeThreads.get(i);
            merge.setThreadPriority(pri);
        }
    }

    private void message(String message) {
        if (this.writer != null) {
            this.writer.message("CMS: " + message);
        }
    }

    private synchronized void initMergeThreadPriority() {
        if (this.mergeThreadPriority == -1) {
            this.mergeThreadPriority = 1 + Thread.currentThread().getPriority();
            if (this.mergeThreadPriority > 10) {
                this.mergeThreadPriority = 10;
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public synchronized void sync() {
        while (this.mergeThreadCount() > 0) {
            this.message("now wait for threads; currently " + this.mergeThreads.size() + " still running");
            int count = this.mergeThreads.size();
            for (int i = 0; i < count; ++i) {
                this.message("    " + i + ": " + (MergeThread)this.mergeThreads.get(i));
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized int mergeThreadCount() {
        int count = 0;
        int numThreads = this.mergeThreads.size();
        for (int i = 0; i < numThreads; ++i) {
            if (!((MergeThread)this.mergeThreads.get(i)).isAlive()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
        this.writer = writer;
        this.initMergeThreadPriority();
        this.dir = writer.getDirectory();
        this.message("now merge");
        this.message("  index: " + writer.segString());
        while (true) {
            MergePolicy.OneMerge merge;
            if ((merge = writer.getNextMerge()) == null) {
                this.message("  no more merges pending; now return");
                return;
            }
            writer.mergeInit(merge);
            this.message("  consider merge " + merge.segString(this.dir));
            if (merge.isExternal) {
                this.message("    merge involves segments from an external directory; now run in foreground");
            } else {
                ConcurrentMergeScheduler concurrentMergeScheduler = this;
                synchronized (concurrentMergeScheduler) {
                    if (this.mergeThreadCount() < this.maxThreadCount) {
                        MergeThread merger = new MergeThread(writer, merge);
                        this.mergeThreads.add(merger);
                        this.message("    launch new thread [" + merger.getName() + "]");
                        merger.setThreadPriority(this.mergeThreadPriority);
                        merger.setDaemon(true);
                        merger.start();
                        continue;
                    }
                    this.message("    too many merge threads running; run merge in foreground");
                }
            }
            writer.merge(merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean anyUnhandledExceptions() {
        List list = allInstances;
        synchronized (list) {
            int count = allInstances.size();
            for (int i = 0; i < count; ++i) {
                ((ConcurrentMergeScheduler)allInstances.get(i)).sync();
            }
            return anyExceptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMyself() {
        List list = allInstances;
        synchronized (list) {
            boolean size = false;
            int upto = 0;
            for (int i = 0; i < 0; ++i) {
                ConcurrentMergeScheduler other = (ConcurrentMergeScheduler)allInstances.get(i);
                if (other.closed && 0 == other.mergeThreadCount()) continue;
                allInstances.set(upto++, other);
            }
            allInstances.subList(upto, allInstances.size()).clear();
            allInstances.add(this);
        }
    }

    void setSuppressExceptions() {
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        this.suppressExceptions = false;
    }

    public static void setTestMode() {
        allInstances = new ArrayList();
    }

    private class MergeThread
    extends Thread {
        IndexWriter writer;
        MergePolicy.OneMerge startMerge;
        MergePolicy.OneMerge runningMerge;

        public MergeThread(IndexWriter writer, MergePolicy.OneMerge startMerge) throws IOException {
            this.writer = writer;
            this.startMerge = startMerge;
        }

        public synchronized void setRunningMerge(MergePolicy.OneMerge merge) {
            this.runningMerge = merge;
        }

        public synchronized MergePolicy.OneMerge getRunningMerge() {
            return this.runningMerge;
        }

        public void setThreadPriority(int pri) {
            try {
                this.setPriority(pri);
            }
            catch (NullPointerException npe) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            MergePolicy.OneMerge merge = this.startMerge;
            try {
                try {
                    ConcurrentMergeScheduler.this.message("  merge thread: start");
                    while (true) {
                        this.setRunningMerge(merge);
                        this.writer.merge(merge);
                        merge = this.writer.getNextMerge();
                        if (merge == null) break;
                        this.writer.mergeInit(merge);
                        ConcurrentMergeScheduler.this.message("  merge thread: do another merge " + merge.segString(ConcurrentMergeScheduler.this.dir));
                    }
                    ConcurrentMergeScheduler.this.message("  merge thread: done");
                }
                catch (Throwable exc) {
                    if (merge != null) {
                        merge.setException(exc);
                        this.writer.addMergeException(merge);
                    }
                    if (!(exc instanceof MergePolicy.MergeAbortedException)) {
                        ConcurrentMergeScheduler concurrentMergeScheduler = ConcurrentMergeScheduler.this;
                        // MONITORENTER : concurrentMergeScheduler
                        ConcurrentMergeScheduler.this.exceptions.add(exc);
                        // MONITOREXIT : concurrentMergeScheduler
                        if (!ConcurrentMergeScheduler.this.suppressExceptions) {
                            anyExceptions = true;
                            throw new MergePolicy.MergeException(exc);
                        }
                    }
                    Object var6_3 = null;
                    ConcurrentMergeScheduler concurrentMergeScheduler4 = ConcurrentMergeScheduler.this;
                    // MONITORENTER : concurrentMergeScheduler4
                    ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                    ConcurrentMergeScheduler.this.notifyAll();
                    // MONITOREXIT : concurrentMergeScheduler4
                    return;
                }
                Object var6_2 = null;
                ConcurrentMergeScheduler concurrentMergeScheduler = ConcurrentMergeScheduler.this;
                // MONITORENTER : concurrentMergeScheduler
                ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                ConcurrentMergeScheduler.this.notifyAll();
                // MONITOREXIT : concurrentMergeScheduler
                return;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                ConcurrentMergeScheduler concurrentMergeScheduler2 = ConcurrentMergeScheduler.this;
                // MONITORENTER : concurrentMergeScheduler2
                ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                ConcurrentMergeScheduler.this.notifyAll();
                // MONITOREXIT : concurrentMergeScheduler2
                throw throwable;
            }
        }

        public String toString() {
            MergePolicy.OneMerge merge = this.getRunningMerge();
            if (merge == null) {
                merge = this.startMerge;
            }
            return "merge thread: " + merge.segString(ConcurrentMergeScheduler.this.dir);
        }
    }
}

