/* ex: set ro:
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically from 'core.ops' (and possibly other
 * .ops files). by tools/build/ops2c.pl.
 *
 * Any changes made here will be lost!
 *
 */

#include "parrot/oplib/core_ops_switch.h"

/* defines - tools/build/ops2c.pl -> Parrot::OpTrans::CPrederef */
#define REL_PC ((size_t)(cur_opcode - (opcode_t*)interp->code->prederef.code))
#define CUR_OPCODE \
    ((opcode_t*)cur_opcode + CONTEXT(interp)->pred_offset)
#define OP_AS_OFFS(o) (_reg_base + ((opcode_t*)cur_opcode)[o])

/* defines - tools/build/ops2c.pl -> Parrot::OpTrans::CSwitch */
#  define opcode_to_prederef(i, op)   (op ? \
     (opcode_t*) (op   - CONTEXT(i)->pred_offset) : (opcode_t*)NULL)


/*
 * $Id: /mirror/trunk/src/ops/core.ops 35154 2009-01-07T14:12:23.146823Z jonathan  $
** core.ops
*/

#include "parrot/dynext.h"
#include "parrot/embed.h"
#include "../interp_guts.h"



/*
 * $Id: /mirror/trunk/src/ops/bit.ops 35818 2009-01-20T04:17:21.743227Z chromatic  $
** bit.ops
*/

 /* Signed shift operator that is compatible with PMC shifts.  This is
  * guaranteed to produce the same result as bitwise_left_shift_internal modulo
  * word size, ignoring the fact that Parrot integers are always signed.  This
  * usually gives the same answer regardless whether you shift PMC operands and
  * then assign to an I-reg, or move the operands to I-regs and do the shift
  * there -- except when the true result is between 2^{w-1} and 2^w (where w is
  * the word size), in which case the high order bit is taken as the sign,
  * giving a truncated result that is 2^w lower.
  */
#define bit_shift_left(number, bits) \
    ((bits) >= 8*INTVAL_SIZE     ? 0                    \
     : (bits) >= 0               ? (number) << (bits)   \
     : (bits) > -8*INTVAL_SIZE   ? (number) >> -(bits)   \
     : 0)



/*
 * $Id: /mirror/trunk/src/ops/cmp.ops 35818 2009-01-20T04:17:21.743227Z chromatic  $
** cmp.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/debug.ops 32253 2008-10-28T20:44:01.227920Z julianalbo  $
 * Copyright (C) 2002-2008, The Perl Foundation.
 */

/*
** debug.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/experimental.ops 34560 2008-12-29T01:01:45.826457Z coke  $
** experimental.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/io.ops 34655 2008-12-30T08:09:18.123533Z allison  $
 * Copyright (C) 2002-2008, The Perl Foundation.
** io.ops
*/

#include "../io/io_private.h"



/*
 * $Id: /mirror/trunk/src/ops/math.ops 35884 2009-01-21T08:02:35.116993Z chromatic  $
** math.ops
*/



/*

Copyright (C) 2001-2008, The Perl Foundation.
$Id: /mirror/trunk/src/ops/object.ops 35367 2009-01-10T10:50:26.942379Z cotto  $

object.ops

*/




/*
 * $Id: /mirror/trunk/src/ops/pic.ops 33162 2008-11-24T06:29:08.023921Z pmichaud  $
** pic.ops
*/

#include "parrot/oplib/ops.h"

typedef opcode_t* (*interface_f)(Interp*, INTVAL*, void **);



/*

Copyright (C) 2001-2008, The Perl Foundation.
$Id: /mirror/trunk/src/ops/pmc.ops 35367 2009-01-10T10:50:26.942379Z cotto  $

pmc.ops

*/



/*
 * $Id: /mirror/trunk/src/ops/set.ops 35266 2009-01-09T02:07:32.249591Z coke  $
** set.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/string.ops 32976 2008-11-20T17:06:07.254960Z Whiteknight  $
** string.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/sys.ops 32253 2008-10-28T20:44:01.227920Z julianalbo  $
** sys.ops
*/



/*
 * $Id: /mirror/trunk/src/ops/var.ops 35386 2009-01-10T21:44:06.398727Z coke  $
** var.ops
*/



/*
** op lib descriptor:
*/

static op_lib_t core_switch_op_lib = {
  "core",               /* name */
  "_switch",             /* suffix */
  PARROT_SWITCH_CORE,                       /* core_type = PARROT_XX_CORE */
  0,                                /* flags */
  0,    /* major_version */
  9,    /* minor_version */
  0,    /* patch_version */
  1270,              /* op_count */
  NULL,              /* op_info_table */
  NULL,              /* op_func_table */
  ( int (*)(const char *, int) )NULL                 /* op_code() */
};

/* run_core_func_decl - tools/build/ops2c.pl -> Parrot::OpTrans::CPrederef */
opcode_t * switch_core(opcode_t *cur_op, PARROT_INTERP)

{
/* run_core_func_start - tools/build/ops2c.pl -> Parrot::OpTrans::CSwitch */
#if defined(__GNUC__) && defined(I386) && defined(PARROT_SWITCH_REGS)
    register opcode_t *   cur_opcode __asm__ ("esi") = cur_op;
    register char *   _reg_base   __asm__ ("edi");
#else
    opcode_t * cur_opcode = cur_op;
    char * _reg_base;
#endif

SWITCH_RELOAD:
    _reg_base = (char*)interp->ctx.bp.regs_i;
    do {
SWITCH_AGAIN:
    Parrot_cx_handle_tasks(interp, interp->scheduler);
    if (!cur_opcode)
        break;
    switch (*(opcode_t*)cur_opcode) {
/*
** Op Function Definitions:
*/

case 0: /* end */ {
#line 51 "src/ops/core.ops"
    return (0);;
}

case 1: /* noop */ {
#line 105 "src/ops/core.ops"

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 2: /* cpu_ret */ {
#line 108 "src/ops/core.ops"
#ifdef __GNUC__
#  ifdef I386
    __asm__("ret");
#  endif
#endif

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 3: /* check_events */ {
#line 116 "src/ops/core.ops"
    opcode_t *next = CUR_OPCODE + 1;
    Parrot_cx_check_tasks(interp, interp->scheduler);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;   /* force this being a branch op */
}

case 4: /* check_events__ */ {
#line 122 "src/ops/core.ops"
    opcode_t *_this = CUR_OPCODE;
    /* Restore op_func_table. */
    disable_event_checking(interp);
    Parrot_cx_handle_tasks(interp, interp->scheduler);
                {
               cur_opcode = opcode_to_prederef(interp, _this);
               goto SWITCH_RELOAD;
            }
;   /* force this being a branch op */
}

case 5: /* wrapper__ */ {
#line 130 "src/ops/core.ops"
    opcode_t *pc = CUR_OPCODE;
    DO_OP(pc, interp);
                {
               cur_opcode = opcode_to_prederef(interp, pc);
               goto SWITCH_RELOAD;
            }
;
}

case 6: /* prederef__ */ {
#line 136 "src/ops/core.ops"
    opcode_t * const _this = CUR_OPCODE;
    if (interp->run_core & PARROT_CGOTO_CORE) {
        /* must be CGP then - check for events in not yet prederefed code */
        Parrot_cx_runloop_wake(interp, interp->scheduler);
    /*    _this = CHECK_EVENTS(interp, _this); */
    }
    do_prederef((void**)cur_opcode, interp, core_switch_op_lib.core_type);
                {
               cur_opcode = opcode_to_prederef(interp, _this);
               goto SWITCH_RELOAD;
            }
; /* force this being a branch op */
}

case 7: /* reserved_ic */ {
#line 147 "src/ops/core.ops"
    /* reserve 1 entries */

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 8: /* load_bytecode_s */ {
#line 151 "src/ops/core.ops"
    Parrot_load_bytecode(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 9: /* load_bytecode_sc */ {
#line 151 "src/ops/core.ops"
    Parrot_load_bytecode(interp, ((STRING *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 10: /* branch_i */ {
#line 177 "src/ops/core.ops"
    { cur_opcode += (*(INTVAL *)OP_AS_OFFS(1)); goto SWITCH_AGAIN; };
}

case 11: /* branch_ic */ {
#line 177 "src/ops/core.ops"
    { cur_opcode += ((INTVAL)cur_opcode[1]); goto SWITCH_AGAIN; };
}

case 12: /* branch_cs_s */ {
#line 188 "src/ops/core.ops"
    PackFile_FixupEntry * fe;
    {
        char * const label = string_to_cstring(interp, (*(STRING **)OP_AS_OFFS(1)));
        fe = PackFile_find_fixup_entry(interp, enum_fixup_label, label);
        string_cstring_free(label);
    }

    if (!fe) {
        opcode_t * handler= Parrot_ex_throw_from_op_args(interp, NULL,
            EXCEPTION_INVALID_OPERATION,
            "branch_cs: fixup for '%Ss' not found", (*(STRING **)OP_AS_OFFS(1)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        interp->resume_offset = fe->offset;
        Parrot_switch_to_cs(interp, fe->seg, 1);
        mem_sys_free(fe);
    }
    interp->resume_flag = 2;
    return (0);;
}

case 13: /* branch_cs_sc */ {
#line 188 "src/ops/core.ops"
    PackFile_FixupEntry * fe;
    {
        char * const label = string_to_cstring(interp, ((STRING *)cur_opcode[1]));
        fe = PackFile_find_fixup_entry(interp, enum_fixup_label, label);
        string_cstring_free(label);
    }

    if (!fe) {
        opcode_t * handler= Parrot_ex_throw_from_op_args(interp, NULL,
            EXCEPTION_INVALID_OPERATION,
            "branch_cs: fixup for '%Ss' not found", ((STRING *)cur_opcode[1]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        interp->resume_offset = fe->offset;
        Parrot_switch_to_cs(interp, fe->seg, 1);
        mem_sys_free(fe);
    }
    interp->resume_flag = 2;
    return (0);;
}

case 14: /* bsr_i */ {
#line 220 "src/ops/core.ops"
    stack_push(interp, &interp->dynamic_env,
             CUR_OPCODE + 2,  STACK_ENTRY_DESTINATION, STACK_CLEANUP_NULL);
    { cur_opcode += (*(INTVAL *)OP_AS_OFFS(1)); goto SWITCH_AGAIN; };
}

case 15: /* bsr_ic */ {
#line 220 "src/ops/core.ops"
    stack_push(interp, &interp->dynamic_env,
             CUR_OPCODE + 2,  STACK_ENTRY_DESTINATION, STACK_CLEANUP_NULL);
    { cur_opcode += ((INTVAL)cur_opcode[1]); goto SWITCH_AGAIN; };
}

case 16: /* ret */ {
#line 232 "src/ops/core.ops"
    { opcode_t *dest = (opcode_t*)pop_dest(interp);
              cur_opcode = opcode_to_prederef(interp, dest);
              goto SWITCH_AGAIN; };
}

case 17: /* local_branch_p_i */ {
#line 245 "src/ops/core.ops"
    INTVAL return_addr;
    opcode_t *dest = CUR_OPCODE + 3;

    if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))) || (*(PMC **)OP_AS_OFFS(1))->vtable->base_type != enum_class_ResizableIntegerArray) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, dest,
            EXCEPTION_INVALID_OPERATION,
            "Must pass a valid integer array to 'local_branch'");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    return_addr = PTR2INTVAL(dest);
    VTABLE_push_integer(interp, (*(PMC **)OP_AS_OFFS(1)), return_addr);

    { cur_opcode += (*(INTVAL *)OP_AS_OFFS(2)); goto SWITCH_AGAIN; };
}

case 18: /* local_branch_p_ic */ {
#line 245 "src/ops/core.ops"
    INTVAL return_addr;
    opcode_t *dest = CUR_OPCODE + 3;

    if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))) || (*(PMC **)OP_AS_OFFS(1))->vtable->base_type != enum_class_ResizableIntegerArray) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, dest,
            EXCEPTION_INVALID_OPERATION,
            "Must pass a valid integer array to 'local_branch'");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    return_addr = PTR2INTVAL(dest);
    VTABLE_push_integer(interp, (*(PMC **)OP_AS_OFFS(1)), return_addr);

    { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };
}

case 19: /* local_return_p */ {
#line 268 "src/ops/core.ops"
    INTVAL return_addr;
    opcode_t *next;
    opcode_t *dest = CUR_OPCODE + 2;

    if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))) || (*(PMC **)OP_AS_OFFS(1))->vtable->base_type != enum_class_ResizableIntegerArray) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, dest,
            EXCEPTION_INVALID_OPERATION,
            "Must pass a valid integer array to 'local_return'");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    return_addr = VTABLE_pop_integer(interp, (*(PMC **)OP_AS_OFFS(1)));
    next = INTVAL2PTR(opcode_t *, return_addr);

    /* The return address must be within the current code segment. */
    if (! ( next >= interp->code->base.data
            && next < (interp->code->base.data + interp->code->base.size)) ) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, dest,
            EXCEPTION_INVALID_OPERATION,
            "Address for 'local_return' must be within the current code segment");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 20: /* jsr_i */ {
#line 306 "src/ops/core.ops"
    opcode_t * loc;
    stack_push(interp, &interp->dynamic_env,
             CUR_OPCODE + 2,  STACK_ENTRY_DESTINATION, STACK_CLEANUP_NULL);
    loc = INTVAL2PTR(opcode_t *, (*(INTVAL *)OP_AS_OFFS(1)));
                {
               cur_opcode = opcode_to_prederef(interp, loc);
               goto SWITCH_RELOAD;
            }
;
}

case 21: /* jsr_ic */ {
#line 306 "src/ops/core.ops"
    opcode_t * loc;
    stack_push(interp, &interp->dynamic_env,
             CUR_OPCODE + 2,  STACK_ENTRY_DESTINATION, STACK_CLEANUP_NULL);
    loc = INTVAL2PTR(opcode_t *, ((INTVAL)cur_opcode[1]));
                {
               cur_opcode = opcode_to_prederef(interp, loc);
               goto SWITCH_RELOAD;
            }
;
}

case 22: /* jump_i */ {
#line 322 "src/ops/core.ops"
    opcode_t * const loc = INTVAL2PTR(opcode_t *, (*(INTVAL *)OP_AS_OFFS(1)));
                {
               cur_opcode = opcode_to_prederef(interp, loc);
               goto SWITCH_RELOAD;
            }
;
}

case 23: /* jump_ic */ {
#line 322 "src/ops/core.ops"
    opcode_t * const loc = INTVAL2PTR(opcode_t *, ((INTVAL)cur_opcode[1]));
                {
               cur_opcode = opcode_to_prederef(interp, loc);
               goto SWITCH_RELOAD;
            }
;
}

case 24: /* enternative */ {
#line 335 "src/ops/core.ops"
    opcode_t * const addr = run_native(interp, CUR_OPCODE,
            interp->code->base.data);
                {
               cur_opcode = opcode_to_prederef(interp, addr);
               goto SWITCH_RELOAD;
            }
;
}

case 25: /* if_i_ic */ {
#line 370 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0)
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 26: /* if_n_ic */ {
#line 375 "src/ops/core.ops"
    if (!FLOAT_IS_ZERO((*(FLOATVAL *)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 27: /* if_s_ic */ {
#line 380 "src/ops/core.ops"
    if (string_bool(interp, (*(STRING **)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 28: /* if_p_ic */ {
#line 385 "src/ops/core.ops"
    if (VTABLE_get_bool(interp, (*(PMC **)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 29: /* unless_i_ic */ {
#line 404 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) == 0)
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 30: /* unless_n_ic */ {
#line 409 "src/ops/core.ops"
    if (FLOAT_IS_ZERO((*(FLOATVAL *)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 31: /* unless_s_ic */ {
#line 414 "src/ops/core.ops"
    if (!string_bool(interp, (*(STRING **)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 32: /* unless_p_ic */ {
#line 419 "src/ops/core.ops"
    if (!VTABLE_get_bool(interp, (*(PMC **)OP_AS_OFFS(1))))
        { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 33: /* invokecc_p */ {
#line 474 "src/ops/core.ops"
    PMC      * const p     = (*(PMC **)OP_AS_OFFS(1));
    opcode_t *dest         = CUR_OPCODE + 2;

    interp->current_object = NULL;
    interp->current_cont   = NEED_CONTINUATION;
    dest                   = (opcode_t *)VTABLE_invoke(interp, p, dest);

                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 34: /* invoke_p_p */ {
#line 485 "src/ops/core.ops"
    opcode_t *dest;
    PMC * const p = (*(PMC **)OP_AS_OFFS(1));

    interp->current_object = NULL;
    interp->current_cont = (*(PMC **)OP_AS_OFFS(2));
    dest = (opcode_t *)VTABLE_invoke(interp, p, CUR_OPCODE + 3);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 35: /* yield */ {
#line 495 "src/ops/core.ops"
    opcode_t *dest = CUR_OPCODE + 1;
    PMC * const p = CONTEXT(interp)->current_sub;
    dest = (opcode_t *)VTABLE_invoke(interp, p, dest);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 36: /* tailcall_p */ {
#line 502 "src/ops/core.ops"
    opcode_t *dest;
    PMC * const p = (*(PMC **)OP_AS_OFFS(1));
    dest = CUR_OPCODE + 2;
    interp->current_cont = CONTEXT(interp)->current_cont;
    PObj_get_FLAGS(interp->current_cont) |= SUB_FLAG_TAILCALL;
    dest = (opcode_t *)VTABLE_invoke(interp, p, dest);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 37: /* returncc */ {
#line 512 "src/ops/core.ops"
    PMC * const p = CONTEXT(interp)->current_cont;
    opcode_t * const dest = (opcode_t *)VTABLE_invoke(interp,
            p, CUR_OPCODE + 1);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 38: /* capture_lex_p */ {
#line 519 "src/ops/core.ops"
    Parrot_capture_lex(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 39: /* newclosure_p_p */ {
#line 523 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = parrot_new_closure(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 40: /* set_args_pc */ {
#line 561 "src/ops/core.ops"
    opcode_t * const _this = CUR_OPCODE;
    PMC * const signature = ((PMC *)cur_opcode[1]);
    INTVAL argc;

    /* for now just point to the opcode */
    interp->current_args = _this;
    argc = SIG_ELEMS(signature);
    { cur_opcode += argc + 2; goto SWITCH_AGAIN; };
}

case 41: /* get_results_pc */ {
#line 572 "src/ops/core.ops"
    opcode_t * const _this = CUR_OPCODE;
    PMC * const signature = ((PMC *)cur_opcode[1]);
    INTVAL argc;

    CONTEXT(interp)->current_results = _this;
    argc = SIG_ELEMS(signature);
    { cur_opcode += argc + 2; goto SWITCH_AGAIN; };
}

case 42: /* get_params_pc */ {
#line 582 "src/ops/core.ops"
    opcode_t * const _this = CUR_OPCODE;
    Parrot_Context *caller_ctx, *ctx;
    PMC * ccont;
    PMC * const signature = ((PMC *)cur_opcode[1]);
    INTVAL argc;
    opcode_t *src_indexes, *dst_indexes;

    interp->current_params = _this;
    ctx = CONTEXT(interp);
    ccont = ctx->current_cont;

    caller_ctx = ctx->caller_ctx;

    src_indexes = interp->current_args;
    dst_indexes = interp->current_params;
    /* the args and params are now 'used.' */
    interp->current_args = NULL;
    interp->current_params = NULL;

    parrot_pass_args(interp, caller_ctx, ctx, src_indexes, dst_indexes, PARROT_PASS_PARAMS);
    if (PObj_get_FLAGS(ccont) & SUB_FLAG_TAILCALL) {
        PObj_get_FLAGS(ccont) &= ~SUB_FLAG_TAILCALL;
        --ctx->recursion_depth;
        ctx->caller_ctx = caller_ctx->caller_ctx;
        /* ordinarily, this will free the context immediately, but not if the
           sub created a closure (or continuation, or . . .).  */
        Parrot_free_context(interp, caller_ctx, 1);
        interp->current_args = NULL;
    }
    argc = SIG_ELEMS(signature);
    { cur_opcode += argc + 2; goto SWITCH_AGAIN; };
}

case 43: /* set_returns_pc */ {
#line 616 "src/ops/core.ops"
    opcode_t * const _this = CUR_OPCODE;
    Parrot_Context *ctx;
    PMC *ccont;
    PMC *signature = ((PMC *)cur_opcode[1]);
    INTVAL argc;
    opcode_t *src_indexes, *dest_indexes;

    interp->current_returns = _this;
    ctx = CONTEXT(interp);
    ccont = ctx->current_cont;

    if (PMC_cont(ccont)->address) {
        /* Call is from runops_fromc */
        Parrot_Context * const caller_ctx = PMC_cont(ccont)->to_ctx;
        if (! caller_ctx) {
            /* there is no point calling Parrot_ex_throw_..., because
               PDB_backtrace can't deal with a missing to_ctx either. */
            exit_fatal(1, "No caller_ctx for continuation %p.", ccont);
        }

        src_indexes = interp->current_returns;
        dest_indexes = caller_ctx->current_results;
        interp->current_returns = NULL;
        /* does this need to be here */
        interp->current_args = NULL;

        parrot_pass_args(interp, ctx, caller_ctx, src_indexes, dest_indexes, PARROT_PASS_RESULTS);
    }
    else if (ctx->caller_ctx->results_signature) {
    /* We have a dynamic result signature, from pcc_invoke */
        parrot_pass_args(interp, ctx, ctx->caller_ctx, interp->current_returns,
                ctx->caller_ctx->current_results, PARROT_PASS_RESULTS);
    }
    argc = SIG_ELEMS(signature);
    { cur_opcode += argc + 2; goto SWITCH_AGAIN; };
}

case 44: /* result_info_p */ {
#line 663 "src/ops/core.ops"
    /* Get context of callee from return continuation. */
    PMC * const cc = CONTEXT(interp)->current_cont;
    PMC *sig = NULL;
    if (cc && PMC_cont(cc)->to_ctx) {
        /* caller context has results */
        opcode_t * const results = PMC_cont(cc)->to_ctx->current_results;
        if (results) {
            /* get results PMC index and get PMC. */
            sig = PF_CONST(PMC_cont(cc)->seg, results[1])->u.key;
        }
    }

    /* If no elements, hand back empty array; otherwise PMC. */
    if (!sig)
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_FixedIntegerArray);
    else
        (*(PMC **)OP_AS_OFFS(1)) = sig;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 45: /* set_addr_i_ic */ {
#line 711 "src/ops/core.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = PTR2OPCODE_T(CUR_OPCODE + ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 46: /* set_addr_p_ic */ {
#line 715 "src/ops/core.ops"
    VTABLE_set_pointer(interp, (*(PMC **)OP_AS_OFFS(1)), (CUR_OPCODE + ((INTVAL)cur_opcode[2])));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 47: /* set_addr_p_i */ {
#line 719 "src/ops/core.ops"
    VTABLE_set_pointer(interp, (*(PMC **)OP_AS_OFFS(1)), (void*)(*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 48: /* get_addr_i_p */ {
#line 723 "src/ops/core.ops"
    void *ptr = VTABLE_get_pointer(interp, (*(PMC **)OP_AS_OFFS(2)));
    (*(INTVAL *)OP_AS_OFFS(1))        = (INTVAL)ptr;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 49: /* schedule_p */ {
#line 743 "src/ops/core.ops"
    Parrot_cx_schedule_task(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 50: /* addhandler_p */ {
#line 752 "src/ops/core.ops"
    Parrot_cx_add_handler(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 51: /* push_eh_ic */ {
#line 829 "src/ops/core.ops"
    PMC * const eh = pmc_new(interp, enum_class_ExceptionHandler);
    VTABLE_set_pointer(interp, eh, CUR_OPCODE + ((INTVAL)cur_opcode[1]));
    Parrot_cx_add_handler_local(interp, eh);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 52: /* push_eh_p */ {
#line 835 "src/ops/core.ops"
    Parrot_cx_add_handler_local(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 53: /* pop_eh */ {
#line 839 "src/ops/core.ops"
    Parrot_cx_delete_handler_local(interp,
            string_from_cstring(interp, "exception", 9));

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 54: /* throw_p */ {
#line 844 "src/ops/core.ops"
    opcode_t *dest;
    opcode_t *const ret    = CUR_OPCODE + 2;
    PMC            *resume = new_ret_continuation_pmc(interp, ret);
    /*
     * We might return here after handling the exception, so mark the
     * current context appropriately.
     */
    Parrot_context_ref(interp, CONTEXT(interp));
    VTABLE_set_attr_str(interp, (*(PMC **)OP_AS_OFFS(1)), const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, (*(PMC **)OP_AS_OFFS(1)), ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 55: /* throw_p_p */ {
#line 858 "src/ops/core.ops"
    opcode_t * const dest = Parrot_ex_throw_from_op(interp, (*(PMC **)OP_AS_OFFS(1)),
                                VTABLE_get_pointer(interp, (*(PMC **)OP_AS_OFFS(2))));
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 56: /* rethrow_p */ {
#line 864 "src/ops/core.ops"
    opcode_t * const dest = Parrot_ex_rethrow_from_op(interp, (*(PMC **)OP_AS_OFFS(1)));
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 57: /* count_eh_i */ {
#line 869 "src/ops/core.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_cx_count_handlers_typed(interp,
            string_from_cstring(interp, "exception", 9));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 58: /* die_s */ {
#line 874 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    PMC             *exception = Parrot_ex_build_exception(interp, EXCEPT_error,
                                    CONTROL_ERROR, (*(STRING **)OP_AS_OFFS(1)));

    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 59: /* die_sc */ {
#line 874 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    PMC             *exception = Parrot_ex_build_exception(interp, EXCEPT_error,
                                    CONTROL_ERROR, ((STRING *)cur_opcode[1]));

    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 60: /* die_p */ {
#line 887 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    STRING          *msg       = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1)))
                               ? NULL : VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1)));
    PMC             *exception =
        Parrot_ex_build_exception(interp, EXCEPT_error, CONTROL_ERROR, msg);

    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 61: /* die_pc */ {
#line 887 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    STRING          *msg       = PMC_IS_NULL(((PMC *)cur_opcode[1]))
                               ? NULL : VTABLE_get_string(interp, ((PMC *)cur_opcode[1]));
    PMC             *exception =
        Parrot_ex_build_exception(interp, EXCEPT_error, CONTROL_ERROR, msg);

    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 62: /* die_i_i */ {
#line 902 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) == EXCEPT_doomed)
        _exit((*(INTVAL *)OP_AS_OFFS(2)));
    else {
        opcode_t * const ret       = CUR_OPCODE + 3;
        PMC             *resume    = new_ret_continuation_pmc(interp, ret);
        PMC             *exception = Parrot_ex_build_exception(interp, (*(INTVAL *)OP_AS_OFFS(1)),
                                                               (*(INTVAL *)OP_AS_OFFS(2)), NULL);
        opcode_t * const dest      = Parrot_ex_throw_from_op(interp,
                                                             exception, ret);
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
}

case 63: /* die_ic_i */ {
#line 902 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) == EXCEPT_doomed)
        _exit((*(INTVAL *)OP_AS_OFFS(2)));
    else {
        opcode_t * const ret       = CUR_OPCODE + 3;
        PMC             *resume    = new_ret_continuation_pmc(interp, ret);
        PMC             *exception = Parrot_ex_build_exception(interp, ((INTVAL)cur_opcode[1]),
                                                               (*(INTVAL *)OP_AS_OFFS(2)), NULL);
        opcode_t * const dest      = Parrot_ex_throw_from_op(interp,
                                                             exception, ret);
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
}

case 64: /* die_i_ic */ {
#line 902 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) == EXCEPT_doomed)
        _exit(((INTVAL)cur_opcode[2]));
    else {
        opcode_t * const ret       = CUR_OPCODE + 3;
        PMC             *resume    = new_ret_continuation_pmc(interp, ret);
        PMC             *exception = Parrot_ex_build_exception(interp, (*(INTVAL *)OP_AS_OFFS(1)),
                                                               ((INTVAL)cur_opcode[2]), NULL);
        opcode_t * const dest      = Parrot_ex_throw_from_op(interp,
                                                             exception, ret);
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
}

case 65: /* die_ic_ic */ {
#line 902 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) == EXCEPT_doomed)
        _exit(((INTVAL)cur_opcode[2]));
    else {
        opcode_t * const ret       = CUR_OPCODE + 3;
        PMC             *resume    = new_ret_continuation_pmc(interp, ret);
        PMC             *exception = Parrot_ex_build_exception(interp, ((INTVAL)cur_opcode[1]),
                                                               ((INTVAL)cur_opcode[2]), NULL);
        opcode_t * const dest      = Parrot_ex_throw_from_op(interp,
                                                             exception, ret);
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
}

case 66: /* exit_i */ {
#line 916 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    PMC             *exception = Parrot_ex_build_exception(interp, EXCEPT_exit,
                                                      (*(INTVAL *)OP_AS_OFFS(1)), NULL);
    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 67: /* exit_ic */ {
#line 916 "src/ops/core.ops"
    opcode_t        *dest;
    opcode_t * const ret       = CUR_OPCODE + 2;
    PMC             *resume    = new_ret_continuation_pmc(interp, ret);
    PMC             *exception = Parrot_ex_build_exception(interp, EXCEPT_exit,
                                                      ((INTVAL)cur_opcode[1]), NULL);
    VTABLE_set_attr_str(interp, exception,
                        const_string(interp, "resume"), resume);
    dest = Parrot_ex_throw_from_op(interp, exception, ret);
                {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 68: /* pushmark_i */ {
#line 928 "src/ops/core.ops"
    Parrot_push_mark(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 69: /* pushmark_ic */ {
#line 928 "src/ops/core.ops"
    Parrot_push_mark(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 70: /* popmark_i */ {
#line 932 "src/ops/core.ops"
    Parrot_pop_mark(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 71: /* popmark_ic */ {
#line 932 "src/ops/core.ops"
    Parrot_pop_mark(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 72: /* pushaction_p */ {
#line 936 "src/ops/core.ops"
    Parrot_push_action(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 73: /* debug_i */ {
#line 963 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0) { Interp_debug_SET(interp,   (*(INTVAL *)OP_AS_OFFS(1))); }
    else         { Interp_debug_CLEAR(interp, PARROT_ALL_DEBUG_FLAGS); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 74: /* debug_ic */ {
#line 963 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) != 0) { Interp_debug_SET(interp,   ((INTVAL)cur_opcode[1])); }
    else         { Interp_debug_CLEAR(interp, PARROT_ALL_DEBUG_FLAGS); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 75: /* bounds_i */ {
#line 978 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0) { Parrot_set_flag(interp,   PARROT_BOUNDS_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_BOUNDS_FLAG); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 76: /* bounds_ic */ {
#line 978 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) != 0) { Parrot_set_flag(interp,   PARROT_BOUNDS_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_BOUNDS_FLAG); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 77: /* profile_i */ {
#line 993 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0) { Parrot_set_flag(interp,   PARROT_PROFILE_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_PROFILE_FLAG); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 78: /* profile_ic */ {
#line 993 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) != 0) { Parrot_set_flag(interp,   PARROT_PROFILE_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_PROFILE_FLAG); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 79: /* trace_i */ {
#line 1008 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0) { Parrot_set_trace(interp,   (*(INTVAL *)OP_AS_OFFS(1))); }
    else         { Parrot_clear_trace(interp, PARROT_ALL_TRACE_FLAGS); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 80: /* trace_ic */ {
#line 1008 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) != 0) { Parrot_set_trace(interp,   ((INTVAL)cur_opcode[1])); }
    else         { Parrot_clear_trace(interp, PARROT_ALL_TRACE_FLAGS); }
    interp->resume_offset = REL_PC + 2; interp->resume_flag = 1; return (0);;
}

case 81: /* gc_debug_i */ {
#line 1022 "src/ops/core.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) != 0) { Interp_flags_SET(interp,   PARROT_GC_DEBUG_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_GC_DEBUG_FLAG); }

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 82: /* gc_debug_ic */ {
#line 1022 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]) != 0) { Interp_flags_SET(interp,   PARROT_GC_DEBUG_FLAG); }
    else         { Interp_flags_CLEAR(interp, PARROT_GC_DEBUG_FLAG); }

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 83: /* interpinfo_i_i */ {
#line 1056 "src/ops/core.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = interpinfo(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 84: /* interpinfo_i_ic */ {
#line 1056 "src/ops/core.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = interpinfo(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 85: /* interpinfo_p_i */ {
#line 1060 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = interpinfo_p(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 86: /* interpinfo_p_ic */ {
#line 1060 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = interpinfo_p(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 87: /* interpinfo_s_i */ {
#line 1064 "src/ops/core.ops"
    (*(STRING **)OP_AS_OFFS(1)) = interpinfo_s(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 88: /* interpinfo_s_ic */ {
#line 1064 "src/ops/core.ops"
    (*(STRING **)OP_AS_OFFS(1)) = interpinfo_s(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 89: /* warningson_i */ {
#line 1083 "src/ops/core.ops"
    PARROT_WARNINGS_on(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 90: /* warningson_ic */ {
#line 1083 "src/ops/core.ops"
    PARROT_WARNINGS_on(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 91: /* warningsoff_i */ {
#line 1095 "src/ops/core.ops"
    PARROT_WARNINGS_off(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 92: /* warningsoff_ic */ {
#line 1095 "src/ops/core.ops"
    PARROT_WARNINGS_off(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 93: /* errorson_i */ {
#line 1130 "src/ops/core.ops"
    PARROT_ERRORS_on(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 94: /* errorson_ic */ {
#line 1130 "src/ops/core.ops"
    PARROT_ERRORS_on(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 95: /* errorsoff_i */ {
#line 1142 "src/ops/core.ops"
    PARROT_ERRORS_off(interp, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 96: /* errorsoff_ic */ {
#line 1142 "src/ops/core.ops"
    PARROT_ERRORS_off(interp, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 97: /* runinterp_p_i */ {
#line 1158 "src/ops/core.ops"
    Interp * const new_interp = (Interp *)PMC_data((*(PMC **)OP_AS_OFFS(1)));
    Interp_flags_SET(new_interp, PARROT_EXTERN_CODE_FLAG);
    new_interp->code = interp->code;
    runops(new_interp, REL_PC + (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 98: /* runinterp_p_ic */ {
#line 1158 "src/ops/core.ops"
    Interp * const new_interp = (Interp *)PMC_data((*(PMC **)OP_AS_OFFS(1)));
    Interp_flags_SET(new_interp, PARROT_EXTERN_CODE_FLAG);
    new_interp->code = interp->code;
    runops(new_interp, REL_PC + ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 99: /* getinterp_p */ {
#line 1165 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed_int(interp, interp->iglobals,
           IGLOBALS_INTERPRETER);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 100: /* sweep_ic */ {
#line 1209 "src/ops/core.ops"
    if (((INTVAL)cur_opcode[1]))
        Parrot_do_dod_run(interp, 0);
    else
        if (interp->arena_base->num_early_DOD_PMCs)
            Parrot_do_dod_run(interp, GC_lazy_FLAG);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 101: /* collect */ {
#line 1223 "src/ops/core.ops"
    Parrot_go_collect(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 102: /* sweepoff */ {
#line 1233 "src/ops/core.ops"
    Parrot_block_GC_mark(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 103: /* sweepon */ {
#line 1243 "src/ops/core.ops"
    Parrot_unblock_GC_mark(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 104: /* collectoff */ {
#line 1253 "src/ops/core.ops"
    Parrot_block_GC_sweep(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 105: /* collecton */ {
#line 1263 "src/ops/core.ops"
    Parrot_unblock_GC_sweep(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 106: /* needs_destroy_p */ {
#line 1274 "src/ops/core.ops"
     PObj_needs_early_DOD_SET((*(PMC **)OP_AS_OFFS(1)));
     ++interp->arena_base->num_early_DOD_PMCs;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 107: /* loadlib_p_s */ {
#line 1330 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_load_lib(interp, (*(STRING **)OP_AS_OFFS(2)), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 108: /* loadlib_p_sc */ {
#line 1330 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_load_lib(interp, ((STRING *)cur_opcode[2]), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 109: /* dlfunc_p_p_s_s */ {
#line 1334 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, ((*(STRING **)OP_AS_OFFS(3))));
    void * const ptr  = Parrot_dlsym(
                            PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL :
                            VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(2))) ? PMC_data((*(PMC **)OP_AS_OFFS(2))) :
                            NULL,
                            name);

    funcptr_t p = D2FPTR(ptr);

    if (p == NULLfunc) {
        const char * err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_NCI);
        VTABLE_set_pointer_keyed_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(4)), F2DPTR(p));
        PObj_get_FLAGS((*(PMC **)OP_AS_OFFS(1))) |= PObj_private1_FLAG;
    }
    string_cstring_free(name);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 110: /* dlfunc_p_p_sc_s */ {
#line 1334 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, (((STRING *)cur_opcode[3])));
    void * const ptr  = Parrot_dlsym(
                            PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL :
                            VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(2))) ? PMC_data((*(PMC **)OP_AS_OFFS(2))) :
                            NULL,
                            name);

    funcptr_t p = D2FPTR(ptr);

    if (p == NULLfunc) {
        const char * err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_NCI);
        VTABLE_set_pointer_keyed_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(4)), F2DPTR(p));
        PObj_get_FLAGS((*(PMC **)OP_AS_OFFS(1))) |= PObj_private1_FLAG;
    }
    string_cstring_free(name);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 111: /* dlfunc_p_p_s_sc */ {
#line 1334 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, ((*(STRING **)OP_AS_OFFS(3))));
    void * const ptr  = Parrot_dlsym(
                            PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL :
                            VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(2))) ? PMC_data((*(PMC **)OP_AS_OFFS(2))) :
                            NULL,
                            name);

    funcptr_t p = D2FPTR(ptr);

    if (p == NULLfunc) {
        const char * err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_NCI);
        VTABLE_set_pointer_keyed_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[4]), F2DPTR(p));
        PObj_get_FLAGS((*(PMC **)OP_AS_OFFS(1))) |= PObj_private1_FLAG;
    }
    string_cstring_free(name);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 112: /* dlfunc_p_p_sc_sc */ {
#line 1334 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, (((STRING *)cur_opcode[3])));
    void * const ptr  = Parrot_dlsym(
                            PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL :
                            VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(2))) ? PMC_data((*(PMC **)OP_AS_OFFS(2))) :
                            NULL,
                            name);

    funcptr_t p = D2FPTR(ptr);

    if (p == NULLfunc) {
        const char * err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_NCI);
        VTABLE_set_pointer_keyed_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[4]), F2DPTR(p));
        PObj_get_FLAGS((*(PMC **)OP_AS_OFFS(1))) |= PObj_private1_FLAG;
    }
    string_cstring_free(name);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 113: /* dlvar_p_p_s */ {
#line 1358 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, ((*(STRING **)OP_AS_OFFS(3))));
    void * const p = Parrot_dlsym(PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL : PMC_data((*(PMC **)OP_AS_OFFS(2))), name);
    if (p == NULL) {
        const char * const err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        /* At this point we have the symbol's address. We just need to build
           a PMC with it so we can get and set the value */
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data((*(PMC **)OP_AS_OFFS(1))) = p;
    }
    string_cstring_free(name);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 114: /* dlvar_p_p_sc */ {
#line 1358 "src/ops/core.ops"
    char * const name = string_to_cstring(interp, (((STRING *)cur_opcode[3])));
    void * const p = Parrot_dlsym(PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? NULL : PMC_data((*(PMC **)OP_AS_OFFS(2))), name);
    if (p == NULL) {
        const char * const err = Parrot_dlerror();
        Parrot_warn(interp, PARROT_WARNINGS_UNDEF_FLAG,
                "Symbol '%s' not found: %s\n", name, err ? err : "unknown reason");
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);
    }
    else {
        /* At this point we have the symbol's address. We just need to build
           a PMC with it so we can get and set the value */
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data((*(PMC **)OP_AS_OFFS(1))) = p;
    }
    string_cstring_free(name);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 115: /* compreg_s_p */ {
#line 1376 "src/ops/core.ops"
    PMC * const compreg_hash = VTABLE_get_pmc_keyed_int(interp,
            interp->iglobals, IGLOBALS_COMPREG_HASH);
    VTABLE_set_pmc_keyed_str(interp, compreg_hash, (*(STRING **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 116: /* compreg_sc_p */ {
#line 1376 "src/ops/core.ops"
    PMC * const compreg_hash = VTABLE_get_pmc_keyed_int(interp,
            interp->iglobals, IGLOBALS_COMPREG_HASH);
    VTABLE_set_pmc_keyed_str(interp, compreg_hash, ((STRING *)cur_opcode[1]), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 117: /* compreg_p_s */ {
#line 1382 "src/ops/core.ops"
    PMC * const compreg_hash = VTABLE_get_pmc_keyed_int(interp,
            interp->iglobals, IGLOBALS_COMPREG_HASH);
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed_str(interp, compreg_hash, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 118: /* compreg_p_sc */ {
#line 1382 "src/ops/core.ops"
    PMC * const compreg_hash = VTABLE_get_pmc_keyed_int(interp,
            interp->iglobals, IGLOBALS_COMPREG_HASH);
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed_str(interp, compreg_hash, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 119: /* new_callback_p_p_p_s */ {
#line 1388 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_make_cb(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(STRING **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 120: /* new_callback_p_p_p_sc */ {
#line 1388 "src/ops/core.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_make_cb(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), ((STRING *)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 121: /* annotations_p */ {
#line 1415 "src/ops/core.ops"
    if (interp->code->annotations) {
        opcode_t const cur_pos = (CUR_OPCODE + 2) - interp->code->base.data;
        (*(PMC **)OP_AS_OFFS(1)) = PackFile_Annotations_lookup(interp, interp->code->annotations,
                cur_pos, NULL);
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Hash);
    }
    { cur_opcode += 2; goto SWITCH_AGAIN; };

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 122: /* annotations_p_s */ {
#line 1434 "src/ops/core.ops"
    if (interp->code->annotations) {
        opcode_t const cur_pos = (CUR_OPCODE + 3) - interp->code->base.data;
        (*(PMC **)OP_AS_OFFS(1)) = PackFile_Annotations_lookup(interp, interp->code->annotations,
                cur_pos, (*(STRING **)OP_AS_OFFS(2)));
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    { cur_opcode += 3; goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 123: /* annotations_p_sc */ {
#line 1434 "src/ops/core.ops"
    if (interp->code->annotations) {
        opcode_t const cur_pos = (CUR_OPCODE + 3) - interp->code->base.data;
        (*(PMC **)OP_AS_OFFS(1)) = PackFile_Annotations_lookup(interp, interp->code->annotations,
                cur_pos, ((STRING *)cur_opcode[2]));
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    { cur_opcode += 3; goto SWITCH_AGAIN; };

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 124: /* band_i_i */ {
#line 61 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) &= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 125: /* band_i_ic */ {
#line 61 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) &= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 126: /* band_p_i */ {
#line 65 "src/ops/bit.ops"
      VTABLE_i_bitwise_and_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 127: /* band_p_ic */ {
#line 65 "src/ops/bit.ops"
      VTABLE_i_bitwise_and_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 128: /* band_p_p */ {
#line 69 "src/ops/bit.ops"
      VTABLE_i_bitwise_and(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 129: /* band_i_i_i */ {
#line 73 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) & (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 130: /* band_i_ic_i */ {
#line 73 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) & (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 131: /* band_i_i_ic */ {
#line 73 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) & ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 132: /* band_p_p_i */ {
#line 77 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_and_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 133: /* band_p_p_ic */ {
#line 77 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_and_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 134: /* band_p_p_p */ {
#line 81 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_and(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 135: /* bands_s_s */ {
#line 105 "src/ops/bit.ops"
  string_bitwise_and(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 136: /* bands_s_sc */ {
#line 105 "src/ops/bit.ops"
  string_bitwise_and(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 137: /* bands_p_s */ {
#line 109 "src/ops/bit.ops"
      VTABLE_i_bitwise_ands_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 138: /* bands_p_sc */ {
#line 109 "src/ops/bit.ops"
      VTABLE_i_bitwise_ands_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 139: /* bands_p_p */ {
#line 113 "src/ops/bit.ops"
      VTABLE_i_bitwise_ands(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 140: /* bands_s_s_s */ {
#line 117 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_and(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 141: /* bands_s_sc_s */ {
#line 117 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_and(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 142: /* bands_s_s_sc */ {
#line 117 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_and(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 143: /* bands_p_p_s */ {
#line 121 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ands_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 144: /* bands_p_p_sc */ {
#line 121 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ands_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 145: /* bands_p_p_p */ {
#line 125 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ands(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 146: /* bnot_i */ {
#line 143 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ~ (*(INTVAL *)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 147: /* bnot_i_i */ {
#line 147 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ~ (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 148: /* bnot_p */ {
#line 151 "src/ops/bit.ops"
  VTABLE_i_bitwise_not(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 149: /* bnot_p_p */ {
#line 155 "src/ops/bit.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_not(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 150: /* bnots_s */ {
#line 169 "src/ops/bit.ops"
  string_bitwise_not(interp, (*(STRING **)OP_AS_OFFS(1)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 151: /* bnots_s_s */ {
#line 173 "src/ops/bit.ops"
  string_bitwise_not(interp, (*(STRING **)OP_AS_OFFS(2)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 152: /* bnots_s_sc */ {
#line 173 "src/ops/bit.ops"
  string_bitwise_not(interp, ((STRING *)cur_opcode[2]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 153: /* bnots_p */ {
#line 177 "src/ops/bit.ops"
  VTABLE_i_bitwise_nots(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 154: /* bnots_p_p */ {
#line 181 "src/ops/bit.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_nots(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 155: /* bor_i_i */ {
#line 207 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) |= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 156: /* bor_i_ic */ {
#line 207 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) |= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 157: /* bor_p_i */ {
#line 211 "src/ops/bit.ops"
      VTABLE_i_bitwise_or_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 158: /* bor_p_ic */ {
#line 211 "src/ops/bit.ops"
      VTABLE_i_bitwise_or_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 159: /* bor_p_p */ {
#line 215 "src/ops/bit.ops"
      VTABLE_i_bitwise_or(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 160: /* bor_i_i_i */ {
#line 219 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) | (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 161: /* bor_i_ic_i */ {
#line 219 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) | (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 162: /* bor_i_i_ic */ {
#line 219 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) | ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 163: /* bor_p_p_i */ {
#line 223 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_or_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 164: /* bor_p_p_ic */ {
#line 223 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_or_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 165: /* bor_p_p_p */ {
#line 227 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_or(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 166: /* bors_s_s */ {
#line 251 "src/ops/bit.ops"
  string_bitwise_or(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 167: /* bors_s_sc */ {
#line 251 "src/ops/bit.ops"
  string_bitwise_or(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 168: /* bors_p_s */ {
#line 255 "src/ops/bit.ops"
      VTABLE_i_bitwise_ors_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 169: /* bors_p_sc */ {
#line 255 "src/ops/bit.ops"
      VTABLE_i_bitwise_ors_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 170: /* bors_p_p */ {
#line 259 "src/ops/bit.ops"
      VTABLE_i_bitwise_ors(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 171: /* bors_s_s_s */ {
#line 263 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_or(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 172: /* bors_s_sc_s */ {
#line 263 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_or(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 173: /* bors_s_s_sc */ {
#line 263 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_or(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 174: /* bors_p_p_s */ {
#line 267 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ors_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 175: /* bors_p_p_sc */ {
#line 267 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ors_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 176: /* bors_p_p_p */ {
#line 271 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_ors(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 177: /* shl_i_i */ {
#line 295 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 178: /* shl_i_ic */ {
#line 295 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 179: /* shl_p_i */ {
#line 299 "src/ops/bit.ops"
      VTABLE_i_bitwise_shl_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 180: /* shl_p_ic */ {
#line 299 "src/ops/bit.ops"
      VTABLE_i_bitwise_shl_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 181: /* shl_p_p */ {
#line 303 "src/ops/bit.ops"
      VTABLE_i_bitwise_shl(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 182: /* shl_i_i_i */ {
#line 307 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 183: /* shl_i_ic_i */ {
#line 307 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left(((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 184: /* shl_i_i_ic */ {
#line 307 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 185: /* shl_p_p_i */ {
#line 311 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shl_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 186: /* shl_p_p_ic */ {
#line 311 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shl_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 187: /* shl_p_p_p */ {
#line 315 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shl(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 188: /* shr_i_i */ {
#line 339 "src/ops/bit.ops"
  INTVAL signed_shift = -(*(INTVAL *)OP_AS_OFFS(2));
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(1)), signed_shift);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 189: /* shr_i_ic */ {
#line 339 "src/ops/bit.ops"
  INTVAL signed_shift = -((INTVAL)cur_opcode[2]);
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(1)), signed_shift);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 190: /* shr_p_i */ {
#line 344 "src/ops/bit.ops"
      VTABLE_i_bitwise_shr_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 191: /* shr_p_ic */ {
#line 344 "src/ops/bit.ops"
      VTABLE_i_bitwise_shr_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 192: /* shr_p_p */ {
#line 348 "src/ops/bit.ops"
      VTABLE_i_bitwise_shr(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 193: /* shr_i_i_i */ {
#line 352 "src/ops/bit.ops"
  INTVAL signed_shift = -(*(INTVAL *)OP_AS_OFFS(3));
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(2)), signed_shift);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 194: /* shr_i_ic_i */ {
#line 352 "src/ops/bit.ops"
  INTVAL signed_shift = -(*(INTVAL *)OP_AS_OFFS(3));
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left(((INTVAL)cur_opcode[2]), signed_shift);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 195: /* shr_i_i_ic */ {
#line 352 "src/ops/bit.ops"
  INTVAL signed_shift = -((INTVAL)cur_opcode[3]);
  (*(INTVAL *)OP_AS_OFFS(1)) = bit_shift_left((*(INTVAL *)OP_AS_OFFS(2)), signed_shift);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 196: /* shr_p_p_i */ {
#line 357 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shr_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 197: /* shr_p_p_ic */ {
#line 357 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shr_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 198: /* shr_p_p_p */ {
#line 361 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_shr(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 199: /* lsr_i_i */ {
#line 385 "src/ops/bit.ops"
  /*
   * lvalue casts are evil, but this one isn't evil enough to kill.
   * it's just casting a signed integral to the equivalent unsigned.
   */
  LVALUE_CAST(UINTVAL, (*(INTVAL *)OP_AS_OFFS(1))) >>= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 200: /* lsr_i_ic */ {
#line 385 "src/ops/bit.ops"
  /*
   * lvalue casts are evil, but this one isn't evil enough to kill.
   * it's just casting a signed integral to the equivalent unsigned.
   */
  LVALUE_CAST(UINTVAL, (*(INTVAL *)OP_AS_OFFS(1))) >>= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 201: /* lsr_p_i */ {
#line 393 "src/ops/bit.ops"
      VTABLE_i_bitwise_lsr_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 202: /* lsr_p_ic */ {
#line 393 "src/ops/bit.ops"
      VTABLE_i_bitwise_lsr_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 203: /* lsr_p_p */ {
#line 397 "src/ops/bit.ops"
      VTABLE_i_bitwise_lsr(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 204: /* lsr_i_i_i */ {
#line 401 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)((UINTVAL)(*(INTVAL *)OP_AS_OFFS(2)) >> (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 205: /* lsr_i_ic_i */ {
#line 401 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)((UINTVAL)((INTVAL)cur_opcode[2]) >> (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 206: /* lsr_i_i_ic */ {
#line 401 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)((UINTVAL)(*(INTVAL *)OP_AS_OFFS(2)) >> ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 207: /* lsr_p_p_i */ {
#line 405 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_lsr_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 208: /* lsr_p_p_ic */ {
#line 405 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_lsr_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 209: /* lsr_p_p_p */ {
#line 409 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_lsr(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 210: /* rot_i_i_i_ic */ {
#line 422 "src/ops/bit.ops"
  const INTVAL r = (*(INTVAL *)OP_AS_OFFS(2));
  INTVAL s = (*(INTVAL *)OP_AS_OFFS(3));
  const INTVAL w = ((INTVAL)cur_opcode[4]);
  INTVAL d, t;
  if (s < 0)
    s += w;
  d = r << s;
  t = w - s;
  t = (INTVAL)((UINTVAL)r >> t);
  d |= t;
  (*(INTVAL *)OP_AS_OFFS(1)) = d;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 211: /* rot_i_ic_i_ic */ {
#line 422 "src/ops/bit.ops"
  const INTVAL r = ((INTVAL)cur_opcode[2]);
  INTVAL s = (*(INTVAL *)OP_AS_OFFS(3));
  const INTVAL w = ((INTVAL)cur_opcode[4]);
  INTVAL d, t;
  if (s < 0)
    s += w;
  d = r << s;
  t = w - s;
  t = (INTVAL)((UINTVAL)r >> t);
  d |= t;
  (*(INTVAL *)OP_AS_OFFS(1)) = d;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 212: /* rot_i_i_ic_ic */ {
#line 422 "src/ops/bit.ops"
  const INTVAL r = (*(INTVAL *)OP_AS_OFFS(2));
  INTVAL s = ((INTVAL)cur_opcode[3]);
  const INTVAL w = ((INTVAL)cur_opcode[4]);
  INTVAL d, t;
  if (s < 0)
    s += w;
  d = r << s;
  t = w - s;
  t = (INTVAL)((UINTVAL)r >> t);
  d |= t;
  (*(INTVAL *)OP_AS_OFFS(1)) = d;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 213: /* bxor_i_i */ {
#line 461 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) ^= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 214: /* bxor_i_ic */ {
#line 461 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) ^= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 215: /* bxor_p_i */ {
#line 465 "src/ops/bit.ops"
      VTABLE_i_bitwise_xor_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 216: /* bxor_p_ic */ {
#line 465 "src/ops/bit.ops"
      VTABLE_i_bitwise_xor_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 217: /* bxor_p_p */ {
#line 469 "src/ops/bit.ops"
      VTABLE_i_bitwise_xor(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 218: /* bxor_i_i_i */ {
#line 473 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ^ (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 219: /* bxor_i_ic_i */ {
#line 473 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) ^ (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 220: /* bxor_i_i_ic */ {
#line 473 "src/ops/bit.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ^ ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 221: /* bxor_p_p_i */ {
#line 477 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xor_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 222: /* bxor_p_p_ic */ {
#line 477 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xor_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 223: /* bxor_p_p_p */ {
#line 481 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xor(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 224: /* bxors_s_s */ {
#line 505 "src/ops/bit.ops"
  string_bitwise_xor(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 225: /* bxors_s_sc */ {
#line 505 "src/ops/bit.ops"
  string_bitwise_xor(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 226: /* bxors_p_s */ {
#line 509 "src/ops/bit.ops"
      VTABLE_i_bitwise_xors_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 227: /* bxors_p_sc */ {
#line 509 "src/ops/bit.ops"
      VTABLE_i_bitwise_xors_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 228: /* bxors_p_p */ {
#line 513 "src/ops/bit.ops"
      VTABLE_i_bitwise_xors(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 229: /* bxors_s_s_s */ {
#line 517 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_xor(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 230: /* bxors_s_sc_s */ {
#line 517 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_xor(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 231: /* bxors_s_s_sc */ {
#line 517 "src/ops/bit.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_bitwise_xor(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 232: /* bxors_p_p_s */ {
#line 521 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xors_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 233: /* bxors_p_p_sc */ {
#line 521 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xors_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 234: /* bxors_p_p_p */ {
#line 525 "src/ops/bit.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_bitwise_xors(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 235: /* eq_i_i_ic */ {
#line 68 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) == (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 236: /* eq_ic_i_ic */ {
#line 68 "src/ops/cmp.ops"
  if (((INTVAL)cur_opcode[1]) == (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 237: /* eq_i_ic_ic */ {
#line 68 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) == ((INTVAL)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 238: /* eq_n_n_ic */ {
#line 74 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) == (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 239: /* eq_nc_n_ic */ {
#line 74 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)cur_opcode[1]) == (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 240: /* eq_n_nc_ic */ {
#line 74 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) == (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 241: /* eq_s_s_ic */ {
#line 80 "src/ops/cmp.ops"
  if (string_equal(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2))) == 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 242: /* eq_sc_s_ic */ {
#line 80 "src/ops/cmp.ops"
  if (string_equal(interp, ((STRING *)cur_opcode[1]), (*(STRING **)OP_AS_OFFS(2))) == 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 243: /* eq_s_sc_ic */ {
#line 80 "src/ops/cmp.ops"
  if (string_equal(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2])) == 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 244: /* eq_p_p_ic */ {
#line 86 "src/ops/cmp.ops"
  if (VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 245: /* eq_p_i_ic */ {
#line 92 "src/ops/cmp.ops"
  PMC *temp = temporary_pmc_new(interp, enum_class_Integer);
  VTABLE_set_integer_native(interp, temp, (*(INTVAL *)OP_AS_OFFS(2)));

  if (VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), temp)) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 246: /* eq_p_ic_ic */ {
#line 92 "src/ops/cmp.ops"
  PMC *temp = temporary_pmc_new(interp, enum_class_Integer);
  VTABLE_set_integer_native(interp, temp, ((INTVAL)cur_opcode[2]));

  if (VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), temp)) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 247: /* eq_p_n_ic */ {
#line 104 "src/ops/cmp.ops"
  /*
   * the get_number and get_string should probably
   * be also replaced with code like above, as
   * overriding the compare multi subs wouldn't
   * have any effect with the current code
   */
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) == (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 248: /* eq_p_nc_ic */ {
#line 104 "src/ops/cmp.ops"
  /*
   * the get_number and get_string should probably
   * be also replaced with code like above, as
   * overriding the compare multi subs wouldn't
   * have any effect with the current code
   */
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) == (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 249: /* eq_p_s_ic */ {
#line 116 "src/ops/cmp.ops"
  if (0 == string_equal(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 250: /* eq_p_sc_ic */ {
#line 116 "src/ops/cmp.ops"
  if (0 == string_equal(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2]))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 251: /* eq_str_p_p_ic */ {
#line 123 "src/ops/cmp.ops"
  if (VTABLE_is_equal_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 252: /* eq_num_p_p_ic */ {
#line 129 "src/ops/cmp.ops"
  if (VTABLE_is_equal_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 253: /* eq_addr_s_s_ic */ {
#line 135 "src/ops/cmp.ops"
  if ((*(STRING **)OP_AS_OFFS(1)) == (*(STRING **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 254: /* eq_addr_sc_s_ic */ {
#line 135 "src/ops/cmp.ops"
  if (((STRING *)cur_opcode[1]) == (*(STRING **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 255: /* eq_addr_s_sc_ic */ {
#line 135 "src/ops/cmp.ops"
  if ((*(STRING **)OP_AS_OFFS(1)) == ((STRING *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 256: /* eq_addr_sc_sc_ic */ {
#line 135 "src/ops/cmp.ops"
  if (((STRING *)cur_opcode[1]) == ((STRING *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 257: /* eq_addr_p_p_ic */ {
#line 141 "src/ops/cmp.ops"
  if ((*(PMC **)OP_AS_OFFS(1)) == (*(PMC **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 258: /* ne_i_i_ic */ {
#line 175 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) != (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 259: /* ne_ic_i_ic */ {
#line 175 "src/ops/cmp.ops"
  if (((INTVAL)cur_opcode[1]) != (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 260: /* ne_i_ic_ic */ {
#line 175 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) != ((INTVAL)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 261: /* ne_n_n_ic */ {
#line 181 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) != (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 262: /* ne_nc_n_ic */ {
#line 181 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)cur_opcode[1]) != (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 263: /* ne_n_nc_ic */ {
#line 181 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) != (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 264: /* ne_s_s_ic */ {
#line 187 "src/ops/cmp.ops"
  if (string_equal(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2))) != 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 265: /* ne_sc_s_ic */ {
#line 187 "src/ops/cmp.ops"
  if (string_equal(interp, ((STRING *)cur_opcode[1]), (*(STRING **)OP_AS_OFFS(2))) != 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 266: /* ne_s_sc_ic */ {
#line 187 "src/ops/cmp.ops"
  if (string_equal(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2])) != 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 267: /* ne_p_p_ic */ {
#line 193 "src/ops/cmp.ops"
  if (!VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 268: /* ne_p_i_ic */ {
#line 199 "src/ops/cmp.ops"
  PMC *temp = temporary_pmc_new(interp, enum_class_Integer);
  VTABLE_set_integer_native(interp, temp, (*(INTVAL *)OP_AS_OFFS(2)));

  if (!VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), temp)) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 269: /* ne_p_ic_ic */ {
#line 199 "src/ops/cmp.ops"
  PMC *temp = temporary_pmc_new(interp, enum_class_Integer);
  VTABLE_set_integer_native(interp, temp, ((INTVAL)cur_opcode[2]));

  if (!VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(1)), temp)) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 270: /* ne_p_n_ic */ {
#line 211 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) != (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 271: /* ne_p_nc_ic */ {
#line 211 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) != (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 272: /* ne_p_s_ic */ {
#line 217 "src/ops/cmp.ops"
  if (0 != string_equal(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2)))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 273: /* ne_p_sc_ic */ {
#line 217 "src/ops/cmp.ops"
  if (0 != string_equal(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2]))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 274: /* ne_str_p_p_ic */ {
#line 224 "src/ops/cmp.ops"
  if (VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) != 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 275: /* ne_num_p_p_ic */ {
#line 230 "src/ops/cmp.ops"
  if (VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) != 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 276: /* ne_addr_s_s_ic */ {
#line 236 "src/ops/cmp.ops"
  if ((*(STRING **)OP_AS_OFFS(1)) != (*(STRING **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 277: /* ne_addr_sc_s_ic */ {
#line 236 "src/ops/cmp.ops"
  if (((STRING *)cur_opcode[1]) != (*(STRING **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 278: /* ne_addr_s_sc_ic */ {
#line 236 "src/ops/cmp.ops"
  if ((*(STRING **)OP_AS_OFFS(1)) != ((STRING *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 279: /* ne_addr_sc_sc_ic */ {
#line 236 "src/ops/cmp.ops"
  if (((STRING *)cur_opcode[1]) != ((STRING *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 280: /* ne_addr_p_p_ic */ {
#line 242 "src/ops/cmp.ops"
  if ((*(PMC **)OP_AS_OFFS(1)) != (*(PMC **)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 281: /* lt_i_i_ic */ {
#line 272 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) < (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 282: /* lt_ic_i_ic */ {
#line 272 "src/ops/cmp.ops"
  if (((INTVAL)cur_opcode[1]) < (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 283: /* lt_i_ic_ic */ {
#line 272 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) < ((INTVAL)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 284: /* lt_n_n_ic */ {
#line 278 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) < (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 285: /* lt_nc_n_ic */ {
#line 278 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)cur_opcode[1]) < (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 286: /* lt_n_nc_ic */ {
#line 278 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) < (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 287: /* lt_s_s_ic */ {
#line 284 "src/ops/cmp.ops"
  if (string_compare(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 288: /* lt_sc_s_ic */ {
#line 284 "src/ops/cmp.ops"
  if (string_compare(interp, ((STRING *)cur_opcode[1]), (*(STRING **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 289: /* lt_s_sc_ic */ {
#line 284 "src/ops/cmp.ops"
  if (string_compare(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2])) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 290: /* lt_p_p_ic */ {
#line 290 "src/ops/cmp.ops"
  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 291: /* lt_p_i_ic */ {
#line 296 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = (*(INTVAL *)OP_AS_OFFS(2));

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) < 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 292: /* lt_p_ic_ic */ {
#line 296 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = ((INTVAL)cur_opcode[2]);

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) < 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 293: /* lt_p_n_ic */ {
#line 308 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) < (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 294: /* lt_p_nc_ic */ {
#line 308 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) < (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 295: /* lt_p_s_ic */ {
#line 314 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 296: /* lt_p_sc_ic */ {
#line 314 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2])) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 297: /* lt_str_p_p_ic */ {
#line 321 "src/ops/cmp.ops"
  if (VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 298: /* lt_num_p_p_ic */ {
#line 327 "src/ops/cmp.ops"
  if (VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) < 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 299: /* le_i_i_ic */ {
#line 357 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) <= (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

    default:
    switch (*(opcode_t*)cur_opcode) {
case 300: /* le_ic_i_ic */ {
#line 357 "src/ops/cmp.ops"
  if (((INTVAL)cur_opcode[1]) <= (*(INTVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 301: /* le_i_ic_ic */ {
#line 357 "src/ops/cmp.ops"
  if ((*(INTVAL *)OP_AS_OFFS(1)) <= ((INTVAL)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 302: /* le_n_n_ic */ {
#line 363 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) <= (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 303: /* le_nc_n_ic */ {
#line 363 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)cur_opcode[1]) <= (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 304: /* le_n_nc_ic */ {
#line 363 "src/ops/cmp.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) <= (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 305: /* le_s_s_ic */ {
#line 369 "src/ops/cmp.ops"
  if (string_compare(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 306: /* le_sc_s_ic */ {
#line 369 "src/ops/cmp.ops"
  if (string_compare(interp, ((STRING *)cur_opcode[1]), (*(STRING **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 307: /* le_s_sc_ic */ {
#line 369 "src/ops/cmp.ops"
  if (string_compare(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2])) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 308: /* le_p_p_ic */ {
#line 375 "src/ops/cmp.ops"
  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 309: /* le_p_i_ic */ {
#line 381 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = (*(INTVAL *)OP_AS_OFFS(2));

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) <= 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 310: /* le_p_ic_ic */ {
#line 381 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = ((INTVAL)cur_opcode[2]);

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) <= 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 311: /* le_p_n_ic */ {
#line 393 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) <= (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 312: /* le_p_nc_ic */ {
#line 393 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) <= (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 313: /* le_p_s_ic */ {
#line 399 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 314: /* le_p_sc_ic */ {
#line 399 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2])) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 315: /* le_str_p_p_ic */ {
#line 406 "src/ops/cmp.ops"
  if (VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 316: /* le_num_p_p_ic */ {
#line 412 "src/ops/cmp.ops"
  if (VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) <= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 317: /* gt_p_p_ic */ {
#line 436 "src/ops/cmp.ops"
  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) > 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 318: /* gt_p_i_ic */ {
#line 442 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = (*(INTVAL *)OP_AS_OFFS(2));

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) > 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 319: /* gt_p_ic_ic */ {
#line 442 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = ((INTVAL)cur_opcode[2]);

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) > 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 320: /* gt_p_n_ic */ {
#line 454 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) > (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 321: /* gt_p_nc_ic */ {
#line 454 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) > (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 322: /* gt_p_s_ic */ {
#line 460 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2))) > 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 323: /* gt_p_sc_ic */ {
#line 460 "src/ops/cmp.ops"
  if (string_compare(interp,
      VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2])) > 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 324: /* gt_str_p_p_ic */ {
#line 467 "src/ops/cmp.ops"
  if (VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) > 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 325: /* gt_num_p_p_ic */ {
#line 473 "src/ops/cmp.ops"
  if (VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) > 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 326: /* ge_p_p_ic */ {
#line 497 "src/ops/cmp.ops"
  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) >= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 327: /* ge_p_i_ic */ {
#line 503 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = (*(INTVAL *)OP_AS_OFFS(2));

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) >= 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 328: /* ge_p_ic_ic */ {
#line 503 "src/ops/cmp.ops"
  PMC *temp         = temporary_pmc_new(interp, enum_class_Integer);
  PMC_int_val(temp) = ((INTVAL)cur_opcode[2]);

  if (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(1)), temp) >= 0) {
    temporary_pmc_free(interp, temp);
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

  temporary_pmc_free(interp, temp);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 329: /* ge_p_n_ic */ {
#line 515 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) >= (*(FLOATVAL *)OP_AS_OFFS(2))) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 330: /* ge_p_nc_ic */ {
#line 515 "src/ops/cmp.ops"
  if (VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(1))) >= (*(FLOATVAL *)cur_opcode[2])) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 331: /* ge_p_s_ic */ {
#line 521 "src/ops/cmp.ops"
  if (string_compare(interp, VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), (*(STRING **)OP_AS_OFFS(2))) >= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 332: /* ge_p_sc_ic */ {
#line 521 "src/ops/cmp.ops"
  if (string_compare(interp, VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(1))), ((STRING *)cur_opcode[2])) >= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 333: /* ge_str_p_p_ic */ {
#line 527 "src/ops/cmp.ops"
  if (VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) >= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 334: /* ge_num_p_p_ic */ {
#line 533 "src/ops/cmp.ops"
  if (VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2))) >= 0) {
    { cur_opcode += ((INTVAL)cur_opcode[3]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 335: /* if_null_p_ic */ {
#line 551 "src/ops/cmp.ops"
  if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1)))) {
    { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 336: /* if_null_s_ic */ {
#line 557 "src/ops/cmp.ops"
  if (!(*(STRING **)OP_AS_OFFS(1))) {
    { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 337: /* unless_null_p_ic */ {
#line 575 "src/ops/cmp.ops"
  if (!PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1)))) {
    { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 338: /* unless_null_s_ic */ {
#line 581 "src/ops/cmp.ops"
  if ((*(STRING **)OP_AS_OFFS(1))) {
    { cur_opcode += ((INTVAL)cur_opcode[2]); goto SWITCH_AGAIN; };
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 339: /* cmp_i_i_i */ {
#line 623 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) < (*(INTVAL *)OP_AS_OFFS(3)) ? -1 :
       (*(INTVAL *)OP_AS_OFFS(2)) > (*(INTVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 340: /* cmp_i_ic_i */ {
#line 623 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) < (*(INTVAL *)OP_AS_OFFS(3)) ? -1 :
       ((INTVAL)cur_opcode[2]) > (*(INTVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 341: /* cmp_i_i_ic */ {
#line 623 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) < ((INTVAL)cur_opcode[3]) ? -1 :
       (*(INTVAL *)OP_AS_OFFS(2)) > ((INTVAL)cur_opcode[3]) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 342: /* cmp_i_n_n */ {
#line 629 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) < (*(FLOATVAL *)OP_AS_OFFS(3)) ? -1 :
       (*(FLOATVAL *)OP_AS_OFFS(2)) > (*(FLOATVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 343: /* cmp_i_nc_n */ {
#line 629 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) < (*(FLOATVAL *)OP_AS_OFFS(3)) ? -1 :
       (*(FLOATVAL *)cur_opcode[2]) > (*(FLOATVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 344: /* cmp_i_n_nc */ {
#line 629 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) < (*(FLOATVAL *)cur_opcode[3]) ? -1 :
       (*(FLOATVAL *)OP_AS_OFFS(2)) > (*(FLOATVAL *)cur_opcode[3]) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 345: /* cmp_i_s_s */ {
#line 635 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 346: /* cmp_i_sc_s */ {
#line 635 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 347: /* cmp_i_s_sc */ {
#line 635 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 348: /* cmp_i_p_p */ {
#line 639 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 349: /* cmp_i_p_i */ {
#line 643 "src/ops/cmp.ops"
  INTVAL l = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = l < (*(INTVAL *)OP_AS_OFFS(3)) ? -1 :
       l > (*(INTVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 350: /* cmp_i_p_ic */ {
#line 643 "src/ops/cmp.ops"
  INTVAL l = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = l < ((INTVAL)cur_opcode[3]) ? -1 :
       l > ((INTVAL)cur_opcode[3]) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 351: /* cmp_i_p_n */ {
#line 650 "src/ops/cmp.ops"
  FLOATVAL l = VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = l < (*(FLOATVAL *)OP_AS_OFFS(3)) ? -1 :
       l > (*(FLOATVAL *)OP_AS_OFFS(3)) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 352: /* cmp_i_p_nc */ {
#line 650 "src/ops/cmp.ops"
  FLOATVAL l = VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = l < (*(FLOATVAL *)cur_opcode[3]) ? -1 :
       l > (*(FLOATVAL *)cur_opcode[3]) ? +1 :
       0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 353: /* cmp_i_p_s */ {
#line 657 "src/ops/cmp.ops"
  STRING* l = VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, l, (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 354: /* cmp_i_p_sc */ {
#line 657 "src/ops/cmp.ops"
  STRING* l = VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, l, ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 355: /* cmp_str_i_p_p */ {
#line 662 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_cmp_string(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 356: /* cmp_num_i_p_p */ {
#line 666 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_cmp_num(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 357: /* issame_i_p_p */ {
#line 699 "src/ops/cmp.ops"
    if ((*(PMC **)OP_AS_OFFS(2)) == (*(PMC **)OP_AS_OFFS(3)))
        (*(INTVAL *)OP_AS_OFFS(1)) = 1;
    else
        (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_is_same(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 358: /* issame_i_s_s */ {
#line 706 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2)) == (*(STRING **)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 359: /* issame_i_sc_s */ {
#line 706 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2]) == (*(STRING **)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 360: /* issame_i_s_sc */ {
#line 706 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2)) == ((STRING *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 361: /* issame_i_sc_sc */ {
#line 706 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2]) == ((STRING *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 362: /* isntsame_i_p_p */ {
#line 710 "src/ops/cmp.ops"
    if ((*(PMC **)OP_AS_OFFS(2)) == (*(PMC **)OP_AS_OFFS(3)))
        (*(INTVAL *)OP_AS_OFFS(1)) = 0;
    else
        (*(INTVAL *)OP_AS_OFFS(1)) = !VTABLE_is_same(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 363: /* isntsame_i_s_s */ {
#line 717 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2)) != (*(STRING **)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 364: /* isntsame_i_sc_s */ {
#line 717 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2]) != (*(STRING **)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 365: /* isntsame_i_s_sc */ {
#line 717 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2)) != ((STRING *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 366: /* isntsame_i_sc_sc */ {
#line 717 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2]) != ((STRING *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 367: /* istrue_i_p */ {
#line 721 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_bool(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 368: /* isfalse_i_p */ {
#line 725 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = !VTABLE_get_bool(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 369: /* isnull_i_p */ {
#line 729 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 370: /* isnull_i_pc */ {
#line 729 "src/ops/cmp.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL(((PMC *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 371: /* isgt_i_p_p */ {
#line 747 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) > 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 372: /* isge_i_p_p */ {
#line 765 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) >= 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 373: /* isle_i_i_i */ {
#line 781 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) <= (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 374: /* isle_i_ic_i */ {
#line 781 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) <= (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 375: /* isle_i_i_ic */ {
#line 781 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) <= ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 376: /* isle_i_n_n */ {
#line 785 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) <= (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 377: /* isle_i_nc_n */ {
#line 785 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) <= (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 378: /* isle_i_n_nc */ {
#line 785 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) <= (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 379: /* isle_i_s_s */ {
#line 789 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) <= 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 380: /* isle_i_sc_s */ {
#line 789 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3))) <= 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 381: /* isle_i_s_sc */ {
#line 789 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) <= 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 382: /* isle_i_p_p */ {
#line 793 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) <= 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 383: /* islt_i_i_i */ {
#line 809 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) < (*(INTVAL *)OP_AS_OFFS(3))) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 384: /* islt_i_ic_i */ {
#line 809 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (((INTVAL)cur_opcode[2]) < (*(INTVAL *)OP_AS_OFFS(3))) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 385: /* islt_i_i_ic */ {
#line 809 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) < ((INTVAL)cur_opcode[3])) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 386: /* islt_i_n_n */ {
#line 813 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) < (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 387: /* islt_i_nc_n */ {
#line 813 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) < (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 388: /* islt_i_n_nc */ {
#line 813 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) < (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 389: /* islt_i_s_s */ {
#line 817 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) < 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 390: /* islt_i_sc_s */ {
#line 817 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3))) < 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 391: /* islt_i_s_sc */ {
#line 817 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_compare(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) < 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 392: /* islt_i_p_p */ {
#line 821 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (VTABLE_cmp(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) < 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 393: /* iseq_i_i_i */ {
#line 837 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) == (*(INTVAL *)OP_AS_OFFS(3))) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 394: /* iseq_i_ic_i */ {
#line 837 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (((INTVAL)cur_opcode[2]) == (*(INTVAL *)OP_AS_OFFS(3))) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 395: /* iseq_i_i_ic */ {
#line 837 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) == ((INTVAL)cur_opcode[3])) ? 1 : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 396: /* iseq_i_n_n */ {
#line 841 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) == (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 397: /* iseq_i_nc_n */ {
#line 841 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) == (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 398: /* iseq_i_n_nc */ {
#line 841 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) == (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 399: /* iseq_i_s_s */ {
#line 845 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) == 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 400: /* iseq_i_sc_s */ {
#line 845 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3))) == 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 401: /* iseq_i_s_sc */ {
#line 845 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) == 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 402: /* iseq_i_p_p */ {
#line 849 "src/ops/cmp.ops"
  if (&(*(PMC **)OP_AS_OFFS(2)) == &(*(PMC **)OP_AS_OFFS(3)))
    (*(INTVAL *)OP_AS_OFFS(1)) = 1;
  else
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 403: /* isne_i_i_i */ {
#line 868 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) == (*(INTVAL *)OP_AS_OFFS(3))) ? 0 : 1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 404: /* isne_i_ic_i */ {
#line 868 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (((INTVAL)cur_opcode[2]) == (*(INTVAL *)OP_AS_OFFS(3))) ? 0 : 1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 405: /* isne_i_i_ic */ {
#line 868 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) == ((INTVAL)cur_opcode[3])) ? 0 : 1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 406: /* isne_i_n_n */ {
#line 872 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) != (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 407: /* isne_i_nc_n */ {
#line 872 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) != (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 408: /* isne_i_n_nc */ {
#line 872 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) != (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 409: /* isne_i_s_s */ {
#line 876 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) != 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 410: /* isne_i_sc_s */ {
#line 876 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3))) != 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 411: /* isne_i_s_sc */ {
#line 876 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_equal(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) != 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 412: /* isne_i_p_p */ {
#line 880 "src/ops/cmp.ops"
  if (&(*(PMC **)OP_AS_OFFS(2)) == &(*(PMC **)OP_AS_OFFS(3)))
    (*(INTVAL *)OP_AS_OFFS(1)) = 0;
  else
    (*(INTVAL *)OP_AS_OFFS(1)) = !VTABLE_is_equal(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 413: /* and_i_i_i */ {
#line 912 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ? (*(INTVAL *)OP_AS_OFFS(3)) : (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 414: /* and_i_ic_i */ {
#line 912 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) ? (*(INTVAL *)OP_AS_OFFS(3)) : ((INTVAL)cur_opcode[2]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 415: /* and_i_i_ic */ {
#line 912 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ? ((INTVAL)cur_opcode[3]) : (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 416: /* and_p_p_p */ {
#line 916 "src/ops/cmp.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_logical_and(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 417: /* not_i */ {
#line 934 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ! (*(INTVAL *)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 418: /* not_i_i */ {
#line 938 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ! (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 419: /* not_p */ {
#line 942 "src/ops/cmp.ops"
  VTABLE_i_logical_not(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 420: /* not_p_p */ {
#line 946 "src/ops/cmp.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_logical_not(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 421: /* or_i_i_i */ {
#line 960 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ? (*(INTVAL *)OP_AS_OFFS(2)) : (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 422: /* or_i_ic_i */ {
#line 960 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) ? ((INTVAL)cur_opcode[2]) : (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 423: /* or_i_i_ic */ {
#line 960 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) ? (*(INTVAL *)OP_AS_OFFS(2)) : ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 424: /* or_p_p_p */ {
#line 964 "src/ops/cmp.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_logical_or(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 425: /* xor_i_i_i */ {
#line 979 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) && ! (*(INTVAL *)OP_AS_OFFS(3))) ? (*(INTVAL *)OP_AS_OFFS(2)) : ((*(INTVAL *)OP_AS_OFFS(3)) && ! (*(INTVAL *)OP_AS_OFFS(2))) ? (*(INTVAL *)OP_AS_OFFS(3)) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 426: /* xor_i_ic_i */ {
#line 979 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (((INTVAL)cur_opcode[2]) && ! (*(INTVAL *)OP_AS_OFFS(3))) ? ((INTVAL)cur_opcode[2]) : ((*(INTVAL *)OP_AS_OFFS(3)) && ! ((INTVAL)cur_opcode[2])) ? (*(INTVAL *)OP_AS_OFFS(3)) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 427: /* xor_i_i_ic */ {
#line 979 "src/ops/cmp.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((*(INTVAL *)OP_AS_OFFS(2)) && ! ((INTVAL)cur_opcode[3])) ? (*(INTVAL *)OP_AS_OFFS(2)) : (((INTVAL)cur_opcode[3]) && ! (*(INTVAL *)OP_AS_OFFS(2))) ? ((INTVAL)cur_opcode[3]) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 428: /* xor_p_p_p */ {
#line 983 "src/ops/cmp.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_logical_xor(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 429: /* debug_init */ {
#line 47 "src/ops/debug.ops"
    Parrot_debugger_init(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 430: /* debug_load_sc */ {
#line 59 "src/ops/debug.ops"
    Parrot_debugger_load(interp, ((STRING *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 431: /* debug_break */ {
#line 79 "src/ops/debug.ops"
    Parrot_debugger_break(interp, cur_opcode);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 432: /* debug_print */ {
#line 91 "src/ops/debug.ops"
    if (!interp->pdb) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 1,
            EXCEPTION_INVALID_OPERATION,
            "Initialize debugger with debug_init before using debug_print");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    if (!(interp->pdb->state & PDB_BREAK)) {
        PDB_print(interp, "I");
        PDB_print(interp, "N");
        PDB_print(interp, "S");
        PDB_print(interp, "P");
    }

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 433: /* backtrace */ {
#line 113 "src/ops/debug.ops"
    PDB_backtrace(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 434: /* getline_i */ {
#line 125 "src/ops/debug.ops"
  Parrot_Context_info info;
  Parrot_Context_get_info(interp, CONTEXT(interp), &info);
  (*(INTVAL *)OP_AS_OFFS(1)) = info.line;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 435: /* getfile_s */ {
#line 137 "src/ops/debug.ops"
  Parrot_Context_info info;
  Parrot_Context_get_info(interp, CONTEXT(interp), &info);
  (*(STRING **)OP_AS_OFFS(1)) = info.file;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 436: /* close_p */ {
#line 42 "src/ops/io.ops"
  Parrot_io_close(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 437: /* fdopen_p_i_s */ {
#line 57 "src/ops/io.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_fdopen(interp, PMCNULL, (PIOHANDLE)(*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));
    if (!(*(PMC **)OP_AS_OFFS(1)))
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 438: /* fdopen_p_ic_s */ {
#line 57 "src/ops/io.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_fdopen(interp, PMCNULL, (PIOHANDLE)((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));
    if (!(*(PMC **)OP_AS_OFFS(1)))
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 439: /* fdopen_p_i_sc */ {
#line 57 "src/ops/io.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_fdopen(interp, PMCNULL, (PIOHANDLE)(*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));
    if (!(*(PMC **)OP_AS_OFFS(1)))
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 440: /* fdopen_p_ic_sc */ {
#line 57 "src/ops/io.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_fdopen(interp, PMCNULL, (PIOHANDLE)((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]));
    if (!(*(PMC **)OP_AS_OFFS(1)))
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Undef);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 441: /* getstdin_p */ {
#line 80 "src/ops/io.ops"
  (*(PMC **)OP_AS_OFFS(1)) = _PIO_STDIN(interp);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 442: /* getstdout_p */ {
#line 84 "src/ops/io.ops"
  (*(PMC **)OP_AS_OFFS(1)) = _PIO_STDOUT(interp);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 443: /* getstderr_p */ {
#line 88 "src/ops/io.ops"
  (*(PMC **)OP_AS_OFFS(1)) = _PIO_STDERR(interp);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 444: /* open_p_s_s */ {
#line 113 "src/ops/io.ops"
    if (STRING_IS_NULL((*(STRING **)OP_AS_OFFS(2))) || STRING_IS_NULL((*(STRING **)OP_AS_OFFS(3)))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 445: /* open_p_sc_s */ {
#line 113 "src/ops/io.ops"
    if (STRING_IS_NULL(((STRING *)cur_opcode[2])) || STRING_IS_NULL((*(STRING **)OP_AS_OFFS(3)))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 446: /* open_p_s_sc */ {
#line 113 "src/ops/io.ops"
    if (STRING_IS_NULL((*(STRING **)OP_AS_OFFS(2))) || STRING_IS_NULL(((STRING *)cur_opcode[3]))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 447: /* open_p_sc_sc */ {
#line 113 "src/ops/io.ops"
    if (STRING_IS_NULL(((STRING *)cur_opcode[2])) || STRING_IS_NULL(((STRING *)cur_opcode[3]))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]));
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 448: /* open_p_s */ {
#line 125 "src/ops/io.ops"
    if (STRING_IS_NULL((*(STRING **)OP_AS_OFFS(2)))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, (*(STRING **)OP_AS_OFFS(2)), NULL);
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 449: /* open_p_sc */ {
#line 125 "src/ops/io.ops"
    if (STRING_IS_NULL(((STRING *)cur_opcode[2]))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
            EXCEPTION_UNEXPECTED_NULL, "Invalid open");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        (*(PMC **)OP_AS_OFFS(1)) = Parrot_io_open(interp, PMCNULL, ((STRING *)cur_opcode[2]), NULL);
        PARROT_ASSERT(! PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))));
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 450: /* print_i */ {
#line 151 "src/ops/io.ops"
  Parrot_io_printf(interp, INTVAL_FMT, (INTVAL)(*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 451: /* print_ic */ {
#line 151 "src/ops/io.ops"
  Parrot_io_printf(interp, INTVAL_FMT, (INTVAL)((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 452: /* print_n */ {
#line 155 "src/ops/io.ops"
  Parrot_io_printf(interp, FLOATVAL_FMT, (*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 453: /* print_nc */ {
#line 155 "src/ops/io.ops"
  Parrot_io_printf(interp, FLOATVAL_FMT, (*(FLOATVAL *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 454: /* print_s */ {
#line 159 "src/ops/io.ops"
  STRING * const s = (*(STRING **)OP_AS_OFFS(1));
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDOUT(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 455: /* print_sc */ {
#line 159 "src/ops/io.ops"
  STRING * const s = ((STRING *)cur_opcode[1]);
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDOUT(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 456: /* print_p */ {
#line 165 "src/ops/io.ops"
  PMC * const p = (*(PMC **)OP_AS_OFFS(1));
  STRING * const s = (VTABLE_get_string(interp, p));
  if (s)
    Parrot_io_putps(interp, _PIO_STDOUT(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 457: /* say_i */ {
#line 184 "src/ops/io.ops"
  Parrot_io_printf(interp, INTVAL_FMT "\n", (INTVAL)(*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 458: /* say_ic */ {
#line 184 "src/ops/io.ops"
  Parrot_io_printf(interp, INTVAL_FMT "\n", (INTVAL)((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 459: /* say_n */ {
#line 188 "src/ops/io.ops"
  Parrot_io_printf(interp, FLOATVAL_FMT "\n", (*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 460: /* say_nc */ {
#line 188 "src/ops/io.ops"
  Parrot_io_printf(interp, FLOATVAL_FMT "\n", (*(FLOATVAL *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 461: /* say_s */ {
#line 192 "src/ops/io.ops"
  STRING * const s = (*(STRING **)OP_AS_OFFS(1));
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDOUT(interp), s);
  Parrot_io_puts(interp, _PIO_STDOUT(interp), "\n");

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 462: /* say_sc */ {
#line 192 "src/ops/io.ops"
  STRING * const s = ((STRING *)cur_opcode[1]);
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDOUT(interp), s);
  Parrot_io_puts(interp, _PIO_STDOUT(interp), "\n");

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 463: /* say_p */ {
#line 199 "src/ops/io.ops"
    PMC * const p = (*(PMC **)OP_AS_OFFS(1));

    if (PMC_IS_NULL(p)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 2,
             EXCEPTION_UNEXPECTED_NULL,
            "Null PMC in say");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        STRING * const s = VTABLE_get_string(interp, p);
        if (s)
            Parrot_io_putps(interp, _PIO_STDOUT(interp), s);
        Parrot_io_puts(interp, _PIO_STDOUT(interp), "\n");
    }

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 464: /* printerr_i */ {
#line 233 "src/ops/io.ops"
  Parrot_io_eprintf(interp, INTVAL_FMT, (*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 465: /* printerr_ic */ {
#line 233 "src/ops/io.ops"
  Parrot_io_eprintf(interp, INTVAL_FMT, ((INTVAL)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 466: /* printerr_n */ {
#line 237 "src/ops/io.ops"
  Parrot_io_eprintf(interp, FLOATVAL_FMT, (*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 467: /* printerr_nc */ {
#line 237 "src/ops/io.ops"
  Parrot_io_eprintf(interp, FLOATVAL_FMT, (*(FLOATVAL *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 468: /* printerr_s */ {
#line 241 "src/ops/io.ops"
  STRING * const s = (*(STRING **)OP_AS_OFFS(1));
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDERR(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 469: /* printerr_sc */ {
#line 241 "src/ops/io.ops"
  STRING * const s = ((STRING *)cur_opcode[1]);
  if (s && string_length(interp, s))
    Parrot_io_putps(interp, _PIO_STDERR(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 470: /* printerr_p */ {
#line 247 "src/ops/io.ops"
  PMC * const p = (*(PMC **)OP_AS_OFFS(1));
  STRING * const s = (VTABLE_get_string(interp, p));
  if (s)
    Parrot_io_putps(interp, _PIO_STDERR(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 471: /* print_p_i */ {
#line 268 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(1))) {
    STRING * const s = Parrot_sprintf_c(interp, INTVAL_FMT, (*(INTVAL *)OP_AS_OFFS(2)));
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), s);
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 472: /* print_p_ic */ {
#line 268 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(1))) {
    STRING * const s = Parrot_sprintf_c(interp, INTVAL_FMT, ((INTVAL)cur_opcode[2]));
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), s);
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 473: /* print_p_n */ {
#line 275 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(1))) {
    STRING * const s = Parrot_sprintf_c(interp, FLOATVAL_FMT, (*(FLOATVAL *)OP_AS_OFFS(2)));
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), s);
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 474: /* print_p_nc */ {
#line 275 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(1))) {
    STRING * const s = Parrot_sprintf_c(interp, FLOATVAL_FMT, (*(FLOATVAL *)cur_opcode[2]));
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), s);
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 475: /* print_p_s */ {
#line 282 "src/ops/io.ops"
  if ((*(STRING **)OP_AS_OFFS(2)) && (*(PMC **)OP_AS_OFFS(1))) {
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 476: /* print_p_sc */ {
#line 282 "src/ops/io.ops"
  if (((STRING *)cur_opcode[2]) && (*(PMC **)OP_AS_OFFS(1))) {
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 477: /* print_p_p */ {
#line 288 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(2)) && (*(PMC **)OP_AS_OFFS(1))) {
    STRING * const s = VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2)));
    Parrot_io_putps(interp, (*(PMC **)OP_AS_OFFS(1)), s);
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 478: /* read_s_i */ {
#line 307 "src/ops/io.ops"
  (*(STRING **)OP_AS_OFFS(1)) = Parrot_io_reads(interp, _PIO_STDIN(interp), (size_t)(*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 479: /* read_s_ic */ {
#line 307 "src/ops/io.ops"
  (*(STRING **)OP_AS_OFFS(1)) = Parrot_io_reads(interp, _PIO_STDIN(interp), (size_t)((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 480: /* read_s_p_i */ {
#line 311 "src/ops/io.ops"
  (*(STRING **)OP_AS_OFFS(1)) = Parrot_io_reads(interp, (*(PMC **)OP_AS_OFFS(2)), (size_t)(*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 481: /* read_s_p_ic */ {
#line 311 "src/ops/io.ops"
  (*(STRING **)OP_AS_OFFS(1)) = Parrot_io_reads(interp, (*(PMC **)OP_AS_OFFS(2)), (size_t)((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 482: /* readline_s_p */ {
#line 322 "src/ops/io.ops"
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_io_readline(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 483: /* peek_s */ {
#line 340 "src/ops/io.ops"
  STRING ** const s = &(*(STRING **)OP_AS_OFFS(1));

  *s = NULL;
  Parrot_io_peek(interp, _PIO_STDIN(interp), s);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 484: /* peek_s_p */ {
#line 347 "src/ops/io.ops"
  STRING ** const s = &(*(STRING **)OP_AS_OFFS(1));

  *s = NULL;
  Parrot_io_peek(interp, (*(PMC **)OP_AS_OFFS(2)), s);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 485: /* stat_i_s_i */ {
#line 378 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_stat_info_intval(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 486: /* stat_i_sc_i */ {
#line 378 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_stat_info_intval(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 487: /* stat_i_s_ic */ {
#line 378 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_stat_info_intval(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 488: /* stat_i_sc_ic */ {
#line 378 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_stat_info_intval(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 489: /* stat_i_i_i */ {
#line 382 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_fstat_info_intval(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 490: /* stat_i_ic_i */ {
#line 382 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_fstat_info_intval(interp, ((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 491: /* stat_i_i_ic */ {
#line 382 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_fstat_info_intval(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 492: /* stat_i_ic_ic */ {
#line 382 "src/ops/io.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_fstat_info_intval(interp, ((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 493: /* seek_p_i_i */ {
#line 404 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset((*(INTVAL *)OP_AS_OFFS(2))), (*(INTVAL *)OP_AS_OFFS(3))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_PIO_ERROR,
                "seek failed (32bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 494: /* seek_p_ic_i */ {
#line 404 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset(((INTVAL)cur_opcode[2])), (*(INTVAL *)OP_AS_OFFS(3))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_PIO_ERROR,
                "seek failed (32bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 495: /* seek_p_i_ic */ {
#line 404 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset((*(INTVAL *)OP_AS_OFFS(2))), ((INTVAL)cur_opcode[3])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_PIO_ERROR,
                "seek failed (32bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 496: /* seek_p_ic_ic */ {
#line 404 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset(((INTVAL)cur_opcode[2])), ((INTVAL)cur_opcode[3])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_PIO_ERROR,
                "seek failed (32bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 497: /* seek_p_i_i_i */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32((*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3))), (*(INTVAL *)OP_AS_OFFS(4))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 498: /* seek_p_ic_i_i */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32(((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3))), (*(INTVAL *)OP_AS_OFFS(4))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 499: /* seek_p_i_ic_i */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32((*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3])), (*(INTVAL *)OP_AS_OFFS(4))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 500: /* seek_p_ic_ic_i */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32(((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3])), (*(INTVAL *)OP_AS_OFFS(4))) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 501: /* seek_p_i_i_ic */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32((*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3))), ((INTVAL)cur_opcode[4])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 502: /* seek_p_ic_i_ic */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32(((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3))), ((INTVAL)cur_opcode[4])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 503: /* seek_p_i_ic_ic */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32((*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3])), ((INTVAL)cur_opcode[4])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 504: /* seek_p_ic_ic_ic */ {
#line 415 "src/ops/io.ops"
    if ((*(PMC **)OP_AS_OFFS(1))) {
        if (Parrot_io_seek(interp, (*(PMC **)OP_AS_OFFS(1)), Parrot_io_make_offset32(((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3])), ((INTVAL)cur_opcode[4])) < 0) {
            opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 5,
                EXCEPTION_PIO_ERROR,
                "seek failed (64bit)");
                        {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
        }
    }

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 505: /* tell_i_p */ {
#line 441 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(2)))
    (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)Parrot_io_tell(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 506: /* tell_i_i_p */ {
#line 446 "src/ops/io.ops"
  if ((*(PMC **)OP_AS_OFFS(3))) {
    PIOOFF_T pos;
    pos = Parrot_io_tell(interp, (*(PMC **)OP_AS_OFFS(3)));
    (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)(pos >> 31);
    (*(INTVAL *)OP_AS_OFFS(2)) = (INTVAL)(pos & 0xffffffff);
  }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 507: /* abs_i */ {
#line 49 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = abs((*(INTVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 508: /* abs_n */ {
#line 53 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = fabs((*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 509: /* abs_i_i */ {
#line 57 "src/ops/math.ops"
  if ((*(INTVAL *)OP_AS_OFFS(2)) < 0)
    (*(INTVAL *)OP_AS_OFFS(1)) = - (INTVAL)(*(INTVAL *)OP_AS_OFFS(2));
  else
    (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)(*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 510: /* abs_n_n */ {
#line 64 "src/ops/math.ops"
  if ((*(FLOATVAL *)OP_AS_OFFS(2)) < 0)
    (*(FLOATVAL *)OP_AS_OFFS(1)) = - (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2));
  else
    (*(FLOATVAL *)OP_AS_OFFS(1)) = (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 511: /* abs_p */ {
#line 71 "src/ops/math.ops"
  VTABLE_i_absolute(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 512: /* abs_p_p */ {
#line 75 "src/ops/math.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_absolute(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 513: /* add_i_i */ {
#line 107 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) += (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 514: /* add_i_ic */ {
#line 107 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) += ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 515: /* add_n_n */ {
#line 111 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) += (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 516: /* add_n_nc */ {
#line 111 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) += (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 517: /* add_p_p */ {
#line 115 "src/ops/math.ops"
      VTABLE_i_add(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 518: /* add_p_i */ {
#line 119 "src/ops/math.ops"
      VTABLE_i_add_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 519: /* add_p_ic */ {
#line 119 "src/ops/math.ops"
      VTABLE_i_add_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 520: /* add_p_n */ {
#line 123 "src/ops/math.ops"
      VTABLE_i_add_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 521: /* add_p_nc */ {
#line 123 "src/ops/math.ops"
      VTABLE_i_add_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 522: /* add_i_i_i */ {
#line 127 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) + (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 523: /* add_i_ic_i */ {
#line 127 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) + (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 524: /* add_i_i_ic */ {
#line 127 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) + ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 525: /* add_n_n_n */ {
#line 131 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) + (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 526: /* add_n_nc_n */ {
#line 131 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) + (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 527: /* add_n_n_nc */ {
#line 131 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) + (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 528: /* add_p_p_p */ {
#line 135 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_add(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 529: /* add_p_p_i */ {
#line 139 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_add_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 530: /* add_p_p_ic */ {
#line 139 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_add_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 531: /* add_p_p_n */ {
#line 143 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_add_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 532: /* add_p_p_nc */ {
#line 143 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_add_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 533: /* cmod_i_i_i */ {
#line 188 "src/ops/math.ops"
  INTVAL den = (*(INTVAL *)OP_AS_OFFS(3));
  if ((*(INTVAL *)OP_AS_OFFS(3)) == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) % den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 534: /* cmod_i_ic_i */ {
#line 188 "src/ops/math.ops"
  INTVAL den = (*(INTVAL *)OP_AS_OFFS(3));
  if ((*(INTVAL *)OP_AS_OFFS(3)) == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) % den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 535: /* cmod_i_i_ic */ {
#line 188 "src/ops/math.ops"
  INTVAL den = ((INTVAL)cur_opcode[3]);
  if (((INTVAL)cur_opcode[3]) == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) % den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 536: /* cmod_p_p_i */ {
#line 199 "src/ops/math.ops"
  INTVAL result;

  if ((*(INTVAL *)OP_AS_OFFS(3)) == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  result = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2))) % (*(INTVAL *)OP_AS_OFFS(3));

  (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2))));
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), result);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 537: /* cmod_p_p_ic */ {
#line 199 "src/ops/math.ops"
  INTVAL result;

  if (((INTVAL)cur_opcode[3]) == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  result = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2))) % ((INTVAL)cur_opcode[3]);

  (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2))));
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), result);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 538: /* cmod_p_p_p */ {
#line 215 "src/ops/math.ops"
  INTVAL result;
  INTVAL value = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(3)));

  if (value == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  result = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2))) % value;

  (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2))));
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), result);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 539: /* cmod_n_n_n */ {
#line 265 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO((*(FLOATVAL *)OP_AS_OFFS(3)))) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = fmod((*(FLOATVAL *)OP_AS_OFFS(2)), den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 540: /* cmod_n_nc_n */ {
#line 265 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO((*(FLOATVAL *)OP_AS_OFFS(3)))) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = fmod((*(FLOATVAL *)cur_opcode[2]), den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 541: /* cmod_n_n_nc */ {
#line 265 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[3]);
  if (FLOAT_IS_ZERO((*(FLOATVAL *)cur_opcode[3]))) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = fmod((*(FLOATVAL *)OP_AS_OFFS(2)), den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 542: /* cmod_p_p_n */ {
#line 276 "src/ops/math.ops"
  FLOATVAL result;
  FLOATVAL value = (*(FLOATVAL *)OP_AS_OFFS(3));

  if (FLOAT_IS_ZERO(value)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  result = fmod(VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2))), value);

  (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2))));
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), (INTVAL) result);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 543: /* cmod_p_p_nc */ {
#line 276 "src/ops/math.ops"
  FLOATVAL result;
  FLOATVAL value = (*(FLOATVAL *)cur_opcode[3]);

  if (FLOAT_IS_ZERO(value)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  result = fmod(VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2))), value);

  (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2))));
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), (INTVAL) result);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 544: /* dec_i */ {
#line 305 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1))--;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 545: /* dec_n */ {
#line 309 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1))--;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 546: /* dec_p */ {
#line 313 "src/ops/math.ops"
  VTABLE_decrement(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 547: /* div_i_i */ {
#line 347 "src/ops/math.ops"
  INTVAL den = (*(INTVAL *)OP_AS_OFFS(2));
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) /= den;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 548: /* div_i_ic */ {
#line 347 "src/ops/math.ops"
  INTVAL den = ((INTVAL)cur_opcode[2]);
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) /= den;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 549: /* div_n_n */ {
#line 358 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(2));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) /= den;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 550: /* div_n_nc */ {
#line 358 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[2]);
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) /= den;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 551: /* div_p_p */ {
#line 369 "src/ops/math.ops"
      VTABLE_i_divide(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 552: /* div_p_i */ {
#line 373 "src/ops/math.ops"
      VTABLE_i_divide_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 553: /* div_p_ic */ {
#line 373 "src/ops/math.ops"
      VTABLE_i_divide_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 554: /* div_p_n */ {
#line 377 "src/ops/math.ops"
      VTABLE_i_divide_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 555: /* div_p_nc */ {
#line 377 "src/ops/math.ops"
      VTABLE_i_divide_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 556: /* div_i_i_i */ {
#line 380 "src/ops/math.ops"
  INTVAL den = (*(INTVAL *)OP_AS_OFFS(3));
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 557: /* div_i_ic_i */ {
#line 380 "src/ops/math.ops"
  INTVAL den = (*(INTVAL *)OP_AS_OFFS(3));
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 558: /* div_i_i_ic */ {
#line 380 "src/ops/math.ops"
  INTVAL den = ((INTVAL)cur_opcode[3]);
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 559: /* div_i_ic_ic */ {
#line 380 "src/ops/math.ops"
  INTVAL den = ((INTVAL)cur_opcode[3]);
  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 560: /* div_n_n_n */ {
#line 391 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 561: /* div_n_nc_n */ {
#line 391 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 562: /* div_n_n_nc */ {
#line 391 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[3]);
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 563: /* div_n_nc_nc */ {
#line 391 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[3]);
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) / den;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 564: /* div_p_p_p */ {
#line 402 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_divide(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 565: /* div_p_p_i */ {
#line 406 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_divide_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 566: /* div_p_p_ic */ {
#line 406 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_divide_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 567: /* div_p_p_n */ {
#line 410 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_divide_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 568: /* div_p_p_nc */ {
#line 410 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_divide_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 569: /* fdiv_i_i */ {
#line 443 "src/ops/math.ops"
  INTVAL   den = (*(INTVAL *)OP_AS_OFFS(2));
  FLOATVAL f;

  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  f  = floor((*(INTVAL *)OP_AS_OFFS(1)) / den);
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)f;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 570: /* fdiv_i_ic */ {
#line 443 "src/ops/math.ops"
  INTVAL   den = ((INTVAL)cur_opcode[2]);
  FLOATVAL f;

  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  f  = floor((*(INTVAL *)OP_AS_OFFS(1)) / den);
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)f;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 571: /* fdiv_n_n */ {
#line 458 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(2));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(1)) / den);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 572: /* fdiv_n_nc */ {
#line 458 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[2]);
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(1)) / den);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 573: /* fdiv_p_p */ {
#line 469 "src/ops/math.ops"
      VTABLE_i_floor_divide(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 574: /* fdiv_p_i */ {
#line 473 "src/ops/math.ops"
      VTABLE_i_floor_divide_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 575: /* fdiv_p_ic */ {
#line 473 "src/ops/math.ops"
      VTABLE_i_floor_divide_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 576: /* fdiv_p_n */ {
#line 477 "src/ops/math.ops"
      VTABLE_i_floor_divide_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 577: /* fdiv_p_nc */ {
#line 477 "src/ops/math.ops"
      VTABLE_i_floor_divide_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 578: /* fdiv_i_i_i */ {
#line 481 "src/ops/math.ops"
  INTVAL   den = (*(INTVAL *)OP_AS_OFFS(3));
  FLOATVAL f;

  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  f  = floor((*(INTVAL *)OP_AS_OFFS(2)) / den);
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)f;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 579: /* fdiv_i_ic_i */ {
#line 481 "src/ops/math.ops"
  INTVAL   den = (*(INTVAL *)OP_AS_OFFS(3));
  FLOATVAL f;

  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  f  = floor(((INTVAL)cur_opcode[2]) / den);
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)f;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 580: /* fdiv_i_i_ic */ {
#line 481 "src/ops/math.ops"
  INTVAL   den = ((INTVAL)cur_opcode[3]);
  FLOATVAL f;

  if (den == 0) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }

  f  = floor((*(INTVAL *)OP_AS_OFFS(2)) / den);
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)f;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 581: /* fdiv_n_n_n */ {
#line 496 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(2)) / den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 582: /* fdiv_n_nc_n */ {
#line 496 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)OP_AS_OFFS(3));
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)cur_opcode[2]) / den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 583: /* fdiv_n_n_nc */ {
#line 496 "src/ops/math.ops"
  FLOATVAL den = (*(FLOATVAL *)cur_opcode[3]);
  if (FLOAT_IS_ZERO(den)) {
    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
        EXCEPTION_DIV_BY_ZERO,
        "Divide by zero");
                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(2)) / den);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 584: /* fdiv_p_p_p */ {
#line 507 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_floor_divide(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 585: /* fdiv_p_p_i */ {
#line 511 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_floor_divide_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 586: /* fdiv_p_p_ic */ {
#line 511 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_floor_divide_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 587: /* fdiv_p_p_n */ {
#line 515 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_floor_divide_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 588: /* fdiv_p_p_nc */ {
#line 515 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_floor_divide_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 589: /* ceil_n */ {
#line 533 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = ceil((*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 590: /* ceil_i_n */ {
#line 537 "src/ops/math.ops"
  FLOATVAL f = ceil((*(FLOATVAL *)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1))         = (INTVAL)f;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 591: /* ceil_n_n */ {
#line 542 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = ceil((*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 592: /* floor_n */ {
#line 560 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 593: /* floor_i_n */ {
#line 564 "src/ops/math.ops"
  FLOATVAL f = floor((*(FLOATVAL *)OP_AS_OFFS(2)));
  (*(INTVAL *)OP_AS_OFFS(1))         = (INTVAL)f;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 594: /* floor_n_n */ {
#line 569 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floor((*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 595: /* inc_i */ {
#line 585 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1))++;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 596: /* inc_n */ {
#line 589 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1))++;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 597: /* inc_p */ {
#line 593 "src/ops/math.ops"
  VTABLE_increment(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 598: /* mod_i_i */ {
#line 645 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = intval_mod((*(INTVAL *)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 599: /* mod_i_ic */ {
#line 645 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = intval_mod((*(INTVAL *)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

    default:
    switch (*(opcode_t*)cur_opcode) {
case 600: /* mod_n_n */ {
#line 649 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floatval_mod((*(FLOATVAL *)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 601: /* mod_n_nc */ {
#line 649 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floatval_mod((*(FLOATVAL *)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 602: /* mod_p_p */ {
#line 653 "src/ops/math.ops"
      VTABLE_i_modulus(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 603: /* mod_p_i */ {
#line 657 "src/ops/math.ops"
      VTABLE_i_modulus_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 604: /* mod_p_ic */ {
#line 657 "src/ops/math.ops"
      VTABLE_i_modulus_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 605: /* mod_p_n */ {
#line 661 "src/ops/math.ops"
      VTABLE_i_modulus_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 606: /* mod_p_nc */ {
#line 661 "src/ops/math.ops"
      VTABLE_i_modulus_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 607: /* mod_i_i_i */ {
#line 665 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = intval_mod((*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 608: /* mod_i_ic_i */ {
#line 665 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = intval_mod(((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 609: /* mod_i_i_ic */ {
#line 665 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = intval_mod((*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 610: /* mod_n_n_n */ {
#line 669 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floatval_mod((*(FLOATVAL *)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 611: /* mod_n_nc_n */ {
#line 669 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floatval_mod((*(FLOATVAL *)cur_opcode[2]), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 612: /* mod_n_n_nc */ {
#line 669 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = floatval_mod((*(FLOATVAL *)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 613: /* mod_p_p_p */ {
#line 673 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_modulus(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 614: /* mod_p_p_i */ {
#line 677 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_modulus_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 615: /* mod_p_p_ic */ {
#line 677 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_modulus_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 616: /* mod_p_p_n */ {
#line 681 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_modulus_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 617: /* mod_p_p_nc */ {
#line 681 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_modulus_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 618: /* mul_i_i */ {
#line 713 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) *= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 619: /* mul_i_ic */ {
#line 713 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) *= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 620: /* mul_n_n */ {
#line 717 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) *= (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 621: /* mul_n_nc */ {
#line 717 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) *= (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 622: /* mul_p_p */ {
#line 721 "src/ops/math.ops"
      VTABLE_i_multiply(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 623: /* mul_p_i */ {
#line 725 "src/ops/math.ops"
      VTABLE_i_multiply_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 624: /* mul_p_ic */ {
#line 725 "src/ops/math.ops"
      VTABLE_i_multiply_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 625: /* mul_p_n */ {
#line 729 "src/ops/math.ops"
      VTABLE_i_multiply_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 626: /* mul_p_nc */ {
#line 729 "src/ops/math.ops"
      VTABLE_i_multiply_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 627: /* mul_i_i_i */ {
#line 733 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) * (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 628: /* mul_i_ic_i */ {
#line 733 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) * (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 629: /* mul_i_i_ic */ {
#line 733 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) * ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 630: /* mul_n_n_n */ {
#line 737 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) * (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 631: /* mul_n_nc_n */ {
#line 737 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) * (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 632: /* mul_n_n_nc */ {
#line 737 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) * (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 633: /* mul_p_p_p */ {
#line 741 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_multiply(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 634: /* mul_p_p_i */ {
#line 745 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_multiply_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 635: /* mul_p_p_ic */ {
#line 745 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_multiply_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 636: /* mul_p_p_n */ {
#line 749 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_multiply_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 637: /* mul_p_p_nc */ {
#line 749 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_multiply_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 638: /* neg_i */ {
#line 773 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = - (*(INTVAL *)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 639: /* neg_n */ {
#line 777 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = - (*(FLOATVAL *)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 640: /* neg_p */ {
#line 781 "src/ops/math.ops"
  VTABLE_i_neg(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 641: /* neg_i_i */ {
#line 785 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = - (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 642: /* neg_n_n */ {
#line 789 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = - (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 643: /* neg_p_p */ {
#line 793 "src/ops/math.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_neg(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 644: /* pow_n_n_n */ {
#line 811 "src/ops/math.ops"
   (*(FLOATVAL *)OP_AS_OFFS(1)) = pow((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)), (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 645: /* pow_n_nc_n */ {
#line 811 "src/ops/math.ops"
   (*(FLOATVAL *)OP_AS_OFFS(1)) = pow((FLOATVAL)(*(FLOATVAL *)cur_opcode[2]), (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 646: /* pow_n_n_nc */ {
#line 811 "src/ops/math.ops"
   (*(FLOATVAL *)OP_AS_OFFS(1)) = pow((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)), (FLOATVAL)(*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 647: /* pow_p_p_p */ {
#line 815 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pow(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 648: /* pow_p_p_i */ {
#line 819 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pow_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 649: /* pow_p_p_ic */ {
#line 819 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pow_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 650: /* pow_p_p_n */ {
#line 823 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pow_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 651: /* pow_p_p_nc */ {
#line 823 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pow_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 652: /* sub_i_i */ {
#line 856 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) -= (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 653: /* sub_i_ic */ {
#line 856 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) -= ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 654: /* sub_n_n */ {
#line 860 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) -= (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 655: /* sub_n_nc */ {
#line 860 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) -= (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 656: /* sub_p_p */ {
#line 864 "src/ops/math.ops"
      VTABLE_i_subtract(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 657: /* sub_p_i */ {
#line 868 "src/ops/math.ops"
      VTABLE_i_subtract_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 658: /* sub_p_ic */ {
#line 868 "src/ops/math.ops"
      VTABLE_i_subtract_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 659: /* sub_p_n */ {
#line 872 "src/ops/math.ops"
      VTABLE_i_subtract_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 660: /* sub_p_nc */ {
#line 872 "src/ops/math.ops"
      VTABLE_i_subtract_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 661: /* sub_i_i_i */ {
#line 876 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) - (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 662: /* sub_i_ic_i */ {
#line 876 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]) - (*(INTVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 663: /* sub_i_i_ic */ {
#line 876 "src/ops/math.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2)) - ((INTVAL)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 664: /* sub_n_n_n */ {
#line 880 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) - (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 665: /* sub_n_nc_n */ {
#line 880 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]) - (*(FLOATVAL *)OP_AS_OFFS(3));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 666: /* sub_n_n_nc */ {
#line 880 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2)) - (*(FLOATVAL *)cur_opcode[3]);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 667: /* sub_p_p_p */ {
#line 884 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_subtract(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 668: /* sub_p_p_i */ {
#line 888 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_subtract_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 669: /* sub_p_p_ic */ {
#line 888 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_subtract_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 670: /* sub_p_p_n */ {
#line 892 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_subtract_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 671: /* sub_p_p_nc */ {
#line 892 "src/ops/math.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_subtract_float(interp, (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 672: /* sqrt_n_n */ {
#line 904 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = sqrt((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 673: /* acos_n_n */ {
#line 933 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = acos((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 674: /* asec_n_n */ {
#line 945 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = acos(((FLOATVAL)1) / ((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2))));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 675: /* asin_n_n */ {
#line 958 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = asin((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 676: /* atan_n_n */ {
#line 976 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = atan((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 677: /* atan_n_n_n */ {
#line 980 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = atan2((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)), (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 678: /* atan_n_nc_n */ {
#line 980 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = atan2((FLOATVAL)(*(FLOATVAL *)cur_opcode[2]), (FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 679: /* atan_n_n_nc */ {
#line 980 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = atan2((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)), (FLOATVAL)(*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 680: /* cos_n_n */ {
#line 992 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = cos((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 681: /* cosh_n_n */ {
#line 1004 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = cosh((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 682: /* exp_n_n */ {
#line 1017 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = exp((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 683: /* ln_n_n */ {
#line 1029 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = log((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 684: /* log10_n_n */ {
#line 1041 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = log10((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 685: /* log2_n_n */ {
#line 1053 "src/ops/math.ops"
   FLOATVAL temp = log((FLOATVAL)2.0);
  (*(FLOATVAL *)OP_AS_OFFS(1)) = log((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2))) / temp;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 686: /* sec_n_n */ {
#line 1066 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = ((FLOATVAL)1) / cos((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 687: /* sech_n_n */ {
#line 1078 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = ((FLOATVAL)1) / cosh((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 688: /* sin_n_n */ {
#line 1090 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = sin((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 689: /* sinh_n_n */ {
#line 1102 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = sinh((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 690: /* tan_n_n */ {
#line 1114 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = tan((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 691: /* tanh_n_n */ {
#line 1126 "src/ops/math.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = tanh((FLOATVAL)(*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 692: /* gcd_i_i_i */ {
#line 1152 "src/ops/math.ops"
 INTVAL p = 0;
 INTVAL a = (*(INTVAL *)OP_AS_OFFS(2)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(2)) : (*(INTVAL *)OP_AS_OFFS(2));
 INTVAL b = (*(INTVAL *)OP_AS_OFFS(3)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(3)) : (*(INTVAL *)OP_AS_OFFS(3));

 if (a==0) { (*(INTVAL *)OP_AS_OFFS(1))=b; { cur_opcode += 4; goto SWITCH_AGAIN; }; }
 if (b==0) { (*(INTVAL *)OP_AS_OFFS(1))=a; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 (*(INTVAL *)OP_AS_OFFS(1)) = b<<p;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 693: /* gcd_i_ic_i */ {
#line 1152 "src/ops/math.ops"
 INTVAL p = 0;
 INTVAL a = ((INTVAL)cur_opcode[2]) < 0 ? -((INTVAL)cur_opcode[2]) : ((INTVAL)cur_opcode[2]);
 INTVAL b = (*(INTVAL *)OP_AS_OFFS(3)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(3)) : (*(INTVAL *)OP_AS_OFFS(3));

 if (a==0) { (*(INTVAL *)OP_AS_OFFS(1))=b; { cur_opcode += 4; goto SWITCH_AGAIN; }; }
 if (b==0) { (*(INTVAL *)OP_AS_OFFS(1))=a; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 (*(INTVAL *)OP_AS_OFFS(1)) = b<<p;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 694: /* gcd_i_i_ic */ {
#line 1152 "src/ops/math.ops"
 INTVAL p = 0;
 INTVAL a = (*(INTVAL *)OP_AS_OFFS(2)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(2)) : (*(INTVAL *)OP_AS_OFFS(2));
 INTVAL b = ((INTVAL)cur_opcode[3]) < 0 ? -((INTVAL)cur_opcode[3]) : ((INTVAL)cur_opcode[3]);

 if (a==0) { (*(INTVAL *)OP_AS_OFFS(1))=b; { cur_opcode += 4; goto SWITCH_AGAIN; }; }
 if (b==0) { (*(INTVAL *)OP_AS_OFFS(1))=a; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 (*(INTVAL *)OP_AS_OFFS(1)) = b<<p;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 695: /* lcm_i_i_i */ {
#line 1185 "src/ops/math.ops"
 INTVAL gcd = 0;
 INTVAL p = 0;
 INTVAL a = (*(INTVAL *)OP_AS_OFFS(2)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(2)) : (*(INTVAL *)OP_AS_OFFS(2));
 INTVAL b = (*(INTVAL *)OP_AS_OFFS(3)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(3)) : (*(INTVAL *)OP_AS_OFFS(3));
 INTVAL saved_var1 = a, saved_var2 = b;

 if (a==0 || b==0) { (*(INTVAL *)OP_AS_OFFS(1))=0; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 gcd = b<<p;
 saved_var1 /= gcd;
 (*(INTVAL *)OP_AS_OFFS(1)) = saved_var1*saved_var2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 696: /* lcm_i_ic_i */ {
#line 1185 "src/ops/math.ops"
 INTVAL gcd = 0;
 INTVAL p = 0;
 INTVAL a = ((INTVAL)cur_opcode[2]) < 0 ? -((INTVAL)cur_opcode[2]) : ((INTVAL)cur_opcode[2]);
 INTVAL b = (*(INTVAL *)OP_AS_OFFS(3)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(3)) : (*(INTVAL *)OP_AS_OFFS(3));
 INTVAL saved_var1 = a, saved_var2 = b;

 if (a==0 || b==0) { (*(INTVAL *)OP_AS_OFFS(1))=0; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 gcd = b<<p;
 saved_var1 /= gcd;
 (*(INTVAL *)OP_AS_OFFS(1)) = saved_var1*saved_var2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 697: /* lcm_i_i_ic */ {
#line 1185 "src/ops/math.ops"
 INTVAL gcd = 0;
 INTVAL p = 0;
 INTVAL a = (*(INTVAL *)OP_AS_OFFS(2)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(2)) : (*(INTVAL *)OP_AS_OFFS(2));
 INTVAL b = ((INTVAL)cur_opcode[3]) < 0 ? -((INTVAL)cur_opcode[3]) : ((INTVAL)cur_opcode[3]);
 INTVAL saved_var1 = a, saved_var2 = b;

 if (a==0 || b==0) { (*(INTVAL *)OP_AS_OFFS(1))=0; { cur_opcode += 4; goto SWITCH_AGAIN; }; }

 while (!((a | b) & 1)) {
   a>>=1;
   b>>=1;
   p++;
 }

 while (a>0) {
   if (!(a & 1)) a>>=1;
   else if (!(b & 1)) b>>=1;
   else if (a<b)      b = (b-a)>>1;
   else               a = (a-b)>>1;
 }

 gcd = b<<p;
 saved_var1 /= gcd;
 (*(INTVAL *)OP_AS_OFFS(1)) = saved_var1*saved_var2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 698: /* fact_i_i */ {
#line 1222 "src/ops/math.ops"
  /* Coercing a negative to a UINT can get pretty ugly
   * in this situation. */
  INTVAL i = (*(INTVAL *)OP_AS_OFFS(2));
  UINTVAL q = 1;
  while (i>0) {
    q = q*i;
    i--;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = q;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 699: /* fact_n_i */ {
#line 1234 "src/ops/math.ops"
  /* Coercing a negative to a UINT can get pretty ugly
   * in this situation. */
  INTVAL i = (*(INTVAL *)OP_AS_OFFS(2));
  FLOATVAL q = 1;
  while (i>0) {
    q = q*i;
    i--;
  }
  (*(FLOATVAL *)OP_AS_OFFS(1)) = q;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 700: /* callmethodcc_p_s */ {
#line 54 "src/ops/object.ops"
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = (*(STRING **)OP_AS_OFFS(2));
  opcode_t * const next       = CUR_OPCODE + 3;

  /* a class-specific find_method can overwrite interp->current_args()! */
  opcode_t *current_args      = interp->current_args;
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);
  opcode_t *dest              = NULL;
  interp->current_args        = current_args;

  if (PMC_IS_NULL(method_pmc)) {
    PMC * const _class = VTABLE_get_class(interp, object);
    if (PMC_IS_NULL(_class)) {
      dest = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_METHOD_NOT_FOUND,
          "Method '%Ss' not found for non-object", meth);
    }
    else {
      dest = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_METHOD_NOT_FOUND,
          "Method '%Ss' not found for invocant of class '%Ss'", meth,
          VTABLE_get_string(interp, _class));
    }
  }
  else {
    interp->current_object = object;
    interp->current_cont   = NEED_CONTINUATION;
    dest                   = VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 701: /* callmethodcc_p_sc */ {
#line 54 "src/ops/object.ops"
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = ((STRING *)cur_opcode[2]);
  opcode_t * const next       = CUR_OPCODE + 3;

  /* a class-specific find_method can overwrite interp->current_args()! */
  opcode_t *current_args      = interp->current_args;
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);
  opcode_t *dest              = NULL;
  interp->current_args        = current_args;

  if (PMC_IS_NULL(method_pmc)) {
    PMC * const _class = VTABLE_get_class(interp, object);
    if (PMC_IS_NULL(_class)) {
      dest = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_METHOD_NOT_FOUND,
          "Method '%Ss' not found for non-object", meth);
    }
    else {
      dest = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_METHOD_NOT_FOUND,
          "Method '%Ss' not found for invocant of class '%Ss'", meth,
          VTABLE_get_string(interp, _class));
    }
  }
  else {
    interp->current_object = object;
    interp->current_cont   = NEED_CONTINUATION;
    dest                   = VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 702: /* callmethodcc_p_p */ {
#line 87 "src/ops/object.ops"
  opcode_t        *dest;
  opcode_t * const next  = CUR_OPCODE + 3;

  interp->current_object = (*(PMC **)OP_AS_OFFS(1));
  interp->current_cont   = NEED_CONTINUATION;
  dest                   = VTABLE_invoke(interp, (*(PMC **)OP_AS_OFFS(2)), next);

              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 703: /* callmethod_p_s_p */ {
#line 98 "src/ops/object.ops"
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = (*(STRING **)OP_AS_OFFS(2));
  opcode_t * const next       = CUR_OPCODE + 4;

  /* a class-specific find_method can overwrite interp->current_args()! */
  opcode_t *current_args      = interp->current_args;
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);
  opcode_t *dest              = NULL;
  interp->current_args        = current_args;


  if (PMC_IS_NULL(method_pmc)) {
    dest = Parrot_ex_throw_from_op_args(interp, next, EXCEPTION_METHOD_NOT_FOUND,
        "Method '%Ss' not found for invocant of class '%Ss'", meth,
        VTABLE_get_string(interp, VTABLE_get_class(interp, object)));
  }
  else {
    interp->current_object = object;
    interp->current_cont = (*(PMC **)OP_AS_OFFS(3));
    dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 704: /* callmethod_p_sc_p */ {
#line 98 "src/ops/object.ops"
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = ((STRING *)cur_opcode[2]);
  opcode_t * const next       = CUR_OPCODE + 4;

  /* a class-specific find_method can overwrite interp->current_args()! */
  opcode_t *current_args      = interp->current_args;
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);
  opcode_t *dest              = NULL;
  interp->current_args        = current_args;


  if (PMC_IS_NULL(method_pmc)) {
    dest = Parrot_ex_throw_from_op_args(interp, next, EXCEPTION_METHOD_NOT_FOUND,
        "Method '%Ss' not found for invocant of class '%Ss'", meth,
        VTABLE_get_string(interp, VTABLE_get_class(interp, object)));
  }
  else {
    interp->current_object = object;
    interp->current_cont = (*(PMC **)OP_AS_OFFS(3));
    dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 705: /* callmethod_p_p_p */ {
#line 123 "src/ops/object.ops"
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  PMC      * const method_pmc = (*(PMC **)OP_AS_OFFS(2));
  opcode_t * const next       = CUR_OPCODE + 4;

  opcode_t *dest;

  interp->current_object = object;
  interp->current_cont = (*(PMC **)OP_AS_OFFS(3));
  dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 706: /* tailcallmethod_p_s */ {
#line 136 "src/ops/object.ops"
  opcode_t * const next       = CUR_OPCODE + 3;
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = (*(STRING **)OP_AS_OFFS(2));
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);

  opcode_t *dest;

  if (PMC_IS_NULL(method_pmc)) {
    dest = Parrot_ex_throw_from_op_args(interp, next, EXCEPTION_METHOD_NOT_FOUND,
        "Method '%Ss' not found for invocant of class '%Ss'", meth,
        VTABLE_get_string(interp, VTABLE_get_class(interp, object)));
  }
  else {
    interp->current_cont = CONTEXT(interp)->current_cont;
    PObj_get_FLAGS(interp->current_cont) |= SUB_FLAG_TAILCALL;
    interp->current_object = object;
    dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 707: /* tailcallmethod_p_sc */ {
#line 136 "src/ops/object.ops"
  opcode_t * const next       = CUR_OPCODE + 3;
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  STRING   * const meth       = ((STRING *)cur_opcode[2]);
  PMC      * const method_pmc = VTABLE_find_method(interp, object, meth);

  opcode_t *dest;

  if (PMC_IS_NULL(method_pmc)) {
    dest = Parrot_ex_throw_from_op_args(interp, next, EXCEPTION_METHOD_NOT_FOUND,
        "Method '%Ss' not found for invocant of class '%Ss'", meth,
        VTABLE_get_string(interp, VTABLE_get_class(interp, object)));
  }
  else {
    interp->current_cont = CONTEXT(interp)->current_cont;
    PObj_get_FLAGS(interp->current_cont) |= SUB_FLAG_TAILCALL;
    interp->current_object = object;
    dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
  }
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 708: /* tailcallmethod_p_p */ {
#line 158 "src/ops/object.ops"
  opcode_t * const next       = CUR_OPCODE + 3;
  PMC      * const object     = (*(PMC **)OP_AS_OFFS(1));
  PMC      * const method_pmc = (*(PMC **)OP_AS_OFFS(2));

  opcode_t *dest;

  interp->current_cont = CONTEXT(interp)->current_cont;
  PObj_get_FLAGS(interp->current_cont) |= SUB_FLAG_TAILCALL;
  interp->current_object = object;
  dest = (opcode_t *)VTABLE_invoke(interp, method_pmc, next);
              {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
}

case 709: /* addmethod_p_s_p */ {
#line 178 "src/ops/object.ops"
  VTABLE_add_method(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 710: /* addmethod_p_sc_p */ {
#line 178 "src/ops/object.ops"
  VTABLE_add_method(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 711: /* can_i_p_s */ {
#line 190 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_can(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 712: /* can_i_p_sc */ {
#line 190 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_can(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 713: /* does_i_p_s */ {
#line 202 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(3)) ? VTABLE_does(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 714: /* does_i_p_sc */ {
#line 202 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[3]) ? VTABLE_does(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 715: /* does_i_p_p */ {
#line 213 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(PMC **)OP_AS_OFFS(3)) ? VTABLE_does_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 716: /* does_i_p_pc */ {
#line 213 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((PMC *)cur_opcode[3]) ? VTABLE_does_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3])) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 717: /* isa_i_p_s */ {
#line 226 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(3)) ? VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3))) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 718: /* isa_i_p_sc */ {
#line 226 "src/ops/object.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[3]) ? VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3])) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 719: /* isa_i_p_p */ {
#line 230 "src/ops/object.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(PMC **)OP_AS_OFFS(3)) ? VTABLE_isa_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3))) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 720: /* isa_i_p_pc */ {
#line 230 "src/ops/object.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((PMC *)cur_opcode[3]) ? VTABLE_isa_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3])) : 0;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 721: /* newclass_p_s */ {
#line 248 "src/ops/object.ops"
  PMC * const name = pmc_new(interp, enum_class_String);
  VTABLE_set_string_native(interp, name, (*(STRING **)OP_AS_OFFS(2)));
  (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, name);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 722: /* newclass_p_sc */ {
#line 248 "src/ops/object.ops"
  PMC * const name = pmc_new(interp, enum_class_String);
  VTABLE_set_string_native(interp, name, ((STRING *)cur_opcode[2]));
  (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, name);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 723: /* newclass_p_p */ {
#line 254 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 724: /* newclass_p_pc */ {
#line 254 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, ((PMC *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 725: /* subclass_p_p */ {
#line 270 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 3;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Class);
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 726: /* subclass_p_pc */ {
#line 270 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 3;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, ((PMC *)cur_opcode[2])));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Class);
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 727: /* subclass_p_p_s */ {
#line 285 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_newclass_from_str(interp, (*(STRING **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 728: /* subclass_p_pc_s */ {
#line 285 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, ((PMC *)cur_opcode[2])));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_newclass_from_str(interp, (*(STRING **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 729: /* subclass_p_p_sc */ {
#line 285 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_newclass_from_str(interp, ((STRING *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 730: /* subclass_p_pc_sc */ {
#line 285 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t * handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, ((PMC *)cur_opcode[2])));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_newclass_from_str(interp, ((STRING *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 731: /* subclass_p_p_p */ {
#line 300 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, (*(PMC **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 732: /* subclass_p_pc_p */ {
#line 300 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, ((PMC *)cur_opcode[2])));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, (*(PMC **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 733: /* subclass_p_p_pc */ {
#line 300 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, ((PMC *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 734: /* subclass_p_pc_pc */ {
#line 300 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", VTABLE_get_string(interp, ((PMC *)cur_opcode[2])));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, ((PMC *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 735: /* subclass_p_s */ {
#line 328 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 3;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Class);
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 736: /* subclass_p_sc */ {
#line 328 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 3;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, enum_class_Class);
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 737: /* subclass_p_s_s */ {
#line 344 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1))  = Parrot_oo_newclass_from_str(interp, (*(STRING **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 738: /* subclass_p_sc_s */ {
#line 344 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1))  = Parrot_oo_newclass_from_str(interp, (*(STRING **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 739: /* subclass_p_s_sc */ {
#line 344 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1))  = Parrot_oo_newclass_from_str(interp, ((STRING *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 740: /* subclass_p_sc_sc */ {
#line 344 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1))  = Parrot_oo_newclass_from_str(interp, ((STRING *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 741: /* subclass_p_s_p */ {
#line 360 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, (*(PMC **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 742: /* subclass_p_sc_p */ {
#line 360 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, (*(PMC **)OP_AS_OFFS(3)));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 743: /* subclass_p_s_pc */ {
#line 360 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, ((PMC *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 744: /* subclass_p_sc_pc */ {
#line 360 "src/ops/object.ops"
    PMC      * const parent_class = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));
    opcode_t * const next         = CUR_OPCODE + 4;

    if (PMC_IS_NULL(parent_class)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
            EXCEPTION_NO_CLASS,
            "Class '%Ss' doesn't exist", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, enum_class_Class, ((PMC *)cur_opcode[3]));
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), parent_class);
                {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 745: /* get_class_p_s */ {
#line 386 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_get_class_str(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 746: /* get_class_p_sc */ {
#line 386 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_get_class_str(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 747: /* get_class_p_p */ {
#line 390 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 748: /* get_class_p_pc */ {
#line 390 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_oo_get_class(interp, ((PMC *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 749: /* class_p_p */ {
#line 402 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 750: /* addparent_p_p */ {
#line 415 "src/ops/object.ops"
    VTABLE_add_parent(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 751: /* removeparent_p_p */ {
#line 425 "src/ops/object.ops"
    Parrot_remove_parent(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 752: /* addrole_p_p */ {
#line 435 "src/ops/object.ops"
    VTABLE_add_role(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 753: /* addattribute_p_s */ {
#line 445 "src/ops/object.ops"
    STRING * const class_name  = string_from_literal(interp, "Class");
    STRING * const role_name   = string_from_literal(interp, "Role");

    if (VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(1)), class_name) || VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(1)), role_name))
        VTABLE_add_attribute(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), PMCNULL);
    else {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
            EXCEPTION_INVALID_OPERATION,
            "Cannot add attribute to non-class");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 754: /* addattribute_p_sc */ {
#line 445 "src/ops/object.ops"
    STRING * const class_name  = string_from_literal(interp, "Class");
    STRING * const role_name   = string_from_literal(interp, "Role");

    if (VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(1)), class_name) || VTABLE_isa(interp, (*(PMC **)OP_AS_OFFS(1)), role_name))
        VTABLE_add_attribute(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), PMCNULL);
    else {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
            EXCEPTION_INVALID_OPERATION,
            "Cannot add attribute to non-class");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 755: /* removeattribute_p_s */ {
#line 467 "src/ops/object.ops"
    Parrot_ex_throw_from_c_args(interp, NULL, EXCEPTION_UNIMPLEMENTED,
        "removeattribute is not implemented");
}

/* removeattribute_p_sc */
case 757: /* removeattribute_p_i */ {
#line 472 "src/ops/object.ops"
    Parrot_ex_throw_from_c_args(interp, NULL, EXCEPTION_UNIMPLEMENTED,
        "removeattribute is not implemented");
}

/* removeattribute_p_ic */
case 759: /* getattribute_p_p_s */ {
#line 490 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 760: /* getattribute_p_p_sc */ {
#line 490 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 761: /* getattribute_p_p_p_s */ {
#line 494 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(STRING **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 762: /* getattribute_p_p_pc_s */ {
#line 494 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]), (*(STRING **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 763: /* getattribute_p_p_p_sc */ {
#line 494 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), ((STRING *)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 764: /* getattribute_p_p_pc_sc */ {
#line 494 "src/ops/object.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]), ((STRING *)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 765: /* setattribute_p_s_p */ {
#line 510 "src/ops/object.ops"
    VTABLE_set_attr_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 766: /* setattribute_p_sc_p */ {
#line 510 "src/ops/object.ops"
    VTABLE_set_attr_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 767: /* setattribute_p_p_s_p */ {
#line 514 "src/ops/object.ops"
    VTABLE_set_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 768: /* setattribute_p_pc_s_p */ {
#line 514 "src/ops/object.ops"
    VTABLE_set_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 769: /* setattribute_p_p_sc_p */ {
#line 514 "src/ops/object.ops"
    VTABLE_set_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 770: /* setattribute_p_pc_sc_p */ {
#line 514 "src/ops/object.ops"
    VTABLE_set_attr_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 771: /* inspect_p_p */ {
#line 532 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 772: /* inspect_p_pc */ {
#line 532 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect(interp, ((PMC *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 773: /* inspect_p_p_s */ {
#line 536 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 774: /* inspect_p_pc_s */ {
#line 536 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect_str(interp, ((PMC *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 775: /* inspect_p_p_sc */ {
#line 536 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 776: /* inspect_p_pc_sc */ {
#line 536 "src/ops/object.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_inspect_str(interp, ((PMC *)cur_opcode[2]), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 777: /* pic_infix___ic_p_p */ {
#line 39 "src/ops/pic.ops"
    Parrot_MIC *mic;
    Parrot_PIC_lru *lru;
    PMC *left, *right;
    INTVAL lr_types;

    mic = (Parrot_MIC *) cur_opcode[1];
    left = (*(PMC **)OP_AS_OFFS(2));
    right = (*(PMC **)OP_AS_OFFS(3));
    lru = &mic->lru;
    lr_types = (VTABLE_type(interp, left) << 16) | VTABLE_type(interp, right);
    if (lru->u.type == lr_types) {
runit_v_pp:
        ((mmd_f_v_pp)lru->f.real_function)(interp, left, right);
        { cur_opcode += 4; goto SWITCH_AGAIN; };
    }
    if (mic->pic) {
        lru = mic->pic->lru;
        if (lru->u.type == lr_types)
            goto runit_v_pp;
        if (++lru->u.type == lr_types)
            goto runit_v_pp;
        if (++lru->u.type == lr_types)
            goto runit_v_pp;
        mic->pic->miss_count++;
        /*
         * RT#42353 if we got too often here just do a dynamic lookup
         */
    }
    parrot_pic_find_infix_v_pp(interp, left, right, mic, cur_opcode);
    /* rerun this opcode */
    { cur_opcode += 0; goto SWITCH_AGAIN; };
}

case 778: /* pic_inline_sub___ic_p_p */ {
#line 79 "src/ops/pic.ops"
    Parrot_MIC *mic;
    Parrot_PIC_lru *lru;
    PMC *left, *right;
    INTVAL lr_types, lt, rt;

    left = (*(PMC **)OP_AS_OFFS(2));
    mic = (Parrot_MIC *) cur_opcode[1];
    lt = VTABLE_type(interp, left);
    right = (*(PMC **)OP_AS_OFFS(3));
    lru = &mic->lru;
    rt = VTABLE_type(interp, right);
    lr_types = (lt << 16) | rt;
    if (lru->u.type == lr_types) {
        INTVAL a = lt == enum_class_Integer ? PMC_int_val(left) :
            VTABLE_get_integer(interp, left);
        INTVAL b = rt == enum_class_Integer ? PMC_int_val(right) :
            VTABLE_get_integer(interp, right);
        INTVAL c = a - b;
        if ((c^a) >= 0 || (c^~b) >= 0) {
            if (lt == enum_class_Integer)
                PMC_int_val(left) = c;
            else
                VTABLE_set_integer_native(interp, left, c);
        }
        else {
            if (PARROT_ERRORS_test(interp, PARROT_ERRORS_OVERFLOW_FLAG)) {
                opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_ERR_OVERFLOW,
                        "Integer overflow");
                            {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
            }
            /* #RT42354 preserve type system */
            VTABLE_morph(interp, left, enum_class_BigInt);
            VTABLE_set_integer_native(interp, left, a);
            (*(PMC **)OP_AS_OFFS(2)) = VTABLE_subtract_int(interp, left, b, left);
        }
    }
    else {
        ((void**)cur_opcode)[0] =
            parrot_pic_opcode(interp, PARROT_OP_pic_infix___ic_p_p);
        { cur_opcode += 0; goto SWITCH_AGAIN; };
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 779: /* pic_get_params___pc */ {
#line 134 "src/ops/pic.ops"
    Parrot_MIC *mic;
    Parrot_PIC_lru *lru;
    PMC *sig, *ccont;
    opcode_t *src_pc;
    void **src_pred;
    Parrot_Context *caller_ctx, *ctx;
    int n;

    /* avoid load dependencies - intermix derefs
     * - yes, confusing but faster
     */
    ctx = CONTEXT(interp);
    src_pc = interp->current_args;
    mic = (Parrot_MIC *) cur_opcode[1];
    caller_ctx = ctx->caller_ctx;
    if (src_pc) {
        src_pred = (void**) src_pc - caller_ctx->pred_offset;
        sig = (PMC*)(src_pred[1]);
    }
    else {
        sig = NULL;
        src_pred = NULL;        /* just for gcc */
    }
    lru = &mic->lru;
    if (lru->u.signature == sig) {
        if (sig) {
            n = ((arg_pass_f)lru->f.real_function)(interp, sig,
                    (char*)caller_ctx->bp.regs_i, src_pred,
                    _reg_base, (void**)cur_opcode);
        }
        else
            n = 2;
        ccont = ctx->current_cont;
        if (PObj_get_FLAGS(ccont) & SUB_FLAG_TAILCALL) {
            PObj_get_FLAGS(ccont) &= ~SUB_FLAG_TAILCALL;
            --ctx->recursion_depth;
            ctx->caller_ctx = caller_ctx->caller_ctx;
            Parrot_free_context(interp, caller_ctx, 1);
            interp->current_args = NULL;
        }

        { cur_opcode += n; goto SWITCH_AGAIN; };
    }
    /* no match redo plain opcode */
    ((void**)cur_opcode)[0] =
        parrot_pic_opcode(interp, PARROT_OP_get_params_pc);
    ((void**)cur_opcode)[1] = mic->m.sig;
    { cur_opcode += 0; goto SWITCH_AGAIN; };
}

case 780: /* pic_set_returns___pc */ {
#line 185 "src/ops/pic.ops"
    Parrot_MIC *mic;
    Parrot_PIC_lru *lru;
    PMC *sig, *ccont;
    opcode_t *dest_pc;
    void **dest_pred;
    Parrot_Context *caller_ctx, *ctx;
    Parrot_cont *cc;
    int n;

    ctx = CONTEXT(interp);
    mic = (Parrot_MIC *) cur_opcode[1];
    ccont = ctx->current_cont;
    cc = PMC_cont(ccont);
    if (!cc->address) {
        interp->current_returns = CUR_OPCODE;
        n = PMC_int_val(mic->m.sig);
        { cur_opcode += n + 2; goto SWITCH_AGAIN; };
    }
    caller_ctx = cc->to_ctx;
    interp->current_args = NULL;
    dest_pc = caller_ctx->current_results;
    if (dest_pc) {
        dest_pred = (void**) dest_pc - caller_ctx->pred_offset;
        sig = (PMC*)(dest_pred[1]);
    }
    else {
        sig = NULL;
        dest_pred = NULL;
    }
    lru = &mic->lru;
    if (lru->u.signature == sig) {
        if (sig) {
            n = ((arg_pass_f)lru->f.real_function)(interp, mic->m.sig,
                    _reg_base, (void**)cur_opcode,
                    (char*)caller_ctx->bp.regs_i, dest_pred);
        }
        else
            n = 2;
        { cur_opcode += n; goto SWITCH_AGAIN; };
    }
    /* no match redo plain opcode */
    ((void**)cur_opcode)[0] =
        parrot_pic_opcode(interp, PARROT_OP_set_returns_pc);
    ((void**)cur_opcode)[1] = mic->m.sig;
    { cur_opcode += 0; goto SWITCH_AGAIN; };
}

case 781: /* pic_callr___pc */ {
#line 243 "src/ops/pic.ops"
    Parrot_MIC *mic;
    Parrot_PIC_lru *lru;
    void *args[6];      /* RT#42355 ARG_MAX */
    Parrot_Context *ctx;
    opcode_t *pc;
    void **pred_pc;
    INTVAL i, n_args, *sig_bits;
    PMC *sig;

    ctx = CONTEXT(interp);
    mic = (Parrot_MIC *) cur_opcode[1];
    /* get_results */
    pc = ctx->current_results;
    if (pc) {
        pred_pc = (void**) pc - ctx->pred_offset;
        sig = (PMC*)(pred_pc[1]);
        ASSERT_SIG_PMC(sig);
        PARROT_ASSERT(SIG_ELEMS(sig) <= 1);
        args[0] = SIG_ELEMS(sig) ?
            (_reg_base + ((opcode_t*)pred_pc)[2]) : NULL;
    }
    else
        args[0] = NULL;
    /* set_args */
    n_args = 0;
    sig = mic->m.sig;
    ASSERT_SIG_PMC(sig);
    n_args = SIG_ELEMS(sig);
    sig_bits = SIG_ARRAY(sig);
    for (i = 0; i < n_args; ++i) {
        switch (sig_bits[i]) {
            case PARROT_ARG_INTVAL:
                args[1 + i] = (void*)*(INTVAL*)(_reg_base +
                        ((opcode_t*)cur_opcode)[2 + i]);
                break;
            case PARROT_ARG_INTVAL|PARROT_ARG_CONSTANT:
            case PARROT_ARG_FLOATVAL|PARROT_ARG_CONSTANT:
                args[1 + i] = (void**)cur_opcode[2 + i];
                break;
            case PARROT_ARG_FLOATVAL:
                args[1 + i] = (_reg_base +
                        ((opcode_t*)cur_opcode)[2 + i]);
                break;
            default:
                {
                    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_INVALID_OPERATION,
                        "unhandled sig_bits");
                                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
                }
        }
    }
    /* set_args(); set_p_pc; get_results(1), x; invokecc_p */
    pc = CUR_OPCODE + 2 + n_args + 3 + 3 + 2;
    args[1 + n_args] = pc;
    lru = &mic->lru;
    /* RT#42356 verify ((PMC *)cur_opcode[1]) didn't change */
    (void) ((interface_f)lru->f.real_function)(interp, sig_bits, args);
                {
               cur_opcode = opcode_to_prederef(interp, pc);
               goto SWITCH_RELOAD;
            }
;
}

case 782: /* new_p_s */ {
#line 56 "src/ops/pmc.ops"
    STRING * const classname = (*(STRING **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, PMCNULL);
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, type);
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 783: /* new_p_sc */ {
#line 56 "src/ops/pmc.ops"
    STRING * const classname = ((STRING *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, PMCNULL);
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, type);
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 784: /* new_p_s_p */ {
#line 74 "src/ops/pmc.ops"
    STRING * const classname = (*(STRING **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, (*(PMC **)OP_AS_OFFS(3)));
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, (*(PMC **)OP_AS_OFFS(3)));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 785: /* new_p_sc_p */ {
#line 74 "src/ops/pmc.ops"
    STRING * const classname = ((STRING *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, (*(PMC **)OP_AS_OFFS(3)));
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, (*(PMC **)OP_AS_OFFS(3)));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 786: /* new_p_s_pc */ {
#line 74 "src/ops/pmc.ops"
    STRING * const classname = (*(STRING **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, ((PMC *)cur_opcode[3]));
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, ((PMC *)cur_opcode[3]));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 787: /* new_p_sc_pc */ {
#line 74 "src/ops/pmc.ops"
    STRING * const classname = ((STRING *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class_str(interp, classname);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, ((PMC *)cur_opcode[3]));
    else {
        const INTVAL type = pmc_type(interp, classname);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", classname);
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, ((PMC *)cur_opcode[3]));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 788: /* new_p_p */ {
#line 92 "src/ops/pmc.ops"
    PMC * const classname_key = (*(PMC **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, PMCNULL);
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, type);
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 789: /* new_p_pc */ {
#line 92 "src/ops/pmc.ops"
    PMC * const classname_key = ((PMC *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, PMCNULL);
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, type);
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 790: /* new_p_p_p */ {
#line 110 "src/ops/pmc.ops"
    PMC * const classname_key = (*(PMC **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, (*(PMC **)OP_AS_OFFS(3)));
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, (*(PMC **)OP_AS_OFFS(3)));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 791: /* new_p_pc_p */ {
#line 110 "src/ops/pmc.ops"
    PMC * const classname_key = ((PMC *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, (*(PMC **)OP_AS_OFFS(3)));
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, (*(PMC **)OP_AS_OFFS(3)));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 792: /* new_p_p_pc */ {
#line 110 "src/ops/pmc.ops"
    PMC * const classname_key = (*(PMC **)OP_AS_OFFS(2));
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, ((PMC *)cur_opcode[3]));
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, ((PMC *)cur_opcode[3]));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 793: /* new_p_pc_pc */ {
#line 110 "src/ops/pmc.ops"
    PMC * const classname_key = ((PMC *)cur_opcode[2]);
    PMC * const classobj = Parrot_oo_get_class(interp, classname_key);

    if (!PMC_IS_NULL(classobj))
        (*(PMC **)OP_AS_OFFS(1)) = VTABLE_instantiate(interp, classobj, ((PMC *)cur_opcode[3]));
    else {
        const INTVAL type = pmc_type_p(interp, classname_key);
        if (type <= 0) {
            opcode_t *dest = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 4,
                EXCEPTION_NO_CLASS,
                "Class '%Ss' not found", VTABLE_get_repr(interp, classname_key));
                        {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
        }
        (*(PMC **)OP_AS_OFFS(1)) = pmc_new_init(interp, type, ((PMC *)cur_opcode[3]));
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 794: /* typeof_s_p */ {
#line 138 "src/ops/pmc.ops"
  (*(STRING **)OP_AS_OFFS(1)) = VTABLE_name(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 795: /* typeof_p_p */ {
#line 142 "src/ops/pmc.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_class(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 796: /* get_repr_s_p */ {
#line 154 "src/ops/pmc.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_repr(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 797: /* find_method_p_p_s */ {
#line 181 "src/ops/pmc.ops"
    opcode_t * const resume = CUR_OPCODE + 4;
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_find_method(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));
    if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))) || !VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(1)))) {
        opcode_t *dest = Parrot_ex_throw_from_op_args(interp, resume,
            EXCEPTION_METHOD_NOT_FOUND,
            "Method '%Ss' not found for invocant of class '%Ss'", (*(STRING **)OP_AS_OFFS(3)),
            VTABLE_get_string(interp, VTABLE_get_class(interp, (*(PMC **)OP_AS_OFFS(2)))));
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
                {
               cur_opcode = opcode_to_prederef(interp, resume);
               goto SWITCH_RELOAD;
            }
;
}

case 798: /* find_method_p_p_sc */ {
#line 181 "src/ops/pmc.ops"
    opcode_t * const resume = CUR_OPCODE + 4;
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_find_method(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));
    if (PMC_IS_NULL((*(PMC **)OP_AS_OFFS(1))) || !VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(1)))) {
        opcode_t *dest = Parrot_ex_throw_from_op_args(interp, resume,
            EXCEPTION_METHOD_NOT_FOUND,
            "Method '%Ss' not found for invocant of class '%Ss'", ((STRING *)cur_opcode[3]),
            VTABLE_get_string(interp, VTABLE_get_class(interp, (*(PMC **)OP_AS_OFFS(2)))));
                    {
               cur_opcode = opcode_to_prederef(interp, dest);
               goto SWITCH_RELOAD;
            }
;
    }
                {
               cur_opcode = opcode_to_prederef(interp, resume);
               goto SWITCH_RELOAD;
            }
;
}

case 799: /* defined_i_p */ {
#line 213 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_defined(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 800: /* defined_i_p_ki */ {
#line 217 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_defined_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 801: /* defined_i_p_kic */ {
#line 217 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_defined_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 802: /* defined_i_p_k */ {
#line 221 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_defined_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 803: /* defined_i_p_kc */ {
#line 221 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_defined_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 804: /* exists_i_p_ki */ {
#line 225 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_exists_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 805: /* exists_i_p_kic */ {
#line 225 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0 : VTABLE_exists_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 806: /* exists_i_p_k */ {
#line 229 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0: VTABLE_exists_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 807: /* exists_i_p_kc */ {
#line 229 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = PMC_IS_NULL((*(PMC **)OP_AS_OFFS(2))) ? 0: VTABLE_exists_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 808: /* delete_p_k */ {
#line 243 "src/ops/pmc.ops"
  VTABLE_delete_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 809: /* delete_p_kc */ {
#line 243 "src/ops/pmc.ops"
  VTABLE_delete_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 810: /* delete_p_ki */ {
#line 247 "src/ops/pmc.ops"
  VTABLE_delete_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 811: /* delete_p_kic */ {
#line 247 "src/ops/pmc.ops"
  VTABLE_delete_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 812: /* elements_i_p */ {
#line 259 "src/ops/pmc.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_elements(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 813: /* push_p_i */ {
#line 291 "src/ops/pmc.ops"
    VTABLE_push_integer(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 814: /* push_p_ic */ {
#line 291 "src/ops/pmc.ops"
    VTABLE_push_integer(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 815: /* push_p_n */ {
#line 295 "src/ops/pmc.ops"
    VTABLE_push_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 816: /* push_p_nc */ {
#line 295 "src/ops/pmc.ops"
    VTABLE_push_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 817: /* push_p_s */ {
#line 299 "src/ops/pmc.ops"
    VTABLE_push_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 818: /* push_p_sc */ {
#line 299 "src/ops/pmc.ops"
    VTABLE_push_string(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 819: /* push_p_p */ {
#line 303 "src/ops/pmc.ops"
    VTABLE_push_pmc(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 820: /* pop_i_p */ {
#line 321 "src/ops/pmc.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_pop_integer(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 821: /* pop_n_p */ {
#line 325 "src/ops/pmc.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_pop_float(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 822: /* pop_s_p */ {
#line 329 "src/ops/pmc.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_pop_string(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 823: /* pop_p_p */ {
#line 333 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_pop_pmc(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 824: /* unshift_p_i */ {
#line 351 "src/ops/pmc.ops"
    VTABLE_unshift_integer(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 825: /* unshift_p_ic */ {
#line 351 "src/ops/pmc.ops"
    VTABLE_unshift_integer(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 826: /* unshift_p_n */ {
#line 355 "src/ops/pmc.ops"
    VTABLE_unshift_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 827: /* unshift_p_nc */ {
#line 355 "src/ops/pmc.ops"
    VTABLE_unshift_float(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 828: /* unshift_p_s */ {
#line 359 "src/ops/pmc.ops"
    VTABLE_unshift_string(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 829: /* unshift_p_sc */ {
#line 359 "src/ops/pmc.ops"
    VTABLE_unshift_string(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 830: /* unshift_p_p */ {
#line 363 "src/ops/pmc.ops"
    VTABLE_unshift_pmc(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 831: /* shift_i_p */ {
#line 381 "src/ops/pmc.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_shift_integer(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 832: /* shift_n_p */ {
#line 385 "src/ops/pmc.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_shift_float(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 833: /* shift_s_p */ {
#line 389 "src/ops/pmc.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_shift_string(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 834: /* shift_p_p */ {
#line 393 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_shift_pmc(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 835: /* setprop_p_s_p */ {
#line 420 "src/ops/pmc.ops"
      VTABLE_setprop(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 836: /* setprop_p_sc_p */ {
#line 420 "src/ops/pmc.ops"
      VTABLE_setprop(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 837: /* getprop_p_s_p */ {
#line 432 "src/ops/pmc.ops"
   (*(PMC **)OP_AS_OFFS(1)) = VTABLE_getprop(interp, (*(PMC **)OP_AS_OFFS(3)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 838: /* getprop_p_sc_p */ {
#line 432 "src/ops/pmc.ops"
   (*(PMC **)OP_AS_OFFS(1)) = VTABLE_getprop(interp, (*(PMC **)OP_AS_OFFS(3)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 839: /* delprop_p_s */ {
#line 444 "src/ops/pmc.ops"
   VTABLE_delprop(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 840: /* delprop_p_sc */ {
#line 444 "src/ops/pmc.ops"
   VTABLE_delprop(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 841: /* prophash_p_p */ {
#line 457 "src/ops/pmc.ops"
   (*(PMC **)OP_AS_OFFS(1)) = VTABLE_getprops(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 842: /* freeze_s_p */ {
#line 487 "src/ops/pmc.ops"
   (*(STRING **)OP_AS_OFFS(1)) = Parrot_freeze(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 843: /* thaw_p_s */ {
#line 491 "src/ops/pmc.ops"
   (*(PMC **)OP_AS_OFFS(1)) = Parrot_thaw(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 844: /* thaw_p_sc */ {
#line 491 "src/ops/pmc.ops"
   (*(PMC **)OP_AS_OFFS(1)) = Parrot_thaw(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 845: /* add_multi_s_s_p */ {
#line 522 "src/ops/pmc.ops"
  Parrot_mmd_add_multi_from_long_sig(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 846: /* add_multi_sc_s_p */ {
#line 522 "src/ops/pmc.ops"
  Parrot_mmd_add_multi_from_long_sig(interp, ((STRING *)cur_opcode[1]), (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 847: /* add_multi_s_sc_p */ {
#line 522 "src/ops/pmc.ops"
  Parrot_mmd_add_multi_from_long_sig(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 848: /* add_multi_sc_sc_p */ {
#line 522 "src/ops/pmc.ops"
  Parrot_mmd_add_multi_from_long_sig(interp, ((STRING *)cur_opcode[1]), ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 849: /* find_multi_p_s_s */ {
#line 532 "src/ops/pmc.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_mmd_find_multi_from_long_sig(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 850: /* find_multi_p_sc_s */ {
#line 532 "src/ops/pmc.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_mmd_find_multi_from_long_sig(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 851: /* find_multi_p_s_sc */ {
#line 532 "src/ops/pmc.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_mmd_find_multi_from_long_sig(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 852: /* find_multi_p_sc_sc */ {
#line 532 "src/ops/pmc.ops"
  (*(PMC **)OP_AS_OFFS(1)) = Parrot_mmd_find_multi_from_long_sig(interp, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 853: /* register_p */ {
#line 565 "src/ops/pmc.ops"
  dod_register_pmc(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 854: /* unregister_p */ {
#line 569 "src/ops/pmc.ops"
  dod_unregister_pmc(interp, (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 855: /* box_p_i */ {
#line 586 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_Integer));
    VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 856: /* box_p_ic */ {
#line 586 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_Integer));
    VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 857: /* box_p_n */ {
#line 591 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_Float));
    VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 858: /* box_p_nc */ {
#line 591 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_Float));
    VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 859: /* box_p_s */ {
#line 596 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_String));
    VTABLE_set_string_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 860: /* box_p_sc */ {
#line 596 "src/ops/pmc.ops"
    (*(PMC **)OP_AS_OFFS(1)) = pmc_new(interp, Parrot_get_ctx_HLL_type(interp, enum_class_String));
    VTABLE_set_string_native(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 861: /* clone_s_s */ {
#line 30 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_copy(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 862: /* clone_s_sc */ {
#line 30 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_copy(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 863: /* exchange_i_i */ {
#line 50 "src/ops/set.ops"
   const INTVAL temp = (*(INTVAL *)OP_AS_OFFS(1));
   (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2));
   (*(INTVAL *)OP_AS_OFFS(2)) = temp;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 864: /* exchange_p_p */ {
#line 56 "src/ops/set.ops"
   PMC * const temp = (*(PMC **)OP_AS_OFFS(1));
   (*(PMC **)OP_AS_OFFS(1)) = (*(PMC **)OP_AS_OFFS(2));
   (*(PMC **)OP_AS_OFFS(2)) = temp;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 865: /* exchange_n_n */ {
#line 62 "src/ops/set.ops"
   FLOATVAL temp = (*(FLOATVAL *)OP_AS_OFFS(1));
   (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2));
   (*(FLOATVAL *)OP_AS_OFFS(2)) = temp;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 866: /* exchange_s_s */ {
#line 68 "src/ops/set.ops"
   STRING * const temp = (*(STRING **)OP_AS_OFFS(1));
   (*(STRING **)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2));
   (*(STRING **)OP_AS_OFFS(2)) = temp;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 867: /* set_i_i */ {
#line 120 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 868: /* set_i_ic */ {
#line 120 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 869: /* set_i_n */ {
#line 124 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)((*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 870: /* set_i_nc */ {
#line 124 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)((*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 871: /* set_i_s */ {
#line 128 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_to_int(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 872: /* set_i_sc */ {
#line 128 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = string_to_int(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 873: /* set_n_n */ {
#line 132 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 874: /* set_n_nc */ {
#line 132 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 875: /* set_n_i */ {
#line 136 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (FLOATVAL)(*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 876: /* set_n_ic */ {
#line 136 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = (FLOATVAL)((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 877: /* set_n_s */ {
#line 140 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = string_to_num(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 878: /* set_n_sc */ {
#line 140 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = string_to_num(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 879: /* set_n_p */ {
#line 144 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_get_number(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 880: /* set_s_p */ {
#line 148 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 881: /* set_s_s */ {
#line 152 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 882: /* set_s_sc */ {
#line 156 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_copy(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 883: /* set_s_i */ {
#line 160 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_from_int(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 884: /* set_s_ic */ {
#line 160 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_from_int(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 885: /* set_s_n */ {
#line 164 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_from_num(interp, (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 886: /* set_s_nc */ {
#line 164 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_from_num(interp, (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 887: /* set_p_pc */ {
#line 168 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = ((PMC *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 888: /* set_p_p */ {
#line 172 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = (*(PMC **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 889: /* set_p_i */ {
#line 176 "src/ops/set.ops"
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 890: /* set_p_ic */ {
#line 176 "src/ops/set.ops"
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 891: /* set_p_n */ {
#line 180 "src/ops/set.ops"
  VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 892: /* set_p_nc */ {
#line 180 "src/ops/set.ops"
  VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 893: /* set_p_s */ {
#line 184 "src/ops/set.ops"
  VTABLE_set_string_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 894: /* set_p_sc */ {
#line 188 "src/ops/set.ops"
  VTABLE_set_string_native(interp, (*(PMC **)OP_AS_OFFS(1)),
    string_copy(interp, ((STRING *)cur_opcode[2])));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 895: /* set_i_p */ {
#line 192 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_integer(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 896: /* assign_p_p */ {
#line 233 "src/ops/set.ops"
  VTABLE_assign_pmc(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 897: /* assign_p_i */ {
#line 237 "src/ops/set.ops"
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 898: /* assign_p_ic */ {
#line 237 "src/ops/set.ops"
  VTABLE_set_integer_native(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 899: /* assign_p_n */ {
#line 241 "src/ops/set.ops"
  VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

    default:
    switch (*(opcode_t*)cur_opcode) {
case 900: /* assign_p_nc */ {
#line 241 "src/ops/set.ops"
  VTABLE_set_number_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(FLOATVAL *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 901: /* assign_p_s */ {
#line 245 "src/ops/set.ops"
  VTABLE_assign_string_native(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 902: /* assign_p_sc */ {
#line 245 "src/ops/set.ops"
  VTABLE_assign_string_native(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 903: /* assign_s_s */ {
#line 249 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_set(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 904: /* assign_s_sc */ {
#line 249 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_set(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 905: /* setref_p_p */ {
#line 253 "src/ops/set.ops"
  VTABLE_set_pmc(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 906: /* deref_p_p */ {
#line 257 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 907: /* setp_ind_i_p */ {
#line 275 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_PMC(interp, (*(INTVAL *)OP_AS_OFFS(1))) = (*(PMC **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 908: /* setp_ind_ic_p */ {
#line 275 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_PMC(interp, ((INTVAL)cur_opcode[1])) = (*(PMC **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 909: /* setn_ind_i_n */ {
#line 289 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_NUM(interp, (*(INTVAL *)OP_AS_OFFS(1))) = (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 910: /* setn_ind_ic_n */ {
#line 289 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_NUM(interp, ((INTVAL)cur_opcode[1])) = (*(FLOATVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 911: /* setn_ind_i_nc */ {
#line 289 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_NUM(interp, (*(INTVAL *)OP_AS_OFFS(1))) = (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 912: /* setn_ind_ic_nc */ {
#line 289 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_NUM(interp, ((INTVAL)cur_opcode[1])) = (*(FLOATVAL *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 913: /* sets_ind_i_s */ {
#line 303 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_STR(interp, (*(INTVAL *)OP_AS_OFFS(1))) = (*(STRING **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 914: /* sets_ind_ic_s */ {
#line 303 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_STR(interp, ((INTVAL)cur_opcode[1])) = (*(STRING **)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 915: /* sets_ind_i_sc */ {
#line 303 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_STR(interp, (*(INTVAL *)OP_AS_OFFS(1))) = ((STRING *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 916: /* sets_ind_ic_sc */ {
#line 303 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_STR(interp, ((INTVAL)cur_opcode[1])) = ((STRING *)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 917: /* seti_ind_i_i */ {
#line 317 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_INT(interp, (*(INTVAL *)OP_AS_OFFS(1))) = (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 918: /* seti_ind_ic_i */ {
#line 317 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_INT(interp, ((INTVAL)cur_opcode[1])) = (*(INTVAL *)OP_AS_OFFS(2));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 919: /* seti_ind_i_ic */ {
#line 317 "src/ops/set.ops"
    if ((*(INTVAL *)OP_AS_OFFS(1)) < 0 || (*(INTVAL *)OP_AS_OFFS(1)) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_INT(interp, (*(INTVAL *)OP_AS_OFFS(1))) = ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 920: /* seti_ind_ic_ic */ {
#line 317 "src/ops/set.ops"
    if (((INTVAL)cur_opcode[1]) < 0 || ((INTVAL)cur_opcode[1]) >= NUM_REGISTERS)
        PANIC(interp, "Out of bound register access");
    REG_INT(interp, ((INTVAL)cur_opcode[1])) = ((INTVAL)cur_opcode[2]);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 921: /* set_p_ki_i */ {
#line 343 "src/ops/set.ops"
    VTABLE_set_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 922: /* set_p_kic_i */ {
#line 343 "src/ops/set.ops"
    VTABLE_set_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 923: /* set_p_ki_ic */ {
#line 343 "src/ops/set.ops"
    VTABLE_set_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 924: /* set_p_kic_ic */ {
#line 343 "src/ops/set.ops"
    VTABLE_set_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 925: /* set_p_ki_n */ {
#line 347 "src/ops/set.ops"
    VTABLE_set_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 926: /* set_p_kic_n */ {
#line 347 "src/ops/set.ops"
    VTABLE_set_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 927: /* set_p_ki_nc */ {
#line 347 "src/ops/set.ops"
    VTABLE_set_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 928: /* set_p_kic_nc */ {
#line 347 "src/ops/set.ops"
    VTABLE_set_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 929: /* set_p_ki_s */ {
#line 351 "src/ops/set.ops"
    VTABLE_set_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 930: /* set_p_kic_s */ {
#line 351 "src/ops/set.ops"
    VTABLE_set_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 931: /* set_p_ki_sc */ {
#line 351 "src/ops/set.ops"
    VTABLE_set_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 932: /* set_p_kic_sc */ {
#line 351 "src/ops/set.ops"
    VTABLE_set_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 933: /* set_p_ki_p */ {
#line 355 "src/ops/set.ops"
    VTABLE_set_pmc_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 934: /* set_p_kic_p */ {
#line 355 "src/ops/set.ops"
    VTABLE_set_pmc_keyed_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 935: /* set_i_p_ki */ {
#line 379 "src/ops/set.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 936: /* set_i_p_kic */ {
#line 379 "src/ops/set.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_integer_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 937: /* set_n_p_ki */ {
#line 383 "src/ops/set.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_get_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 938: /* set_n_p_kic */ {
#line 383 "src/ops/set.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_get_number_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 939: /* set_s_p_ki */ {
#line 387 "src/ops/set.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 940: /* set_s_p_kic */ {
#line 387 "src/ops/set.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_string_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 941: /* set_p_p_ki */ {
#line 391 "src/ops/set.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 942: /* set_p_p_kic */ {
#line 391 "src/ops/set.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 943: /* set_p_k_i */ {
#line 415 "src/ops/set.ops"
    VTABLE_set_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 944: /* set_p_kc_i */ {
#line 415 "src/ops/set.ops"
    VTABLE_set_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 945: /* set_p_k_ic */ {
#line 415 "src/ops/set.ops"
    VTABLE_set_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 946: /* set_p_kc_ic */ {
#line 415 "src/ops/set.ops"
    VTABLE_set_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 947: /* set_p_k_n */ {
#line 419 "src/ops/set.ops"
    VTABLE_set_number_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 948: /* set_p_kc_n */ {
#line 419 "src/ops/set.ops"
    VTABLE_set_number_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(FLOATVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 949: /* set_p_k_nc */ {
#line 419 "src/ops/set.ops"
    VTABLE_set_number_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 950: /* set_p_kc_nc */ {
#line 419 "src/ops/set.ops"
    VTABLE_set_number_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(FLOATVAL *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 951: /* set_p_k_s */ {
#line 423 "src/ops/set.ops"
    VTABLE_set_string_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 952: /* set_p_kc_s */ {
#line 423 "src/ops/set.ops"
    VTABLE_set_string_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 953: /* set_p_k_sc */ {
#line 423 "src/ops/set.ops"
    VTABLE_set_string_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 954: /* set_p_kc_sc */ {
#line 423 "src/ops/set.ops"
    VTABLE_set_string_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 955: /* set_p_k_p */ {
#line 427 "src/ops/set.ops"
    VTABLE_set_pmc_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 956: /* set_p_kc_p */ {
#line 427 "src/ops/set.ops"
    VTABLE_set_pmc_keyed(interp, (*(PMC **)OP_AS_OFFS(1)), ((PMC *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 957: /* set_i_p_k */ {
#line 451 "src/ops/set.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 958: /* set_i_p_kc */ {
#line 451 "src/ops/set.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = VTABLE_get_integer_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 959: /* set_n_p_k */ {
#line 455 "src/ops/set.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_get_number_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 960: /* set_n_p_kc */ {
#line 455 "src/ops/set.ops"
    (*(FLOATVAL *)OP_AS_OFFS(1)) = VTABLE_get_number_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 961: /* set_s_p_k */ {
#line 459 "src/ops/set.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_string_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 962: /* set_s_p_kc */ {
#line 459 "src/ops/set.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_get_string_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 963: /* set_p_p_k */ {
#line 463 "src/ops/set.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 964: /* set_p_p_kc */ {
#line 463 "src/ops/set.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_pmc_keyed(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 965: /* clone_p_p */ {
#line 473 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_clone(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 966: /* clone_p_p_p */ {
#line 483 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_clone_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 967: /* clone_p_p_pc */ {
#line 483 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = VTABLE_clone_pmc(interp, (*(PMC **)OP_AS_OFFS(2)), ((PMC *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 968: /* copy_p_p */ {
#line 493 "src/ops/set.ops"
  PMC   * const clone = VTABLE_clone(interp, (*(PMC **)OP_AS_OFFS(2)));
  INTVAL type         = VTABLE_type(interp, (*(PMC **)OP_AS_OFFS(2)));

  /* Preserve the metadata on the destination. */
  PMC   * const meta  = VTABLE_getprops(interp, (*(PMC **)OP_AS_OFFS(1)));

  /* avoid leaks and unreachable memory by destroying the destination PMC */
  if (PObj_active_destroy_TEST((*(PMC **)OP_AS_OFFS(1))))
      VTABLE_destroy(interp, (*(PMC **)OP_AS_OFFS(1)));

  /* the source PMC knows how to clone itself, but we must reuse the
   destination header */
  memmove((*(PMC **)OP_AS_OFFS(1)), clone, sizeof (PMC));

  /* don't let the clone's destruction destroy the destination's data */
  PObj_active_destroy_CLEAR(clone);
  if (PObj_is_PMC_EXT_TEST(clone))
    clone->pmc_ext = NULL;

  /* Restore metadata. */
  if (!PMC_IS_NULL(meta)) {
      PMC * const iter = VTABLE_get_iter(interp, meta);
      while (VTABLE_get_bool(interp, iter)) {
          STRING * const key = VTABLE_shift_string(interp, iter);
          PMC * const value  = VTABLE_get_pmc_keyed_str(interp, meta, key);
          VTABLE_setprop(interp, (*(PMC **)OP_AS_OFFS(1)), key, value);
      }
  }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 969: /* null_s */ {
#line 556 "src/ops/set.ops"
  (*(STRING **)OP_AS_OFFS(1)) = NULL;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 970: /* null_i */ {
#line 560 "src/ops/set.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = 0;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 971: /* null_p */ {
#line 564 "src/ops/set.ops"
  (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 972: /* null_n */ {
#line 568 "src/ops/set.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = 0;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 973: /* cleari */ {
#line 590 "src/ops/set.ops"
  Parrot_clear_i(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 974: /* clearn */ {
#line 594 "src/ops/set.ops"
  Parrot_clear_n(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 975: /* clears */ {
#line 598 "src/ops/set.ops"
  Parrot_clear_s(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 976: /* clearp */ {
#line 602 "src/ops/set.ops"
  Parrot_clear_p(interp);

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 977: /* ord_i_s */ {
#line 42 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, (*(STRING **)OP_AS_OFFS(2)), 0);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 978: /* ord_i_sc */ {
#line 42 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, ((STRING *)cur_opcode[2]), 0);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 979: /* ord_i_s_i */ {
#line 46 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 980: /* ord_i_sc_i */ {
#line 46 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 981: /* ord_i_s_ic */ {
#line 46 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 982: /* ord_i_sc_ic */ {
#line 46 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = string_ord(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 983: /* chr_s_i */ {
#line 58 "src/ops/string.ops"
    STRING * const s = string_chr(interp, (UINTVAL)(*(INTVAL *)OP_AS_OFFS(2)));
    (*(STRING **)OP_AS_OFFS(1)) = s;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 984: /* chr_s_ic */ {
#line 58 "src/ops/string.ops"
    STRING * const s = string_chr(interp, (UINTVAL)((INTVAL)cur_opcode[2]));
    (*(STRING **)OP_AS_OFFS(1)) = s;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 985: /* chopn_s_i */ {
#line 77 "src/ops/string.ops"
    string_chopn_inplace(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 986: /* chopn_s_ic */ {
#line 77 "src/ops/string.ops"
    string_chopn_inplace(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 987: /* chopn_s_s_i */ {
#line 81 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_chopn(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 988: /* chopn_s_sc_i */ {
#line 81 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_chopn(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 989: /* chopn_s_s_ic */ {
#line 81 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_chopn(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 990: /* chopn_s_sc_ic */ {
#line 81 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_chopn(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 991: /* concat_s_s */ {
#line 104 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_append(interp, (*(STRING **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 992: /* concat_s_sc */ {
#line 104 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_append(interp, (*(STRING **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 993: /* concat_p_p */ {
#line 108 "src/ops/string.ops"
      VTABLE_i_concatenate(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 994: /* concat_p_s */ {
#line 112 "src/ops/string.ops"
      VTABLE_i_concatenate_str(interp, (*(PMC **)OP_AS_OFFS(1)), (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 995: /* concat_p_sc */ {
#line 112 "src/ops/string.ops"
      VTABLE_i_concatenate_str(interp, (*(PMC **)OP_AS_OFFS(1)), ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 996: /* concat_s_s_s */ {
#line 116 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_concat(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), 1);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 997: /* concat_s_sc_s */ {
#line 116 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_concat(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), 1);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 998: /* concat_s_s_sc */ {
#line 116 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_concat(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), 1);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 999: /* concat_p_p_s */ {
#line 120 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_concatenate_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1000: /* concat_p_p_sc */ {
#line 120 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_concatenate_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1001: /* concat_p_p_p */ {
#line 124 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_concatenate(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1002: /* repeat_s_s_i */ {
#line 139 "src/ops/string.ops"
    if ((*(INTVAL *)OP_AS_OFFS(3)) < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_NEG_REPEAT,
                "Cannot repeat with negative arg");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(STRING **)OP_AS_OFFS(1)) = string_repeat(interp, (*(STRING **)OP_AS_OFFS(2)), (UINTVAL)(*(INTVAL *)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1003: /* repeat_s_sc_i */ {
#line 139 "src/ops/string.ops"
    if ((*(INTVAL *)OP_AS_OFFS(3)) < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_NEG_REPEAT,
                "Cannot repeat with negative arg");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(STRING **)OP_AS_OFFS(1)) = string_repeat(interp, ((STRING *)cur_opcode[2]), (UINTVAL)(*(INTVAL *)OP_AS_OFFS(3)), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1004: /* repeat_s_s_ic */ {
#line 139 "src/ops/string.ops"
    if (((INTVAL)cur_opcode[3]) < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_NEG_REPEAT,
                "Cannot repeat with negative arg");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(STRING **)OP_AS_OFFS(1)) = string_repeat(interp, (*(STRING **)OP_AS_OFFS(2)), (UINTVAL)((INTVAL)cur_opcode[3]), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1005: /* repeat_s_sc_ic */ {
#line 139 "src/ops/string.ops"
    if (((INTVAL)cur_opcode[3]) < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_NEG_REPEAT,
                "Cannot repeat with negative arg");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(STRING **)OP_AS_OFFS(1)) = string_repeat(interp, ((STRING *)cur_opcode[2]), (UINTVAL)((INTVAL)cur_opcode[3]), NULL);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1006: /* repeat_p_p_i */ {
#line 149 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_repeat_int(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1007: /* repeat_p_p_ic */ {
#line 149 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_repeat_int(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1008: /* repeat_p_p_p */ {
#line 153 "src/ops/string.ops"
      (*(PMC **)OP_AS_OFFS(1)) = VTABLE_repeat(interp, (*(PMC **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)), (*(PMC **)OP_AS_OFFS(1)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1009: /* repeat_p_i */ {
#line 166 "src/ops/string.ops"
      VTABLE_i_repeat_int(interp, (*(PMC **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1010: /* repeat_p_ic */ {
#line 166 "src/ops/string.ops"
      VTABLE_i_repeat_int(interp, (*(PMC **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1011: /* repeat_p_p */ {
#line 170 "src/ops/string.ops"
      VTABLE_i_repeat(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1012: /* length_i_s */ {
#line 187 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2)) ? string_length(interp, (*(STRING **)OP_AS_OFFS(2))) : 0;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1013: /* length_i_sc */ {
#line 187 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2]) ? string_length(interp, ((STRING *)cur_opcode[2])) : 0;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1014: /* bytelength_i_s */ {
#line 191 "src/ops/string.ops"
    UINTVAL n;
    STRING * const s = (*(STRING **)OP_AS_OFFS(2));
    if (!s)
        n = 0;
    else {
        n = s->bufused;
        PARROT_ASSERT(n == ENCODING_BYTES(interp, (*(STRING **)OP_AS_OFFS(2))));
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1015: /* bytelength_i_sc */ {
#line 191 "src/ops/string.ops"
    UINTVAL n;
    STRING * const s = ((STRING *)cur_opcode[2]);
    if (!s)
        n = 0;
    else {
        n = s->bufused;
        PARROT_ASSERT(n == ENCODING_BYTES(interp, ((STRING *)cur_opcode[2])));
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1016: /* pin_s */ {
#line 214 "src/ops/string.ops"
    string_pin(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1017: /* unpin_s */ {
#line 226 "src/ops/string.ops"
    string_unpin(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1018: /* substr_s_s_i */ {
#line 262 "src/ops/string.ops"
    const INTVAL len = string_length(interp, (*(STRING **)OP_AS_OFFS(2)));
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), len, &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1019: /* substr_s_sc_i */ {
#line 262 "src/ops/string.ops"
    const INTVAL len = string_length(interp, ((STRING *)cur_opcode[2]));
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), len, &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1020: /* substr_s_s_ic */ {
#line 262 "src/ops/string.ops"
    const INTVAL len = string_length(interp, (*(STRING **)OP_AS_OFFS(2)));
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), len, &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1021: /* substr_s_sc_ic */ {
#line 262 "src/ops/string.ops"
    const INTVAL len = string_length(interp, ((STRING *)cur_opcode[2]));
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), len, &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1022: /* substr_s_s_i_i */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1023: /* substr_s_sc_i_i */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1024: /* substr_s_s_ic_i */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1025: /* substr_s_sc_ic_i */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1026: /* substr_s_s_i_ic */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1027: /* substr_s_sc_i_ic */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1028: /* substr_s_s_ic_ic */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1029: /* substr_s_sc_ic_ic */ {
#line 267 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), &(*(STRING **)OP_AS_OFFS(1)), 0);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1030: /* substr_s_s_i_i_s */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), (*(STRING **)OP_AS_OFFS(5)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1031: /* substr_s_s_ic_i_s */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), (*(STRING **)OP_AS_OFFS(5)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1032: /* substr_s_s_i_ic_s */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), (*(STRING **)OP_AS_OFFS(5)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1033: /* substr_s_s_ic_ic_s */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), (*(STRING **)OP_AS_OFFS(5)), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1034: /* substr_s_s_i_i_sc */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), ((STRING *)cur_opcode[5]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1035: /* substr_s_s_ic_i_sc */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), ((STRING *)cur_opcode[5]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1036: /* substr_s_s_i_ic_sc */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), ((STRING *)cur_opcode[5]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1037: /* substr_s_s_ic_ic_sc */ {
#line 271 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_replace(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), ((STRING *)cur_opcode[5]), &(*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1038: /* substr_s_i_i_s */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(STRING **)OP_AS_OFFS(4)), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1039: /* substr_s_ic_i_s */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), (*(STRING **)OP_AS_OFFS(4)), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1040: /* substr_s_i_ic_s */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(STRING **)OP_AS_OFFS(4)), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1041: /* substr_s_ic_ic_s */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3]), (*(STRING **)OP_AS_OFFS(4)), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1042: /* substr_s_i_i_sc */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((STRING *)cur_opcode[4]), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1043: /* substr_s_ic_i_sc */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), ((STRING *)cur_opcode[4]), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1044: /* substr_s_i_ic_sc */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((STRING *)cur_opcode[4]), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1045: /* substr_s_ic_ic_sc */ {
#line 275 "src/ops/string.ops"
    (void)string_replace(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), ((INTVAL)cur_opcode[3]), ((STRING *)cur_opcode[4]), NULL);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1046: /* substr_s_p_i_i */ {
#line 279 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_substr_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1047: /* substr_s_p_ic_i */ {
#line 279 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_substr_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1048: /* substr_s_p_i_ic */ {
#line 279 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_substr_str(interp, (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1049: /* substr_s_p_ic_ic */ {
#line 279 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = VTABLE_substr_str(interp, (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1050: /* index_i_s_s */ {
#line 299 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), 0) : -1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1051: /* index_i_sc_s */ {
#line 299 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), 0) : -1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1052: /* index_i_s_sc */ {
#line 299 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), 0) : -1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1053: /* index_i_sc_sc */ {
#line 299 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]), 0) : -1;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1054: /* index_i_s_s_i */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4))) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1055: /* index_i_sc_s_i */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4))) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1056: /* index_i_s_sc_i */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4))) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1057: /* index_i_sc_sc_i */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4))) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1058: /* index_i_s_s_ic */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4])) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1059: /* index_i_sc_s_ic */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && (*(STRING **)OP_AS_OFFS(3))) ? string_str_index(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4])) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1060: /* index_i_s_sc_ic */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = ((*(STRING **)OP_AS_OFFS(2)) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4])) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1061: /* index_i_sc_sc_ic */ {
#line 303 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = (((STRING *)cur_opcode[2]) && ((STRING *)cur_opcode[3])) ? string_str_index(interp, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4])) : -1;

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1062: /* sprintf_s_s_p */ {
#line 323 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1))=Parrot_psprintf(interp, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1063: /* sprintf_s_sc_p */ {
#line 323 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1))=Parrot_psprintf(interp, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1064: /* sprintf_p_p_p */ {
#line 327 "src/ops/string.ops"
    VTABLE_set_string_native(interp, (*(PMC **)OP_AS_OFFS(1)),
        Parrot_psprintf(interp, VTABLE_get_string(interp, (*(PMC **)OP_AS_OFFS(2))), (*(PMC **)OP_AS_OFFS(3))));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1065: /* new_s */ {
#line 341 "src/ops/string.ops"
  (*(STRING **)OP_AS_OFFS(1)) = string_make_empty(interp, enum_stringrep_one, 0);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1066: /* new_s_i */ {
#line 345 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_make_empty(interp, enum_stringrep_one, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1067: /* new_s_ic */ {
#line 345 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_make_empty(interp, enum_stringrep_one, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1068: /* stringinfo_i_s_i */ {
#line 375 "src/ops/string.ops"
    if ((*(STRING **)OP_AS_OFFS(2)) == NULL)
        (*(INTVAL *)OP_AS_OFFS(1)) = 0;
    else {
        switch ((*(INTVAL *)OP_AS_OFFS(3))) {
            case STRINGINFO_HEADER:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_STRSTART:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL((*(STRING **)OP_AS_OFFS(2))->strstart);
                break;
            case STRINGINFO_BUFLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_buflen((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_FLAGS:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_get_FLAGS((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_BUFUSED:
                (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2))->bufused;
                break;
            case STRINGINFO_STRLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2))->strlen;
                break;
            default:
                {
                    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_INVALID_OPERATION,
                        "stringinfo: unknown info type: %d", (*(INTVAL *)OP_AS_OFFS(3)));
                                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
                }
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1069: /* stringinfo_i_sc_i */ {
#line 375 "src/ops/string.ops"
    if (((STRING *)cur_opcode[2]) == NULL)
        (*(INTVAL *)OP_AS_OFFS(1)) = 0;
    else {
        switch ((*(INTVAL *)OP_AS_OFFS(3))) {
            case STRINGINFO_HEADER:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_STRSTART:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL(((STRING *)cur_opcode[2])->strstart);
                break;
            case STRINGINFO_BUFLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_buflen(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_FLAGS:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_get_FLAGS(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_BUFUSED:
                (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2])->bufused;
                break;
            case STRINGINFO_STRLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2])->strlen;
                break;
            default:
                {
                    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_INVALID_OPERATION,
                        "stringinfo: unknown info type: %d", (*(INTVAL *)OP_AS_OFFS(3)));
                                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
                }
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1070: /* stringinfo_i_s_ic */ {
#line 375 "src/ops/string.ops"
    if ((*(STRING **)OP_AS_OFFS(2)) == NULL)
        (*(INTVAL *)OP_AS_OFFS(1)) = 0;
    else {
        switch (((INTVAL)cur_opcode[3])) {
            case STRINGINFO_HEADER:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_STRSTART:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL((*(STRING **)OP_AS_OFFS(2))->strstart);
                break;
            case STRINGINFO_BUFLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_buflen((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_FLAGS:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_get_FLAGS((*(STRING **)OP_AS_OFFS(2)));
                break;
            case STRINGINFO_BUFUSED:
                (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2))->bufused;
                break;
            case STRINGINFO_STRLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = (*(STRING **)OP_AS_OFFS(2))->strlen;
                break;
            default:
                {
                    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_INVALID_OPERATION,
                        "stringinfo: unknown info type: %d", ((INTVAL)cur_opcode[3]));
                                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
                }
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1071: /* stringinfo_i_sc_ic */ {
#line 375 "src/ops/string.ops"
    if (((STRING *)cur_opcode[2]) == NULL)
        (*(INTVAL *)OP_AS_OFFS(1)) = 0;
    else {
        switch (((INTVAL)cur_opcode[3])) {
            case STRINGINFO_HEADER:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_STRSTART:
                (*(INTVAL *)OP_AS_OFFS(1)) = PTR2UINTVAL(((STRING *)cur_opcode[2])->strstart);
                break;
            case STRINGINFO_BUFLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_buflen(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_FLAGS:
                (*(INTVAL *)OP_AS_OFFS(1)) = PObj_get_FLAGS(((STRING *)cur_opcode[2]));
                break;
            case STRINGINFO_BUFUSED:
                (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2])->bufused;
                break;
            case STRINGINFO_STRLEN:
                (*(INTVAL *)OP_AS_OFFS(1)) = ((STRING *)cur_opcode[2])->strlen;
                break;
            default:
                {
                    opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                        EXCEPTION_INVALID_OPERATION,
                        "stringinfo: unknown info type: %d", ((INTVAL)cur_opcode[3]));
                                {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
                }
        }
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1072: /* upcase_s_s */ {
#line 420 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_upcase(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1073: /* upcase_s_sc */ {
#line 420 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_upcase(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1074: /* upcase_s */ {
#line 424 "src/ops/string.ops"
    string_upcase_inplace(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1075: /* downcase_s_s */ {
#line 439 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_downcase(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1076: /* downcase_s_sc */ {
#line 439 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_downcase(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1077: /* downcase_s */ {
#line 443 "src/ops/string.ops"
    string_downcase_inplace(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1078: /* titlecase_s_s */ {
#line 458 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_titlecase(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1079: /* titlecase_s_sc */ {
#line 458 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_titlecase(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1080: /* titlecase_s */ {
#line 462 "src/ops/string.ops"
    string_titlecase_inplace(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1081: /* join_s_s_p */ {
#line 484 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_join(interp, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1082: /* join_s_sc_p */ {
#line 484 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_join(interp, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1083: /* split_p_s_s */ {
#line 488 "src/ops/string.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_string_split(interp, (*(STRING **)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1084: /* split_p_sc_s */ {
#line 488 "src/ops/string.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_string_split(interp, ((STRING *)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1085: /* split_p_s_sc */ {
#line 488 "src/ops/string.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_string_split(interp, (*(STRING **)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1086: /* split_p_sc_sc */ {
#line 488 "src/ops/string.ops"
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_string_split(interp, ((STRING *)cur_opcode[2]), ((STRING *)cur_opcode[3]));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1087: /* charset_i_s */ {
#line 519 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_charset_number_of_str(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1088: /* charset_i_sc */ {
#line 519 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_charset_number_of_str(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1089: /* charsetname_s_i */ {
#line 523 "src/ops/string.ops"
    STRING * const name = Parrot_charset_name(interp, (*(INTVAL *)OP_AS_OFFS(2)));
    (*(STRING **)OP_AS_OFFS(1)) = name ? string_copy(interp, name) : NULL;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1090: /* charsetname_s_ic */ {
#line 523 "src/ops/string.ops"
    STRING * const name = Parrot_charset_name(interp, ((INTVAL)cur_opcode[2]));
    (*(STRING **)OP_AS_OFFS(1)) = name ? string_copy(interp, name) : NULL;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1091: /* find_charset_i_s */ {
#line 528 "src/ops/string.ops"
    const INTVAL n = Parrot_charset_number(interp, (*(STRING **)OP_AS_OFFS(2)));
    if (n < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_CHARTYPE,
                "charset '%Ss' not found", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1092: /* find_charset_i_sc */ {
#line 528 "src/ops/string.ops"
    const INTVAL n = Parrot_charset_number(interp, ((STRING *)cur_opcode[2]));
    if (n < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_CHARTYPE,
                "charset '%Ss' not found", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1093: /* trans_charset_s_i */ {
#line 539 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1094: /* trans_charset_s_ic */ {
#line 539 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1095: /* trans_charset_s_s_i */ {
#line 543 "src/ops/string.ops"
    STRING *dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1096: /* trans_charset_s_sc_i */ {
#line 543 "src/ops/string.ops"
    STRING *dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1097: /* trans_charset_s_s_ic */ {
#line 543 "src/ops/string.ops"
    STRING *dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1098: /* trans_charset_s_sc_ic */ {
#line 543 "src/ops/string.ops"
    STRING *dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_charset(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1099: /* encoding_i_s */ {
#line 575 "src/ops/string.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_encoding_number_of_str(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1100: /* encoding_i_sc */ {
#line 575 "src/ops/string.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_encoding_number_of_str(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1101: /* encodingname_s_i */ {
#line 579 "src/ops/string.ops"
    STRING * const name = Parrot_encoding_name(interp, (*(INTVAL *)OP_AS_OFFS(2)));
    (*(STRING **)OP_AS_OFFS(1)) = name ? string_copy(interp, name) : NULL;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1102: /* encodingname_s_ic */ {
#line 579 "src/ops/string.ops"
    STRING * const name = Parrot_encoding_name(interp, ((INTVAL)cur_opcode[2]));
    (*(STRING **)OP_AS_OFFS(1)) = name ? string_copy(interp, name) : NULL;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1103: /* find_encoding_i_s */ {
#line 584 "src/ops/string.ops"
    const INTVAL n = Parrot_encoding_number(interp, (*(STRING **)OP_AS_OFFS(2)));
    if (n < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_ENCODING,
                "encoding '%Ss' not found", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1104: /* find_encoding_i_sc */ {
#line 584 "src/ops/string.ops"
    const INTVAL n = Parrot_encoding_number(interp, ((STRING *)cur_opcode[2]));
    if (n < 0) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_ENCODING,
                "encoding '%Ss' not found", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(INTVAL *)OP_AS_OFFS(1)) = n;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1105: /* trans_encoding_s_i */ {
#line 595 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, (*(STRING **)OP_AS_OFFS(1)), (*(INTVAL *)OP_AS_OFFS(2)), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1106: /* trans_encoding_s_ic */ {
#line 595 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, (*(STRING **)OP_AS_OFFS(1)), ((INTVAL)cur_opcode[2]), NULL);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1107: /* trans_encoding_s_s_i */ {
#line 599 "src/ops/string.ops"
    STRING * const dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1108: /* trans_encoding_s_sc_i */ {
#line 599 "src/ops/string.ops"
    STRING * const dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1109: /* trans_encoding_s_s_ic */ {
#line 599 "src/ops/string.ops"
    STRING * const dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1110: /* trans_encoding_s_sc_ic */ {
#line 599 "src/ops/string.ops"
    STRING * const dest = new_string_header(interp, 0);
    (*(STRING **)OP_AS_OFFS(1)) = Parrot_string_trans_encoding(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), dest);

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1111: /* is_cclass_i_i_s_i */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1112: /* is_cclass_i_ic_s_i */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1113: /* is_cclass_i_i_sc_i */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1114: /* is_cclass_i_ic_sc_i */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1115: /* is_cclass_i_i_s_ic */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1116: /* is_cclass_i_ic_s_ic */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1117: /* is_cclass_i_i_sc_ic */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1118: /* is_cclass_i_ic_sc_ic */ {
#line 612 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_is_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1119: /* find_cclass_i_i_s_i_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1120: /* find_cclass_i_ic_s_i_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1121: /* find_cclass_i_i_sc_i_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1122: /* find_cclass_i_ic_sc_i_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1123: /* find_cclass_i_i_s_ic_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1124: /* find_cclass_i_ic_s_ic_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1125: /* find_cclass_i_i_sc_ic_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1126: /* find_cclass_i_ic_sc_ic_i */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1127: /* find_cclass_i_i_s_i_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1128: /* find_cclass_i_ic_s_i_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1129: /* find_cclass_i_i_sc_i_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1130: /* find_cclass_i_ic_sc_i_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1131: /* find_cclass_i_i_s_ic_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1132: /* find_cclass_i_ic_s_ic_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1133: /* find_cclass_i_i_sc_ic_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1134: /* find_cclass_i_ic_sc_ic_ic */ {
#line 626 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1135: /* find_not_cclass_i_i_s_i_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1136: /* find_not_cclass_i_ic_s_i_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1137: /* find_not_cclass_i_i_sc_i_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1138: /* find_not_cclass_i_ic_sc_i_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1139: /* find_not_cclass_i_i_s_ic_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1140: /* find_not_cclass_i_ic_s_ic_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1141: /* find_not_cclass_i_i_sc_ic_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1142: /* find_not_cclass_i_ic_sc_ic_i */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), (*(INTVAL *)OP_AS_OFFS(5)));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1143: /* find_not_cclass_i_i_s_i_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1144: /* find_not_cclass_i_ic_s_i_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1145: /* find_not_cclass_i_i_sc_i_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1146: /* find_not_cclass_i_ic_sc_i_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1147: /* find_not_cclass_i_i_s_ic_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1148: /* find_not_cclass_i_ic_s_ic_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), (*(STRING **)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1149: /* find_not_cclass_i_i_sc_ic_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, (*(INTVAL *)OP_AS_OFFS(2)), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1150: /* find_not_cclass_i_ic_sc_ic_ic */ {
#line 640 "src/ops/string.ops"
    (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_string_find_not_cclass(interp, ((INTVAL)cur_opcode[2]), ((STRING *)cur_opcode[3]), ((INTVAL)cur_opcode[4]), ((INTVAL)cur_opcode[5]));

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1151: /* escape_s_s */ {
#line 656 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_escape_string(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1152: /* compose_s_s */ {
#line 660 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_compose(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1153: /* compose_s_sc */ {
#line 660 "src/ops/string.ops"
    (*(STRING **)OP_AS_OFFS(1)) = string_compose(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1154: /* spawnw_i_s */ {
#line 40 "src/ops/sys.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_Run_OS_Command(interp, (*(STRING **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1155: /* spawnw_i_sc */ {
#line 40 "src/ops/sys.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_Run_OS_Command(interp, ((STRING *)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1156: /* spawnw_i_p */ {
#line 44 "src/ops/sys.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_Run_OS_Command_Argv(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1157: /* err_i */ {
#line 65 "src/ops/sys.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = errno;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1158: /* err_s */ {
#line 69 "src/ops/sys.ops"
  const char * const tmp = strerror(errno);
  (*(STRING **)OP_AS_OFFS(1)) = string_make(interp, tmp, strlen(tmp), "ascii", 0);

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1159: /* err_s_i */ {
#line 74 "src/ops/sys.ops"
  const char * const tmp = strerror((*(INTVAL *)OP_AS_OFFS(2)));
  (*(STRING **)OP_AS_OFFS(1)) = string_make(interp, tmp, strlen(tmp), "ascii", 0);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1160: /* err_s_ic */ {
#line 74 "src/ops/sys.ops"
  const char * const tmp = strerror(((INTVAL)cur_opcode[2]));
  (*(STRING **)OP_AS_OFFS(1)) = string_make(interp, tmp, strlen(tmp), "ascii", 0);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1161: /* time_i */ {
#line 89 "src/ops/sys.ops"
  (*(INTVAL *)OP_AS_OFFS(1)) = Parrot_intval_time();

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1162: /* time_n */ {
#line 103 "src/ops/sys.ops"
  (*(FLOATVAL *)OP_AS_OFFS(1)) = Parrot_floatval_time();

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1163: /* gmtime_s_i */ {
#line 176 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) (*(INTVAL *)OP_AS_OFFS(2));
  char resultbuffer[26];
  Parrot_gmtime_r(&t, &tm);
  Parrot_asctime_r(&tm, resultbuffer);
  (*(STRING **)OP_AS_OFFS(1)) = string_from_cstring(interp, resultbuffer, 25);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1164: /* gmtime_s_ic */ {
#line 176 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) ((INTVAL)cur_opcode[2]);
  char resultbuffer[26];
  Parrot_gmtime_r(&t, &tm);
  Parrot_asctime_r(&tm, resultbuffer);
  (*(STRING **)OP_AS_OFFS(1)) = string_from_cstring(interp, resultbuffer, 25);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1165: /* localtime_s_i */ {
#line 185 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) (*(INTVAL *)OP_AS_OFFS(2));
  char resultbuffer[26];
  Parrot_localtime_r(&t, &tm);
  Parrot_asctime_r(&tm, resultbuffer);
  (*(STRING **)OP_AS_OFFS(1)) = string_from_cstring(interp, resultbuffer, 25);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1166: /* localtime_s_ic */ {
#line 185 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) ((INTVAL)cur_opcode[2]);
  char resultbuffer[26];
  Parrot_localtime_r(&t, &tm);
  Parrot_asctime_r(&tm, resultbuffer);
  (*(STRING **)OP_AS_OFFS(1)) = string_from_cstring(interp, resultbuffer, 25);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1167: /* decodetime_p_i */ {
#line 194 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) (*(INTVAL *)OP_AS_OFFS(2));
  Parrot_gmtime_r(&t, &tm);
  (*(PMC **)OP_AS_OFFS(1)) = tm_to_array(interp, &tm);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1168: /* decodetime_p_ic */ {
#line 194 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) ((INTVAL)cur_opcode[2]);
  Parrot_gmtime_r(&t, &tm);
  (*(PMC **)OP_AS_OFFS(1)) = tm_to_array(interp, &tm);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1169: /* decodelocaltime_p_i */ {
#line 201 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) (*(INTVAL *)OP_AS_OFFS(2));
  Parrot_localtime_r(&t, &tm);
  (*(PMC **)OP_AS_OFFS(1)) = tm_to_array(interp, &tm);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1170: /* decodelocaltime_p_ic */ {
#line 201 "src/ops/sys.ops"
  struct tm tm;
  const time_t t = (time_t) ((INTVAL)cur_opcode[2]);
  Parrot_localtime_r(&t, &tm);
  (*(PMC **)OP_AS_OFFS(1)) = tm_to_array(interp, &tm);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1171: /* sysinfo_s_i */ {
#line 265 "src/ops/sys.ops"
   (*(STRING **)OP_AS_OFFS(1)) = sysinfo_s(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1172: /* sysinfo_s_ic */ {
#line 265 "src/ops/sys.ops"
   (*(STRING **)OP_AS_OFFS(1)) = sysinfo_s(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1173: /* sysinfo_i_i */ {
#line 269 "src/ops/sys.ops"
   (*(INTVAL *)OP_AS_OFFS(1)) = sysinfo_i(interp, (*(INTVAL *)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1174: /* sysinfo_i_ic */ {
#line 269 "src/ops/sys.ops"
   (*(INTVAL *)OP_AS_OFFS(1)) = sysinfo_i(interp, ((INTVAL)cur_opcode[2]));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1175: /* sleep_i */ {
#line 283 "src/ops/sys.ops"
  opcode_t *next = CUR_OPCODE + 2;
  if ((*(INTVAL *)OP_AS_OFFS(1)) < 0) {
      opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
        EXCEPTION_NEG_SLEEP,
        "Cannot go back in time");
                  {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  next = (opcode_t *)Parrot_cx_schedule_sleep(interp, (FLOATVAL) (*(INTVAL *)OP_AS_OFFS(1)), next);
              {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 1176: /* sleep_ic */ {
#line 283 "src/ops/sys.ops"
  opcode_t *next = CUR_OPCODE + 2;
  if (((INTVAL)cur_opcode[1]) < 0) {
      opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
        EXCEPTION_NEG_SLEEP,
        "Cannot go back in time");
                  {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  next = (opcode_t *)Parrot_cx_schedule_sleep(interp, (FLOATVAL) ((INTVAL)cur_opcode[1]), next);
              {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 1177: /* sleep_n */ {
#line 295 "src/ops/sys.ops"
  opcode_t *next = CUR_OPCODE + 2;
  if ((*(FLOATVAL *)OP_AS_OFFS(1)) < 0.0) {
      opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_NEG_SLEEP,
          "Cannot go back in time");
                  {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  next = (opcode_t *)Parrot_cx_schedule_sleep(interp, (*(FLOATVAL *)OP_AS_OFFS(1)), next);
              {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 1178: /* sleep_nc */ {
#line 295 "src/ops/sys.ops"
  opcode_t *next = CUR_OPCODE + 2;
  if ((*(FLOATVAL *)cur_opcode[1]) < 0.0) {
      opcode_t *handler = Parrot_ex_throw_from_op_args(interp, next,
          EXCEPTION_NEG_SLEEP,
          "Cannot go back in time");
                  {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
  }
  next = (opcode_t *)Parrot_cx_schedule_sleep(interp, (*(FLOATVAL *)cur_opcode[1]), next);
              {
               cur_opcode = opcode_to_prederef(interp, next);
               goto SWITCH_RELOAD;
            }
;
}

case 1179: /* sizeof_i_i */ {
#line 315 "src/ops/sys.ops"
    if ((*(INTVAL *)OP_AS_OFFS(2)) < enum_first_type || (*(INTVAL *)OP_AS_OFFS(2)) >= enum_last_type)
        (*(INTVAL *)OP_AS_OFFS(1)) = -1;
    else
        (*(INTVAL *)OP_AS_OFFS(1)) = data_types[(*(INTVAL *)OP_AS_OFFS(2)) - enum_first_type].size;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1180: /* sizeof_i_ic */ {
#line 315 "src/ops/sys.ops"
    if (((INTVAL)cur_opcode[2]) < enum_first_type || ((INTVAL)cur_opcode[2]) >= enum_last_type)
        (*(INTVAL *)OP_AS_OFFS(1)) = -1;
    else
        (*(INTVAL *)OP_AS_OFFS(1)) = data_types[((INTVAL)cur_opcode[2]) - enum_first_type].size;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1181: /* store_lex_s_p */ {
#line 42 "src/ops/var.ops"
    Parrot_Context   * const ctx      = CONTEXT(interp);
    STRING           * const lex_name = (*(STRING **)OP_AS_OFFS(1));
    PMC              * const lex_pad  = Parrot_find_pad(interp, lex_name, ctx);

    if (PMC_IS_NULL(lex_pad)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_LEX_NOT_FOUND,
                "Lexical '%Ss' not found", lex_name);
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    VTABLE_set_pmc_keyed_str(interp, lex_pad, lex_name, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1182: /* store_lex_sc_p */ {
#line 42 "src/ops/var.ops"
    Parrot_Context   * const ctx      = CONTEXT(interp);
    STRING           * const lex_name = ((STRING *)cur_opcode[1]);
    PMC              * const lex_pad  = Parrot_find_pad(interp, lex_name, ctx);

    if (PMC_IS_NULL(lex_pad)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_LEX_NOT_FOUND,
                "Lexical '%Ss' not found", lex_name);
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    VTABLE_set_pmc_keyed_str(interp, lex_pad, lex_name, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1183: /* find_lex_p_s */ {
#line 67 "src/ops/var.ops"
    Parrot_Context   * const ctx      = CONTEXT(interp);
    STRING           * const lex_name = (*(STRING **)OP_AS_OFFS(2));
    PMC              * const lex_pad  = Parrot_find_pad(interp, lex_name, ctx);

    PMC * const result =
        PMC_IS_NULL(lex_pad)
            ? NULL
            : VTABLE_get_pmc_keyed_str(interp, lex_pad, lex_name);
    if (!result) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_LEX_NOT_FOUND,
                "Lexical '%Ss' not found", lex_name);
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = result;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1184: /* find_lex_p_sc */ {
#line 67 "src/ops/var.ops"
    Parrot_Context   * const ctx      = CONTEXT(interp);
    STRING           * const lex_name = ((STRING *)cur_opcode[2]);
    PMC              * const lex_pad  = Parrot_find_pad(interp, lex_name, ctx);

    PMC * const result =
        PMC_IS_NULL(lex_pad)
            ? NULL
            : VTABLE_get_pmc_keyed_str(interp, lex_pad, lex_name);
    if (!result) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_LEX_NOT_FOUND,
                "Lexical '%Ss' not found", lex_name);
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    (*(PMC **)OP_AS_OFFS(1)) = result;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1185: /* get_namespace_p */ {
#line 106 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = cur_ns;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1186: /* get_namespace_p_p */ {
#line 111 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_get_namespace_keyed(interp, cur_ns, (*(PMC **)OP_AS_OFFS(2)));

    (*(PMC **)OP_AS_OFFS(1)) = PMC_IS_NULL(ns) ? PMCNULL : ns;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1187: /* get_namespace_p_pc */ {
#line 111 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_get_namespace_keyed(interp, cur_ns, ((PMC *)cur_opcode[2]));

    (*(PMC **)OP_AS_OFFS(1)) = PMC_IS_NULL(ns) ? PMCNULL : ns;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1188: /* get_hll_namespace_p */ {
#line 130 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    (*(PMC **)OP_AS_OFFS(1)) = hll_ns;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1189: /* get_hll_namespace_p_p */ {
#line 135 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, (*(PMC **)OP_AS_OFFS(2)));
        (*(PMC **)OP_AS_OFFS(1)) = ns;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1190: /* get_hll_namespace_p_pc */ {
#line 135 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, ((PMC *)cur_opcode[2]));
        (*(PMC **)OP_AS_OFFS(1)) = ns;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1191: /* get_root_namespace_p */ {
#line 156 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = root_ns;

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1192: /* get_root_namespace_p_p */ {
#line 161 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, (*(PMC **)OP_AS_OFFS(2)));
        (*(PMC **)OP_AS_OFFS(1)) = ns;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1193: /* get_root_namespace_p_pc */ {
#line 161 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, ((PMC *)cur_opcode[2]));
        (*(PMC **)OP_AS_OFFS(1)) = ns;
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1194: /* get_global_p_s */ {
#line 194 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, cur_ns, (*(STRING **)OP_AS_OFFS(2)), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1195: /* get_global_p_sc */ {
#line 194 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, cur_ns, ((STRING *)cur_opcode[2]), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1196: /* get_global_p_p_s */ {
#line 199 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    if (PMC_IS_NULL(cur_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, cur_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1197: /* get_global_p_pc_s */ {
#line 199 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    if (PMC_IS_NULL(cur_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, cur_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1198: /* get_global_p_p_sc */ {
#line 199 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    if (PMC_IS_NULL(cur_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, cur_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1199: /* get_global_p_pc_sc */ {
#line 199 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    if (PMC_IS_NULL(cur_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, cur_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

    default:
    switch (*(opcode_t*)cur_opcode) {
case 1200: /* get_hll_global_p_s */ {
#line 226 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, hll_ns, (*(STRING **)OP_AS_OFFS(2)), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1201: /* get_hll_global_p_sc */ {
#line 226 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, hll_ns, ((STRING *)cur_opcode[2]), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1202: /* get_hll_global_p_p_s */ {
#line 231 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = hll_ns;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1203: /* get_hll_global_p_pc_s */ {
#line 231 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = hll_ns;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1204: /* get_hll_global_p_p_sc */ {
#line 231 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = hll_ns;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1205: /* get_hll_global_p_pc_sc */ {
#line 231 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    if (PMC_IS_NULL(hll_ns)) {
        (*(PMC **)OP_AS_OFFS(1)) = hll_ns;
    }
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, hll_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1206: /* get_root_global_p_s */ {
#line 258 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, root_ns, (*(STRING **)OP_AS_OFFS(2)), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1207: /* get_root_global_p_sc */ {
#line 258 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, root_ns, ((STRING *)cur_opcode[2]), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1208: /* get_root_global_p_p_s */ {
#line 263 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1209: /* get_root_global_p_pc_s */ {
#line 263 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, (*(STRING **)OP_AS_OFFS(3)), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1210: /* get_root_global_p_p_sc */ {
#line 263 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, (*(PMC **)OP_AS_OFFS(2)));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1211: /* get_root_global_p_pc_sc */ {
#line 263 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    if (PMC_IS_NULL(root_ns))
        (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
    else {
        PMC * const ns = Parrot_get_namespace_keyed(interp, root_ns, ((PMC *)cur_opcode[2]));
        if (PMC_IS_NULL(ns))
            (*(PMC **)OP_AS_OFFS(1)) = PMCNULL;
        else
            (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_global_op(interp, ns, ((STRING *)cur_opcode[3]), CUR_OPCODE + 4);
    }

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1212: /* set_global_s_p */ {
#line 298 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    Parrot_set_global(interp, cur_ns, (*(STRING **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1213: /* set_global_sc_p */ {
#line 298 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    Parrot_set_global(interp, cur_ns, ((STRING *)cur_opcode[1]), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1214: /* set_global_p_s_p */ {
#line 303 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_make_namespace_keyed(interp, cur_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1215: /* set_global_pc_s_p */ {
#line 303 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_make_namespace_keyed(interp, cur_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1216: /* set_global_p_sc_p */ {
#line 303 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_make_namespace_keyed(interp, cur_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1217: /* set_global_pc_sc_p */ {
#line 303 "src/ops/var.ops"
    PMC * const cur_ns = CONTEXT(interp)->current_namespace;
    PMC * const ns     = Parrot_make_namespace_keyed(interp, cur_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1218: /* set_hll_global_s_p */ {
#line 322 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    Parrot_set_global(interp, hll_ns, (*(STRING **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1219: /* set_hll_global_sc_p */ {
#line 322 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    Parrot_set_global(interp, hll_ns, ((STRING *)cur_opcode[1]), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1220: /* set_hll_global_p_s_p */ {
#line 327 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    PMC * const ns     = Parrot_make_namespace_keyed(interp, hll_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1221: /* set_hll_global_pc_s_p */ {
#line 327 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    PMC * const ns     = Parrot_make_namespace_keyed(interp, hll_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1222: /* set_hll_global_p_sc_p */ {
#line 327 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    PMC * const ns     = Parrot_make_namespace_keyed(interp, hll_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1223: /* set_hll_global_pc_sc_p */ {
#line 327 "src/ops/var.ops"
    PMC * const hll_ns = Parrot_get_ctx_HLL_namespace(interp);
    PMC * const ns     = Parrot_make_namespace_keyed(interp, hll_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1224: /* set_root_global_s_p */ {
#line 346 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    Parrot_set_global(interp, root_ns, (*(STRING **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1225: /* set_root_global_sc_p */ {
#line 346 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    Parrot_set_global(interp, root_ns, ((STRING *)cur_opcode[1]), (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1226: /* set_root_global_p_s_p */ {
#line 351 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    PMC * const ns      = Parrot_make_namespace_keyed(interp, root_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1227: /* set_root_global_pc_s_p */ {
#line 351 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    PMC * const ns      = Parrot_make_namespace_keyed(interp, root_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, (*(STRING **)OP_AS_OFFS(2)), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1228: /* set_root_global_p_sc_p */ {
#line 351 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    PMC * const ns      = Parrot_make_namespace_keyed(interp, root_ns, (*(PMC **)OP_AS_OFFS(1)));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1229: /* set_root_global_pc_sc_p */ {
#line 351 "src/ops/var.ops"
    PMC * const root_ns = interp->root_namespace;
    PMC * const ns      = Parrot_make_namespace_keyed(interp, root_ns, ((PMC *)cur_opcode[1]));

    Parrot_set_global(interp, ns, ((STRING *)cur_opcode[2]), (*(PMC **)OP_AS_OFFS(3)));

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1230: /* find_name_p_s */ {
#line 383 "src/ops/var.ops"
    if (!(*(STRING **)OP_AS_OFFS(2))) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_OPERATION,
                "Tried to find null name");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_name_op(interp, (*(STRING **)OP_AS_OFFS(2)), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1231: /* find_name_p_sc */ {
#line 383 "src/ops/var.ops"
    if (!((STRING *)cur_opcode[2])) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, NULL,
                EXCEPTION_INVALID_OPERATION,
                "Tried to find null name");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = Parrot_find_name_op(interp, ((STRING *)cur_opcode[2]), CUR_OPCODE + 3);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1232: /* gcd_i_n_n */ {
#line 48 "src/ops/experimental.ops"

  FLOATVAL q     = 0;
  FLOATVAL c     = 0;
  FLOATVAL temp2 = fabs((*(FLOATVAL *)OP_AS_OFFS(2)));
  FLOATVAL temp3 = fabs((*(FLOATVAL *)OP_AS_OFFS(3)));

  while (!FLOAT_IS_ZERO(temp3)) {
    q     = floor((FLOATVAL)temp2/temp3);
    c     = temp2 - temp3*q;
    temp2 = temp3;
    temp3 = c;
  }

  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)temp2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1233: /* gcd_i_nc_n */ {
#line 48 "src/ops/experimental.ops"

  FLOATVAL q     = 0;
  FLOATVAL c     = 0;
  FLOATVAL temp2 = fabs((*(FLOATVAL *)cur_opcode[2]));
  FLOATVAL temp3 = fabs((*(FLOATVAL *)OP_AS_OFFS(3)));

  while (!FLOAT_IS_ZERO(temp3)) {
    q     = floor((FLOATVAL)temp2/temp3);
    c     = temp2 - temp3*q;
    temp2 = temp3;
    temp3 = c;
  }

  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)temp2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1234: /* gcd_i_n_nc */ {
#line 48 "src/ops/experimental.ops"

  FLOATVAL q     = 0;
  FLOATVAL c     = 0;
  FLOATVAL temp2 = fabs((*(FLOATVAL *)OP_AS_OFFS(2)));
  FLOATVAL temp3 = fabs((*(FLOATVAL *)cur_opcode[3]));

  while (!FLOAT_IS_ZERO(temp3)) {
    q     = floor((FLOATVAL)temp2/temp3);
    c     = temp2 - temp3*q;
    temp2 = temp3;
    temp3 = c;
  }

  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)temp2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1235: /* gcd_i_nc_nc */ {
#line 48 "src/ops/experimental.ops"

  FLOATVAL q     = 0;
  FLOATVAL c     = 0;
  FLOATVAL temp2 = fabs((*(FLOATVAL *)cur_opcode[2]));
  FLOATVAL temp3 = fabs((*(FLOATVAL *)cur_opcode[3]));

  while (!FLOAT_IS_ZERO(temp3)) {
    q     = floor((FLOATVAL)temp2/temp3);
    c     = temp2 - temp3*q;
    temp2 = temp3;
    temp3 = c;
  }

  (*(INTVAL *)OP_AS_OFFS(1)) = (INTVAL)temp2;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1236: /* gcd_i_i_i_i_i */ {
#line 65 "src/ops/experimental.ops"
  /* r0 = q1*r1 + r2 */
  INTVAL r0 = (*(INTVAL *)OP_AS_OFFS(4)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(4)) : (*(INTVAL *)OP_AS_OFFS(4));
  INTVAL r1 = (*(INTVAL *)OP_AS_OFFS(5)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(5)) : (*(INTVAL *)OP_AS_OFFS(5));
  INTVAL r2 = 0;
  INTVAL q1 = 0;

  INTVAL xkm1 = 1;
  INTVAL xk = 0;
  INTVAL xkp1 = 0;

  INTVAL ykm1 = 0;
  INTVAL yk = 1;
  INTVAL ykp1 = 0;

  INTVAL n = 1;

  INTVAL x;
  INTVAL y;

  while (1) {
    q1 = r0/r1;
    r2 = r0 - q1*r1;
    if (r2 == 0) {
      break;
    }
    r0 = r1;
    r1 = r2;

    xkp1 = q1*xk + xkm1;
    xkm1 = xk;
    xk = xkp1;

    ykp1 = q1*yk + ykm1;
    ykm1 = yk;
    yk = ykp1;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = r1;
  (*(INTVAL *)OP_AS_OFFS(2)) = (INTVAL)(xk * pow(-1, n));
  (*(INTVAL *)OP_AS_OFFS(3)) = (INTVAL)(yk * pow(-1, n+1));

  x = (*(INTVAL *)OP_AS_OFFS(2)) * (*(INTVAL *)OP_AS_OFFS(4));
  y = (*(INTVAL *)OP_AS_OFFS(3)) * (*(INTVAL *)OP_AS_OFFS(5));

  /* correct the sign (can be wrong because we used abs((*(INTVAL *)OP_AS_OFFS(4))) and abs((*(INTVAL *)OP_AS_OFFS(5))) */
  if (x + y == r1) {
    /* no correction necessary */
  }
  else if (x + y == -r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (x - y == r1) {
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (-x + y == r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
  }

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1237: /* gcd_i_i_i_ic_i */ {
#line 65 "src/ops/experimental.ops"
  /* r0 = q1*r1 + r2 */
  INTVAL r0 = ((INTVAL)cur_opcode[4]) < 0 ? -((INTVAL)cur_opcode[4]) : ((INTVAL)cur_opcode[4]);
  INTVAL r1 = (*(INTVAL *)OP_AS_OFFS(5)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(5)) : (*(INTVAL *)OP_AS_OFFS(5));
  INTVAL r2 = 0;
  INTVAL q1 = 0;

  INTVAL xkm1 = 1;
  INTVAL xk = 0;
  INTVAL xkp1 = 0;

  INTVAL ykm1 = 0;
  INTVAL yk = 1;
  INTVAL ykp1 = 0;

  INTVAL n = 1;

  INTVAL x;
  INTVAL y;

  while (1) {
    q1 = r0/r1;
    r2 = r0 - q1*r1;
    if (r2 == 0) {
      break;
    }
    r0 = r1;
    r1 = r2;

    xkp1 = q1*xk + xkm1;
    xkm1 = xk;
    xk = xkp1;

    ykp1 = q1*yk + ykm1;
    ykm1 = yk;
    yk = ykp1;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = r1;
  (*(INTVAL *)OP_AS_OFFS(2)) = (INTVAL)(xk * pow(-1, n));
  (*(INTVAL *)OP_AS_OFFS(3)) = (INTVAL)(yk * pow(-1, n+1));

  x = (*(INTVAL *)OP_AS_OFFS(2)) * ((INTVAL)cur_opcode[4]);
  y = (*(INTVAL *)OP_AS_OFFS(3)) * (*(INTVAL *)OP_AS_OFFS(5));

  /* correct the sign (can be wrong because we used abs(((INTVAL)cur_opcode[4])) and abs((*(INTVAL *)OP_AS_OFFS(5))) */
  if (x + y == r1) {
    /* no correction necessary */
  }
  else if (x + y == -r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (x - y == r1) {
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (-x + y == r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
  }

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1238: /* gcd_i_i_i_i_ic */ {
#line 65 "src/ops/experimental.ops"
  /* r0 = q1*r1 + r2 */
  INTVAL r0 = (*(INTVAL *)OP_AS_OFFS(4)) < 0 ? -(*(INTVAL *)OP_AS_OFFS(4)) : (*(INTVAL *)OP_AS_OFFS(4));
  INTVAL r1 = ((INTVAL)cur_opcode[5]) < 0 ? -((INTVAL)cur_opcode[5]) : ((INTVAL)cur_opcode[5]);
  INTVAL r2 = 0;
  INTVAL q1 = 0;

  INTVAL xkm1 = 1;
  INTVAL xk = 0;
  INTVAL xkp1 = 0;

  INTVAL ykm1 = 0;
  INTVAL yk = 1;
  INTVAL ykp1 = 0;

  INTVAL n = 1;

  INTVAL x;
  INTVAL y;

  while (1) {
    q1 = r0/r1;
    r2 = r0 - q1*r1;
    if (r2 == 0) {
      break;
    }
    r0 = r1;
    r1 = r2;

    xkp1 = q1*xk + xkm1;
    xkm1 = xk;
    xk = xkp1;

    ykp1 = q1*yk + ykm1;
    ykm1 = yk;
    yk = ykp1;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = r1;
  (*(INTVAL *)OP_AS_OFFS(2)) = (INTVAL)(xk * pow(-1, n));
  (*(INTVAL *)OP_AS_OFFS(3)) = (INTVAL)(yk * pow(-1, n+1));

  x = (*(INTVAL *)OP_AS_OFFS(2)) * (*(INTVAL *)OP_AS_OFFS(4));
  y = (*(INTVAL *)OP_AS_OFFS(3)) * ((INTVAL)cur_opcode[5]);

  /* correct the sign (can be wrong because we used abs((*(INTVAL *)OP_AS_OFFS(4))) and abs(((INTVAL)cur_opcode[5])) */
  if (x + y == r1) {
    /* no correction necessary */
  }
  else if (x + y == -r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (x - y == r1) {
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (-x + y == r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
  }

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1239: /* gcd_i_i_i_ic_ic */ {
#line 65 "src/ops/experimental.ops"
  /* r0 = q1*r1 + r2 */
  INTVAL r0 = ((INTVAL)cur_opcode[4]) < 0 ? -((INTVAL)cur_opcode[4]) : ((INTVAL)cur_opcode[4]);
  INTVAL r1 = ((INTVAL)cur_opcode[5]) < 0 ? -((INTVAL)cur_opcode[5]) : ((INTVAL)cur_opcode[5]);
  INTVAL r2 = 0;
  INTVAL q1 = 0;

  INTVAL xkm1 = 1;
  INTVAL xk = 0;
  INTVAL xkp1 = 0;

  INTVAL ykm1 = 0;
  INTVAL yk = 1;
  INTVAL ykp1 = 0;

  INTVAL n = 1;

  INTVAL x;
  INTVAL y;

  while (1) {
    q1 = r0/r1;
    r2 = r0 - q1*r1;
    if (r2 == 0) {
      break;
    }
    r0 = r1;
    r1 = r2;

    xkp1 = q1*xk + xkm1;
    xkm1 = xk;
    xk = xkp1;

    ykp1 = q1*yk + ykm1;
    ykm1 = yk;
    yk = ykp1;
  }
  (*(INTVAL *)OP_AS_OFFS(1)) = r1;
  (*(INTVAL *)OP_AS_OFFS(2)) = (INTVAL)(xk * pow(-1, n));
  (*(INTVAL *)OP_AS_OFFS(3)) = (INTVAL)(yk * pow(-1, n+1));

  x = (*(INTVAL *)OP_AS_OFFS(2)) * ((INTVAL)cur_opcode[4]);
  y = (*(INTVAL *)OP_AS_OFFS(3)) * ((INTVAL)cur_opcode[5]);

  /* correct the sign (can be wrong because we used abs(((INTVAL)cur_opcode[4])) and abs(((INTVAL)cur_opcode[5])) */
  if (x + y == r1) {
    /* no correction necessary */
  }
  else if (x + y == -r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (x - y == r1) {
    (*(INTVAL *)OP_AS_OFFS(3)) = -(*(INTVAL *)OP_AS_OFFS(3));
  }
  else if (-x + y == r1) {
    (*(INTVAL *)OP_AS_OFFS(2)) = -(*(INTVAL *)OP_AS_OFFS(2));
  }

{ cur_opcode += 6; goto SWITCH_AGAIN; };}

case 1240: /* splice_p_p_i_i */ {
#line 145 "src/ops/experimental.ops"
    VTABLE_splice(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1241: /* splice_p_p_ic_i */ {
#line 145 "src/ops/experimental.ops"
    VTABLE_splice(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1242: /* splice_p_p_i_ic */ {
#line 145 "src/ops/experimental.ops"
    VTABLE_splice(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1243: /* splice_p_p_ic_ic */ {
#line 145 "src/ops/experimental.ops"
    VTABLE_splice(interp, (*(PMC **)OP_AS_OFFS(1)), (*(PMC **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]));

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1244: /* iter_p_p */ {
#line 156 "src/ops/experimental.ops"
    (*(PMC **)OP_AS_OFFS(1)) = VTABLE_get_iter(interp, (*(PMC **)OP_AS_OFFS(2)));

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1245: /* morph_p_s */ {
#line 168 "src/ops/experimental.ops"
  INTVAL type = pmc_type(interp, (*(STRING **)OP_AS_OFFS(2)));
  VTABLE_morph(interp, (*(PMC **)OP_AS_OFFS(1)), type);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1246: /* morph_p_sc */ {
#line 168 "src/ops/experimental.ops"
  INTVAL type = pmc_type(interp, ((STRING *)cur_opcode[2]));
  VTABLE_morph(interp, (*(PMC **)OP_AS_OFFS(1)), type);

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1247: /* exec_s */ {
#line 182 "src/ops/experimental.ops"
  Parrot_Exec_OS_Command(interp, (*(STRING **)OP_AS_OFFS(1)));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1248: /* exec_sc */ {
#line 182 "src/ops/experimental.ops"
  Parrot_Exec_OS_Command(interp, ((STRING *)cur_opcode[1]));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1249: /* classname_p_p */ {
#line 194 "src/ops/experimental.ops"
    PMC *ns = Parrot_ns_get_name(interp,
                                    VTABLE_get_namespace(interp, (*(PMC **)OP_AS_OFFS(2))));
    if (PMC_IS_NULL(ns) || VTABLE_elements(interp, ns) < 2) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, CUR_OPCODE + 3,
             EXCEPTION_NO_CLASS,
            "Attempt to get class name of a non-class.");
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }
    else {
        PMC *key_tail, *key;
        STRING *tmp;
        int i, max;

        /* Need to turn list of strings into a key. Note that we are not
           including the first item in the array, since that is the HLL. */
        tmp = VTABLE_get_string_keyed_int(interp, ns, 1);
        (*(PMC **)OP_AS_OFFS(1)) = key_tail = key_new_string(interp, tmp);
        max = VTABLE_elements(interp, ns);
        for (i = 2; i < max; i++)
        {
            tmp = VTABLE_get_string_keyed_int(interp, ns, i);
            key = key_new_string(interp, tmp);
            key_append(interp, key_tail, key);
            key_tail = key;
        }
    }

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1250: /* trap */ {
#line 241 "src/ops/experimental.ops"
#if defined(__GNUC__) && defined(i386)
    __asm__("int3");       /* opcode 0xcc */
#endif
#if defined(__GNUC__) && defined(PPC)
    __asm__("trap");       /* opcode tr 31, 0, 0 */
#endif

{ cur_opcode += 1; goto SWITCH_AGAIN; };}

case 1251: /* pow_n_n_i */ {
#line 256 "src/ops/experimental.ops"
    FLOATVAL n2 = (*(FLOATVAL *)OP_AS_OFFS(2));
    FLOATVAL res = 1.0;
    INTVAL   e  = (*(INTVAL *)OP_AS_OFFS(3));
    int s = 1;
    if (e != 0) {
        if (e < 0) {
            s = -1;
            e = -e;
        }
    }
    while (e) {
        if (e & 1) {
            res *= n2;
        }
        n2 *= n2;
        e >>= 1;
    }
    if (s < 0) {
        res = 1.0/res;
    }
    (*(FLOATVAL *)OP_AS_OFFS(1)) = res;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1252: /* pow_n_nc_i */ {
#line 256 "src/ops/experimental.ops"
    FLOATVAL n2 = (*(FLOATVAL *)cur_opcode[2]);
    FLOATVAL res = 1.0;
    INTVAL   e  = (*(INTVAL *)OP_AS_OFFS(3));
    int s = 1;
    if (e != 0) {
        if (e < 0) {
            s = -1;
            e = -e;
        }
    }
    while (e) {
        if (e & 1) {
            res *= n2;
        }
        n2 *= n2;
        e >>= 1;
    }
    if (s < 0) {
        res = 1.0/res;
    }
    (*(FLOATVAL *)OP_AS_OFFS(1)) = res;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1253: /* pow_n_n_ic */ {
#line 256 "src/ops/experimental.ops"
    FLOATVAL n2 = (*(FLOATVAL *)OP_AS_OFFS(2));
    FLOATVAL res = 1.0;
    INTVAL   e  = ((INTVAL)cur_opcode[3]);
    int s = 1;
    if (e != 0) {
        if (e < 0) {
            s = -1;
            e = -e;
        }
    }
    while (e) {
        if (e & 1) {
            res *= n2;
        }
        n2 *= n2;
        e >>= 1;
    }
    if (s < 0) {
        res = 1.0/res;
    }
    (*(FLOATVAL *)OP_AS_OFFS(1)) = res;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1254: /* pow_n_nc_ic */ {
#line 256 "src/ops/experimental.ops"
    FLOATVAL n2 = (*(FLOATVAL *)cur_opcode[2]);
    FLOATVAL res = 1.0;
    INTVAL   e  = ((INTVAL)cur_opcode[3]);
    int s = 1;
    if (e != 0) {
        if (e < 0) {
            s = -1;
            e = -e;
        }
    }
    while (e) {
        if (e & 1) {
            res *= n2;
        }
        n2 *= n2;
        e >>= 1;
    }
    if (s < 0) {
        res = 1.0/res;
    }
    (*(FLOATVAL *)OP_AS_OFFS(1)) = res;

{ cur_opcode += 4; goto SWITCH_AGAIN; };}

case 1255: /* need_finalize_p */ {
#line 288 "src/ops/experimental.ops"
    PMC* pmc = (*(PMC **)OP_AS_OFFS(1));
    if (PObj_is_object_TEST(pmc)) {
        PObj_get_FLAGS(pmc) |= PObj_need_finalize_FLAG;
    }

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1256: /* setstdout_p */ {
#line 310 "src/ops/experimental.ops"
        _PIO_STDOUT(interp) = (*(PMC **)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1257: /* setstderr_p */ {
#line 314 "src/ops/experimental.ops"
        _PIO_STDERR(interp) = (*(PMC **)OP_AS_OFFS(1));

{ cur_opcode += 2; goto SWITCH_AGAIN; };}

case 1258: /* runinterp_p_p */ {
#line 327 "src/ops/experimental.ops"
    Interp * const new_interp = (Interp *)PMC_data((*(PMC **)OP_AS_OFFS(1)));
    opcode_t *pc;
    Interp_flags_SET(new_interp, PARROT_EXTERN_CODE_FLAG);
    pc = (opcode_t *)VTABLE_invoke(new_interp, (*(PMC **)OP_AS_OFFS(2)), NULL);
    UNUSED(pc);
    Parrot_runops_fromc_args(new_interp, (*(PMC **)OP_AS_OFFS(2)), "P");

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1259: /* runinterp_p_pc */ {
#line 327 "src/ops/experimental.ops"
    Interp * const new_interp = (Interp *)PMC_data((*(PMC **)OP_AS_OFFS(1)));
    opcode_t *pc;
    Interp_flags_SET(new_interp, PARROT_EXTERN_CODE_FLAG);
    pc = (opcode_t *)VTABLE_invoke(new_interp, ((PMC *)cur_opcode[2]), NULL);
    UNUSED(pc);
    Parrot_runops_fromc_args(new_interp, ((PMC *)cur_opcode[2]), "P");

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1260: /* substr_r_s_s_i_i */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1261: /* substr_r_s_sc_i_i */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), (*(INTVAL *)OP_AS_OFFS(4)), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1262: /* substr_r_s_s_ic_i */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1263: /* substr_r_s_sc_ic_i */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), (*(INTVAL *)OP_AS_OFFS(4)), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1264: /* substr_r_s_s_i_ic */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1265: /* substr_r_s_sc_i_ic */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), (*(INTVAL *)OP_AS_OFFS(3)), ((INTVAL)cur_opcode[4]), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1266: /* substr_r_s_s_ic_ic */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, (*(STRING **)OP_AS_OFFS(2)), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1267: /* substr_r_s_sc_ic_ic */ {
#line 353 "src/ops/experimental.ops"
  STRING *dest = (*(STRING **)OP_AS_OFFS(1));
  if (!dest)
    dest = new_string_header(interp, 0);
  (*(STRING **)OP_AS_OFFS(1)) = string_substr(interp, ((STRING *)cur_opcode[2]), ((INTVAL)cur_opcode[3]), ((INTVAL)cur_opcode[4]), &dest, 1);

{ cur_opcode += 5; goto SWITCH_AGAIN; };}

case 1268: /* find_sub_not_null_p_s */ {
#line 362 "src/ops/experimental.ops"
    opcode_t *dest = CUR_OPCODE + 3;
    PMC *sub = Parrot_find_name_op(interp, (*(STRING **)OP_AS_OFFS(2)), dest);

    if (PMC_IS_NULL(sub)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, dest,
                       EXCEPTION_GLOBAL_NOT_FOUND,
                       "Could not find non-existent sub %Ss", (*(STRING **)OP_AS_OFFS(2)));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = sub;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

case 1269: /* find_sub_not_null_p_sc */ {
#line 362 "src/ops/experimental.ops"
    opcode_t *dest = CUR_OPCODE + 3;
    PMC *sub = Parrot_find_name_op(interp, ((STRING *)cur_opcode[2]), dest);

    if (PMC_IS_NULL(sub)) {
        opcode_t *handler = Parrot_ex_throw_from_op_args(interp, dest,
                       EXCEPTION_GLOBAL_NOT_FOUND,
                       "Could not find non-existent sub %Ss", ((STRING *)cur_opcode[2]));
                    {
               cur_opcode = opcode_to_prederef(interp, handler);
               goto SWITCH_RELOAD;
            }
;
    }

    (*(PMC **)OP_AS_OFFS(1)) = sub;

{ cur_opcode += 3; goto SWITCH_AGAIN; };}

        default:
            if (*(opcode_t*)cur_opcode >= 0 &&
                *(opcode_t*)cur_opcode < (opcode_t)core_switch_op_lib.op_count) {
                *(opcode_t*)cur_opcode = CORE_OPS_wrapper__;
                continue;
            }
            Parrot_ex_throw_from_c_args(interp, NULL, 1,
                "illegal opcode in switch core\n");
            break;
        } /* switch */
    } /* switch 0 */
    } /* switch 1 */
    } /* switch 2 */
    } /* switch 3 */
    } while (1);
    return NULL;
}
 /* switch_core */

#line 11876 "src/ops/core_ops_switch.c"
static void hop_deinit(void) {}
op_lib_t *
Parrot_DynOp_core_switch_0_9_0(long init) {
    /* initialize and return op_lib ptr */
    if (init == 1) {
        if (!core_switch_op_lib.op_func_table)
            core_switch_op_lib.op_func_table = (op_func_t *)&core_switch_op_lib;

    return &core_switch_op_lib;
    }
    /* set op_lib to the passed ptr (in init) */
    else if (init) {

    }
    /* deinit - free resources */
    else {
    hop_deinit();
    }
    return NULL;
}


/*
 * Local variables:
 *   c-file-style: "parrot"
 *   buffer-read-only: t
 * End:
 * vim: expandtab shiftwidth=4:
 */
