/*
 * Decompiled with CFR 0.152.
 */
package xtpipes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import xtpipes.FileInfo;

public class InputObject {
    InputStream inputStream;
    URLConnection connection;
    String filename;
    static PrintWriter log;
    String dtdRoot;
    String publicId;
    String systemId;
    String xtpipes;
    String url;
    String metaType;
    String contentType;
    String root;

    public InputObject(String string, PrintWriter printWriter) {
        block6: {
            this.inputStream = null;
            this.connection = null;
            this.filename = null;
            this.dtdRoot = null;
            this.publicId = null;
            this.systemId = null;
            this.xtpipes = null;
            this.url = null;
            this.metaType = null;
            this.contentType = null;
            this.root = null;
            log = printWriter;
            string = string.trim();
            try {
                this.inputStream = this.getInputStream(string);
            }
            catch (Exception exception) {
                if (string.startsWith("http://")) break block6;
                try {
                    String string2 = "http://" + string;
                    this.inputStream = this.getInputStream(string2);
                    string = string2;
                }
                catch (Exception exception2) {
                    try {
                        String string3 = FileInfo.cleanPath(string);
                        this.inputStream = this.getInputStream(string3);
                        string = string3;
                    }
                    catch (Exception exception3) {
                        this.inputStream = null;
                    }
                }
            }
        }
        this.filename = string;
    }

    public InputObject(byte[] byArray, PrintWriter printWriter) {
        this.inputStream = null;
        this.connection = null;
        this.filename = null;
        this.dtdRoot = null;
        this.publicId = null;
        this.systemId = null;
        this.xtpipes = null;
        this.url = null;
        this.metaType = null;
        this.contentType = null;
        this.root = null;
        log = printWriter;
        this.inputStream = new ByteArrayInputStream(byArray);
    }

    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            URL uRL = new File(string).toURI().toURL();
            inputStream = this.getInputStream(uRL);
        }
        catch (Exception exception) {
            try {
                URL uRL = new URL(string);
                inputStream = this.getInputStream(uRL);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("File not found: " + string);
            }
            catch (Exception exception2) {
                throw new IOException(exception2 + "\n" + exception);
            }
        }
        return inputStream;
    }

    private InputStream getInputStream(URL uRL) throws FileNotFoundException, IOException {
        InputStream inputStream = null;
        String string = "";
        try {
            this.connection = null;
            this.connection = uRL.openConnection();
            this.connection.setRequestProperty("User-Agent", "[" + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + "]" + "[" + System.getProperty("java.version") + " - " + System.getProperty("java.vendor") + "]");
            inputStream = this.connection.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "File not found: " + uRL;
            throw new FileNotFoundException("--- Ml2xml input error --- " + string);
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            string = "SSL Handshake Exception: " + sSLHandshakeException.getMessage();
            throw new SSLHandshakeException("--- Ml2xml input error --- " + string);
        }
        catch (UnknownHostException unknownHostException) {
            string = "Unknown Host Exception: " + unknownHostException.getMessage();
            throw new UnknownHostException("--- Ml2xml input error --- " + string);
        }
        return inputStream;
    }

    public void buildProfile(boolean bl) {
        if (bl) {
            log.println("xtpipes (2008-03-20-16:23)\n   java.version: " + System.getProperty("java.version") + "\n   java.class.path: " + System.getProperty("java.class.path") + "\n   os.name: " + System.getProperty("os.name") + "\n   user.home: " + System.getProperty("user.home") + "\n   user.dir: " + System.getProperty("user.dir"));
        }
        if (this.connection != null) {
            this.contentType = this.connection.getContentType();
            this.url = this.connection.getURL().toString();
        }
        int n = 8192;
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = null;
        while (n3 < n) {
            int n6;
            try {
                n6 = Math.min(n - n3, n2);
                n4 = this.inputStream.read(byArray, 0, n6);
                if (n4 == -1) break;
                if (n4 == 0) {
                    continue;
                }
            }
            catch (IOException iOException) {
                System.err.println("--- xtpipes error --- : " + iOException);
                break;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                byte by = byArray[n6];
                block1 : switch (by) {
                    case 60: {
                        string = "";
                        n5 = 1;
                        break;
                    }
                    case 62: {
                        int n7;
                        if (string == null) break;
                        string = string.replaceAll("\\s+", " ");
                        if (n5 == 9) {
                            String string2;
                            if (this.xtpipes == null && (n7 = string.length()) > 1 && string.charAt(n7 - 1) == '?' && string.startsWith("xtpipes") && (n7 = (string2 = string.substring(7, n7 - 1).replaceAll("\\s+", "")).length()) > 6 && string2.startsWith("file=") && string2.charAt(5) == string2.charAt(n7 - 1)) {
                                this.xtpipes = string2.substring(6, n7 - 1);
                            }
                        } else if (n5 == 11) {
                            if (this.metaType == null) {
                                string = string.replaceAll("\\s+", "");
                                n7 = string.indexOf("http-equiv");
                                int n8 = string.indexOf("content");
                                if (n7 != -1 && n8 != -1 && string.length() > Math.max(n7, n8) + 3 && string.substring(n7 + 12).startsWith("Content-Type") && (n8 = (string = string.substring(n8 + 9)).indexOf(";")) != -1) {
                                    this.metaType = string.substring(0, n8);
                                }
                            }
                        } else if (n5 == 2 && this.root == null) {
                            this.root = string;
                        }
                        string = null;
                        break;
                    }
                    case 10: 
                    case 32: {
                        if (string == null) break;
                        if (n5 == 2) {
                            if (string.equals("meta")) {
                                if (this.metaType == null) {
                                    n5 = 11;
                                    string = " ";
                                    break;
                                }
                                string = null;
                                break;
                            }
                            if (this.root == null) {
                                this.root = string;
                            }
                            string = null;
                            break;
                        }
                        if (n5 == 4) {
                            if (string.equals("DOCTYPE")) {
                                n5 = 5;
                                string = " ";
                                break;
                            }
                            string = null;
                            break;
                        }
                        if (n5 == 5) {
                            if (!string.trim().equals("")) {
                                this.dtdRoot = string.trim();
                                string = " ";
                                n5 = 6;
                                break;
                            }
                            string = null;
                            break;
                        }
                        if (n5 == 6) {
                            if (string.trim().equals("")) break;
                            if ((string = string.trim()).equals("PUBLIC")) {
                                n5 = 7;
                                string = "";
                                break;
                            }
                            if (string.equals("SYSTEM")) {
                                n5 = 8;
                                string = "";
                                break;
                            }
                            string = null;
                            break;
                        }
                        string = string + ' ';
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (string == null) break;
                        if (!string.trim().equals("") && string.trim().charAt(0) == by) {
                            if (n5 == 7) {
                                this.publicId = string.trim().substring(1);
                                n5 = 8;
                                string = "";
                                break;
                            }
                            if (n5 == 8) {
                                this.systemId = string.trim().substring(1);
                                string = null;
                                break;
                            }
                        }
                    }
                    default: {
                        if (string == null) break;
                        if (n5 == 3) {
                            if (by == 68) {
                                n5 = 4;
                                string = string + (char)by;
                                break;
                            }
                            string = null;
                            n5 = 0;
                            break;
                        }
                        if (string.equals("") && n5 == 1) {
                            switch (by) {
                                case 33: {
                                    n5 = 3;
                                    break block1;
                                }
                                case 63: {
                                    n5 = 9;
                                    break block1;
                                }
                            }
                            if (Character.isLetter(by) && (this.root == null || this.metaType == null)) {
                                n5 = 2;
                                string = string + (char)by;
                                break;
                            }
                            string = null;
                            break;
                        }
                        string = string + (char)by;
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            log.println(" url = " + this.url + "\n contentType = " + this.contentType + "\n publicId = " + this.publicId + "\n systemId = " + this.systemId + "\n xtpipes = " + this.xtpipes + "\n root = " + this.root + "\n dtdRoot = " + this.dtdRoot);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFilename() {
        return this.url == null ? (this.connection == null ? this.filename : this.connection.getURL().toString()) : this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getXtpipes() {
        return this.xtpipes;
    }

    public String getRoot() {
        return this.root;
    }

    public String getDtdRoot() {
        return this.dtdRoot;
    }
}

