/*
 * Decompiled with CFR 0.152.
 */
package tr.background.activation;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.appl.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateInactive;
import tr.model.future.Future;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.util.DateUtils;
import tr.util.Observable;

final class ActivatorTaskThread
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.activation");
    private static final String NAME = "TR Activation Task";
    private Data data;
    private Date endOfToday;

    public ActivatorTaskThread() {
        super(NAME);
    }

    public void run() {
        LOG.info("Started.");
        this.process();
        LOG.info("Finished.");
    }

    private void process() {
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        if (this.data == null) {
            LOG.severe("Data instance could not be obtained.");
            return;
        }
        this.endOfToday = DateUtils.getEnd((Date)Calendar.getInstance().getTime());
        this.activateFutureItems();
        this.activateFutureProjects();
        this.activateInactiveActions();
    }

    private void activateFutureItems() {
        for (Future future : this.data.getFutureManager().list()) {
            Date tickle = future.getTickle();
            if (tickle == null || tickle.after(this.endOfToday)) continue;
            Action action = new Action((IDGenerator)this.data);
            action.setDescription(future.getDescription());
            action.setNotes(future.getNotes());
            Thought thought = new Thought();
            thought.setAction(action);
            String date = Constants.DATE_FORMAT_FIXED.format(future.getTickle());
            String desc = NbBundle.getMessage(this.getClass(), (String)"Tickled", (Object)date, (Object)future.getDescription());
            thought.setDescription(desc);
            thought.setTopic(future.getTopic());
            thought.setNotes(future.getNotes());
            this.data.getThoughtManager().insert((Observable)thought, 0);
            this.data.getFutureManager().remove((Observable)future);
        }
    }

    private void activateFutureProjects() {
        Iterator i = this.data.getRootFutures().iterator(Project.class);
        while (i.hasNext()) {
            Project futureProject = (Project)i.next();
            Date startDate = futureProject.getStartDate();
            if (startDate == null || !this.endOfToday.after(startDate)) continue;
            futureProject.removeFromParent();
            this.data.getRootProjects().add((Item)futureProject);
        }
    }

    private void activateInactiveActions() {
        Iterator i = this.data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            this.process((Action)i.next());
        }
        i = this.data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            this.process((Project)i.next());
        }
    }

    private void process(Project project) {
        for (Item item : project.getChildren()) {
            if (item instanceof Project) {
                this.process((Project)item);
                continue;
            }
            if (!(item instanceof Action)) continue;
            this.process((Action)item);
        }
    }

    private void process(Action action) {
        Date startDate;
        ActionState state = action.getState();
        if (state instanceof ActionStateInactive && (startDate = action.getStartDate()) != null && this.endOfToday.after(startDate)) {
            action.setState((ActionState)new ActionStateASAP());
        }
    }
}

