/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.extract.Param;
import tr.extract.ParamFont;
import tr.view.actions.prefs.ActionsOptionsPanelController;
import tr.view.actions.prefs.ActionsPrefs;

final class ActionsPrefsPanel
extends JPanel {
    private final ActionsOptionsPanelController controller;
    private JComboBox fontComboBox;
    private JLabel fontLabel;
    private JLabel fontLabel1;
    private JLabel jLabel1;
    private JCheckBox strikeDoneCheckBox;
    private JCheckBox useColourCheckBox;
    private JSpinner viewDelaySpinner;
    private Vector<Param.Item> items;

    ActionsPrefsPanel(ActionsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.fontLabel = new JLabel();
        this.fontComboBox = new JComboBox();
        this.fontLabel1 = new JLabel();
        this.useColourCheckBox = new JCheckBox();
        this.strikeDoneCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.viewDelaySpinner = new JSpinner();
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((JLabel)this.fontLabel, (String)NbBundle.getMessage(ActionsPrefsPanel.class, (String)"report.font"));
        this.fontLabel.setMaximumSize(new Dimension(38, 23));
        this.fontLabel.setMinimumSize(new Dimension(38, 23));
        this.fontLabel.setPreferredSize(new Dimension(38, 23));
        this.fontComboBox.setMaximumSize(new Dimension(180, 23));
        this.fontComboBox.setMinimumSize(new Dimension(180, 23));
        this.fontComboBox.setPreferredSize(new Dimension(180, 23));
        this.fontComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsPrefsPanel.this.actionPerformed(evt);
            }
        });
        this.fontLabel1.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.fontLabel1, (String)NbBundle.getMessage(ActionsPrefsPanel.class, (String)"report.heading"));
        this.fontLabel1.setMaximumSize(new Dimension(180, 23));
        this.fontLabel1.setMinimumSize(new Dimension(180, 23));
        this.fontLabel1.setPreferredSize(new Dimension(180, 23));
        Mnemonics.setLocalizedText((AbstractButton)this.useColourCheckBox, (String)NbBundle.getMessage(ActionsPrefsPanel.class, (String)"use.color"));
        this.useColourCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.strikeDoneCheckBox, (String)NbBundle.getMessage(ActionsPrefsPanel.class, (String)"strike.done"));
        this.strikeDoneCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.strikeDoneCheckBox.setMaximumSize(new Dimension(180, 23));
        this.strikeDoneCheckBox.setMinimumSize(new Dimension(180, 23));
        this.strikeDoneCheckBox.setPreferredSize(new Dimension(180, 23));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"View action details delay (milliseconds)");
        this.jLabel1.setPreferredSize(new Dimension(107, 23));
        this.viewDelaySpinner.setModel(new SpinnerNumberModel(200, 0, 2000, 50));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fontLabel1, -2, -1, -2).add((Component)this.useColourCheckBox, -1, 180, Short.MAX_VALUE).add((Component)this.strikeDoneCheckBox, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -1, 345, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fontLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.fontComboBox, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.viewDelaySpinner, -2, 69, -2).addContainerGap(296, Short.MAX_VALUE)))));
        layout.linkSize(new Component[]{this.strikeDoneCheckBox, this.useColourCheckBox}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.fontLabel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fontLabel, -2, -1, -2).add((Component)this.fontComboBox, -2, -1, -2)).addPreferredGap(1).add((Component)this.useColourCheckBox).addPreferredGap(1).add((Component)this.strikeDoneCheckBox, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel1, -2, -1, -2).add(0, 0, 0).add((Component)this.viewDelaySpinner, -2, -1, -2).addContainerGap(28, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.strikeDoneCheckBox, this.useColourCheckBox}, 2);
    }

    private void actionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    void load() {
        this.useColourCheckBox.setSelected(ActionsPrefs.isReportUseColour());
        this.strikeDoneCheckBox.setSelected(ActionsPrefs.isReportStrikeDone());
        this.items = (Vector)new ParamFont(null, null).getItems();
        this.fontComboBox.setModel(new DefaultComboBoxModel<Param.Item>(this.items));
        String font = ActionsPrefs.getReportFont();
        for (Param.Item item : this.items) {
            if (!item.value.equals(font)) continue;
            this.fontComboBox.setSelectedItem(item);
            break;
        }
        this.viewDelaySpinner.setValue(ActionsPrefs.getViewDelay());
    }

    void store() {
        ActionsPrefs.setReportUseColour(this.useColourCheckBox.isSelected());
        ActionsPrefs.setReportStrikeDone(this.strikeDoneCheckBox.isSelected());
        Param.Item item = (Param.Item)this.fontComboBox.getSelectedItem();
        if (item != null) {
            ActionsPrefs.setReportFont(item.value);
        }
        ActionsPrefs.setViewDelay((Integer)this.viewDelaySpinner.getValue());
    }

    boolean valid() {
        return true;
    }
}

