/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.exports.information;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamList;
import tr.extract.ParamsDialog;
import tr.extract.prefs.ExtractPrefs;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportText
extends Extract {
    public String getID() {
        return "information-text";
    }

    public String getName() {
        return this.getString("CTL_ExportTextAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(2);
        params.add((Param)new ParamBoolean("include-topic", this.getString("param-include-topic")));
        params.add((Param)new ParamBoolean("include-notes", this.getString("param-include-notes")));
        Vector<Param.Item> separatorItems = new Vector<Param.Item>(3);
        separatorItems.add(new Param.Item(this.getString("comma"), "comma"));
        separatorItems.add(new Param.Item(this.getString("semicolon"), "semicolon"));
        separatorItems.add(new Param.Item(this.getString("tab"), "tab"));
        params.add((Param)new ParamList("separator", this.getString("param-separator"), separatorItems));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleExport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = ExportText.getTmpFile((String)"data.xml");
        this.extractData(data, xmlfile, Extract.FormatType.CSV);
        URL xslURL = ((Object)((Object)this)).getClass().getResource("reference-text.xsl");
        File outfile = ExportText.getOutFile((String)("reference-" + ExportText.getTimeStamp() + ".txt"));
        String encoding = ExtractPrefs.getEncoding();
        this.transformXSL(xmlfile, xslURL, params, outfile, encoding, false);
        this.openTextFile(outfile);
    }
}

