/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics.screen;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.Constants;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.topics.AddTopicsAction;
import tr.view.topics.DeleteTopicAction;
import tr.view.topics.EditTopicAction;
import tr.view.topics.screen.TopicNode;
import tr.view.topics.screen.TopicNodeProvider;
import tr.view.topics.screen.TopicsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicsTopComponent
extends Window
implements TopicNodeProvider {
    private static final long serialVersionUID = 1L;
    private static final String PREFERRED_ID = "TopicsTopComponent";
    private static TopicsTopComponent instance;
    private TopicsPanel.Preferences panelPrefs;
    private TopicsPanel panel;
    private InstanceContent content;
    private Lookup lookup;
    private JToolBar toolbar;

    private TopicsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TopicsTopComponent.class, (String)"CTL_TopicsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TopicsTopComponent.class, (String)"TTT_TopicsTopComponent"));
        this.setIcon(Icons.Topics.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized TopicsTopComponent getDefault() {
        if (instance == null) {
            instance = new TopicsTopComponent();
        }
        return instance;
    }

    public static synchronized TopicsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find topics component. It will not be located properly in the window system.");
            return TopicsTopComponent.getDefault();
        }
        if (win instanceof TopicsTopComponent) {
            return (TopicsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'TopicsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TopicsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            SystemAction[] actions = new SystemAction[]{SystemAction.get(AddTopicsAction.class), SystemAction.get(EditTopicAction.class), SystemAction.get(DeleteTopicAction.class)};
            this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            this.toolbar.setUI(new Toolbar().getUI());
            this.toolbar.setFloatable(false);
            Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
            for (Component component : this.toolbar.getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                component.setPreferredSize(buttonSize);
                component.setMinimumSize(buttonSize);
                component.setMaximumSize(buttonSize);
                component.setSize(buttonSize);
            }
        }
        return this.toolbar;
    }

    protected void componentOpened() {
        super.componentOpened();
        this.provide(null);
        this.removeAll();
        JToolBar tb = this.getToolBar();
        String position = GUIPrefs.getButtonsPosition();
        if (position.equals("top")) {
            tb.setOrientation(0);
            this.add(this.getToolBar(), "North");
        } else if (position.equals("bottom")) {
            tb.setOrientation(0);
            this.add(this.getToolBar(), "South");
        } else if (position.equals("left")) {
            tb.setOrientation(1);
            this.add(this.getToolBar(), "West");
        } else if (position.equals("right")) {
            tb.setOrientation(1);
            this.add(this.getToolBar(), "East");
        }
        this.panel = new TopicsPanel(this);
        this.panel.setPreferences(this.panelPrefs);
        this.add(this.panel, "Center");
    }

    protected void componentClosed() {
        this.panelPrefs = this.panel.getPreferences();
        super.componentClosed();
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    @Override
    public void provide(final Collection<TopicNode> topicNodes) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (TopicsTopComponent.this.panel == null || topicNodes == null) {
                    TopicsTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    TopicsTopComponent.this.getInstanceContent().set(topicNodes, null);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.topics");
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.panel.getPreferences());
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TopicsPanel.Preferences prefs;

        public ResolvableHelper(TopicsPanel.Preferences prefs) {
            this.prefs = prefs;
        }

        public Object readResolve() {
            TopicsTopComponent result = TopicsTopComponent.getDefault();
            result.panelPrefs = this.prefs;
            return result;
        }
    }
}

