/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts.screen;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.Constants;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.contexts.AddContextsAction;
import tr.view.contexts.DeleteContextAction;
import tr.view.contexts.EditContextAction;
import tr.view.contexts.screen.ContextNode;
import tr.view.contexts.screen.ContextNodeProvider;
import tr.view.contexts.screen.ContextsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextsTopComponent
extends Window
implements ContextNodeProvider {
    private static final long serialVersionUID = 1L;
    private static final String PREFERRED_ID = "ContextsTopComponent";
    private static ContextsTopComponent instance;
    private ContextsPanel.Preferences panelPrefs;
    private ContextsPanel panel;
    private InstanceContent content;
    private Lookup lookup;
    private JToolBar toolbar;

    private ContextsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ContextsTopComponent.class, (String)"CTL_ContextsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ContextsTopComponent.class, (String)"TTT_ContextsTopComponent"));
        this.setIcon(Icons.Context.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ContextsTopComponent getDefault() {
        if (instance == null) {
            instance = new ContextsTopComponent();
        }
        return instance;
    }

    public static synchronized ContextsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find contexts component. It will not be located properly in the window system.");
            return ContextsTopComponent.getDefault();
        }
        if (win instanceof ContextsTopComponent) {
            return (ContextsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ContextsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ContextsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            SystemAction[] actions = new SystemAction[]{SystemAction.get(AddContextsAction.class), SystemAction.get(EditContextAction.class), SystemAction.get(DeleteContextAction.class)};
            this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            this.toolbar.setUI(new Toolbar().getUI());
            this.toolbar.setFloatable(false);
            Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
            for (Component component : this.toolbar.getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                component.setPreferredSize(buttonSize);
                component.setMinimumSize(buttonSize);
                component.setMaximumSize(buttonSize);
                component.setSize(buttonSize);
            }
        }
        return this.toolbar;
    }

    protected void componentOpened() {
        super.componentOpened();
        this.provide(null);
        this.removeAll();
        JToolBar toolbar = this.getToolBar();
        String position = GUIPrefs.getButtonsPosition();
        if (position.equals("top")) {
            toolbar.setOrientation(0);
            this.add(this.getToolBar(), "North");
        } else if (position.equals("bottom")) {
            toolbar.setOrientation(0);
            this.add(this.getToolBar(), "South");
        } else if (position.equals("left")) {
            toolbar.setOrientation(1);
            this.add(this.getToolBar(), "West");
        } else if (position.equals("right")) {
            toolbar.setOrientation(1);
            this.add(this.getToolBar(), "East");
        }
        this.panel = new ContextsPanel(this);
        this.panel.setPreferences(this.panelPrefs);
        this.add(this.panel, "Center");
    }

    protected void componentClosed() {
        this.panelPrefs = this.panel.getPreferences();
        super.componentClosed();
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    @Override
    public void provide(final Collection<ContextNode> contextNodes) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (ContextsTopComponent.this.panel == null || contextNodes == null) {
                    ContextsTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    ContextsTopComponent.this.getInstanceContent().set(contextNodes, null);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.contexts");
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.panel.getPreferences());
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ContextsPanel.Preferences prefs;

        public ResolvableHelper(ContextsPanel.Preferences prefs) {
            this.prefs = prefs;
        }

        public Object readResolve() {
            ContextsTopComponent result = ContextsTopComponent.getDefault();
            result.panelPrefs = this.prefs;
            return result;
        }
    }
}

