/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.render.pdf.PDFGraphics2DAdapter;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ColorProfileUtil;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;
import org.w3c.dom.Document;

public class PDFRenderer
extends AbstractPathOrientedRenderer {
    public static final String MIME_TYPE = "application/pdf";
    public static final int NORMAL_PDF_RESOLUTION = 72;
    public static final String ENCRYPTION_PARAMS = "encryption-params";
    public static final String USER_PASSWORD = "user-password";
    public static final String OWNER_PASSWORD = "owner-password";
    public static final String NO_PRINT = "noprint";
    public static final String NO_COPY_CONTENT = "nocopy";
    public static final String NO_EDIT_CONTENT = "noedit";
    public static final String NO_ANNOTATIONS = "noannotations";
    public static final String PDF_A_MODE = "pdf-a-mode";
    public static final String PDF_X_MODE = "pdf-x-mode";
    public static final String KEY_OUTPUT_PROFILE = "output-profile";
    protected static final boolean WRITE_COMMENTS = true;
    protected PDFDocument pdfDoc;
    protected PDFAMode pdfAMode = PDFAMode.DISABLED;
    protected PDFXMode pdfXMode = PDFXMode.DISABLED;
    protected Map pages = null;
    protected Map pageReferences = new HashMap();
    protected Map pvReferences = new HashMap();
    protected OutputStream ostream;
    protected PDFResources pdfResources;
    protected PDFStream currentStream;
    protected PDFResourceContext currentContext = null;
    protected PDFPage currentPage;
    protected PDFEncryptionParams encryptionParams;
    protected PDFICCStream outputProfile;
    protected PDFICCBasedColorSpace sRGBColorSpace;
    protected String outputProfileURI;
    protected PDFState currentState = null;
    protected String currentFontName = "";
    protected int currentFontSize = 0;
    protected int pageHeight;
    protected Map filterMap;
    protected boolean inTextMode = false;
    static /* synthetic */ Class class$org$apache$fop$pdf$PDFDocument;

    public void configure(Configuration cfg) throws ConfigurationException {
        this.filterMap = PDFFilterList.buildFilterMapFromConfiguration(cfg);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
        String s = cfg.getChild(PDF_A_MODE, true).getValue(null);
        if (s != null) {
            this.pdfAMode = PDFAMode.valueOf(s);
        }
        if ((s = cfg.getChild(PDF_X_MODE, true).getValue(null)) != null) {
            this.pdfXMode = PDFXMode.valueOf(s);
        }
        if ((s = cfg.getChild(KEY_OUTPUT_PROFILE, true).getValue(null)) != null) {
            this.outputProfileURI = s;
        }
    }

    private boolean booleanValueOf(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
    }

    public void setUserAgent(FOUserAgent agent) {
        String s;
        Object setting;
        String pwd;
        super.setUserAgent(agent);
        PDFEncryptionParams params = (PDFEncryptionParams)agent.getRendererOptions().get(ENCRYPTION_PARAMS);
        if (params != null) {
            this.encryptionParams = params;
        }
        if ((pwd = (String)agent.getRendererOptions().get(USER_PASSWORD)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setUserPassword(pwd);
        }
        if ((pwd = (String)agent.getRendererOptions().get(OWNER_PASSWORD)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setOwnerPassword(pwd);
        }
        if ((setting = agent.getRendererOptions().get(NO_PRINT)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setAllowPrint(!this.booleanValueOf(setting));
        }
        if ((setting = agent.getRendererOptions().get(NO_COPY_CONTENT)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setAllowCopyContent(!this.booleanValueOf(setting));
        }
        if ((setting = agent.getRendererOptions().get(NO_EDIT_CONTENT)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setAllowEditContent(!this.booleanValueOf(setting));
        }
        if ((setting = agent.getRendererOptions().get(NO_ANNOTATIONS)) != null) {
            if (this.encryptionParams == null) {
                this.encryptionParams = new PDFEncryptionParams();
            }
            this.encryptionParams.setAllowEditAnnotations(!this.booleanValueOf(setting));
        }
        if ((s = (String)agent.getRendererOptions().get(PDF_A_MODE)) != null) {
            this.pdfAMode = PDFAMode.valueOf(s);
        }
        if ((s = (String)agent.getRendererOptions().get(PDF_X_MODE)) != null) {
            this.pdfXMode = PDFXMode.valueOf(s);
        }
        if ((s = (String)agent.getRendererOptions().get(KEY_OUTPUT_PROFILE)) != null) {
            this.outputProfileURI = s;
        }
    }

    public void startRenderer(OutputStream stream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("UserAgent must be set before starting the renderer");
        }
        this.ostream = stream;
        this.pdfDoc = new PDFDocument(this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "");
        this.pdfDoc.getProfile().setPDFAMode(this.pdfAMode);
        this.pdfDoc.getProfile().setPDFXMode(this.pdfXMode);
        this.pdfDoc.getInfo().setCreator(this.userAgent.getCreator());
        this.pdfDoc.getInfo().setCreationDate(this.userAgent.getCreationDate());
        this.pdfDoc.getInfo().setAuthor(this.userAgent.getAuthor());
        this.pdfDoc.getInfo().setTitle(this.userAgent.getTitle());
        this.pdfDoc.getInfo().setKeywords(this.userAgent.getKeywords());
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(stream);
        PDFEncryptionManager.setupPDFEncryption(this.encryptionParams, this.pdfDoc);
        this.addsRGBColorSpace();
        if (this.outputProfileURI != null) {
            this.addDefaultOutputProfile();
        }
        if (this.pdfXMode != PDFXMode.DISABLED) {
            log.debug((Object)(this.pdfXMode + " is active."));
            log.warn((Object)("Note: " + this.pdfXMode + " support is work-in-progress and not fully implemented, yet!"));
            this.addPDFXOutputIntent();
        }
        if (this.pdfAMode.isPDFA1LevelB()) {
            log.debug((Object)("PDF/A is active. Conformance Level: " + this.pdfAMode));
            this.addPDFA1OutputIntent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addsRGBColorSpace() throws IOException {
        ICC_Profile profile;
        if (this.sRGBColorSpace != null) {
            return;
        }
        PDFICCStream sRGBProfile = this.pdfDoc.getFactory().makePDFICCStream();
        InputStream in = (class$org$apache$fop$pdf$PDFDocument == null ? (class$org$apache$fop$pdf$PDFDocument = PDFRenderer.class$("org.apache.fop.pdf.PDFDocument")) : class$org$apache$fop$pdf$PDFDocument).getResourceAsStream("sRGB Color Space Profile.icm");
        if (in != null) {
            try {
                profile = ICC_Profile.getInstance(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            profile = ICC_Profile.getInstance(1000);
        }
        sRGBProfile.setColorSpace(profile, null);
        this.sRGBColorSpace = this.pdfDoc.getFactory().makeICCBasedColorSpace(null, "DefaultRGB", sRGBProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultOutputProfile() throws IOException {
        if (this.outputProfile != null) {
            return;
        }
        InputStream in = null;
        if (this.outputProfileURI != null) {
            ICC_Profile profile;
            this.outputProfile = this.pdfDoc.getFactory().makePDFICCStream();
            Source src = this.userAgent.resolveURI(this.outputProfileURI);
            if (src == null) {
                throw new IOException("Output profile not found: " + this.outputProfileURI);
            }
            in = src instanceof StreamSource ? ((StreamSource)src).getInputStream() : new URL(src.getSystemId()).openStream();
            try {
                profile = ICC_Profile.getInstance(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            this.outputProfile.setColorSpace(profile, null);
        } else {
            this.outputProfile = this.sRGBColorSpace.getICCStream();
        }
    }

    private void addPDFA1OutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription(this.outputProfile.getICCProfile());
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFA1");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    private void addPDFXOutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription(this.outputProfile.getICCProfile());
        int deviceClass = this.outputProfile.getICCProfile().getProfileClass();
        if (deviceClass != 2) {
            throw new PDFConformanceException(this.pdfDoc.getProfile().getPDFXMode() + " requires that" + " the DestOutputProfile be an Output Device Profile. " + desc + " does not match that requirement.");
        }
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFX");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    public void stopRenderer() throws IOException {
        this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
        this.pdfDoc.outputTrailer(this.ostream);
        this.pdfDoc = null;
        this.ostream = null;
        this.pages = null;
        this.pageReferences.clear();
        this.pvReferences.clear();
        this.pdfResources = null;
        this.currentStream = null;
        this.currentContext = null;
        this.currentPage = null;
        this.currentState = null;
        this.currentFontName = "";
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
        ExtensionAttachment attachment;
        if (odi instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)odi);
        } else if (odi instanceof OffDocumentExtensionAttachment && "adobe:ns:meta/".equals((attachment = ((OffDocumentExtensionAttachment)odi).getAttachment()).getCategory())) {
            this.renderXMPMetadata((XMPMetadata)attachment);
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarks) {
        for (int i = 0; i < bookmarks.getCount(); ++i) {
            BookmarkData ext = bookmarks.getSubData(i);
            this.renderBookmarkItem(ext, null);
        }
    }

    private void renderBookmarkItem(BookmarkData bookmarkItem, PDFOutline parentBookmarkItem) {
        PDFOutline pdfOutline = null;
        PageViewport pv = bookmarkItem.getPageViewport();
        if (pv != null) {
            Rectangle2D bounds = pv.getViewArea();
            double h = bounds.getHeight();
            float yoffset = (float)h / 1000.0f;
            String intDest = (String)this.pageReferences.get(pv.getKey());
            if (parentBookmarkItem == null) {
                PDFOutline outlineRoot = this.pdfDoc.getOutlineRoot();
                pdfOutline = this.pdfDoc.getFactory().makeOutline(outlineRoot, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            } else {
                pdfOutline = this.pdfDoc.getFactory().makeOutline(parentBookmarkItem, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            }
        } else {
            log.warn((Object)("Unresolved bookmark item received: " + bookmarkItem.getIDRef()));
        }
        for (int i = 0; i < bookmarkItem.getCount(); ++i) {
            this.renderBookmarkItem(bookmarkItem.getSubData(i), pdfOutline);
        }
    }

    private void renderXMPMetadata(XMPMetadata metadata) {
        Metadata docXMP = metadata.getMetadata();
        Metadata fopXMP = PDFMetadata.createXMPFromUserAgent(this.pdfDoc);
        fopXMP.mergeInto(docXMP);
        XMPBasicAdapter xmpBasic = XMPBasicSchema.getAdapter((Metadata)docXMP);
        xmpBasic.setMetadataDate(new Date());
        PDFMetadata.updateInfoFromMetadata(docXMP, this.pdfDoc.getInfo());
        PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(docXMP, metadata.isReadOnly());
        this.pdfDoc.getRoot().setMetadata(pdfMetadata);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PDFGraphics2DAdapter(this);
    }

    protected void comment(String text) {
        this.currentStream.add("% " + text + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.currentStream.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.endTextObject();
        this.currentStream.add("Q\n");
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.currentStream.add("BT\n");
            this.currentFontName = "";
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        this.closeText();
        if (this.inTextMode) {
            this.currentStream.add("ET\n");
            this.inTextMode = false;
        }
    }

    public void startPageSequence(LineArea seqTitle) {
        if (seqTitle != null) {
            String str = this.convertTitleToString(seqTitle);
            PDFInfo info = this.pdfDoc.getInfo();
            if (info.getTitle() == null) {
                info.setTitle(str);
            }
        }
        if (this.pdfDoc.getRoot().getMetadata() == null) {
            Metadata xmp = PDFMetadata.createXMPFromUserAgent(this.pdfDoc);
            PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(xmp, true);
            this.pdfDoc.getRoot().setMetadata(pdfMetadata);
        }
    }

    public void preparePage(PageViewport page) {
        this.setupPage(page);
        if (this.pages == null) {
            this.pages = new HashMap();
        }
        this.pages.put(page, this.currentPage);
    }

    private void setupPage(PageViewport page) {
        this.pdfResources = this.pdfDoc.getResources();
        Rectangle2D bounds = page.getViewArea();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0), page.getPageIndex());
        this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
        this.pvReferences.put(page.getKey(), page);
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        if (this.pages != null && (this.currentPage = (PDFPage)this.pages.get(page)) != null) {
            this.pages.remove(page);
        } else {
            this.setupPage(page);
        }
        Rectangle2D bounds = page.getViewArea();
        double h = bounds.getHeight();
        this.pageHeight = (int)h;
        this.currentStream = this.pdfDoc.getFactory().makeStream("content", false);
        this.currentState = new PDFState();
        AffineTransform basicPageTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, (float)this.pageHeight / 1000.0f);
        this.currentState.concatenate(basicPageTransform);
        this.currentStream.add(CTMHelper.toPDFString(basicPageTransform, false) + " cm\n");
        this.currentFontName = "";
        super.renderPage(page);
        this.pdfDoc.registerObject(this.currentStream);
        this.currentPage.setContents(this.currentStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        this.pdfDoc.addObject(this.currentPage);
        this.pdfDoc.output(this.ostream);
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.currentState.push();
        this.currentState.concatenate(new AffineTransform(CTMHelper.toPDFArray(ctm)));
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        this.currentStream.add(CTMHelper.toPDFString(ctm) + " cm\n");
    }

    protected void endVParea() {
        this.restoreGraphicsState();
        this.currentState.pop();
    }

    protected void handleRegionTraits(RegionViewport region) {
        this.currentFontName = "";
        super.handleRegionTraits(region);
    }

    protected static final String format(float value) {
        return PDFNumber.doubleOut(value);
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                this.setColor(col, false, null);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[" + PDFRenderer.format(unit) + "] 0 d ");
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[" + PDFRenderer.format(unit) + "] 0 d ");
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 36: {
                this.setColor(col, false, null);
                this.currentStream.add("1 J ");
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[0 " + PDFRenderer.format(unit) + "] 0 d ");
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[0 " + PDFRenderer.format(unit) + " ] 0 d ");
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 37: {
                this.setColor(col, false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    float h3 = h / 3.0f;
                    this.currentStream.add(PDFRenderer.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym2) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym2) + " l S\n");
                    break;
                }
                float w3 = w / 3.0f;
                this.currentStream.add(PDFRenderer.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                this.currentStream.add(PDFRenderer.format(xm2) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm2) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    Color uppercol = PDFRenderer.lightenColor(col, -colFactor);
                    Color lowercol = PDFRenderer.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    this.currentStream.add(PDFRenderer.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    this.setColor(uppercol, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    this.setColor(col, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1 + h3) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1 + h3) + " l S\n");
                    this.setColor(lowercol, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1 + h3 + h3) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1 + h3 + h3) + " l S\n");
                    break;
                }
                Color leftcol = PDFRenderer.lightenColor(col, -colFactor);
                Color rightcol = PDFRenderer.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                this.currentStream.add(PDFRenderer.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                this.setColor(leftcol, false, null);
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                this.setColor(col, false, null);
                this.currentStream.add(PDFRenderer.format(xm1 + w3) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1 + w3) + " " + PDFRenderer.format(y2) + " l S\n");
                this.setColor(rightcol, false, null);
                this.currentStream.add(PDFRenderer.format(xm1 + w3 + w3) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1 + w3 + w3) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                Color c = col;
                if (horz) {
                    c = PDFRenderer.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym1 = y1 + h / 2.0f;
                    this.setColor(c, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    break;
                }
                c = PDFRenderer.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm1 = x1 + w / 2.0f;
                this.setColor(c, false, null);
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.setColor(col, false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
            }
        }
    }

    private void updateLineWidth(float width) {
        if (this.currentState.setLineWidth(width)) {
            this.currentStream.add(PDFRenderer.format(width) + " w\n");
        }
    }

    protected void clipRect(float x, float y, float width, float height) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " " + PDFRenderer.format(width) + " " + PDFRenderer.format(height) + " re ");
        this.clip();
    }

    protected void clip() {
        this.currentStream.add("W\n");
        this.currentStream.add("n\n");
    }

    protected void moveTo(float x, float y) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " m ");
    }

    protected void lineTo(float x, float y) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " l ");
    }

    protected void closePath() {
        this.currentStream.add("h ");
    }

    protected void fillRect(float x, float y, float w, float h) {
        if (w != 0.0f && h != 0.0f) {
            this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " " + PDFRenderer.format(w) + " " + PDFRenderer.format(h) + " re f\n");
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m ");
        this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(endy) + " l S\n");
    }

    protected List breakOutOfStateStack() {
        ArrayList<PDFState.Data> breakOutList = new ArrayList<PDFState.Data>();
        while (true) {
            PDFState.Data data = this.currentState.getData();
            if (this.currentState.pop() == null) break;
            if (breakOutList.size() == 0) {
                this.comment("------ break out!");
            }
            breakOutList.add(0, data);
            this.restoreGraphicsState();
        }
        return breakOutList;
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        this.comment("------ restoring context after break-out...");
        Iterator i = breakOutList.iterator();
        double[] matrix = new double[6];
        while (i.hasNext()) {
            PDFState.Data data = (PDFState.Data)i.next();
            this.currentState.push();
            this.saveGraphicsState();
            AffineTransform at = data.getTransform();
            if (at.isIdentity()) continue;
            this.currentState.concatenate(at);
            at.getMatrix(matrix);
            CTM tempctm = new CTM(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4] * 1000.0, matrix[5] * 1000.0);
            this.currentStream.add(CTMHelper.toPDFString(tempctm) + " cm\n");
        }
        this.comment("------ done.");
    }

    protected void renderLineArea(LineArea line) {
        super.renderLineArea(line);
        this.closeText();
    }

    public void renderInlineParent(InlineParent ip) {
        float start = (float)this.currentIPPosition / 1000.0f;
        float top = (float)(ip.getOffset() + this.currentBPPosition) / 1000.0f;
        float width = (float)ip.getIPD() / 1000.0f;
        float height = (float)ip.getBPD() / 1000.0f;
        super.renderInlineParent(ip);
        if (this.pdfDoc.getProfile().isAnnotationAllowed()) {
            Object tr = ip.getTrait(Trait.INTERNAL_LINK);
            boolean internal = false;
            String dest = null;
            float yoffset = 0.0f;
            if (tr == null) {
                dest = (String)ip.getTrait(Trait.EXTERNAL_LINK);
            } else {
                String pvKey = (String)tr;
                dest = (String)this.pageReferences.get(pvKey);
                if (dest != null) {
                    PageViewport pv = (PageViewport)this.pvReferences.get(pvKey);
                    Rectangle2D bounds = pv.getViewArea();
                    double h = bounds.getHeight();
                    yoffset = (float)h / 1000.0f;
                    internal = true;
                }
            }
            if (dest != null) {
                Rectangle2D rect = new Rectangle2D.Float(start, top, width, height);
                AffineTransform transform = this.currentState.getTransform();
                rect = transform.createTransformedShape(rect).getBounds2D();
                int type = internal ? 1 : 0;
                PDFLink pdflink = this.pdfDoc.getFactory().makeLink(rect, dest, type, yoffset);
                this.currentPage.addAnnotation(pdflink);
            }
        } else {
            log.warn((Object)("Skipping annotation for a link due to PDF profile: " + this.pdfDoc.getProfile()));
        }
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        this.beginTextObject();
        StringBuffer pdf = new StringBuffer();
        String fontName = this.getInternalFontNameForArea(text);
        int size = (Integer)text.getTrait(Trait.FONT_SIZE);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(fontName);
        boolean useMultiByte = tf.isMultiByte();
        this.updateFont(fontName, size, pdf);
        Color ct = (Color)text.getTrait(Trait.COLOR);
        this.updateColor(ct, true, pdf);
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        pdf.append("1 0 0 -1 " + PDFRenderer.format((float)rx / 1000.0f) + " " + PDFRenderer.format((float)bl / 1000.0f) + " Tm ");
        pdf.append("[");
        this.currentStream.add(pdf.toString());
        super.renderText(text);
        this.currentStream.add("] TJ\n");
        this.renderTextDecoration(tf, size, text, bl, rx);
    }

    public void renderWord(WordArea word) {
        Font font = this.getFontFromArea(word.getParentArea());
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        boolean useMultiByte = tf.isMultiByte();
        StringBuffer pdf = new StringBuffer();
        String s = word.getWord();
        this.escapeText(s, word.getLetterAdjustArray(), font, (AbstractTextArea)word.getParentArea(), useMultiByte, pdf);
        this.currentStream.add(pdf.toString());
        super.renderWord(word);
    }

    public void renderSpace(SpaceArea space) {
        int tws;
        Font font = this.getFontFromArea(space.getParentArea());
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        boolean useMultiByte = tf.isMultiByte();
        String s = space.getSpace();
        StringBuffer pdf = new StringBuffer();
        AbstractTextArea textArea = (AbstractTextArea)space.getParentArea();
        this.escapeText(s, null, font, textArea, useMultiByte, pdf);
        if (space.isAdjustable() && (tws = -((TextArea)space.getParentArea()).getTextWordSpaceAdjust() - 2 * textArea.getTextLetterSpaceAdjust()) != 0) {
            pdf.append(PDFRenderer.format((float)tws / ((float)font.getFontSize() / 1000.0f)));
            pdf.append(" ");
        }
        this.currentStream.add(pdf.toString());
        super.renderSpace(space);
    }

    public void escapeText(String s, int[] letterAdjust, Font fs, AbstractTextArea parentArea, boolean useMultiByte, StringBuffer pdf) {
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        int l = s.length();
        float fontSize = (float)fs.getFontSize() / 1000.0f;
        boolean startPending = true;
        for (int i = 0; i < l; ++i) {
            char ch;
            char orgChar = s.charAt(i);
            float glyphAdjust = 0.0f;
            if (fs.hasChar(orgChar)) {
                ch = fs.mapChar(orgChar);
                int tls = i < l - 1 ? parentArea.getTextLetterSpaceAdjust() : 0;
                glyphAdjust -= (float)tls;
            } else if (CharUtilities.isFixedWidthSpace(orgChar)) {
                ch = fs.mapChar(' ');
                glyphAdjust = fs.getCharWidth(ch) - fs.getCharWidth(orgChar);
            } else {
                ch = fs.mapChar(orgChar);
            }
            if (letterAdjust != null && i < l - 1) {
                glyphAdjust -= (float)letterAdjust[i + 1];
            }
            if (startPending) {
                pdf.append(startText);
                startPending = false;
            }
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    pdf.append("\\");
                    pdf.append(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            pdf.append("\\");
                            break;
                        }
                    }
                    pdf.append(ch);
                }
            } else {
                pdf.append(PDFText.toUnicodeHex(ch));
            }
            float adjust = glyphAdjust / fontSize;
            if (adjust == 0.0f) continue;
            pdf.append(endText).append(PDFRenderer.format(adjust)).append(' ');
            startPending = true;
        }
        if (!startPending) {
            pdf.append(endText);
        }
    }

    protected void closeText() {
    }

    protected void setColor(Color col, boolean fill, StringBuffer pdf) {
        PDFColor color = new PDFColor(this.pdfDoc, col);
        this.closeText();
        if (pdf != null) {
            pdf.append(color.getColorSpaceOut(fill));
        } else {
            this.currentStream.add(color.getColorSpaceOut(fill));
        }
    }

    private void updateColor(Color col, boolean fill, StringBuffer pdf) {
        if (col == null) {
            return;
        }
        boolean update = false;
        update = fill ? this.currentState.setBackColor(col) : this.currentState.setColor(col);
        if (update) {
            this.setColor(col, fill, pdf);
        }
    }

    protected void updateColor(Color col, boolean fill) {
        this.updateColor(col, fill, null);
    }

    private void updateFont(String name, int size, StringBuffer pdf) {
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.closeText();
            this.currentFontName = name;
            this.currentFontSize = size;
            pdf = pdf.append("/" + name + " " + PDFRenderer.format((float)size / 1000.0f) + " Tf\n");
        }
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.endTextObject();
        String url = image.getURL();
        this.putImage(url, pos);
    }

    protected void drawImage(String url, Rectangle2D pos, Map foreignAttributes) {
        this.endTextObject();
        this.putImage(url, pos);
    }

    protected void putImage(String url, Rectangle2D pos) {
        PDFXObject xobject = this.pdfDoc.getImage(url);
        if (xobject != null) {
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobject.getXNumber());
            return;
        }
        url = ImageFactory.getURL(url);
        ImageFactory fact = this.userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, null);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, null);
        } else if ("image/eps".equals(mime)) {
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        } else if ("image/jpeg".equals(mime) || "image/tiff".equals(mime)) {
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        } else {
            if (!fopimage.load(4)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        }
        try {
            this.pdfDoc.output(this.ostream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void placeImage(float x, float y, float w, float h, int xobj) {
        this.saveGraphicsState();
        this.currentStream.add(PDFRenderer.format(w) + " 0 0 " + PDFRenderer.format(-h) + " " + PDFRenderer.format((float)this.currentIPPosition / 1000.0f + x) + " " + PDFRenderer.format((float)this.currentBPPosition / 1000.0f + h + y) + " cm\n" + "/Im" + xobj + " Do\n");
        this.restoreGraphicsState();
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("pdfDoc", this.pdfDoc);
        context.setProperty("outputStream", this.ostream);
        context.setProperty("pdfState", this.currentState);
        context.setProperty("pdfPage", this.currentPage);
        context.setProperty("pdfContext", this.currentContext == null ? this.currentPage : this.currentContext);
        context.setProperty("pdfContext", this.currentContext);
        context.setProperty("pdfStream", this.currentStream);
        context.setProperty("fontInfo", this.fontInfo);
        context.setProperty("fontName", this.currentFontName);
        context.setProperty("fontSize", new Integer(this.currentFontSize));
        return context;
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        this.currentState.push();
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        switch (style) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 36: {
                this.clipRect(startx, starty, endx - startx, ruleThickness);
                this.currentStream.add("1 0 0 1 " + PDFRenderer.format(ruleThickness / 2.0f) + " 0 cm\n");
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 55: 
            case 119: {
                float half = (float)area.getRuleThickness() / 2000.0f;
                this.setColor(PDFRenderer.lightenColor(col, 0.6f), true, null);
                this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m\n");
                this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " l\n");
                this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                this.currentStream.add("h\n");
                this.currentStream.add("f\n");
                this.setColor(col, true, null);
                if (style == 55) {
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " l\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx + half) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                } else {
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " m\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(endx - half) + " " + PDFRenderer.format(starty + half) + " l\n");
                }
                this.currentStream.add("h\n");
                this.currentStream.add("f\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
        this.currentState.pop();
        this.beginTextObject();
        super.renderLeader(area);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

