/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.projects;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;

public class ProjectsPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.projects");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/projects");
    private static final String KEY_AUTO_SEQUENCE_ACTIONS = "auto.sequence.actions";
    private static final boolean DEF_AUTO_SEQUENCE_ACTIONS = false;
    private static final String KEY_INCLUDE_START_DATE = "include.start.date";
    private static final boolean DEF_INCLUDE_START_DATE = false;
    private static final String KEY_INCLUDE_DUE_DATE = "include.due.date";
    private static final boolean DEF_INCLUDE_DUE_DATE = false;
    private static final String KEY_NEW_ACTION_STATE = "new.action.state";
    private static final ActionState DEF_NEW_ACTION_STATE = ActionState.INACTIVE;
    private static final String KEY_EDIT_CREATE_DATE = "edit.create-date";
    private static final boolean DEF_EDIT_CREATE_DATE = false;

    public static final boolean isSequencing() {
        return prefs.getBoolean(KEY_AUTO_SEQUENCE_ACTIONS, false);
    }

    public static final void setSequencing(boolean value) {
        prefs.putBoolean(KEY_AUTO_SEQUENCE_ACTIONS, value);
        ProjectsPrefs.flush();
    }

    public static final boolean isIncludeStartDate() {
        return prefs.getBoolean(KEY_INCLUDE_START_DATE, false);
    }

    public static final void setIncludeStartDate(boolean value) {
        prefs.putBoolean(KEY_INCLUDE_START_DATE, value);
        ProjectsPrefs.flush();
    }

    public static final boolean isIncludeDueDate() {
        return prefs.getBoolean(KEY_INCLUDE_DUE_DATE, false);
    }

    public static final void setIncludeDueDate(boolean value) {
        prefs.putBoolean(KEY_INCLUDE_DUE_DATE, value);
        ProjectsPrefs.flush();
    }

    public static final ActionState getNewActionState() {
        int id = prefs.getInt(KEY_NEW_ACTION_STATE, ProjectsPrefs.DEF_NEW_ACTION_STATE.id);
        return ActionState.getActionState(id);
    }

    public static final void setNewActionState(ActionState value) {
        if (value == null) {
            value = DEF_NEW_ACTION_STATE;
        }
        prefs.putInt(KEY_NEW_ACTION_STATE, value.id);
        ProjectsPrefs.flush();
    }

    public static final boolean isEditCreateDate() {
        return prefs.getBoolean(KEY_EDIT_CREATE_DATE, false);
    }

    public static final void setEditCreateDate(boolean value) {
        prefs.putBoolean(KEY_EDIT_CREATE_DATE, value);
        ProjectsPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Projects preferences error. " + ex.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionState {
        INACTIVE(0, NbBundle.getMessage(ProjectsPrefs.class, (String)"ActionStateInactive")),
        DOASAP(1, NbBundle.getMessage(ProjectsPrefs.class, (String)"ActionStateDoASAP")),
        SCHEDULED(2, NbBundle.getMessage(ProjectsPrefs.class, (String)"ActionStateScheduled")),
        DELEGATED(3, NbBundle.getMessage(ProjectsPrefs.class, (String)"ActionStateDelegated"));

        public final int id;
        public final String name;

        private ActionState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static ActionState getActionState(int id) {
            if (id == ActionState.DOASAP.id) {
                return DOASAP;
            }
            if (id == ActionState.SCHEDULED.id) {
                return SCHEDULED;
            }
            if (id == ActionState.DELEGATED.id) {
                return DELEGATED;
            }
            return INACTIVE;
        }

        public String toString() {
            return this.name;
        }
    }
}

