/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects.future;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.awt.Toolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import tr.appl.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.prefs.gui.GUIPrefs;
import tr.view.ReprocessAction;
import tr.view.Window;
import tr.view.projects.ActionNode;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddProjectAction;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectiseAction;
import tr.view.projects.ToggleShowDoneAction;
import tr.view.projects.future.FutureRootNode;

public final class FutureTopComponent
extends Window
implements LookupListener,
ExplorerManager.Provider {
    private static final String PREFERRED_ID = "FutureProjectsTopComponent";
    private static FutureTopComponent instance;
    private final transient ExplorerManager manager = new ExplorerManager();
    private transient boolean initialised;
    private transient Lookup.Result dataResult;
    private transient Lookup.Result itemResult;
    private transient JToolBar toolbar;
    private JScrollPane projectsPane;

    private FutureTopComponent() {
        this.setName(this.getText("CTL_FutureTopComponent"));
        this.setToolTipText(this.getText("HINT_FutureTopComponent"));
        this.setIcon(Icons.ProjectsFuture.getImage());
        this.initComponents();
        this.initialise();
    }

    private void initialise() {
        Data data;
        if (this.initialised) {
            return;
        }
        this.add(this.getToolbar(), GUIPrefs.getBorderLayoutButtonsPosition());
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    FutureTopComponent.this.initialised = false;
                }
            });
        }
        if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
            return;
        }
        this.manager.setRootContext((Node)new FutureRootNode(data.getRootFutures(), false));
        this.manager.getRootContext().setDisplayName(this.getText("CTL_FutureNode"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        try {
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.initialised = true;
    }

    private JToolBar getToolbar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(AddActionAction.class), null, SystemAction.get(AddProjectAction.class), null, SystemAction.get(ReprocessAction.class), null, SystemAction.get(ProjectiseAction.class), null, SystemAction.get(ToggleShowDoneAction.class)};
        this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        this.toolbar.setUI(new Toolbar().getUI());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(GUIPrefs.getToolBarOrientation());
        Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.setPreferredSize(buttonSize);
            component.setMinimumSize(buttonSize);
            component.setMaximumSize(buttonSize);
            component.setSize(buttonSize);
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.initialise();
    }

    public void componentActivated() {
        super.componentActivated();
        this.initialise();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FutureTopComponent.this.activate();
            }
        });
    }

    private void activate() {
        this.itemResult = this.getLookup().lookup(new Lookup.Template(Item.class));
        this.itemResult.addLookupListener((LookupListener)this);
        this.itemResult.allInstances();
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length == 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
            }
            catch (Exception ex) {}
        } else if (selectedNodes[0] instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)projectNode);
        } else if (selectedNodes[0] instanceof ActionNode) {
            ActionNode actionNode = (ActionNode)selectedNodes[0];
            EditorTopComponent.findInstance().view((Node)actionNode);
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        if (this.itemResult != null) {
            this.itemResult.removeLookupListener((LookupListener)this);
            this.itemResult = null;
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Node[] nodes = FutureTopComponent.this.manager.getSelectedNodes();
                Node node = nodes.length > 0 ? nodes[0] : null;
                EditorTopComponent.findInstance().view(node);
            }
        });
    }

    private String getText(String key) {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)key);
    }

    public TreeView getTreeView() {
        return (TreeView)this.projectsPane;
    }

    private void initComponents() {
        this.projectsPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.projectsPane, "Center");
    }

    public static synchronized FutureTopComponent getDefault() {
        if (instance == null) {
            instance = new FutureTopComponent();
        }
        return instance;
    }

    public static synchronized FutureTopComponent findInstance() {
        return FutureTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects.future");
    }

    public void takeFocus() {
        this.getTreeView().requestFocusInWindow();
    }
}

