/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.screen;

import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.information.Information;
import tr.model.thought.Thought;
import tr.util.Observable;
import tr.view.process.ProcessThoughtsAction;
import tr.view.reference.ReferenceDeleteCookie;
import tr.view.reference.ReferenceEditCookie;
import tr.view.reference.ReferenceReprocessCookie;
import tr.view.reference.screen.ReferenceTopComponent;

public class ReferenceNode
extends AbstractNode
implements ReferenceEditCookie,
ReferenceDeleteCookie,
ReferenceReprocessCookie {
    public final Information info;

    public ReferenceNode(Information info) {
        super(Children.LEAF, Lookups.singleton((Object)info));
        this.info = info;
    }

    public String getName() {
        return this.info == null ? "" : this.info.getDescription();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ReferenceEditCookie.class) {
            return this;
        }
        if (clazz == ReferenceDeleteCookie.class) {
            return this;
        }
        if (clazz == ReferenceReprocessCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    public void editReference() {
        if (this.info == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        ReferenceTopComponent rtc = ReferenceTopComponent.findInstance();
        if (rtc == null) {
            return;
        }
        rtc.edit();
    }

    public void deleteReference() {
        if (this.info == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getInformationManager().remove((Observable)this.info);
    }

    public void reprocessReference() {
        if (this.info == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getInformationManager().remove((Observable)this.info);
        Thought thought = new Thought();
        thought.setDescription(this.info.getDescription());
        thought.setTopic(this.info.getTopic());
        thought.setNotes(this.info.getNotes());
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ProcessThoughtsAction pta = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class);
        pta.performAction();
    }
}

