/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.catalina.ant.AbstractCatalinaTask;
import org.apache.tools.ant.BuildException;

public class JkStatusUpdateTask
extends AbstractCatalinaTask {
    private static final String info = "org.apache.jk.status.JkStatusUpdateTask/1.1";
    private String worker = "lb";
    private String workerType = "lb";
    private int internalid = 0;
    private Integer lbRetries;
    private Integer lbRecovertime;
    private Boolean lbStickySession = Boolean.TRUE;
    private Boolean lbForceSession = Boolean.FALSE;
    private Integer workerLoadFactor;
    private String workerJvmRoute;
    private int workerDistance = -1;
    private String workerRedirect;
    private String workerClusterDomain;
    private Boolean workerDisabled;
    private Boolean workerStopped;
    private int workerActivation = -1;
    private boolean isLBMode = true;
    private String workerLb;

    public String getInfo() {
        return info;
    }

    public JkStatusUpdateTask() {
        this.setUrl("http://localhost/jkstatus");
    }

    public int getWorkerDistance() {
        return this.workerDistance;
    }

    public void setWorkerDistance(int workerDistance) {
        this.workerDistance = workerDistance;
    }

    public String getWorkerJvmRoute() {
        return this.workerJvmRoute;
    }

    public void setWorkerJvmRoute(String workerJvmRoute) {
        this.workerJvmRoute = workerJvmRoute;
    }

    public int getInternalid() {
        return this.internalid;
    }

    public void setInternalid(int internalid) {
        this.internalid = internalid;
    }

    public Boolean getLbForceSession() {
        return this.lbForceSession;
    }

    public void setLbForceSession(Boolean lbForceSession) {
        this.lbForceSession = lbForceSession;
    }

    public Integer getLbRecovertime() {
        return this.lbRecovertime;
    }

    public void setLbRecovertime(Integer lbRecovertime) {
        this.lbRecovertime = lbRecovertime;
    }

    public Integer getLbRetries() {
        return this.lbRetries;
    }

    public void setLbRetries(Integer lbRetries) {
        this.lbRetries = lbRetries;
    }

    public Boolean getLbStickySession() {
        return this.lbStickySession;
    }

    public void setLbStickySession(Boolean lbStickySession) {
        this.lbStickySession = lbStickySession;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public void setWorkerType(String workerType) {
        this.workerType = workerType;
    }

    public String getWorkerLb() {
        return this.workerLb;
    }

    public void setWorkerLb(String workerLb) {
        this.workerLb = workerLb;
    }

    public String getWorkerClusterDomain() {
        return this.workerClusterDomain;
    }

    public void setWorkerClusterDomain(String workerClusterDomain) {
        this.workerClusterDomain = workerClusterDomain;
    }

    public Boolean getWorkerDisabled() {
        return this.workerDisabled;
    }

    public void setWorkerDisabled(Boolean workerDisabled) {
        this.workerDisabled = workerDisabled;
    }

    public int getWorkerActivation() {
        return this.workerActivation;
    }

    public void setWorkerActivation(int workerActivation) {
        this.workerActivation = workerActivation;
    }

    public Boolean getWorkerStopped() {
        return this.workerStopped;
    }

    public void setWorkerStopped(Boolean workerStopped) {
        this.workerStopped = workerStopped;
    }

    public Integer getWorkerLoadFactor() {
        return this.workerLoadFactor;
    }

    public void setWorkerLoadFactor(Integer workerLoadFactor) {
        this.workerLoadFactor = workerLoadFactor;
    }

    public String getWorkerRedirect() {
        return this.workerRedirect;
    }

    public void setWorkerRedirect(String workerRedirect) {
        this.workerRedirect = workerRedirect;
    }

    public void execute() throws BuildException {
        super.execute();
        this.checkParameter();
        StringBuffer sb = this.createLink();
        this.execute(sb.toString(), null, null, -1);
    }

    private StringBuffer createLink() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("?cmd=update&mime=txt");
            sb.append("&w=");
            if (this.isLBMode) {
                sb.append(URLEncoder.encode(this.worker, this.getCharset()));
                if (this.lbRetries != null) {
                    sb.append("&vlr=");
                    sb.append(this.lbRetries);
                }
                if (this.lbRecovertime != null) {
                    sb.append("&vlt=");
                    sb.append(this.lbRecovertime);
                }
                if (this.lbStickySession != null) {
                    sb.append("&vls=");
                    sb.append(this.lbStickySession);
                }
                if (this.lbForceSession != null) {
                    sb.append("&vlf=");
                    sb.append(this.lbForceSession);
                }
            } else {
                if (this.workerLb != null) {
                    sb.append(URLEncoder.encode(this.workerLb, this.getCharset()));
                }
                sb.append("&sw=");
                sb.append(URLEncoder.encode(this.worker, this.getCharset()));
                if (this.workerLoadFactor != null) {
                    sb.append("&vwf=");
                    sb.append(this.workerLoadFactor);
                }
                if (this.workerJvmRoute != null) {
                    sb.append("&vwn=");
                    sb.append(URLEncoder.encode(this.workerJvmRoute, this.getCharset()));
                }
                if (this.workerDisabled != null) {
                    sb.append("&vwd=");
                    sb.append(this.workerDisabled);
                }
                if (this.workerStopped != null) {
                    sb.append("&vws=");
                    sb.append(this.workerStopped);
                }
                if (this.workerActivation >= 0 && this.workerActivation < 3) {
                    sb.append("&vwa=");
                    sb.append(this.workerActivation);
                }
                if (this.workerDistance >= 0) {
                    sb.append("&vwx=");
                    sb.append(this.workerDistance);
                }
                if (this.workerRedirect != null) {
                    sb.append("&vwr=");
                    sb.append(URLEncoder.encode(this.workerRedirect, this.getCharset()));
                }
                if (this.workerClusterDomain != null) {
                    sb.append("&vwc=");
                    sb.append(URLEncoder.encode(this.workerClusterDomain, this.getCharset()));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        return sb;
    }

    protected void checkParameter() {
        if (this.worker == null) {
            throw new BuildException("Must specify 'worker' attribute");
        }
        if (this.workerType == null) {
            throw new BuildException("Must specify 'workerType' attribute");
        }
        if ("lb".equals(this.workerType)) {
            if (this.lbRecovertime == null && this.lbRetries == null) {
                throw new BuildException("Must specify at a lb worker either 'lbRecovertime' or'lbRetries' attribute");
            }
            if (this.lbStickySession == null || this.lbForceSession == null) {
                throw new BuildException("Must specify at a lb worker either'lbStickySession' and 'lbForceSession' attribute");
            }
            if (null != this.lbRecovertime && 60 < this.lbRecovertime) {
                throw new BuildException("The 'lbRecovertime' must be greater than 59");
            }
            if (null != this.lbRetries && 1 < this.lbRetries) {
                throw new BuildException("The 'lbRetries' must be greater than 1");
            }
            this.isLBMode = true;
        } else if ("worker".equals(this.workerType)) {
            if (this.workerLoadFactor == null) {
                throw new BuildException("Must specify at a node worker 'workerLoadFactor' attribute");
            }
            if (this.workerClusterDomain == null) {
                throw new BuildException("Must specify at a node worker 'workerClusterDomain' attribute");
            }
            if (this.workerRedirect == null) {
                throw new BuildException("Must specify at a node worker 'workerRedirect' attribute");
            }
            if (this.workerLb == null) {
                throw new BuildException("Must specify 'workerLb' attribute");
            }
            if (this.workerLoadFactor < 1) {
                throw new BuildException("The 'workerLoadFactor' must be greater or equal 1");
            }
            this.isLBMode = false;
        } else {
            throw new BuildException("Only 'lb' and 'worker' supported as workerType attribute");
        }
    }
}

