/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserAPIUsage
extends DefaultHandler {
    protected static final String DEFAULT_API_TO_USE = "sax";
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_SECURE_PROCESSING = false;

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (stringArray.length == 0) {
            ParserAPIUsage.printUsage();
            System.exit(1);
        }
        ParserAPIUsage parserAPIUsage = new ParserAPIUsage();
        Vector<Object> vector = null;
        String string = stringArray[stringArray.length - 1];
        Object object3 = DEFAULT_API_TO_USE;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length - 1) {
            object2 = stringArray[n];
            if (((String)object2).startsWith("-")) {
                object = ((String)object2).substring(1);
                if (((String)object2).equals("-a")) {
                    if (vector == null) {
                        vector = new Vector<Object>();
                    }
                    while (n + 1 < stringArray.length - 1 && !((String)(object2 = stringArray[n + 1])).startsWith("-")) {
                        vector.add(object2);
                        ++n;
                    }
                } else if (((String)object2).equals("-api")) {
                    if (n + 1 < stringArray.length - 1 && !((String)(object2 = stringArray[n + 1])).startsWith("-")) {
                        if (((String)object2).equals(DEFAULT_API_TO_USE) || ((String)object2).equals("dom")) {
                            object3 = object2;
                        } else {
                            System.err.println("error: unknown source type (" + (String)object2 + ").");
                        }
                    }
                } else if (((String)object).equalsIgnoreCase("xi")) {
                    bl = ((String)object).equals("xi");
                } else if (((String)object).equalsIgnoreCase("sp")) {
                    bl2 = ((String)object).equals("sp");
                } else if (((String)object).equals("h")) {
                    ParserAPIUsage.printUsage();
                } else {
                    System.err.println("error: unknown option (" + (String)object + ").");
                }
            }
            ++n;
        }
        try {
            object2 = null;
            if (vector != null && vector.size() > 0) {
                object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                ((SchemaFactory)object).setErrorHandler(parserAPIUsage);
                int n2 = vector.size();
                Source[] sourceArray = new StreamSource[n2];
                int n3 = 0;
                while (n3 < n2) {
                    sourceArray[n3] = new StreamSource((String)vector.elementAt(n3));
                    ++n3;
                }
                object2 = ((SchemaFactory)object).newSchema(sourceArray);
            }
            if ("dom".equals(object3)) {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                ((DocumentBuilderFactory)object).setXIncludeAware(bl);
                ((DocumentBuilderFactory)object).setSchema((Schema)object2);
                ((DocumentBuilderFactory)object).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", bl2);
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                documentBuilder.setErrorHandler(parserAPIUsage);
                documentBuilder.parse(string);
                documentBuilder.reset();
                documentBuilder.setErrorHandler(parserAPIUsage);
                documentBuilder.parse(string);
            } else {
                object = SAXParserFactory.newInstance();
                ((SAXParserFactory)object).setNamespaceAware(true);
                ((SAXParserFactory)object).setXIncludeAware(bl);
                ((SAXParserFactory)object).setSchema((Schema)object2);
                ((SAXParserFactory)object).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", bl2);
                SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
                sAXParser.parse(string, (DefaultHandler)parserAPIUsage);
                sAXParser.reset();
                sAXParser.parse(string, (DefaultHandler)parserAPIUsage);
            }
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            Exception exception2;
            Exception exception3;
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (exception instanceof SAXException && (exception3 = ((SAXException)exception).getException()) != null) {
                exception2 = exception3;
            }
            exception2.printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.ParserAPIUsage (options) uri");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -a uri ...      Provide a list of schema documents.");
        System.err.println("  -api (sax|dom)  Select API to use (sax|dom).");
        System.err.println("  -xi | -XI       Turn on/off XInclude processing.");
        System.err.println("  -sp | -SP       Turn on/off secure processing.");
        System.err.println("  -h              This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  API to use:            sax");
        System.err.print("  XInclude:              ");
        System.err.println("off");
        System.err.print("  Secure processing:     ");
        System.err.println("off");
    }
}

