/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.pad.GPGraph;

public class GPUserObject
implements Serializable,
DefaultGraphCell.ValueChangeHandler {
    public static String keyValue = "value";
    public static String keyURI = "url";
    protected Map properties;
    protected transient JDialog propertyDlg;
    protected transient JTable table;
    protected transient DefaultTableModel dataModel;

    public GPUserObject() {
        this(null, null);
    }

    public GPUserObject(String string, Map hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = new Hashtable(hashtable);
        if (string != null) {
            this.valueChanged(string);
        }
    }

    public GPUserObject(String string) {
        this(string, null);
    }

    public GPUserObject(Map map) {
        this(null, map);
    }

    public Object valueChanged(Object object) {
        if (object instanceof String) {
            return this.putProperty(keyValue, object);
        }
        return this;
    }

    public Object clone() {
        return new GPUserObject(this.properties);
    }

    public Object getProperty(Object object) {
        return this.properties.get(object);
    }

    public Object putProperty(Object object, Object object2) {
        if (object2 != null) {
            return this.properties.put(object, object2);
        }
        return this.properties.remove(object);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    protected void showPropertyDialog(final GPGraph gPGraph, final Object object) {
        Object object2;
        Object object3;
        Frame frame = (Frame)SwingUtilities.windowForComponent(gPGraph);
        if (frame != null && this.propertyDlg == null) {
            this.propertyDlg = new JDialog(frame, "", false);
            object3 = this.propertyDlg.getContentPane();
            ((Container)object3).setLayout(new BorderLayout());
            this.dataModel = new DefaultTableModel(new Object[]{"Key", "Value"}, 0);
            this.table = new JTable(this.dataModel);
            object2 = new JScrollPane(this.table);
            ((Container)object3).add("Center", (Component)object2);
            JButton jButton = new JButton("OK");
            JButton jButton2 = new JButton("Close");
            JButton jButton3 = new JButton("Apply");
            JButton jButton4 = new JButton("New");
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            jPanel.add(jButton4);
            ((Container)object3).add("South", jPanel);
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPUserObject.this.apply(gPGraph, object, GPUserObject.this.dataModel);
                }
            });
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPUserObject.this.apply(gPGraph, object, GPUserObject.this.dataModel);
                    GPUserObject.this.propertyDlg.dispose();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPUserObject.this.propertyDlg.dispose();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPUserObject.this.dataModel.addRow(new Object[]{"Key", "Value"});
                }
            });
            this.propertyDlg.setSize(new Dimension(300, 300));
            this.propertyDlg.setLocationRelativeTo(frame);
        }
        this.dataModel = new DefaultTableModel(new Object[]{"Key", "Value"}, 0);
        object3 = this.properties.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            this.dataModel.addRow(new Object[]{object2.getKey(), object2.getValue()});
        }
        this.table.setModel(this.dataModel);
        this.propertyDlg.setTitle("Properties of " + this.toString());
        this.propertyDlg.show();
    }

    protected void apply(GPGraph gPGraph, Object object, TableModel tableModel) {
        this.properties.clear();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            this.properties.put(tableModel.getValueAt(n, 0), tableModel.getValueAt(n, 1));
            ++n;
        }
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        Map map = GraphConstants.createMap();
        Object object2 = this.getProperty(keyValue);
        if (object2 == null) {
            this.valueChanged("");
        }
        GraphConstants.setValue(map, this.getProperty(keyValue));
        hashtable.put(object, map);
        gPGraph.getModel().edit(hashtable, null, null, null);
    }

    public String toString() {
        Object v = this.properties.get(keyValue);
        if (v != null) {
            return v.toString();
        }
        return super.toString();
    }
}

