/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.pad.GPGraph;

public class RealGraphCellRenderer
extends JComponent {
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected CellView[] views;
    protected GPGraph graph;
    protected double scale = 1.0;

    public RealGraphCellRenderer(GPGraph gPGraph, CellView[] cellViewArray) {
        this.add(this.rendererPane);
        this.views = cellViewArray;
        this.graph = gPGraph;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public Dimension getPreferredSize() {
        if (this.views != null) {
            Rectangle rectangle = AbstractCellView.getBounds(this.views);
            rectangle.width = (int)((double)rectangle.width * this.scale);
            rectangle.height = (int)((double)rectangle.height * this.scale);
            return new Dimension(rectangle.width + 2, rectangle.height + 2);
        }
        return new Dimension(10, 10);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(this.scale, this.scale);
        if (this.views != null) {
            Rectangle rectangle = AbstractCellView.getBounds(this.views);
            graphics.translate(-rectangle.x, -rectangle.y);
            int n = 0;
            while (n < this.views.length) {
                Rectangle rectangle2 = this.views[n].getBounds();
                Component component = this.graph.isGroup(this.views[n].getCell()) ? new RealGraphCellRenderer(this.graph, this.views[n].getChildViews()) : this.views[n].getRendererComponent(this.graph, false, false, false);
                this.rendererPane.paintComponent(graphics, component, this, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                ++n;
            }
        }
        graphics2D.setTransform(affineTransform);
    }
}

