<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1623 $
 * $Id: EditHolidayPolicy.php 1623 2008-01-09 23:47:31Z ipso $
 * $Date: 2008-01-09 15:47:31 -0800 (Wed, 09 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('holiday_policy','enabled')
		OR !( $permission->Check('holiday_policy','edit') OR $permission->Check('holiday_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Holiday Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data['minimum_time'] ) ) {
	$data['minimum_time'] = TTDate::parseTimeUnit($data['minimum_time']);
}
if ( isset($data['maximum_time'] ) ) {
	$data['maximum_time'] = TTDate::parseTimeUnit($data['maximum_time']);
}


$hpf = new HolidayPolicyFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$hpf->StartTransaction();

		$hpf->setId( $data['id'] );
		$hpf->setCompany( $current_company->getId() );
		$hpf->setName( $data['name'] );
		$hpf->setType( $data['type_id'] );

		$hpf->setDefaultScheduleStatus( $data['default_schedule_status_id'] );
		$hpf->setMinimumEmployedDays( $data['minimum_employed_days'] );
		$hpf->setMinimumWorkedPeriodDays( $data['minimum_worked_period_days'] );
		$hpf->setMinimumWorkedDays( $data['minimum_worked_days'] );
		$hpf->setAverageTimeDays( $data['average_time_days'] );
		//$hpf->setIncludeOverTime( $data['include_over_time'] );
		if ( isset($data['average_time_worked_days']) ) {
			$hpf->setAverageTimeWorkedDays( TRUE );
		} else {
			$hpf->setAverageTimeWorkedDays( FALSE );
		}
		if ( isset($data['include_over_time']) ) {
			$hpf->setIncludeOverTime( TRUE );
		} else {
			$hpf->setIncludeOverTime( FALSE );
		}
		if ( isset($data['include_paid_absence_time']) ) {
			$hpf->setIncludePaidAbsenceTime( TRUE );
		} else {
			$hpf->setIncludePaidAbsenceTime( FALSE );
		}
		if ( isset($data['force_over_time_policy']) ) {
			$hpf->setForceOverTimePolicy( TRUE );
		} else {
			$hpf->setForceOverTimePolicy( FALSE );
		}

		$hpf->setMinimumTime( $data['minimum_time'] );
		$hpf->setMaximumTime( $data['maximum_time'] );
		$hpf->setAbsencePolicyID( $data['absence_policy_id'] );
		$hpf->setRoundIntervalPolicyID( $data['round_interval_policy_id'] );

		if ( $hpf->isValid() ) {
			$hpf->Save(FALSE);

			$hpf->setRecurringHoliday( $data['recurring_holiday_ids'] );

			if ( $hpf->isValid() ) {
				$hpf->Save();
				$hpf->CommitTransaction();

				Redirect::Page( URLBuilder::getURL( NULL, 'HolidayPolicyList.php') );

				break;
			}
		}

		$hpf->FailTransaction();

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$hplf = new HolidayPolicyListFactory();
			$hplf->getById($id);

			foreach ($hplf as $hp_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $hp_obj->getId(),
									'name' => $hp_obj->getName(),
									'type_id' => $hp_obj->getType(),
									'default_schedule_status_id' => $hp_obj->getDefaultScheduleStatus(),
									'minimum_employed_days' => $hp_obj->getMinimumEmployedDays(),
									'minimum_worked_period_days' => $hp_obj->getMinimumWorkedPeriodDays(),
									'minimum_worked_days' => $hp_obj->getMinimumWorkedDays(),
									'average_time_days' => $hp_obj->getAverageTimeDays(),
									'average_time_worked_days' => $hp_obj->getAverageTimeWorkedDays(),
									'force_over_time_policy' => $hp_obj->getForceOverTimePolicy(),
									'include_over_time' => $hp_obj->getIncludeOverTime(),
									'include_paid_absence_time' => $hp_obj->getIncludePaidAbsenceTime(),
									'minimum_time' => $hp_obj->getMinimumTime(),
									'maximum_time' => $hp_obj->getMaximumTime(),
									//'time' => $hp_obj->getTime(),

									'round_interval_policy_id' => $hp_obj->getRoundIntervalPolicyID(),
									'absence_policy_id' => $hp_obj->getAbsencePolicyID(),

									'recurring_holiday_ids' => $hp_obj->getRecurringHoliday(),

									'created_date' => $hp_obj->getCreatedDate(),
									'created_by' => $hp_obj->getCreatedBy(),
									'updated_date' => $hp_obj->getUpdatedDate(),
									'updated_by' => $hp_obj->getUpdatedBy(),
									'deleted_date' => $hp_obj->getDeletedDate(),
									'deleted_by' => $hp_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			//Defaults
			$data = array(
						'default_schedule_status_id' => 20,
						'minimum_employed_days' => 30,
						'minimum_worked_period_days' => 30,
						'minimum_worked_days' => 15,
						'average_time_days' => 30,
						'force_over_time_policy' => FALSE,
						'include_over_time' => FALSE,
						'include_paid_absence_time' => TRUE,
						'minimum_time' => 0,
						'maximum_time' => 0
						);
		}

		$aplf = new AbsencePolicyListFactory();
		$absence_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$riplf = new RoundIntervalPolicyListFactory();
		$round_interval_options = $riplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$rhlf = new RecurringHolidayListFactory();
		$recurring_holiday_options = $rhlf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$sf = new ScheduleFactory();

		//Select box options;
		$data['type_options'] = $hpf->getOptions('type');
		$data['schedule_status_options'] = $sf->getOptions('status');
		$data['absence_options'] = $absence_options;
		$data['round_interval_options'] = $round_interval_options;
		$data['recurring_holiday_options'] = $recurring_holiday_options;

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('hpf', $hpf);

$smarty->display('policy/EditHolidayPolicy.tpl');
?>