/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Animator;
import br.arca.morcego.Graph;
import br.arca.morcego.GraphDataRetriever;
import br.arca.morcego.Node;
import java.util.Enumeration;
import java.util.Vector;

public class Feeder
implements Runnable {
    private Graph graph;
    private GraphDataRetriever retriever;
    private Animator animator;

    public Feeder(Graph g, GraphDataRetriever gdr) {
        this.graph = g;
        this.retriever = gdr;
        this.animator = new Animator(this.graph);
    }

    private Vector diffGraphs(Graph g1, Graph g2) {
        Vector<Node> diff = new Vector<Node>();
        Enumeration e = g1.elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (g2.nodeFromName(node.getName()) != null) continue;
            diff.add(node);
        }
        return diff;
    }

    public void feed(Graph newGraph) {
        Vector removed = this.diffGraphs(this.graph, newGraph);
        Vector added = this.diffGraphs(newGraph, this.graph);
        this.animator.animate(added, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread animationThread = new Thread(this.animator);
        animationThread.start();
        while (true) {
            Graph newGraph;
            Feeder feeder = this;
            synchronized (feeder) {
                try {
                    this.wait();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                newGraph = this.retriever.retrieveData(this.graph.getCenterNode().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            this.feed(newGraph);
        }
    }
}

